/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.event;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalHolder;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.webhook.event.Event;
import com.pageseeder.webhook.event.EventAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBuilder {
    private static final String DOT = ".";
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBuilder.class);
    private final long timestamp;
    private EventAction action = null;
    private String objectName = null;
    private Long objectID = null;
    private String publicObjectID = null;
    private String publicObjectID2 = null;
    private UniversalHolder.Builder output = null;
    private Collection<Event.EventGroup> groups = null;

    public EventBuilder(Event.Object object, EventAction action) {
        this(System.currentTimeMillis(), object, action);
    }

    public EventBuilder(long ts, Event.Object object, EventAction action) {
        this.timestamp = ts;
        this.objectName = object.name();
        this.action = action;
    }

    public String getEventType() {
        return this.objectName + DOT + this.action.name();
    }

    public EventAction getAction() {
        return this.action;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public UniversalHolder getOutput() {
        return this.output == null ? null : this.output.build();
    }

    public Long getObjectID() {
        return this.objectID;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getPublicObjectID() {
        return this.publicObjectID;
    }

    public String getPublicObjectID2() {
        return this.publicObjectID2;
    }

    public Collection<Event.EventGroup> getGroups() {
        return this.groups;
    }

    public EventBuilder uri(URI uri) {
        if (!Event.Object.uri.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectName = "uri";
        this.objectID = uri.getId();
        this.publicObjectID = uri.getDocID();
        this.publicObjectID2 = uri.getPath();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeURI(uri);
        }
        return this;
    }

    public EventBuilder uri(Long id, String docid, String path) {
        return this.minimal("uri", id, docid, path);
    }

    public EventBuilder member(Member member) {
        if (!Event.Object.member.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = member.getId();
        this.publicObjectID = member.getUsername();
        this.publicObjectID2 = MemberRule.hasEmail((Member)member) ? member.getEmail() : null;
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeMember(member, true);
        }
        return this;
    }

    public EventBuilder member(Long id, String username, String email) {
        return this.minimal("member", id, username, email);
    }

    public EventBuilder group(Group group) {
        if (!Event.Object.group.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = group.getId();
        this.publicObjectID = group.getName();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeGroup(group);
        }
        return this;
    }

    public EventBuilder group(Long id, String name) {
        return this.minimal("group", id, name, null);
    }

    public EventBuilder groupProperties(Group group, Database db) {
        if (!Event.Object.groupproperties.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = group.getId();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            try {
                GroupProperties.print((Group)group, (Database)db, (OutputPrinter)this.output);
            }
            catch (QueryFailedException | IOException ex) {
                LOGGER.error("Failed to load properties for group {}", (Object)group.getName(), (Object)ex);
            }
        }
        return this;
    }

    public EventBuilder project(Group project) {
        if (!Event.Object.project.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = project.getId();
        this.publicObjectID = project.getName();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeGroup(project, true, false, false);
        }
        return this;
    }

    public EventBuilder project(Long id, String name) {
        return this.minimal("project", id, name, null);
    }

    public EventBuilder groupfolder(GroupURI groupuri, Database db) {
        if (!Event.Object.groupfolder.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = groupuri.getId();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeGroupFolder(groupuri, true, db);
        }
        return this;
    }

    public EventBuilder groupfolder(Long id, String path) {
        return this.minimal("groupfolder", id, path, null);
    }

    public EventBuilder membership(MemberForGroup membership) {
        return this.membership(new Membership(membership));
    }

    public EventBuilder membership(Membership membership) {
        if (!Event.Object.membership.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = membership.getMemberForGroupID();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeMembership(membership, null, null, null);
        }
        return this;
    }

    public EventBuilder membership(Long id) {
        return this.minimal("membership", id);
    }

    public EventBuilder publication(Publication pub, @Nullable Collection<URI> added, @Nullable Collection<URI> modified, @Nullable Collection<URI> removed, @Nullable Collection<Long> deletedUriids) {
        if (!Event.Object.publication.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = pub.getXLinkId();
        this.publicObjectID = pub.getId();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            Publications.print((Publication)pub, (UniversalPrinter)printer, (boolean)false);
            if (added != null && !added.isEmpty()) {
                printer.startCollection("added");
                for (URI uri : added) {
                    printer.writeURI(uri);
                }
                printer.endCollection();
            }
            if (modified != null && !modified.isEmpty()) {
                printer.startCollection("modified");
                for (URI uri : modified) {
                    printer.writeURI(uri);
                }
                printer.endCollection();
            }
            if (removed != null && !removed.isEmpty()) {
                printer.startCollection("removed");
                for (URI uri : removed) {
                    printer.writeURI(uri);
                }
                printer.endCollection();
            }
            if (deletedUriids != null && !deletedUriids.isEmpty()) {
                printer.startCollection("deleted");
                for (Long uriid : deletedUriids) {
                    printer.startObject("uri");
                    printer.field("id", uriid.longValue());
                    printer.endObject();
                }
                printer.endCollection();
            }
            printer.endObject();
        }
        return this;
    }

    public EventBuilder comment(XLink xl, Database db) {
        if (!Event.Object.comment.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = xl.getId();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeComment(xl, db, null, null, true, true, false, true, null);
        }
        return this;
    }

    public EventBuilder comment(Long id) {
        return this.minimal("comment", id);
    }

    public EventBuilder workflow(XLink xl, Database db) {
        if (!Event.Object.workflow.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        XLink root = XLinks.getThreadRoot((XLink)xl);
        URI uri = URIRule.getURIByXLink((XLink)root);
        List xlinks = new ArrayList();
        if (uri == null) {
            LOGGER.error("Unable to load URI for " + this.objectName + " (" + this.objectID + ")");
        } else {
            try {
                xlinks = URIRule.getWorkflowsForURI((Database)db, (URI)uri, null);
            }
            catch (QueryFailedException e) {
                LOGGER.error("Unable to load " + this.objectName + " (" + this.objectID + "): " + e.getMessage());
            }
        }
        this.objectID = root.getId();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeWorkflow(xlinks, true, false, uri, null);
        }
        return this;
    }

    public EventBuilder workflow(Long id) {
        return this.minimal("workflow", id);
    }

    public EventBuilder task(XLink xl, Collection<Group> groups, Database db) {
        if (!Event.Object.task.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        XLink root = XLinks.getThreadRoot((XLink)xl);
        Discussion task = new Discussion(root, GroupRule.getGroupNames(groups));
        task.loadLastComment(db, false);
        this.objectID = root.getId();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeDiscussion(task, "task", db, null, true, false, false, null);
        }
        return this;
    }

    public EventBuilder task(Long id) {
        return this.minimal("task", id);
    }

    public EventBuilder server() {
        return this.minimal("server", 0L);
    }

    public EventBuilder webhook(Webhook webhook) {
        if (!Event.Object.webhook.name().equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = webhook.getId();
        this.publicObjectID = webhook.getName();
        this.output = new UniversalHolder.Builder();
        try (UniversalPrinter printer = new UniversalPrinter((OutputPrinter)this.output);){
            printer.writeWebhook(webhook);
        }
        return this;
    }

    public EventBuilder webhook(Long id, String name) {
        return this.minimal("webhook", id, name, null);
    }

    private EventBuilder minimal(String name, Long id) {
        return this.minimal(name, id, null, null);
    }

    private EventBuilder minimal(String name, Long id, String publicID, String publicID2) {
        if (!name.equals(this.objectName)) {
            LOGGER.error("Main object set incorrectly to " + this.objectName + " (" + this.objectID + ")");
        }
        this.objectID = id;
        this.publicObjectID = publicID;
        this.publicObjectID2 = publicID2;
        return this;
    }

    public EventBuilder contextGroup(Long id, String name) {
        if (GroupRule.isAdminGroup((String)name)) {
            return this;
        }
        if (this.groups == null) {
            this.groups = new ArrayList<Event.EventGroup>();
        }
        this.groups.add(new Event.EventGroup(id, name));
        return this;
    }

    public EventBuilder contextGroup(Group grp) {
        if (GroupRule.isAdminGroup((String)grp.getName())) {
            return this;
        }
        if (this.groups == null) {
            this.groups = new ArrayList<Event.EventGroup>();
        }
        this.groups.add(new Event.EventGroup(grp.getId(), grp.getName()));
        return this;
    }

    public EventBuilder contextGroups(Collection<Group> grps) {
        this.groups = new ArrayList<Event.EventGroup>();
        for (Group grp : grps) {
            this.contextGroup(grp);
        }
        return this;
    }

    public Event build() {
        if (this.action == null) {
            throw new IllegalStateException("Cannot build an event without an action");
        }
        if (this.objectID == null || this.objectName == null) {
            throw new IllegalStateException("Cannot build an event without a main object");
        }
        if (!this.action.supportsObject(this.objectName)) {
            throw new IllegalStateException("Invalid action " + this.action.name() + " for object " + this.objectName);
        }
        return new Event(this);
    }
}

