/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.event;

import com.pageseeder.base.serial.JSONOutputPrinter;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalHolder;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.event.EventAction;
import com.pageseeder.webhook.event.EventBuilder;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public class Event
implements Serializable,
UniversallyPrintable {
    private static final long serialVersionUID = 1L;
    private static final String DOT = ".";
    private final long _timestamp;
    private final String _id;
    private final String _objectName;
    private final EventAction _action;
    private final Long _objectID;
    private final String _publicObjectID;
    private final String _publicObjectID2;
    private final Collection<EventGroup> _groups;
    private final UniversalHolder _output;
    private boolean queued;

    protected Event(EventBuilder builder) {
        this._timestamp = builder.getTimestamp();
        this._objectID = builder.getObjectID();
        this._id = this._objectID + DOT + System.nanoTime();
        this._publicObjectID = builder.getPublicObjectID();
        this._publicObjectID2 = builder.getPublicObjectID2();
        this._objectName = builder.getObjectName();
        this._action = builder.getAction();
        this._output = builder.getOutput();
        this._groups = builder.getGroups() == null ? null : new ArrayList<EventGroup>(builder.getGroups());
    }

    private Event(Event e) {
        this._action = e._action;
        this._output = e._output;
        this._groups = e._groups;
        this._id = e._id;
        this._objectID = e._objectID;
        this._objectName = e._objectName;
        this._publicObjectID = e._publicObjectID;
        this._publicObjectID2 = e._publicObjectID2;
        this._timestamp = e._timestamp;
    }

    protected Event cloneQueued() {
        Event cloned = new Event(this);
        cloned.queued = true;
        return cloned;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public String getID() {
        return this._id;
    }

    public Long getObjectID() {
        return this._objectID;
    }

    public String getPublicObjectID() {
        return this._publicObjectID;
    }

    public boolean isPing() {
        return this._action == EventAction.ping;
    }

    public String getEventType() {
        return this._objectName + DOT + this._action.name();
    }

    public Collection<EventGroup> getEventGroups() {
        return this._groups;
    }

    public void print(OutputPrinter out, @Nullable Webhook webhook) {
        out.startObject("webevent");
        out.field("id", this._id);
        out.field("datetime", ISO8601.DATETIME.format(this._timestamp));
        out.field("type", this.getEventType());
        if (webhook == null) {
            out.field("queued", this.queued);
        }
        ArrayList<EventGroup> mygroups = new ArrayList<EventGroup>();
        if (this._groups != null) {
            for (EventGroup group : this._groups) {
                if (webhook != null && !webhook.includeGroup(group._name)) continue;
                mygroups.add(group);
            }
        }
        if (!mygroups.isEmpty()) {
            out.startCollection("event");
            for (EventGroup group : mygroups) {
                group.print(out);
            }
            out.endCollection();
        }
        if ((webhook == null || webhook.getObject() == Webhook.ObjectType.basic) && this._output != null) {
            this._output.print(out);
        } else if ("groupproperties".equals(this._objectName)) {
            out.startObject("properties");
            out.endObject();
        } else if (!"server".equals(this._objectName)) {
            out.startObject(this._objectName);
            if (!"publication".equals(this._objectName)) {
                out.field("id", this._objectID.longValue());
            }
            if (this._publicObjectID != null) {
                if (this.getPublicIDName() == null) {
                    LoggerFactory.getLogger(Event.class).error("No publid ID name for object {}", (java.lang.Object)this._objectName);
                } else {
                    out.field(this.getPublicIDName(), this._publicObjectID);
                }
            }
            if (this._publicObjectID2 != null) {
                if (this.getPublicID2Name() == null) {
                    LoggerFactory.getLogger(Event.class).error("No publid ID 2 name for object {}", (java.lang.Object)this._objectName);
                } else {
                    out.field(this.getPublicID2Name(), this._publicObjectID2);
                }
            }
            out.endObject();
        }
        out.endObject();
    }

    public int getBytes(Webhook webhook) {
        XMLOutputPrinter out = webhook.getFormat() == Webhook.Format.xml ? new XMLOutputPrinter() : new JSONOutputPrinter();
        this.print((OutputPrinter)out);
        return out.toString().getBytes(StandardCharsets.UTF_8).length;
    }

    public void print(OutputPrinter out) {
        this.print(out, null);
    }

    private String getPublicIDName() {
        return "uri".equals(this._objectName) ? "docid" : ("publication".equals(this._objectName) ? "id" : ("member".equals(this._objectName) ? "username" : ("groupfolder".equals(this._objectName) ? "path" : ("group".equals(this._objectName) || "project".equals(this._objectName) || "webhook".equals(this._objectName) ? "name" : null))));
    }

    private String getPublicID2Name() {
        return "uri".equals(this._objectName) ? "path" : ("member".equals(this._objectName) ? "email" : null);
    }

    public static final class EventGroup
    implements Serializable,
    UniversallyPrintable {
        private static final long serialVersionUID = 1L;
        private final String _name;
        private final Long _id;

        public EventGroup(Long id, String name) {
            this._id = id;
            this._name = name;
        }

        public String name() {
            return this._name;
        }

        public void print(OutputPrinter out) {
            out.startObject("group");
            if (this._id != null) {
                out.field("id", this._id.longValue());
            }
            if (this._name != null) {
                out.field("name", this._name);
            }
            out.endObject();
        }
    }

    public static enum Object {
        uri,
        comment,
        task,
        workflow,
        group,
        groupfolder,
        groupproperties,
        membership,
        member,
        project,
        publication,
        webhook,
        server;

    }
}

