/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageWebhookCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.job.JobPoster;
import com.pageseeder.webhook.manager.WebhookManager;
import com.pageseeder.webhook.web.WebhookDetails;
import com.pageseeder.webhook.web.WebhookErrorID;
import java.io.IOException;

@Requires(database=true, parameters={"webhook", "client"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class SendPing
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageWebhookCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Long webhookid;
        Database db = req.getDatabase();
        Webhook webhook = WebhookQuery.getWebhook((Database)db, (Long)(webhookid = Long.valueOf(req.getParameter((Parameter)StandardParameters.webhook, -1L))));
        if (webhook == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Webhook was not found");
            return;
        }
        if (!WebhookDetails.checkClient(req, res, webhook)) {
            return;
        }
        JobPoster poster = WebhookManager.getInstance().sendPing(webhook.getId());
        if (poster == null) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to post ping request");
            return;
        }
        String error = poster.getErrorMessage();
        if (error != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)(error.contains("ping header") ? WebhookErrorID.PING_ERROR_HEADER : WebhookErrorID.PING_ERROR_HTTP_CODE), error);
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("ping-sent");
        out.endObject();
        out.flush();
    }
}

