/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.docx.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.docx.DOCXException;
import org.slf4j.Logger;

public final class XSLT {
    private static final Map<String, Templates> CACHE = new Hashtable<String, Templates>();

    private XSLT() {
    }

    public static Templates getTemplates(URL url) {
        if (url == null) {
            return null;
        }
        Templates templates = CACHE.get(url.toString());
        if (templates == null) {
            templates = XSLT.toTemplates(url);
            CACHE.put(url.toString(), templates);
        }
        return templates;
    }

    public static Templates getTemplatesFromResource(String resource) {
        ClassLoader loader = XSLT.class.getClassLoader();
        URL url = loader.getResource(resource);
        if (url == null) {
            throw new DOCXException("Unable to find templates at " + resource);
        }
        return XSLT.getTemplates(url);
    }

    public static void transform(File source, File result, Templates templates, Map<String, String> parameters, Logger logger) {
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(result);){
            StreamSource src = new StreamSource(new BufferedInputStream(in), source.toURI().toString());
            StreamResult res = new StreamResult(new BufferedOutputStream(out));
            XSLT.transform(src, res, templates, parameters, logger);
        }
        catch (IOException ex) {
            throw new DOCXException(ex);
        }
    }

    public static void transform(Source source, Result result, Templates templates, Map<String, String> parameters, Logger logger) {
        try {
            Transformer transformer = templates.newTransformer();
            if (logger != null) {
                transformer.setErrorListener(new XSLTErrorListener(logger));
            }
            if (parameters != null) {
                for (Map.Entry<String, String> e : parameters.entrySet()) {
                    transformer.setParameter(e.getKey(), e.getValue());
                }
            }
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new DOCXException("Unable to transform ", ex);
        }
    }

    private static Templates toTemplates(File stylepath) throws DOCXException {
        StreamSource source = new StreamSource(stylepath);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            return factory.newTemplates(source);
        }
        catch (TransformerConfigurationException ex) {
            throw new DOCXException("Unable to load XSLT templates", ex);
        }
    }

    private static Templates toTemplates(URL url) {
        Templates templates;
        if (url == null) {
            return null;
        }
        try (InputStream in = url.openStream();){
            StreamSource source = new StreamSource(in);
            source.setSystemId(url.toString());
            TransformerFactory factory = TransformerFactory.newInstance();
            templates = factory.newTemplates(source);
        }
        catch (TransformerConfigurationException ex) {
            throw new DOCXException("Transformer exception while trying to load XSLT templates" + url.toString(), ex);
        }
        catch (IOException ex) {
            throw new DOCXException("IO error while trying to load XSLT templates" + url.toString(), ex);
        }
        return templates;
    }

    private static class XSLTErrorListener
    implements ErrorListener {
        private final Logger log;

        XSLTErrorListener(Logger log) {
            this.log = log;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            this.log.error("Transformer fatal error: {}", (Object)exception.getMessageAndLocation());
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            this.log.warn("Transformer warning: {}", (Object)exception.getMessageAndLocation());
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            this.log.error("Transformer error: {}", (Object)exception.getMessageAndLocation());
        }
    }
}

