/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BinaryExpression;

public class BinaryLiteral
extends BinaryExpression {
    private final Byte[] value;

    public BinaryLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Byte[]) {
            this.value = (Byte[])value;
        } else if (value instanceof byte[]) {
            byte[] bytesValue = (byte[])value;
            this.value = new Byte[bytesValue.length];
            for (int i = 0; i < bytesValue.length; ++i) {
                this.value[i] = bytesValue[i];
            }
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + value.getClass().getName());
        }
        if (parameterName != null) {
            this.st.appendParameter(parameterName, mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    public Object getValue() {
        return this.value;
    }

    protected void setStatement() {
        this.st.append(String.valueOf(this.value));
    }
}

