/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.pageseeder.schematron.svrl.SVRLData;

public final class SVRLByteArray
implements SVRLData {
    private final byte[] _svrl;
    private final Charset _charset;

    public SVRLByteArray(byte[] svrl) {
        this(svrl, StandardCharsets.UTF_8);
    }

    public SVRLByteArray(byte[] svrl, Charset charset) {
        this._svrl = Objects.requireNonNull(svrl);
        this._charset = Objects.requireNonNull(charset);
    }

    @Override
    public String asString() {
        return new String(this._svrl, this._charset);
    }

    @Override
    public byte[] asByteArray() {
        return this._svrl;
    }

    @Override
    public Reader getReader() {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this._svrl), this._charset);
    }
}

