/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.schematron.svrl.DiagnosticReference;
import org.pageseeder.schematron.svrl.HumanText;
import org.pageseeder.schematron.svrl.PropertyReference;
import org.pageseeder.schematron.xml.XMLStreamable;

public final class AssertOrReport
implements XMLStreamable {
    private boolean isFailedAssert = false;
    private String id;
    private String location;
    private String test;
    private String role;
    private String flag;
    private final List<DiagnosticReference> diagnosticReferences = new ArrayList<DiagnosticReference>();
    private final List<PropertyReference> propertyReferences = new ArrayList<PropertyReference>();
    private HumanText text = null;

    public boolean isFailedAssert() {
        return this.isFailedAssert;
    }

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTest() {
        return this.test;
    }

    public String getRole() {
        return this.role;
    }

    public String getFlag() {
        return this.flag;
    }

    public List<DiagnosticReference> getDiagnosticReferences() {
        return this.diagnosticReferences;
    }

    public List<PropertyReference> getPropertyReferences() {
        return this.propertyReferences;
    }

    public PropertyReference getPropertyReference(String property) {
        for (PropertyReference ref : this.propertyReferences) {
            if (!property.equals(ref.getProperty())) continue;
            return ref;
        }
        return null;
    }

    public DiagnosticReference getDiagnosticReference(String diagnostic) {
        for (DiagnosticReference ref : this.diagnosticReferences) {
            if (!diagnostic.equals(ref.getDiagnostic())) continue;
            return ref;
        }
        return null;
    }

    public String getPropertyText(String property) {
        for (PropertyReference ref : this.propertyReferences) {
            if (!property.equals(ref.getProperty())) continue;
            return ref.getTextAsString();
        }
        return null;
    }

    public String getDiagnosticText(String diagnostic) {
        for (DiagnosticReference ref : this.diagnosticReferences) {
            if (!diagnostic.equals(ref.getDiagnostic())) continue;
            return ref.getTextAsString();
        }
        return null;
    }

    public HumanText getText() {
        return this.text;
    }

    public String toMessageString() {
        return this.toMessageString(true);
    }

    public String toMessageString(boolean includeDiagnostics) {
        StringBuilder out = new StringBuilder();
        out.append(this.isFailedAssert ? "[assert] " : "[report] ");
        out.append(this.location).append(" - ").append(this.text.toPlainText());
        if (includeDiagnostics) {
            out.append(' ');
            for (DiagnosticReference diagnostic : this.diagnosticReferences) {
                out.append('(').append(diagnostic.getDiagnostic()).append(':');
                HumanText diagnosticText = diagnostic.getText();
                if (diagnosticText == null) continue;
                out.append(diagnosticText.toPlainText()).append(')');
            }
        }
        return out.toString();
    }

    void setFailedAssert(boolean failedAssert) {
        this.isFailedAssert = failedAssert;
    }

    void setId(String id) {
        this.id = id;
    }

    void setLocation(String location) {
        this.location = location;
    }

    void setTest(String test) {
        this.test = test;
    }

    void setRole(String role) {
        this.role = role;
    }

    void setFlag(String flag) {
        this.flag = flag;
    }

    void setText(HumanText text) {
        this.text = text;
    }

    void addDiagnosticReference(DiagnosticReference diagnosticReference) {
        this.diagnosticReferences.add(diagnosticReference);
    }

    void addPropertyReference(PropertyReference propertyReference) {
        this.propertyReferences.add(propertyReference);
    }

    @Override
    public void toXMLStream(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeStartElement("svrl", this.isFailedAssert ? "failed-assert" : "successful-report", "http://purl.oclc.org/dsdl/svrl");
        if (this.id != null) {
            xml.writeAttribute("id", this.id);
        }
        if (this.location != null) {
            xml.writeAttribute("location", this.location);
        }
        if (this.test != null) {
            xml.writeAttribute("test", this.test);
        }
        if (this.role != null) {
            xml.writeAttribute("role", this.role);
        }
        if (this.flag != null) {
            xml.writeAttribute("flag", this.flag);
        }
        if (this.role != null) {
            xml.writeAttribute("role", this.role);
        }
        for (DiagnosticReference diagnosticReference : this.diagnosticReferences) {
            diagnosticReference.toXMLStream(xml);
        }
        for (PropertyReference propertyReference : this.propertyReferences) {
            propertyReference.toXMLStream(xml);
        }
        if (this.text != null) {
            this.text.toXMLStream(xml);
        }
        xml.writeEndElement();
    }
}

