/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron;

import javax.xml.transform.TransformerException;
import org.pageseeder.schematron.SchematronException;

public final class ValidationException
extends SchematronException {
    private final String failingExpression;
    private final String errorCode;
    private final String matchPattern;

    public ValidationException(TransformerException cause) {
        super("Unable to validate: " + cause.getMessage(), cause);
        this.failingExpression = ValidationException.loadFailingExpression(cause);
        this.errorCode = ValidationException.loadErrorCode(cause);
        this.matchPattern = ValidationException.loadMatchPattern(cause);
    }

    @Override
    public String getMessage() {
        StringBuilder out = new StringBuilder();
        if (this.errorCode != null) {
            out.append('[').append(this.errorCode).append("] ");
        }
        out.append(super.getMessage());
        if (this.failingExpression != null) {
            out.append(" (expression=").append(this.failingExpression).append(")");
        }
        if (this.matchPattern != null) {
            out.append(" (matchPattern=").append(this.matchPattern).append(")");
        }
        return out.toString();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getFailingExpression() {
        return this.failingExpression;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    private static String loadMatchPattern(TransformerException cause) {
        try {
            Object matchPattern;
            Object locator = cause.getClass().getMethod("getLocator", new Class[0]).invoke((Object)cause, new Object[0]);
            if (locator != null && (matchPattern = locator.getClass().getMethod("getMatchPattern", new Class[0]).invoke(locator, new Object[0])) != null) {
                return matchPattern.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String loadFailingExpression(TransformerException cause) {
        try {
            Object expression = cause.getClass().getMethod("getFailingExpression", new Class[0]).invoke((Object)cause, new Object[0]);
            return expression != null ? expression.toString() : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String loadErrorCode(TransformerException cause) {
        try {
            Object errorCode = cause.getClass().getMethod("getErrorCodeLocalPart", new Class[0]).invoke((Object)cause, new Object[0]);
            return errorCode != null ? errorCode.toString() : null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

