/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.xml.AttributeException;
import org.pageseeder.psml.xml.Handler;
import org.pageseeder.psml.xml.InvalidAttributeException;
import org.pageseeder.psml.xml.MissingAttributeException;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class BasicHandler<T>
extends Handler<T> {
    private final List<T> list = new ArrayList<T>();
    private final List<String> ancestorOrSelf = new ArrayList<String>();
    private @Nullable StringBuilder buffer = null;
    private @Nullable XMLStringWriter xmlBuffer = null;
    private @Nullable Locator locator = null;

    public void startElement(String element, Attributes atts) {
    }

    public void endElement(String element) {
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String element = localName.isEmpty() ? qName : localName;
        this.ancestorOrSelf.add(element);
        if (this.xmlBuffer != null && !element.equals("xref") && !element.equals("image")) {
            this.xmlBuffer.openElement(element);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getLocalName(i);
                if ("placeholder".equals(element) && "resolved".equals(name)) continue;
                this.xmlBuffer.attribute(name, attributes.getValue(i));
            }
        }
        try {
            this.startElement(element, attributes);
        }
        catch (AttributeException ex) {
            String xpath = "/" + String.join((CharSequence)"/", this.ancestorOrSelf) + "/@" + ex.getAttributeName();
            throw new SAXParseException(ex.getMessage() + " XPath=" + xpath, this.locator);
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        String element = localName.isEmpty() ? qName : localName;
        this.endElement(element);
        if (!this.ancestorOrSelf.isEmpty()) {
            this.ancestorOrSelf.remove(this.ancestorOrSelf.size() - 1);
        }
        if (this.xmlBuffer != null && !element.equals("xref") && !element.equals("image")) {
            this.xmlBuffer.closeElement();
        }
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        XMLStringWriter x;
        StringBuilder b = this.buffer;
        if (b != null) {
            b.append(ch, start, length);
        }
        if ((x = this.xmlBuffer) != null) {
            x.writeText(ch, start, length);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected final void newBuffer() {
        this.buffer = new StringBuilder();
    }

    protected final @Nullable String buffer() {
        StringBuilder b = this.buffer;
        return b != null ? b.toString() : null;
    }

    protected final @Nullable String buffer(boolean clear) {
        String text = this.buffer();
        if (clear) {
            this.buffer = null;
        }
        return text;
    }

    protected final void newXmlBuffer() {
        this.xmlBuffer = new XMLStringWriter(XML.NamespaceAware.No);
    }

    protected final @Nullable String xmlBuffer(boolean clear) {
        if (this.xmlBuffer == null) {
            return null;
        }
        this.xmlBuffer.flush();
        String text = this.xmlBuffer.toString();
        if (clear) {
            this.xmlBuffer = null;
        }
        return text;
    }

    protected final void append(String s) {
        StringBuilder b = this.buffer;
        if (b != null) {
            b.append(s);
        }
    }

    protected void clearBuffer() {
        this.buffer = null;
    }

    protected final void add(T item) {
        this.list.add(Objects.requireNonNull(item, "Cannot add null item to list"));
    }

    protected final @Nullable String element() {
        return this.ancestorOrSelf.isEmpty() ? null : this.ancestorOrSelf.get(this.ancestorOrSelf.size() - 1);
    }

    protected final @Nullable String parent() {
        return this.ancestorOrSelf.size() > 1 ? this.ancestorOrSelf.get(this.ancestorOrSelf.size() - 2) : null;
    }

    protected final @Nullable String ancestor(int i) {
        return this.ancestorOrSelf.size() > i ? this.ancestorOrSelf.get(this.ancestorOrSelf.size() - (i - 1)) : null;
    }

    protected final boolean isElement(String element) {
        return element.equals(this.element());
    }

    protected final boolean isParent(String parent) {
        return parent.equals(this.parent());
    }

    protected final boolean hasAncestor(String ancestor) {
        if (this.ancestorOrSelf.size() <= 1) {
            return false;
        }
        for (int i = this.ancestorOrSelf.size() - 2; i >= 0; --i) {
            if (!ancestor.equals(this.ancestorOrSelf.get(i))) continue;
            return true;
        }
        return false;
    }

    protected final boolean isAny(String ... elements) {
        String current = this.element();
        if (current != null) {
            for (String e : elements) {
                if (!e.equals(current)) continue;
                return true;
            }
        }
        return false;
    }

    public static Long getLong(Attributes atts, String name) {
        @Nullable String value = atts.getValue(name);
        if (value == null) {
            throw new MissingAttributeException(name);
        }
        return BasicHandler.toLong(value, name);
    }

    public static Long getLong(Attributes atts, String name, Long fallback) {
        String value = atts.getValue(name);
        return value != null ? BasicHandler.toLong(value, name) : fallback;
    }

    public static @Nullable Long getOptionalLong(Attributes atts, String name) {
        String value = atts.getValue(name);
        if (value == null) {
            return null;
        }
        return BasicHandler.toLong(value, name);
    }

    public static String getString(Attributes atts, String name) {
        String value = atts.getValue(name);
        if (value == null) {
            throw new MissingAttributeException(name);
        }
        return value;
    }

    public static String getString(Attributes atts, String name, String fallback) {
        String value = atts.getValue(name);
        return value != null ? value : fallback;
    }

    public static int getInt(Attributes atts, String name) {
        @Nullable String value = atts.getValue(name);
        if (value == null) {
            throw new MissingAttributeException(name);
        }
        return BasicHandler.toInt(value, name);
    }

    public static int getInt(Attributes atts, String name, int fallback) {
        String value = atts.getValue(name);
        return value != null ? BasicHandler.toInt(value, name) : fallback;
    }

    public static @Nullable String getOptionalString(Attributes atts, String name) {
        return atts.getValue(name);
    }

    private static Long toLong(String value, String name) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw new InvalidAttributeException(name, ex);
        }
    }

    private static int toInt(String value, String name) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new InvalidAttributeException(name, ex);
        }
    }

    @Override
    public List<T> list() {
        return this.list;
    }

    @Override
    public @Nullable T get() {
        return this.list.isEmpty() ? null : (T)this.list.get(this.list.size() - 1);
    }
}

