/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.util;

import java.util.HashMap;
import java.util.Map;

public final class Subscripts {
    private static final Map<Character, Character> SUBSCRIPT_MAP = new HashMap<Character, Character>();

    private Subscripts() {
    }

    public static boolean isReplaceable(String s) {
        for (char c : s.toCharArray()) {
            if (Subscripts.hasSubscript(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSubscript(char c) {
        return SUBSCRIPT_MAP.containsKey(Character.valueOf(c));
    }

    public static char toSubscript(char c) {
        return SUBSCRIPT_MAP.getOrDefault(Character.valueOf(c), Character.valueOf(c)).charValue();
    }

    public static String toSubscript(String input) {
        StringBuilder sb = new StringBuilder();
        for (char c : input.toCharArray()) {
            sb.append(SUBSCRIPT_MAP.getOrDefault(Character.valueOf(c), Character.valueOf(c)));
        }
        return sb.toString();
    }

    static {
        SUBSCRIPT_MAP.put(Character.valueOf('0'), Character.valueOf('\u2080'));
        SUBSCRIPT_MAP.put(Character.valueOf('1'), Character.valueOf('\u2081'));
        SUBSCRIPT_MAP.put(Character.valueOf('2'), Character.valueOf('\u2082'));
        SUBSCRIPT_MAP.put(Character.valueOf('3'), Character.valueOf('\u2083'));
        SUBSCRIPT_MAP.put(Character.valueOf('4'), Character.valueOf('\u2084'));
        SUBSCRIPT_MAP.put(Character.valueOf('5'), Character.valueOf('\u2085'));
        SUBSCRIPT_MAP.put(Character.valueOf('6'), Character.valueOf('\u2086'));
        SUBSCRIPT_MAP.put(Character.valueOf('7'), Character.valueOf('\u2087'));
        SUBSCRIPT_MAP.put(Character.valueOf('8'), Character.valueOf('\u2088'));
        SUBSCRIPT_MAP.put(Character.valueOf('9'), Character.valueOf('\u2089'));
        SUBSCRIPT_MAP.put(Character.valueOf('+'), Character.valueOf('\u208a'));
        SUBSCRIPT_MAP.put(Character.valueOf('-'), Character.valueOf('\u208b'));
        SUBSCRIPT_MAP.put(Character.valueOf('='), Character.valueOf('\u208c'));
        SUBSCRIPT_MAP.put(Character.valueOf('('), Character.valueOf('\u208d'));
        SUBSCRIPT_MAP.put(Character.valueOf(')'), Character.valueOf('\u208e'));
        SUBSCRIPT_MAP.put(Character.valueOf('a'), Character.valueOf('\u2090'));
        SUBSCRIPT_MAP.put(Character.valueOf('e'), Character.valueOf('\u2091'));
        SUBSCRIPT_MAP.put(Character.valueOf('o'), Character.valueOf('\u2092'));
        SUBSCRIPT_MAP.put(Character.valueOf('x'), Character.valueOf('\u2093'));
    }
}

