/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.io.IOException;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.Element;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.Heading;
import org.pageseeder.psml.toc.Paragraph;
import org.pageseeder.psml.toc.Part;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.Reference;
import org.pageseeder.psml.toc.Toc;
import org.pageseeder.psml.toc.TransclusionEnd;
import org.pageseeder.psml.toc.Tree;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublicationTree
implements Tree,
Serializable,
XMLWritable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicationTree.class);
    private static final long serialVersionUID = 4L;
    private static final int MAX_REVERSE_FOLLOW = 100;
    private final long _rootid;
    private final Map<Long, DocumentTree> _map;
    private final Map<Long, List<Long>> _transclusions;

    public PublicationTree() {
        this._map = Collections.emptyMap();
        this._rootid = -1L;
        this._transclusions = new HashMap<Long, List<Long>>();
    }

    public PublicationTree(DocumentTree tree) {
        this._map = Collections.singletonMap(tree.id(), tree);
        this._rootid = tree.id();
        this._transclusions = new HashMap<Long, List<Long>>();
    }

    private PublicationTree(DocumentTree parent, PublicationTree trunk) {
        HashMap<Long, DocumentTree> map = new HashMap<Long, DocumentTree>(trunk._map);
        map.put(parent.id(), parent);
        this._map = Collections.unmodifiableMap(map);
        this._rootid = parent.id();
        this._transclusions = new HashMap<Long, List<Long>>();
    }

    private PublicationTree(PublicationTree trunk, DocumentTree tree) {
        HashMap<Long, DocumentTree> map = new HashMap<Long, DocumentTree>(trunk._map);
        map.put(tree.id(), tree);
        this._map = Collections.unmodifiableMap(map);
        this._rootid = trunk._rootid;
        this._transclusions = Collections.unmodifiableMap(trunk.transclusions());
    }

    private PublicationTree(PublicationTree pub, List<Long> removeIds, Map<Long, DocumentTree> trees, long rootid) {
        if (pub.id() != rootid) {
            LOGGER.error("Changing publication root id from " + pub.id() + " to " + rootid);
        }
        HashMap<Long, DocumentTree> map = new HashMap<Long, DocumentTree>(pub._map);
        for (Long id : removeIds) {
            if (id == rootid) {
                LOGGER.error("Attempt to remove publication root id " + pub.id() + ", removeIds " + String.valueOf(removeIds) + ", addIds " + String.valueOf(trees.keySet()));
                continue;
            }
            map.remove(id);
        }
        map.putAll(trees);
        this._map = Collections.unmodifiableMap(map);
        this._rootid = rootid;
        this._transclusions = Collections.unmodifiableMap(pub.transclusions());
    }

    private PublicationTree(PublicationTree pub, List<Long> removeIds, Map<Long, DocumentTree> trees, Map<Long, List<Long>> transclusions, long rootid) {
        if (pub.id() != rootid) {
            LOGGER.error("Changing publication root id from " + pub.id() + " to " + rootid);
        }
        HashMap<Long, DocumentTree> map = new HashMap<Long, DocumentTree>(pub._map);
        for (Long id : removeIds) {
            if (id == rootid) {
                LOGGER.error("Attempt to remove publication root id " + pub.id() + ", removeIds " + String.valueOf(removeIds) + ", addIds " + String.valueOf(trees.keySet()));
                continue;
            }
            map.remove(id);
        }
        map.putAll(trees);
        this._map = Collections.unmodifiableMap(map);
        this._rootid = rootid;
        this._transclusions = Collections.unmodifiableMap(transclusions);
    }

    @Override
    public long id() {
        return this._rootid;
    }

    @Override
    public List<Long> listReverseReferences() {
        return this.root().listReverseReferences();
    }

    @Override
    public List<Long> listForwardReferences() {
        HashSet<Long> uris = new HashSet<Long>();
        for (DocumentTree tree : this._map.values()) {
            uris.addAll(tree.listForwardReferences());
        }
        return new ArrayList<Long>(uris);
    }

    public @Nullable String getFragmentHeading(long treeid, String fragment) {
        DocumentTree t = this.tree(treeid);
        if (t == null) {
            return null;
        }
        String h = t.fragmentheadings().get(fragment);
        if (h == null) {
            return null;
        }
        if (t.xmlheadings()) {
            return h;
        }
        return XMLUtils.escape(h);
    }

    @Override
    public String title() {
        return this.root().title();
    }

    public boolean containsTree(long id) {
        return this._map.containsKey(id);
    }

    public @Nullable DocumentTree root() {
        return this._map.get(this._rootid);
    }

    public Map<Long, List<Long>> transclusions() {
        if (this._transclusions == null) {
            return new HashMap<Long, List<Long>>();
        }
        return new HashMap<Long, List<Long>>(this._transclusions);
    }

    public @Nullable DocumentTree tree(long id) {
        return this._map.get(id);
    }

    public PublicationTree add(DocumentTree tree) {
        return new PublicationTree(this, tree);
    }

    public PublicationTree modify(List<Long> removeIds, Map<Long, DocumentTree> trees, long rootid) {
        return new PublicationTree(this, removeIds, trees, rootid);
    }

    public PublicationTree modify(List<Long> removeIds, Map<Long, DocumentTree> trees, Map<Long, List<Long>> transclusions, long rootid) {
        return new PublicationTree(this, removeIds, trees, transclusions, rootid);
    }

    public PublicationTree root(DocumentTree root) {
        return new PublicationTree(root, this);
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        for (Long id : this._map.keySet()) {
            hashCode = 31 * hashCode + Long.hashCode(id);
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PublicationTree other = (PublicationTree)o;
        return !this.ids().equals(other.ids());
    }

    public void toXML(XMLWriter xml) throws IOException {
        this.toXML(xml, -1L, -1, null, null, true);
    }

    public void toXML(XMLWriter xml, long cid, int cposition, @Nullable FragmentNumbering number, boolean externalrefs) throws IOException {
        this.toXML(xml, cid, cposition, number, null, externalrefs);
    }

    public void toXML(XMLWriter xml, long cid, int cposition, @Nullable FragmentNumbering number, @Nullable PublicationConfig config, boolean externalrefs) throws IOException {
        xml.openElement("publication-tree", true);
        DocumentTree root = this.tree(cposition == -1 ? this._rootid : cid);
        if (root != null) {
            xml.attribute("uriid", Long.toString(root.id()));
            xml.attribute("title", root.title());
            if (!"".equals(root.labels())) {
                xml.attribute("labels", root.labels());
            }
            if (root.lastedited() != null) {
                xml.attribute("last-edited", root.lastedited().format(DateTimeFormatter.ISO_DATE_TIME));
            }
            if (root.path() != null) {
                xml.attribute("path", root.path());
            }
            if (this._map.size() == 1 || cposition != -1) {
                xml.attribute("content", "true");
            }
            ArrayList<Long> trees = null;
            if (cid != -1L) {
                trees = new ArrayList<Long>();
                if (cposition != -1) {
                    trees.add(cid);
                } else {
                    this.collectReferences(cid, trees);
                }
            }
            this.toXML(xml, this._rootid, 1, 1, "default", new TOCState(cid, cposition, trees, number, config, externalrefs));
        }
        xml.closeElement();
    }

    private boolean collectReferences(long id, List<Long> trees) {
        List<Long> transcluded;
        if (trees.contains(id)) {
            return true;
        }
        int count = 0;
        DocumentTree t = this.tree(id);
        if (t != null) {
            for (Long ref : t.listReverseReferences()) {
                if (this.collectReferences(ref, trees)) {
                    ++count;
                }
                if (count < 100) continue;
                break;
            }
            trees.add(id);
            return true;
        }
        if (this._transclusions != null && (transcluded = this._transclusions.get(id)) != null && !transcluded.isEmpty()) {
            for (Long ref : transcluded) {
                if (this.collectReferences(ref, trees)) {
                    ++count;
                }
                if (count < 100) continue;
                break;
            }
            trees.add(id);
            return true;
        }
        return false;
    }

    private void toXML(XMLWriter xml, long id, int level, Integer count, String fragment, TOCState state) throws IOException {
        String key = id + "-" + fragment;
        if (state.ancestors.contains(key)) {
            throw new IllegalStateException("XRef loop detected on URIID-fragment " + id);
        }
        state.ancestors.add(key);
        DocumentTree current = this.tree(id);
        if (!"default".equals(fragment)) {
            current = current.singleFragmentTree(fragment);
        }
        for (Part<?> part : current.parts()) {
            this.toXML(xml, id, level, part, count, state);
        }
        state.ancestors.remove(key);
    }

    private void toXML(XMLWriter xml, long id, int level, Part<?> part, Integer count, TOCState state) throws IOException {
        Object element = part.element();
        if (element instanceof TransclusionEnd || element instanceof Toc) {
            return;
        }
        boolean output = !(state.trees != null && !state.trees.contains(id) || state.cposition != -1 && state.cposition != count);
        boolean toNext = false;
        Long next = null;
        DocumentTree nextTree = null;
        String targetFragment = "default";
        Reference.Type refType = Reference.Type.EMBED;
        if (element instanceof Reference) {
            Reference ref = (Reference)element;
            targetFragment = ref.targetfragment();
            refType = ref.type();
            next = ref.uri();
            nextTree = this.tree(next);
            boolean bl = toNext = nextTree != null && Reference.Type.EMBED.equals((Object)refType);
        }
        if (output && !Reference.Type.TRANSCLUDE.equals((Object)refType)) {
            if (element instanceof Paragraph) {
                Paragraph para = (Paragraph)element;
                if (para.isVisible(state.config)) {
                    ((Element)element).toXML(xml, level, state.number, id, count);
                    return;
                }
                return;
            }
            xml.openElement("part", !part.parts().isEmpty() || toNext && (state.trees == null || state.trees.contains(next) || state.cid == id));
            xml.attribute("level", level);
            if (toNext && state.cid == next) {
                xml.attribute("content", "true");
            } else if (element instanceof Heading) {
                xml.attribute("uriid", Long.toString(id));
            }
        }
        Integer nextcount = null;
        if (nextTree != null || Reference.Type.TRANSCLUDE.equals((Object)refType)) {
            nextcount = state.doccount.get(next);
            nextcount = nextcount == null ? 1 : nextcount + 1;
            state.doccount.put(next, nextcount);
            Reference ref = (Reference)element;
            if (Reference.Type.EMBED.equals((Object)refType)) {
                if ("default".equals(targetFragment)) {
                    if (output) {
                        ref.toXML(xml, level, state.number, next, nextcount, nextTree.title(), nextTree.numbered(), nextTree.prefix(), nextTree.hasVisibleItems(state.config, null), nextTree.labels(), nextTree.lastedited(), nextTree.path());
                    }
                } else if (output) {
                    ref.toXML(xml, level, state.number, next, nextcount, ref.title(), false, "", nextTree.hasVisibleItems(state.config, targetFragment), nextTree.labels(), nextTree.lastedited(), nextTree.path());
                }
            } else if (output) {
                xml.openElement("transclusion");
                xml.attribute("uriid", Long.toString(ref.uri()));
                xml.attribute("fragment", ref.targetfragment());
                xml.attribute("position", nextcount.intValue());
                xml.closeElement();
            }
        } else if ((!(element instanceof Reference) || state.externalrefs) && output) {
            ((Element)element).toXML(xml, level, state.number, id, count);
        }
        if (toNext) {
            this.toXML(xml, (long)next, level + 1, nextcount, targetFragment, state);
        }
        for (Part<?> r : part.parts()) {
            this.toXML(xml, id, level + 1, r, count, state);
        }
        if (output && !Reference.Type.TRANSCLUDE.equals((Object)refType)) {
            xml.closeElement();
        }
    }

    public Set<Long> ids() {
        return this._map.keySet();
    }

    @Override
    public void print(Appendable out) {
    }

    private static final class TOCState {
        private long cid;
        private int cposition;
        private @Nullable List<Long> trees;
        private @Nullable FragmentNumbering number;
        private @Nullable PublicationConfig config;
        private Map<Long, Integer> doccount = new HashMap<Long, Integer>();
        private List<String> ancestors = new ArrayList<String>();
        private boolean externalrefs;

        private TOCState(long cid, int cposition, @Nullable List<Long> trees, @Nullable FragmentNumbering number, @Nullable PublicationConfig config, boolean externalrefs) {
            this.cid = cid;
            this.cposition = cposition;
            this.trees = trees;
            this.number = number;
            this.config = config;
            this.externalrefs = externalrefs;
        }
    }
}

