/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.FragmentNumbering;

public final class PublicationNumbering {
    private static final Pattern SCHEME_PATTERN = Pattern.compile("\\[(.*?)([0-9]+)(.*?)\\](?![\\]])");
    private static final Pattern CANONICAL_PATTERN = Pattern.compile("(\\d+)\\.");
    private static final String[] LOWERCASE_ALPHABET = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final String[] UPPERCASE_ALPHABET = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String[] LOWERCASE_ROMAN_ALPHABET = new String[]{"i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix", "x"};
    private static final String[] UPPERCASE_ROMAN_ALPHABET = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
    private SkippedLevels skippedLevels = SkippedLevels.ONE;
    private String label = "";
    private final Map<String, String> formats = new HashMap<String, String>();
    private final Map<String, NumberType> types = new HashMap<String, NumberType>();
    private final Map<String, ElementName> elements = new HashMap<String, ElementName>();
    private final List<String> restarts = new ArrayList<String>();

    public void setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("Label can not be null");
        }
        this.label = label;
    }

    public void setSkippedLevels(SkippedLevels skippedLevels) {
        this.skippedLevels = skippedLevels;
    }

    public String getLabel() {
        return this.label;
    }

    public SkippedLevels getSkippedLevels() {
        return this.skippedLevels;
    }

    public void addNumberFormat(int level, @Nullable String blocklabel, String scheme) {
        if (blocklabel == null) {
            blocklabel = "";
        }
        this.formats.put(level + "-" + blocklabel, scheme);
    }

    public void addNumberType(int level, @Nullable String blocklabel, String type) {
        if (blocklabel == null) {
            blocklabel = "";
        }
        this.types.put(level + "-" + blocklabel, NumberType.fromString(type));
    }

    public void addElement(int level, @Nullable String blocklabel, String element) {
        if (blocklabel == null) {
            blocklabel = "";
        }
        this.elements.put(level + "-" + blocklabel, ElementName.fromString(element));
    }

    public void addRestart(int level, @Nullable String blocklabel) {
        if (blocklabel == null) {
            blocklabel = "";
        }
        this.restarts.add(level + "-" + blocklabel);
    }

    public @Nullable String getNumberFormat(int level, String blocklabel) {
        return this.formats.get(level + "-" + blocklabel);
    }

    public NumberType getNumberType(int level, String blockLabel) {
        NumberType type = this.types.get(level + "-" + blockLabel);
        if (type == null) {
            type = this.types.get(level + "-");
        }
        return type;
    }

    public boolean hasRestart(int level, String blocklabel) {
        String key = level + "-" + blocklabel;
        return this.restarts.contains(key);
    }

    public boolean hasRestarts() {
        return !this.restarts.isEmpty();
    }

    public boolean hasScheme(int level, String blocklabel, String name) {
        String key = level + "-" + blocklabel;
        ElementName element = this.elements.get(key);
        if (element == null) {
            key = level + "-";
            element = this.elements.get(key);
        }
        return ElementName.ANY.equals((Object)element) || element != null && element.toString().equals(name);
    }

    public FragmentNumbering.Prefix getPrefix(String canonical, String blocklabel) {
        int level;
        StringBuilder prefix = new StringBuilder();
        Object toParse = !canonical.matches("^.*\\.$") ? canonical + "." : canonical;
        int lowest = this.buildPrefix(prefix, (String)toParse, this.getNumberFormat(level = ((String)toParse).split("\\.").length, blocklabel), blocklabel);
        if (lowest == 1) {
            return new FragmentNumbering.Prefix(prefix.toString(), canonical, level, null);
        }
        StringBuilder parentNumber = new StringBuilder();
        int i = ((String)toParse).lastIndexOf(46, ((String)toParse).length() - 2);
        int prevlevel = level;
        while (i != -1 && prevlevel > 1) {
            if (--prevlevel >= lowest) continue;
            toParse = ((String)toParse).substring(0, i + 1);
            StringBuilder parent = new StringBuilder();
            lowest = this.buildPrefix(parent, (String)toParse, this.getNumberFormat(prevlevel, ""), "");
            parentNumber.insert(0, parent);
            i = ((String)toParse).lastIndexOf(46, ((String)toParse).length() - 2);
        }
        return new FragmentNumbering.Prefix(prefix.toString(), canonical, level, parentNumber.toString());
    }

    private int buildPrefix(StringBuilder prefix, String canonical, String scheme, String blocklabel) {
        if (scheme == null) {
            if (this.skippedLevels == SkippedLevels.STRIP) {
                prefix.append(canonical.replaceFirst("^(0\\.)+", "").replaceAll("(\\.0\\.)", "."));
            } else {
                prefix.append(canonical);
            }
            return 1;
        }
        Matcher canonicalMatcher = CANONICAL_PATTERN.matcher(canonical);
        HashMap<Integer, Integer> levels = new HashMap<Integer, Integer>();
        int currentLevel = 1;
        while (canonicalMatcher.find()) {
            levels.put(currentLevel++, Integer.parseInt(canonicalMatcher.group(1)));
        }
        Matcher schemeMatcher = SCHEME_PATTERN.matcher(scheme);
        int lowest = currentLevel;
        while (schemeMatcher.find()) {
            Integer value;
            int level = Integer.parseInt(schemeMatcher.group(2));
            if (level < lowest) {
                lowest = level;
            }
            if ((value = (Integer)levels.get(level)) == null || value == 0 && this.skippedLevels == SkippedLevels.STRIP) continue;
            prefix.append(schemeMatcher.group(1));
            prefix.append(PublicationNumbering.numbering(value, this.getNumberType(level, blocklabel)));
            prefix.append(schemeMatcher.group(3));
        }
        return lowest;
    }

    protected static String numbering(int value, NumberType type) {
        if (value == 0 || type == NumberType.DECIMAL) {
            return String.valueOf(value);
        }
        String[] numbers = null;
        if (type == NumberType.LOWERALPHA) {
            numbers = LOWERCASE_ALPHABET;
        } else if (type == NumberType.UPPERALPHA) {
            numbers = UPPERCASE_ALPHABET;
        } else if (type == NumberType.LOWERROMAN) {
            numbers = LOWERCASE_ROMAN_ALPHABET;
        } else if (type == NumberType.UPPERROMAN) {
            numbers = UPPERCASE_ROMAN_ALPHABET;
        } else {
            return String.valueOf(value);
        }
        StringBuilder number = new StringBuilder();
        while (value > 0) {
            int digit = value % numbers.length;
            if (digit == 0) {
                digit = numbers.length;
            }
            number.insert(0, numbers[digit - 1]);
            if ((value -= digit) <= 0 || type == NumberType.LOWERROMAN || type == NumberType.UPPERROMAN) continue;
            value /= numbers.length;
        }
        return number.toString();
    }

    public static enum SkippedLevels {
        ONE,
        ZERO,
        STRIP;


        public static SkippedLevels fromString(String value) {
            if ("1".equals(value)) {
                return ONE;
            }
            if ("0".equals(value)) {
                return ZERO;
            }
            if ("strip".equals(value)) {
                return STRIP;
            }
            return ONE;
        }
    }

    public static enum ElementName {
        HEADING,
        PARA,
        ANY;


        public static ElementName fromString(String value) {
            for (ElementName n : ElementName.values()) {
                if (!n.name().toLowerCase().equals(value)) continue;
                return n;
            }
            return HEADING;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    protected static enum NumberType {
        DECIMAL,
        LOWERALPHA,
        UPPERALPHA,
        LOWERROMAN,
        UPPERROMAN;


        public static NumberType fromString(String value) {
            for (NumberType n : NumberType.values()) {
                if (!n.name().toLowerCase().equals(value)) continue;
                return n;
            }
            return DECIMAL;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

