/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.Heading;
import org.pageseeder.psml.toc.Paragraph;
import org.pageseeder.psml.toc.Reference;
import org.pageseeder.psml.toc.Toc;
import org.pageseeder.psml.toc.TransclusionEnd;
import org.pageseeder.psml.toc.TreeExpander;
import org.pageseeder.psml.xml.BasicHandler;
import org.xml.sax.Attributes;

public final class DocumentTreeHandler
extends BasicHandler<DocumentTree> {
    private static final int SECTION_TITLE_LEVEL = 2;
    private static final String DEFAULT_FRAGMENT = "default";
    private static final String PSML_MEDIATYPE = "application/vnd.pageseeder.psml+xml";
    private final TreeExpander _expander = new TreeExpander();
    private final Deque<Boolean> _blockxrefs = new ArrayDeque<Boolean>();
    private final Deque<String> _fragmentIDs = new ArrayDeque<String>();
    private boolean paraTitles = true;
    private @Nullable Heading currentHeading = null;
    private @Nullable Reference currentReference = null;
    private @Nullable Paragraph currentParagraph = null;
    private boolean firstHeading = false;
    private boolean ignore = false;
    private int inMediaFragment = 0;
    private final DocumentTree.Builder _tree;
    private String fragment = "default";
    private @Nullable String currentBlockLabel = null;
    private int counter = 1;
    private int sectioncounter = 1;
    private int transclusionLevel = 0;
    private int fragmentLevel = 0;
    private @Nullable StringBuilder placeholderContent = null;
    private @Nullable OffsetDateTime lastEdited = null;
    private @Nullable String path = null;

    public DocumentTreeHandler() {
        this._tree = new DocumentTree.Builder();
        this._fragmentIDs.push(DEFAULT_FRAGMENT);
    }

    public DocumentTreeHandler(long uri) {
        this._tree = new DocumentTree.Builder(uri);
        this._fragmentIDs.push(DEFAULT_FRAGMENT);
    }

    public void setParaTitles(boolean store) {
        this.paraTitles = store;
    }

    @Override
    public void startElement(String element, Attributes attributes) {
        if (this.isElement("media-fragment")) {
            ++this.inMediaFragment;
        }
        if (this.inMediaFragment > 0) {
            return;
        }
        try {
            if (this.isElement("fragmentinfo") && attributes.getValue("structure-modified") != null) {
                OffsetDateTime modified = OffsetDateTime.parse(attributes.getValue("structure-modified"));
                if (this.lastEdited == null || this.lastEdited.isBefore(modified)) {
                    this.lastEdited = modified;
                }
            } else if (this.isElement("locator") && attributes.getValue("modified") != null) {
                OffsetDateTime modified = OffsetDateTime.parse(attributes.getValue("modified"));
                if (this.lastEdited == null || this.lastEdited.isBefore(modified)) {
                    this.lastEdited = modified;
                }
            }
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        if (this.ignore) {
            return;
        }
        if ("blockxref".equals(element)) {
            this._blockxrefs.push("transclude".equals(attributes.getValue("type")));
        }
        if (this.isElement("fragmentinfo") || this.isElement("metadata")) {
            this.ignore = true;
        } else if (this.isElement("document")) {
            this.startDocument(attributes);
        } else if (this.isElement("toc")) {
            this._expander.addLeaf(new Toc());
            if (!this.hasAncestor("blockxref") && this.currentHeading != null) {
                this.currentHeading = Heading.untitled(1, DEFAULT_FRAGMENT, DEFAULT_FRAGMENT, 1);
            }
        } else if (this.isElement("heading") || this.isElement("title") && this.isParent("section")) {
            this.startHeading(attributes);
        } else if ((this.isElement("xref") || this.isElement("link")) && this.isParent("property")) {
            this.newXmlBuffer();
        } else if (this.isElement("property")) {
            this.startProperty(attributes);
        } else if (this.isElement("para")) {
            this.startPara(attributes);
        } else if (this.isAny("fragment", "xref-fragment", "properties-fragment")) {
            this.startFragment(attributes);
        } else if ("block".equals(element)) {
            this.startBlock(attributes);
        } else if ("blockxref".equals(element) && ("embed".equals(attributes.getValue("type")) || "transclude".equals(attributes.getValue("type")))) {
            this.startReference(attributes);
        } else if ("reversexref".equals(element) && !this.hasAncestor("blockxref")) {
            this.startReverseRef(attributes);
        } else if (this.isElement("displaytitle") && !this.hasAncestor("blockxref")) {
            this.newBuffer();
        } else if (this.isElement("uri") && !this.hasAncestor("blockxref")) {
            this.path = attributes.getValue("path");
        } else if (this.isElement("labels") && !this.hasAncestor("blockxref") && !this.hasAncestor("xref")) {
            this.newBuffer();
        } else if (this.isElement("placeholder")) {
            this.startPlaceholder(attributes);
        }
    }

    private void startHeading(Attributes attributes) {
        Heading heading;
        if (this.isParent("section")) {
            this.fragmentLevel = 2;
            heading = Heading.untitled(this.transclusionLevel + 2, DEFAULT_FRAGMENT, DEFAULT_FRAGMENT, this.sectioncounter);
            ++this.sectioncounter;
        } else {
            String prefix;
            int level = DocumentTreeHandler.getInt(attributes, "level");
            this.fragmentLevel = DocumentTreeHandler.getInt(attributes, "level");
            heading = Heading.untitled(this.transclusionLevel + level, this.fragment, this._fragmentIDs.peek(), this.counter);
            if ("true".equals(attributes.getValue("numbered"))) {
                heading = heading.numbered(true);
            }
            if ((prefix = attributes.getValue("prefix")) != null) {
                heading = heading.prefix(prefix);
            }
            if (this.isParent("block") && this.currentBlockLabel != null) {
                heading = heading.blocklabel(this.currentBlockLabel);
            }
            ++this.counter;
        }
        this.newBuffer();
        this.newXmlBuffer();
        this.currentHeading = heading;
    }

    private void startPara(Attributes attributes) {
        String prefix = attributes.getValue("prefix");
        String numbered = attributes.getValue("numbered");
        Paragraph para = new Paragraph(DocumentTreeHandler.getInt(attributes, "indent", 0), this.fragment, this._fragmentIDs.peek(), this.counter);
        if ("true".equals(numbered)) {
            para = para.numbered(true);
        }
        if (prefix != null) {
            para = para.prefix(prefix);
        }
        if (this.isParent("block") && this.currentBlockLabel != null) {
            para = para.blocklabel(this.currentBlockLabel);
        }
        this.currentParagraph = para;
        this.newBuffer();
        this.firstHeading = false;
        ++this.counter;
    }

    private void startPlaceholder(Attributes attributes) {
        String name = attributes.getValue("name");
        if (attributes.getValue("resolved") == null && attributes.getValue("unresolved") == null && this.buffer() != null && name != null) {
            this.placeholderContent = new StringBuilder().append(this.buffer(true)).append("[").append(name).append("]");
        }
    }

    private void startDocument(Attributes attributes) {
        if (this._tree.id() < 0L) {
            this._tree.id(DocumentTreeHandler.getLong(attributes, "id"));
        }
    }

    private void startFragment(Attributes attributes) {
        String fragment = DocumentTreeHandler.getString(attributes, "id");
        this._fragmentIDs.push(fragment);
        if (!this.hasAncestor("blockxref") && !this.hasAncestor("xref")) {
            this.fragment = fragment;
            this._tree.putFragmentLevel(this.fragment, this.fragmentLevel);
            this.counter = 1;
            this.firstHeading = true;
        }
    }

    private void startBlock(Attributes attributes) {
        this.currentBlockLabel = DocumentTreeHandler.getString(attributes, "label");
    }

    private void startReference(Attributes attributes) {
        long uriid = DocumentTreeHandler.getLong(attributes, "uriid", -1L);
        if (uriid > 0L) {
            int level = DocumentTreeHandler.getInt(attributes, "level", 0);
            String documenttype = PSML_MEDIATYPE.equals(attributes.getValue("mediatype")) ? DocumentTreeHandler.getString(attributes, "documenttype", DEFAULT_FRAGMENT) : null;
            Reference.Type type = Reference.Type.fromString(attributes.getValue("type"));
            String title = this.computeReferenceTitle(attributes);
            String display = attributes.getValue("display");
            Reference reference = new Reference(level, title, this.fragment, this._fragmentIDs.peek(), uriid, type, documenttype, attributes.getValue("frag"), display == null || "document".equals(display) ? Boolean.TRUE : Boolean.FALSE);
            if (Reference.Type.EMBED.equals((Object)type)) {
                this.newBuffer();
                this.currentReference = reference;
            } else {
                this._expander.addLeaf(reference);
                this.transclusionLevel = level;
            }
        }
    }

    private void startReverseRef(Attributes attributes) {
        String type = DocumentTreeHandler.getString(attributes, "forwardtype", "none");
        Long ref = DocumentTreeHandler.getLong(attributes, "uriid");
        if ("embed".equals(type)) {
            this._tree.addReverseReferenceIfNew(ref);
        }
    }

    private void startProperty(Attributes attributes) {
        String value = attributes.getValue("value");
        if (value != null && !value.isEmpty() && this.firstHeading) {
            this._tree.putFragmentHeading(this.fragment, XMLUtils.escape(value));
            this.firstHeading = false;
        }
    }

    @Override
    public void endElement(String element) {
        if ((this.isElement("fragmentinfo") || this.isElement("metadata")) && this.inMediaFragment == 0) {
            this.ignore = false;
        } else if (this.isElement("media-fragment")) {
            --this.inMediaFragment;
        }
        if (this.ignore || this.inMediaFragment > 0) {
            return;
        }
        if ("placeholder".equals(element) && this.placeholderContent != null) {
            this.newBuffer();
            this.append(this.placeholderContent.toString());
            this.placeholderContent = null;
        } else if ("heading".equals(element) || this.isElement("title") && this.isParent("section")) {
            Heading heading = this.currentHeading;
            if (heading != null) {
                String title;
                String xmltitle = this.xmlBuffer(true);
                if (xmltitle != null && this.firstHeading) {
                    this._tree.putFragmentHeading(this.fragment, xmltitle);
                    this.firstHeading = false;
                }
                if ((title = this.buffer(true)) != null) {
                    heading = heading.title(title);
                }
                this._expander.add(heading);
            }
        } else if ((this.isElement("xref") || this.isElement("link")) && this.isParent("property")) {
            String xmltitle = this.xmlBuffer(true);
            if (xmltitle != null && this.firstHeading) {
                this._tree.putFragmentHeading(this.fragment, xmltitle);
                this.firstHeading = false;
            }
        } else if ("para".equals(element) && this.currentParagraph != null) {
            Object title = this.buffer(true);
            Paragraph para = this.currentParagraph;
            if (title != null && para.numbered() && this.paraTitles) {
                if ("".equals(para.blocklabel()) && ((String)title).length() > 40) {
                    title = ((String)title).substring(0, 40) + "...";
                } else if (((String)title).length() > 100) {
                    title = ((String)title).substring(0, 100) + "...";
                }
                para = para.title((String)title);
            }
            this._expander.addLeaf(para);
            this.currentParagraph = null;
        } else if ("displaytitle".equals(element) && !this.hasAncestor("blockxref")) {
            String title = this.buffer(true);
            if (title != null) {
                this._tree.title(title);
            }
        } else if ("labels".equals(element) && !this.hasAncestor("blockxref") && !this.hasAncestor("xref")) {
            String labels = this.buffer(true);
            if (labels != null) {
                this._tree.labels(labels);
            }
        } else if ("block".equals(element)) {
            this.currentBlockLabel = null;
        } else if ("blockxref".equals(element)) {
            Reference reference = this.currentReference;
            if (reference != null) {
                String title = this.buffer(true);
                if (title != null) {
                    reference = reference.title(title);
                }
                int partLevel = this.getBaseLevel() + 1;
                int newlevel = partLevel + reference.level();
                this._expander.add(reference, newlevel);
                this.currentReference = null;
            }
            if (!this.hasAncestor("blockxref")) {
                this.transclusionLevel = 0;
            }
            if (this._blockxrefs.peek().booleanValue()) {
                this._expander.addLeaf(new TransclusionEnd(this.fragment, this._fragmentIDs.peek()));
            }
            this._blockxrefs.pop();
        } else if ("fragment".equals(element) || "xref-fragment".equals(element) || "properties-fragment".equals(element)) {
            this._fragmentIDs.pop();
        } else if ("document".equals(element) && !this.hasAncestor("blockxref")) {
            this._tree.lastedited(this.lastEdited);
            this._tree.path(this.path);
            this._tree.parts(this._expander.parts());
            this.add(this._tree.build());
        }
    }

    private String computeReferenceTitle(Attributes attributes) {
        String document = Objects.toString(attributes.getValue("urititle"));
        String display = Objects.toString(attributes.getValue("display"));
        if ("document+manual".equals(display)) {
            String manual = Objects.toString(attributes.getValue("title"));
            return document + manual;
        }
        if ("document+fragment".equals(display)) {
            String fragment = Objects.toString(attributes.getValue("frag"));
            return document + fragment;
        }
        if ("manual".equals(display)) {
            String manual = Objects.toString(attributes.getValue("title"));
            return manual;
        }
        return document;
    }

    private int getBaseLevel() {
        Heading heading = this.currentHeading;
        return heading != null ? heading.level() : 0;
    }
}

