/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.template.Template;
import org.pageseeder.psml.template.TemplateException;
import org.pageseeder.psml.template.TemplateFactory;
import org.xml.sax.InputSource;

public final class Processor {
    private final Charset charset;
    private @Nullable String fragment;
    private boolean failOnError = false;

    public Processor() {
        this.charset = StandardCharsets.US_ASCII;
    }

    public Processor(Charset charset) {
        if (!TemplateFactory.isSupported(charset)) {
            throw new IllegalArgumentException("Unsupported encoding");
        }
        this.charset = charset;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public void process(Reader template, Writer psml, Map<String, String> values) throws IOException, TemplateException {
        InputSource source = new InputSource(template);
        PrintWriter out = new PrintWriter(psml);
        this.process(source, out, values);
    }

    public void process(File template, File psml, Map<String, String> values) throws IOException, TemplateException {
        InputSource source = new InputSource(template.toURI().toASCIIString());
        PrintWriter out = new PrintWriter(psml, this.charset);
        this.process(source, out, values);
    }

    public void process(Reader template, File psml, Map<String, String> values) throws IOException, TemplateException {
        InputSource source = new InputSource(template);
        PrintWriter out = new PrintWriter(psml, this.charset);
        this.process(source, out, values);
    }

    public void process(InputSource template, PrintWriter psml, Map<String, String> values) throws IOException, TemplateException {
        TemplateFactory factory = new TemplateFactory(this.charset);
        factory.setFragment(this.fragment);
        Template t = factory.parse(template);
        if (t == null) {
            throw new TemplateException("No matching template");
        }
        t.process(psml, values, this.failOnError);
    }

    public static void main(String[] args) throws IOException, TemplateException {
        if (args.length > 0) {
            File f = new File(args[0]);
            InputSource source = new InputSource(f.toURI().toASCIIString());
            PrintWriter psml = new PrintWriter(System.out);
            Processor p = new Processor(StandardCharsets.US_ASCII);
            HashMap<String, String> parameters = null;
            for (String a : args) {
                if (parameters == null) {
                    parameters = new HashMap<String, String>();
                    continue;
                }
                int equal = a.indexOf(61);
                if (a.equals("-failonerror")) {
                    p.setFailOnError(true);
                    continue;
                }
                if (a.startsWith("-fragment:")) {
                    p.setFragment(a.substring(a.indexOf(58) + 1));
                    continue;
                }
                if (equal <= 0) continue;
                parameters.put(a.substring(0, equal), a.substring(equal + 1));
            }
            System.err.println(parameters);
            p.process(source, psml, parameters);
        } else {
            System.err.println("Processor [template] [param1=value1] [param2=value2]...");
        }
    }
}

