/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

public enum ParameterType {
    INTEGER{

        @Override
        public boolean matches(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
    }
    ,
    TEXT{

        @Override
        public boolean matches(String value) {
            return true;
        }
    }
    ,
    DATE{

        @Override
        public boolean matches(String value) {
            return value.matches("^([0-9]{4})-(1[0-2]|0[1-9])-(3[0-1]|0[1-9]|[1-2][0-9])$");
        }
    }
    ,
    DATETIME{

        @Override
        public boolean matches(String value) {
            return true;
        }
    }
    ,
    TIME{

        @Override
        public boolean matches(String value) {
            return value.matches("^(2[0-3]|[0-1][0-9]):([0-5][0-9]):([0-5][0-9])(\\.[0-9]+)??(Z|[+-](?:2[0-3]|[0-1][0-9]):[0-5][0-9])?$");
        }
    }
    ,
    XML{

        @Override
        public boolean matches(String value) {
            return true;
        }
    };


    public abstract boolean matches(String var1);

    public static ParameterType forName(String name) {
        for (ParameterType type : ParameterType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return TEXT;
    }
}

