/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process.util;

import java.io.File;
import java.io.IOException;

public final class Files {
    private Files() {
    }

    public static String computeRelativePath(File file, File root) throws IllegalArgumentException {
        int i;
        String rpath;
        String fpath;
        try {
            fpath = file.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to compute file's canonical path: " + ex.getMessage(), ex);
        }
        try {
            rpath = root.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to compute root's canonical path: " + ex.getMessage(), ex);
        }
        if (fpath.equals(rpath)) {
            return "";
        }
        if (fpath.startsWith(rpath + File.separator)) {
            return fpath.substring(rpath.length() + 1).replace(File.separatorChar, '/');
        }
        for (i = 0; i < rpath.length() && i < fpath.length() && rpath.charAt(i) == fpath.charAt(i); ++i) {
        }
        throw new IllegalArgumentException("The path " + File.separatorChar + fpath.substring(i) + " is outside the src path " + File.separatorChar + rpath.substring(i));
    }
}

