/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process.math;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.util.WrappingReader;
import org.pageseeder.psml.util.PSCache;

public final class AsciiMathConverter {
    private static final String JS_SCRIPT = "/org/pageseeder/psml/process/math/ASCIIMathML.js";
    private static @Nullable Invocable script = null;
    private static final Map<String, String> cache = Collections.synchronizedMap(new PSCache(200));

    private AsciiMathConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(@Nullable String asciimath) {
        if (asciimath == null || asciimath.isEmpty()) {
            return "";
        }
        String am = asciimath;
        if (am.charAt(0) == '`' && am.charAt(am.length() - 1) == '`') {
            am = am.substring(1, am.length() - 1);
        }
        if (am.contains("class")) {
            throw new IllegalArgumentException("The AsciiMath \"" + am + "\" could not be converted to MathML because \"class\" is not supported.");
        }
        if (am.contains("id")) {
            throw new IllegalArgumentException("The AsciiMath \"" + am + "\" could not be converted to MathML because \"id\" is not supported.");
        }
        String result = cache.get(am);
        if (result == null) {
            try {
                Class<AsciiMathConverter> clazz = AsciiMathConverter.class;
                synchronized (AsciiMathConverter.class) {
                    result = AsciiMathConverter.script().invokeFunction("parse", am).toString();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    cache.put(am, result);
                }
            }
            catch (IOException | NoSuchMethodException | ScriptException ex) {
                throw new IllegalArgumentException("Failed to run ASCIIMath to MathML JS script: " + ex.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<AsciiMathConverter> clazz = AsciiMathConverter.class;
        synchronized (AsciiMathConverter.class) {
            script = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Invocable script() throws ScriptException, IOException {
        Class<AsciiMathConverter> clazz = AsciiMathConverter.class;
        synchronized (AsciiMathConverter.class) {
            if (script != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return script;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("rhino");
            Compilable cengine = (Compilable)((Object)engine);
            try {
                CompiledScript cscript = cengine.compile(new WrappingReader(new InputStreamReader(AsciiMathConverter.class.getResourceAsStream(JS_SCRIPT)), AsciiMathConverter.prefix(), "var parse = function(str) {asciimath.initSymbols(); return asciimath.parseMath(str, false).toXML();};"));
                cscript.eval();
                script = (Invocable)((Object)cscript.getEngine());
                return (Invocable)((Object)cscript.getEngine());
            }
            catch (IOException | ScriptException ex) {
                System.err.println("Failed to load ASCIIMath to MathML JS script: " + ex.getMessage());
                throw ex;
            }
        }
    }

    private static String prefix() {
        return "indent = true;navigator = {appName: ''};text = function(v) { return {  nodeValue: v,  parentNode: {},  hasChildNodes: function() { return false; },  toXML: function() { return xml_encode(this.nodeValue); }}};element = function(ns, n) { return {  namespace: ns,  nodeName: n,  fragment: !n,  atts: [],  childNodes: [],  firstChild: null,  lastChild: null,  nextSibling: null,  parentNode: null,  replaceChild: function(n, o) {    for (var i = 0; i < this.childNodes.length; i++) {      if (this.childNodes[i] == o) {        if (n.parentNode && n.parentNode.removeChild) { n.parentNode.removeChild(n); }        this.childNodes[i] = n;        this.childNodes[i].parentNode = null;        this.childNodes[i].nextSibling = null;        n.parentNode = this;        if (i > 0) { this.childNodes[i-1].nextSibling = n; }        if (i < this.childNodes.length-1) { n.nextSibling = this.childNodes[i+1]; }        break;      }    }    this.firstChild = !this.childNodes.length ? null : this.childNodes[0];    this.lastChild  = !this.childNodes.length ? null : this.childNodes[this.childNodes.length-1];  },  appendChild: function(n) {    if (n.fragment) {      while (n.hasChildNodes()) { this.appendChild(n.firstChild); }    } else {      if (n.parentNode && n.parentNode.removeChild) { n.parentNode.removeChild(n); }      this.childNodes.push(n);      n.parentNode = this;      n.nextSibling = null;      if (this.lastChild) { this.lastChild.nextSibling = n; }      this.firstChild = this.childNodes[0];      this.lastChild  = !this.childNodes.length ? null : this.childNodes[this.childNodes.length-1];    }  },  removeChild: function(n) {    var ind = this.childNodes.indexOf(n);    if (ind >= 0) {      if (ind != 0) { this.childNodes[ind-1].nextSibling = ind == this.childNodes.length-1 ? null : this.childNodes[ind+1]; }      this.childNodes.splice(ind, 1);      n.parentNode = null;      n.nextSibling = null;    }    this.firstChild = !this.childNodes.length ? null : this.childNodes[0];    this.lastChild  = !this.childNodes.length ? null : this.childNodes[this.childNodes.length-1];  },  hasChildNodes: function() { return this.childNodes.length > 0; },  setAttribute: function(n, v) { this.atts.push({name: n, value: v}); },  toXML: function() {    var xml = '';    if (this.nodeName) {      var p = !indent ? null : this.parentNode;      while (p) { if (p.nodeName) { xml += '  '; } p = p.parentNode; }      xml += '<'+this.nodeName;      if (this.namespace && this.nodeName == 'math') {        xml += ' xmlns=\"' + this.namespace + '\"';      }      for (var i = 0; i < this.atts.length; i++) {        var value = this.atts[i].value.toString().replace(/(\")|(&#34;)/g, '&quot;');        xml += ' ' + this.atts[i].name + '=\"' + value + '\"';      }      xml += '>';    }    if (indent && this.childNodes.length > 0 && this.childNodes[0].nodeName) { xml += '\\n'; }    for (var i = 0; i < this.childNodes.length; i++) {      if (this.childNodes[i].toXML) { xml += this.childNodes[i].toXML(); }      else xml += 'unknown element: '+this.childNodes[i];    }    if (this.nodeName) {      if (indent && this.childNodes.length > 0 && this.childNodes[0].nodeName) {        var p = this.parentNode;        while (p) { if (p.nodeName) { xml += '  '; } p = p.parentNode; }      }      xml += '</'+this.nodeName+'>' + ( indent ? '\\n' : '');    }    return xml;  }}};document = {  getElementById         : function()      { return ''; },  getElementsByTagName   : function(n)     { return [element(n)]; },  createTextNode         : function(v)     { return text(v); },  createElement          : function(n)     { return element('', n); },  createElementNS        : function(ns, n) { return element(ns, n); },  createDocumentFragment : function()      { return element(); }};console = { log : function(e) { if (e.toXML) { print('console: ' + e.toXML()); } else { print('console: ' + e); } } },window = {};var codePointAt = function (s, p) {  var code = s.charCodeAt(p);  var next = s.charCodeAt(p + 1);  if (0xD800 <= code && code <= 0xDBFF && 0xDC00 <= next && next <= 0xDFFF) {    return ((code - 0xD800) * 0x400) + (next - 0xDC00) + 0x10000;  }  return code;};var xml_encode = function(s) {  var v = '';  for (var i = 0; i < s.length; i++) {     var cp = codePointAt(s, i);    var c  = s.charAt(i);    if (cp > 127) { v += '&#' + cp + ';'; }    else if (c == '<') { v += '&lt;'; }    else if (c == '>') { v += '&gt;'; }    else if (c == '&') { v += '&amp;'; }    else               { v += s.charAt(i); }  }  return v;}";
    }
}

