/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.PSMLProcessHandler;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TransclusionHandler
extends DefaultHandler {
    private final PSMLProcessHandler parentHandler;
    private final String fragment;
    private final boolean transclude;
    private final XMLWriter xml;
    private boolean ignoreText = false;
    private boolean ignoreElements = false;
    private boolean inCompare = false;
    private boolean inMetadata = false;
    private boolean publication = false;
    private @Nullable String placeholderContent = null;
    private Map<String, String> documentMetadata = new HashMap<String, String>();

    public TransclusionHandler(XMLWriter out, String fragment, boolean transclude, PSMLProcessHandler parent) {
        this.xml = out;
        this.fragment = fragment;
        this.transclude = transclude;
        this.parentHandler = parent;
        if (!"default".equals(fragment)) {
            this.ignoreElements = true;
            this.ignoreText = true;
        }
    }

    public @Nullable Map<String, String> getPublicationMetadata() {
        return this.publication ? this.documentMetadata : null;
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("compare".equals(qName)) {
            this.inCompare = true;
        }
        if ("properties".equals(qName)) {
            this.inMetadata = true;
        }
        if ("publication".equals(qName)) {
            this.publication = true;
        }
        if (!this.inCompare && this.parentHandler.isFragment(qName) && this.fragment.equals(atts.getValue("id"))) {
            this.ignoreElements = false;
            this.ignoreText = false;
        }
        if (this.ignoreElements) {
            return;
        }
        if (this.parentHandler.resolvePlaceholders()) {
            if (this.inMetadata && "property".equals(qName) && this.transclude && atts.getValue("name") != null && !"xref".equals(atts.getValue("datatype")) && !"markdown".equals(atts.getValue("datatype")) && (atts.getValue("count") == null || "1".equals(atts.getValue("count"))) && atts.getValue("multiple") == null) {
                String value = atts.getValue("value") == null ? "" : atts.getValue("value");
                this.documentMetadata.put(atts.getValue("name"), value);
            } else if ("placeholder".equals(qName) && atts.getValue("name") != null) {
                String name = atts.getValue("name");
                if (this.parentHandler.getPublicationMetadata() != null) {
                    this.placeholderContent = this.parentHandler.getPublicationMetadata().get(name);
                } else if (this.documentMetadata != null) {
                    this.placeholderContent = this.documentMetadata.get(name);
                }
            }
        }
        try {
            this.xml.openElement(qName, true);
        }
        catch (IOException ex) {
            throw new SAXException("Failed to open element " + qName, ex);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String auri = atts.getURI(i);
            if (auri != null && auri.isEmpty()) {
                auri = null;
            }
            try {
                this.xml.attribute(atts.getQName(i), atts.getValue(i));
                continue;
            }
            catch (IOException ex) {
                throw new SAXException("Failed to add attribute \"" + atts.getLocalName(i) + "\" to element " + qName, ex);
            }
        }
        if (this.parentHandler.resolvePlaceholders() && "placeholder".equals(qName)) {
            try {
                if (this.placeholderContent == null) {
                    this.xml.attribute("unresolved", "true");
                } else {
                    this.xml.attribute("resolved", "true");
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to add attribute \"unresolved\" to element " + qName, ex);
            }
        }
        if ("blockxref".equalsIgnoreCase(qName) && "transclude".equalsIgnoreCase(atts.getValue("type"))) {
            try {
                this.ignoreText = this.resolveTransclusion(atts.getValue("href"), atts.getValue("frag"));
            }
            catch (TransclusionException ex) {
                this.parentHandler.getLogger().error(ex.getMessage(), (Throwable)ex);
                this.ignoreText = false;
            }
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (this.placeholderContent != null && "placeholder".equals(qName)) {
                this.xml.writeText(this.placeholderContent);
                this.placeholderContent = null;
            }
            if (!this.ignoreElements) {
                this.xml.closeElement();
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to close element " + qName, ex);
        }
        if ("compare".equals(qName)) {
            this.inCompare = false;
        }
        if ("properties".equals(qName)) {
            this.inMetadata = false;
        }
        if (this.parentHandler.isFragment(qName) && !"default".equals(this.fragment)) {
            this.ignoreElements = true;
        }
        this.ignoreText = this.ignoreElements;
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.ignoreText || this.placeholderContent != null) {
            return;
        }
        try {
            this.xml.writeText(ch, start, length);
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write text", ex);
        }
    }

    private boolean resolveTransclusion(@Nullable String href, String fragment) throws TransclusionException, SAXException {
        if (href == null || !href.endsWith(".psml") || !this.transclude) {
            return false;
        }
        href = URLDecoder.decode(href, StandardCharsets.UTF_8);
        String dadPath = this.parentHandler.getParentFolderRelativePath();
        File target = new File(this.parentHandler.getPSMLRoot(), dadPath + "/" + href);
        if (!target.exists() || !target.isFile()) {
            PSMLProcessHandler.handleError("XRef transclusion not found for path: " + dadPath + "/" + href, this.parentHandler.getFailOnError(), this.parentHandler.getLogger(), this.parentHandler.getErrorXRefNotFound(), this.parentHandler.getWarnXRefNotFound());
            return false;
        }
        TransclusionHandler handler = new TransclusionHandler(this.xml, fragment, false, this.parentHandler);
        handler.documentMetadata = this.documentMetadata;
        try {
            XMLUtils.parse(target, (ContentHandler)handler);
        }
        catch (ProcessException ex) {
            throw new TransclusionException("Error parsing XRef target for path: " + href, ex);
        }
        return true;
    }

    private static class TransclusionException
    extends Exception {
        private static final long serialVersionUID = 7733046469035213494L;

        public TransclusionException(String msg) {
            super(msg);
        }

        public TransclusionException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

