/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.model.PSMLNode;
import org.pageseeder.psml.model.PSMLText;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;

public class PSMLElement
implements PSMLNode {
    private Name name = Name.UNKNOWN;
    private @Nullable Map<String, String> attributes;
    public @Nullable List<PSMLNode> nodes;

    public PSMLElement(Name name) {
        this.name = Objects.requireNonNull(name);
    }

    public Name getElement() {
        return this.name;
    }

    public PSMLElement setName(Name name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    public boolean isElement(Name name) {
        return this.name == name;
    }

    public boolean isAnyElement(Name ... names) {
        for (Name element : names) {
            if (this.name != element) continue;
            return true;
        }
        return false;
    }

    public @Nullable String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public String getAttributeOrElse(String name, String defaultValue) {
        if (this.attributes == null) {
            return defaultValue;
        }
        String value = this.attributes.get(name);
        return value == null ? defaultValue : value;
    }

    public int getAttributeOrElse(String name, int defaultValue) {
        if (this.attributes == null) {
            return defaultValue;
        }
        String value = this.attributes.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public PSMLElement setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>(4);
        }
        this.attributes.put(name, value);
        return this;
    }

    public PSMLElement setAttribute(String name, int value) {
        this.setAttribute(name, Integer.toString(value));
        return this;
    }

    public PSMLElement setAttribute(String name, boolean value) {
        this.setAttribute(name, Boolean.toString(value));
        return this;
    }

    public PSMLElement addNode(PSMLNode node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<PSMLNode>();
        }
        this.nodes.add(node);
        return this;
    }

    public PSMLElement addNodes(List<? extends PSMLNode> nodes) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<PSMLNode>();
        }
        this.nodes.addAll(nodes);
        return this;
    }

    public PSMLElement addNodes(PSMLNode ... nodes) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<PSMLNode>();
        }
        this.nodes.addAll(Arrays.asList(nodes));
        return this;
    }

    public PSMLElement setText(String text) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<PSMLNode>(1);
        } else {
            this.nodes.clear();
        }
        this.nodes.add(new PSMLText(text));
        return this;
    }

    public PSMLElement addText(String text) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<PSMLNode>();
        }
        this.nodes.add(new PSMLText(text));
        return this;
    }

    public List<PSMLNode> getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList<PSMLNode>();
        }
        return this.nodes;
    }

    public List<PSMLElement> getChildElements() {
        if (this.nodes == null) {
            return List.of();
        }
        return this.nodes.stream().filter(PSMLElement.class::isInstance).map(PSMLElement.class::cast).collect(Collectors.toList());
    }

    public List<PSMLElement> getChildElements(Name name) {
        if (this.nodes == null) {
            return List.of();
        }
        return this.nodes.stream().filter(PSMLElement.class::isInstance).map(PSMLElement.class::cast).filter(e -> e.isElement(name)).collect(Collectors.toList());
    }

    public List<PSMLElement> getChildElements(Name ... names) {
        if (this.nodes == null) {
            return List.of();
        }
        return this.nodes.stream().filter(PSMLElement.class::isInstance).map(PSMLElement.class::cast).filter(e -> e.isAnyElement(names)).collect(Collectors.toList());
    }

    public @Nullable PSMLElement getFirstChildElement(Name name) {
        if (this.nodes == null) {
            return null;
        }
        for (PSMLNode node : this.nodes) {
            if (!(node instanceof PSMLElement) || !((PSMLElement)node).isElement(name)) continue;
            return (PSMLElement)node;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.nodes == null || this.nodes.isEmpty();
    }

    public boolean hasChildElements() {
        if (this.nodes == null) {
            return false;
        }
        for (PSMLNode node : this.nodes) {
            if (!(node instanceof PSMLElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getText() {
        if (this.nodes == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (PSMLNode node : this.nodes) {
            out.append(node.getText());
        }
        return out.toString();
    }

    public void toXML(XMLWriter xml) throws IOException {
        boolean hasChildren = !this.name.isInline() && this.hasOnlyElementAsChildren();
        xml.openElement(this.name.element(), hasChildren);
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                xml.attribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.nodes != null) {
            for (PSMLNode pSMLNode : this.nodes) {
                pSMLNode.toXML(xml);
            }
        }
        xml.closeElement();
    }

    public String toString() {
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            this.toXML((XMLWriter)xml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xml.toString();
    }

    private boolean hasOnlyElementAsChildren() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return false;
        }
        for (PSMLNode node : this.nodes) {
            if (!(node instanceof PSMLText)) continue;
            return false;
        }
        return true;
    }

    public static enum Name {
        ANCHOR("anchor", true, "name"),
        AUTHOR("author", "firstname", "id", "surname"),
        BLOCK("block", "label"),
        BLOCKXREF("blockxref", "display", "docid", "documenttype", "external", "frag", "href", "id", "labels", "level", "mediatype", "reverselink", "reversetitle", "reversetype", "title", "type", "unresolved", "uriid", "urititle"),
        BOLD("bold", true, new String[0]),
        BR("br", true, new String[0]),
        CAPTION("caption", new String[0]),
        CELL("cell", "align", "colspan", "role", "rowspan", "valign", "width"),
        COL("col", "align", "part", "role", "span", "width"),
        COMPARE("compare", new String[0]),
        COMPARETO("compareto", "date", "version", "docid"),
        CONTENT("content", new String[0]),
        DESCRIPTION("description", new String[0]),
        DIFF("diff", new String[0]),
        DISPLAYTITLE("displaytitle", new String[0]),
        DOCUMENT("document", "date", "edit", "id", "level", "lockstructure", "schemaversion", "status", "type", "version"),
        DOCUMENTINFO("documentinfo", new String[0]),
        FRAGMENT("fragment", "id", "type"),
        FRAGMENT_REF("fragment-ref", "id"),
        FRAGMENTS("overwrite", new String[0]),
        FRAGMENTINFO("fragmentinfo", new String[0]),
        FULLNAME("fullname", new String[0]),
        HCELL("hcell", "align", "alignment", "colspan", "role", "rowspan", "valign", "width"),
        HEADING("heading", new String[0]),
        IMAGE("image", true, "src", "docid", "uriid", "alt", "height", "unresolved", "width"),
        INLINE("inline", true, "label"),
        ITALIC("italic", true, new String[0]),
        ITEM("item", new String[0]),
        LABELS("labels", new String[0]),
        LINK("link", true, "href", "role"),
        LIST("list", "type", "role"),
        LOCATOR("locator", "editid", "fragment", "id", "modified"),
        MARKDOWN("markdown", new String[0]),
        MEDIA_FRAGMENT("media-fragment", "id", "mediatype", "type"),
        METADATA("metadata", new String[0]),
        MONOSPACE("monospace", true, new String[0]),
        NLIST("nlist", "start", "type", "role"),
        NOTE("note", "id", "modified", "title"),
        NOTES("notes", new String[0]),
        PARA("para", "indent", "numbered", "prefix"),
        PLACEHOLDER("name", true, "unresolved"),
        PREFORMAT("preformat", new String[0]),
        PROPERTIES("properties", new String[0]),
        PROPERTIES_FRAGMENT("properties-fragment", new String[0]),
        PROPERTY("property", "count", "datatype", "name", "title", "value"),
        PUBLICATION("publication", "defaultgroupid", "hostid", "id", "rooturiid", "title", "type"),
        REVERSEXREF("reversexref", "docid", "documenttype", "forwardtitle", "forwardtype", "frag", "href", "id", "labels", "level", "mediatype", "title", "type", "uriid", "urititle"),
        REVERSEXREFS("reversexrefs", "limitreached"),
        ROW("row", "align", "part", "role"),
        SECTION("section", "edit", "fragmenttype", "id", "lockstructure", "overwrite", "title"),
        SECTION_REF("section-ref", "id", "title"),
        STRUCTURE("structure", new String[0]),
        SUB("sub", true, new String[0]),
        SUP("sup", true, new String[0]),
        TABLE("table", "height", "role", "summary", "width"),
        TITLE("title", new String[0]),
        TOC("toc", new String[0]),
        TOCREF("tocref", "level", "idref", "canonical", "prefix"),
        TOC_PART("toc-part", "level", "idref", "canonical", "prefix", "title"),
        TOC_REF("toc-ref", new String[0]),
        TOC_TREE("toc-tree", "title"),
        UNDERLINE("underline", true, new String[0]),
        URI("uri", "created", "decodedpath", "docid", "documenttype", "external", "folder", "host", "id", "mediatype", "modified", "path", "port", "scheme", "title"),
        VALUE("value", new String[0]),
        VERSION("version", "created", "id", "name"),
        VERSIONS("versions", new String[0]),
        XREF("xref", true, "display", "docid", "documenttype", "external", "frag", "href", "id", "labels", "level", "mediatype", "reverselink", "reversetitle", "reversetype", "title", "type", "unresolved", "uriid", "urititle"),
        XREF_FRAGMENT("xref-fragment", "id", "type"),
        UNKNOWN("unknown", new String[0]);

        private final String element;
        private final boolean inline;
        private final List<String> attributes;

        private Name(String name, boolean inline, String ... attributes) {
            this.element = name;
            this.inline = inline;
            this.attributes = Arrays.asList(attributes);
        }

        private Name(String name, String ... attributes) {
            this(name, false, attributes);
        }

        public String element() {
            return this.element;
        }

        public boolean isInline() {
            return this.inline;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public static Name forElement(String name) {
            for (Name element : Name.values()) {
                if (!element.element.equals(name)) continue;
                return element;
            }
            return UNKNOWN;
        }
    }
}

