/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.html.HTMLNode;
import org.pageseeder.psml.html.HTMLText;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;

public class HTMLElement
implements HTMLNode {
    private Name name = Name.UNKNOWN;
    private @Nullable Map<String, String> attributes;
    public @Nullable List<HTMLNode> nodes;

    public HTMLElement(String name) {
        this.name = Name.forElement(name);
    }

    public HTMLElement(Name name) {
        this.name = Objects.requireNonNull(name);
    }

    public Name getElement() {
        return this.name;
    }

    public HTMLElement setName(Name name) {
        this.name = name;
        return this;
    }

    public boolean isElement(Name name) {
        return this.name == name;
    }

    public @Nullable String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public HTMLElement setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>(4);
        }
        this.attributes.put(name, value);
        return this;
    }

    public HTMLElement setAttribute(String name, int value) {
        this.setAttribute(name, Integer.toString(value));
        return this;
    }

    public HTMLElement setAttribute(String name, boolean value) {
        this.setAttribute(name, Boolean.toString(value));
        return this;
    }

    public HTMLElement addNode(HTMLNode node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<HTMLNode>();
        }
        this.nodes.add(node);
        return this;
    }

    public HTMLElement addNodes(List<? extends HTMLNode> nodes) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<HTMLNode>();
        }
        this.nodes.addAll(nodes);
        return this;
    }

    public HTMLElement addNodes(HTMLNode ... nodes) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<HTMLNode>();
        }
        Collections.addAll(this.nodes, nodes);
        return this;
    }

    public HTMLElement setText(String text) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<HTMLNode>(1);
        } else {
            this.nodes.clear();
        }
        this.nodes.add(new HTMLText(text));
        return this;
    }

    public HTMLElement addText(String text) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<HTMLNode>();
        }
        this.nodes.add(new HTMLText(text));
        return this;
    }

    public List<HTMLNode> getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList<HTMLNode>();
        }
        return this.nodes;
    }

    public boolean isEmpty() {
        return this.nodes == null || this.nodes.isEmpty();
    }

    @Override
    public String getText() {
        if (this.nodes == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (HTMLNode node : this.nodes) {
            out.append(node.getText());
        }
        return out.toString();
    }

    public void toXML(XMLWriter xml) throws IOException {
        boolean hasChildren = !this.name.isInline() && this.hasOnlyElementAsChildren();
        xml.openElement(this.name.element(), hasChildren);
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                xml.attribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.nodes != null) {
            for (HTMLNode hTMLNode : this.nodes) {
                hTMLNode.toXML(xml);
            }
        }
        xml.closeElement();
    }

    public String toString() {
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            this.toXML((XMLWriter)xml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xml.toString();
    }

    private boolean hasOnlyElementAsChildren() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return false;
        }
        for (HTMLNode node : this.nodes) {
            if (!(node instanceof HTMLText)) continue;
            return false;
        }
        return true;
    }

    public static enum Name {
        A(true),
        ABBR(true),
        ADDRESS(false),
        ARTICLE(false),
        ASIDE(false),
        AUDIO(true),
        B(true),
        BLOCKQUOTE(false),
        BODY(false),
        BR(true),
        CAPTION(false),
        CITE(true),
        CODE(true),
        COL(false),
        COLGROUP(false),
        DD(false),
        DEL(true),
        DFN(true),
        DIV(false),
        DL(false),
        DT(false),
        EM(true),
        FIGCAPTION(false),
        FIGURE(false),
        FOOTER(false),
        H1(false),
        H2(false),
        H3(false),
        H4(false),
        H5(false),
        H6(false),
        HEAD(false),
        HEADER(false),
        HR(false),
        HTML(false),
        I(true),
        IFRAME(false),
        IMG(true),
        INS(true),
        KBD(true),
        LABEL(true),
        LEGEND(false),
        LI(false),
        LINK(true),
        MAIN(false),
        MARK(true),
        META(false),
        NAV(false),
        OL(false),
        P(false),
        PRE(false),
        Q(true),
        S(true),
        SAMP(true),
        SECTION(false),
        SMALL(true),
        SOURCE(false),
        SPAN(true),
        STRONG(true),
        STYLE(false),
        SUB(true),
        SUMMARY(false),
        SUP(true),
        TABLE(false),
        TBODY(false),
        TD(false),
        TFOOT(false),
        TH(false),
        THEAD(false),
        TIME(true),
        TITLE(false),
        TR(false),
        U(true),
        UL(false),
        VAR(true),
        VIDEO(false),
        UNKNOWN(false);

        private final boolean inline;

        private Name(boolean inline) {
            this.inline = inline;
        }

        public String element() {
            return this.name().toLowerCase();
        }

        public boolean isInline() {
            return this.inline;
        }

        public static Name forElement(String name) {
            for (Name element : Name.values()) {
                if (!element.name().equalsIgnoreCase(name)) continue;
                return element;
            }
            return UNKNOWN;
        }
    }
}

