/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.diffx.token.impl.XMLStartElement;

public final class XMLEndElement
extends TokenBase
implements EndElementToken {
    private final StartElementToken start;

    public XMLEndElement(@NotNull String name) {
        this.start = new XMLStartElement(name);
    }

    public XMLEndElement(@NotNull String uri, @NotNull String localName) {
        this.start = new XMLStartElement(uri, localName);
    }

    public XMLEndElement(@NotNull StartElementToken token) {
        this.start = Objects.requireNonNull(token, "Element must have a name.");
    }

    @Override
    @NotNull
    public String getName() {
        return this.start.getName();
    }

    @Override
    @NotNull
    public String getNamespaceURI() {
        return this.start.getNamespaceURI();
    }

    @Override
    public StartElementToken getOpenElement() {
        return this.start;
    }

    @Override
    public StartElementToken getStartElement() {
        return this.start;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public boolean match(StartElementToken token) {
        if (token == null) {
            return false;
        }
        if (token == this.start) {
            return true;
        }
        return token.getNamespaceURI().equals(this.getNamespaceURI()) && token.getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return 89 + this.start.hashCode();
    }

    @Override
    public boolean equals(XMLToken token) {
        if (token == this) {
            return true;
        }
        if (!(token instanceof EndElementToken)) {
            return false;
        }
        if (this.hashCode() != token.hashCode()) {
            return false;
        }
        EndElementToken other = (EndElementToken)token;
        return other.getName().equals(this.getName()) && other.getNamespaceURI().equals(this.getNamespaceURI());
    }

    public String toString() {
        if (this.start.getNamespaceURI().isEmpty()) {
            return "</" + this.getName() + ">";
        }
        return "</{" + this.getNamespaceURI() + "}:" + this.getName() + ">";
    }
}

