/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.pageseeder.diffx.api.LoadingException;
import org.pageseeder.diffx.config.DiffConfig;
import org.pageseeder.diffx.load.AttributeComparator;
import org.pageseeder.diffx.load.XMLLoader;
import org.pageseeder.diffx.load.XMLLoaderBase;
import org.pageseeder.diffx.load.text.TextTokenizer;
import org.pageseeder.diffx.load.text.TokenizerFactory;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLTokenFactory;
import org.pageseeder.diffx.token.impl.SpaceToken;
import org.pageseeder.diffx.token.impl.XMLAttribute;
import org.pageseeder.diffx.token.impl.XMLComment;
import org.pageseeder.diffx.token.impl.XMLProcessingInstruction;
import org.pageseeder.diffx.xml.Sequence;
import org.xml.sax.InputSource;

public final class XMLStreamLoader
extends XMLLoaderBase
implements XMLLoader {
    @Override
    public Sequence load(File file) throws LoadingException, IOException {
        Sequence sequence;
        BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        try {
            XMLInputFactory factory = XMLStreamLoader.toFactory(this.config);
            factory.setProperty("javax.xml.stream.supportDTD", this.config.allowDoctypeDeclaration());
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            XMLStreamReader reader = factory.createXMLStreamReader(in);
            sequence = this.load(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XMLStreamException ex) {
                throw new LoadingException(ex);
            }
        }
        ((InputStream)in).close();
        return sequence;
    }

    @Override
    public Sequence load(String xml) throws LoadingException {
        XMLInputFactory factory = XMLStreamLoader.toFactory(this.config);
        StringReader source = new StringReader(xml);
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(source);
            Sequence sequence = this.load(reader);
            source.close();
            return sequence;
        }
        catch (Throwable throwable) {
            try {
                try {
                    source.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XMLStreamException ex) {
                throw new LoadingException(ex);
            }
        }
    }

    @Override
    public Sequence load(InputSource source) throws LoadingException, IOException {
        XMLInputFactory factory = XMLStreamLoader.toFactory(this.config);
        try {
            XMLStreamReader reader = XMLStreamLoader.toXMLStreamReader(factory, source);
            return this.load(reader);
        }
        catch (XMLStreamException ex) {
            throw new LoadingException(ex);
        }
    }

    public Sequence load(XMLStreamReader reader) throws LoadingException {
        XMLTokenFactory tokenFactory = new XMLTokenFactory(this.config.isNamespaceAware());
        TextTokenizer tokenizer = TokenizerFactory.get(this.config);
        ArrayList<StartElementToken> startElements = new ArrayList<StartElementToken>();
        Sequence sequence = new Sequence();
        sequence.addNamespace("http://www.w3.org/XML/1998/namespace", "xml");
        sequence.addNamespace("", "");
        try {
            while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement()) {
                    XMLStreamLoader.processNamespaces(reader, sequence);
                    XMLStreamLoader.processStartElement(reader, sequence, tokenFactory, startElements);
                    XMLStreamLoader.processAttributes(reader, sequence, this.config.isNamespaceAware());
                    continue;
                }
                if (reader.isEndElement()) {
                    XMLStreamLoader.processEndElement(reader, sequence, tokenFactory, startElements);
                    continue;
                }
                if (reader.isCharacters()) {
                    XMLStreamLoader.processText(reader, sequence, tokenizer);
                    continue;
                }
                XMLStreamLoader.processOther(reader, sequence);
            }
        }
        catch (XMLStreamException ex) {
            throw new LoadingException(ex);
        }
        return sequence;
    }

    static XMLInputFactory toFactory(DiffConfig config) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
        factory.setProperty("javax.xml.stream.isNamespaceAware", config.isNamespaceAware());
        factory.setProperty("javax.xml.stream.supportDTD", config.allowDoctypeDeclaration());
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return factory;
    }

    private static void processStartElement(XMLStreamReader stream, Sequence sequence, XMLTokenFactory factory, List<StartElementToken> startElements) {
        assert (stream.isStartElement());
        QName name = stream.getName();
        StartElementToken startElement = factory.newStartElement(name.getNamespaceURI(), name.getLocalPart());
        sequence.addToken(startElement);
        startElements.add(startElement);
    }

    private static void processNamespaces(XMLStreamReader stream, Sequence sequence) {
        assert (stream.isStartElement());
        int namespaceCount = stream.getNamespaceCount();
        if (namespaceCount > 0) {
            for (int i = 0; i < namespaceCount; ++i) {
                String prefix;
                String namespaceURI = stream.getNamespaceURI(i);
                if (namespaceURI == null) {
                    namespaceURI = "";
                }
                if ((prefix = stream.getNamespacePrefix(i)) == null) {
                    prefix = "";
                }
                sequence.addNamespace(namespaceURI, prefix);
            }
        }
    }

    private static void processAttributes(XMLStreamReader stream, Sequence sequence, boolean namespaceAware) {
        assert (stream.isStartElement());
        int attributeCount = stream.getAttributeCount();
        if (attributeCount > 0) {
            AttributeToken[] attributes = new AttributeToken[attributeCount];
            for (int i = 0; i < attributeCount; ++i) {
                attributes[i] = XMLStreamLoader.toAttribute(stream, i, namespaceAware);
            }
            Arrays.sort(attributes, new AttributeComparator());
            for (AttributeToken token : attributes) {
                sequence.addToken(token);
            }
        }
    }

    private static void processEndElement(XMLStreamReader stream, Sequence sequence, XMLTokenFactory factory, List<StartElementToken> startElements) {
        assert (stream.isEndElement());
        StartElementToken startElement = startElements.remove(startElements.size() - 1);
        EndElementToken endElement = factory.newEndElement(startElement);
        sequence.addToken(endElement);
    }

    private static void processText(XMLStreamReader stream, Sequence sequence, TextTokenizer tokenizer) {
        assert (stream.isCharacters());
        if (stream.isWhiteSpace()) {
            sequence.addToken(new SpaceToken(stream.getText()));
        } else {
            sequence.addTokens(tokenizer.tokenize(stream.getText()));
        }
    }

    private static void processOther(XMLStreamReader stream, Sequence sequence) {
        if (stream.getEventType() == 3) {
            XMLProcessingInstruction token = new XMLProcessingInstruction(stream.getPITarget(), stream.getPIData());
            sequence.addToken(token);
        } else if (stream.getEventType() == 5) {
            XMLComment token = new XMLComment(stream.getText());
            sequence.addToken(token);
        }
    }

    private static AttributeToken toAttribute(XMLStreamReader stream, int i, boolean namespaceAware) {
        String localName = stream.getAttributeLocalName(i);
        String value = stream.getAttributeValue(i);
        if (namespaceAware) {
            String namespaceURI = stream.getAttributeNamespace(i);
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            return new XMLAttribute(namespaceURI, localName, value);
        }
        String prefix = stream.getAttributePrefix(i);
        if (prefix.isEmpty()) {
            return new XMLAttribute(localName, value);
        }
        return new XMLAttribute(prefix + ":" + localName, value);
    }

    private static XMLStreamReader toXMLStreamReader(XMLInputFactory factory, InputSource source) throws XMLStreamException, LoadingException {
        if (source.getByteStream() != null) {
            String encoding = Objects.toString(source.getEncoding(), "utf-8");
            return factory.createXMLStreamReader(source.getByteStream(), encoding);
        }
        if (source.getCharacterStream() != null) {
            return factory.createXMLStreamReader(source.getSystemId(), source.getCharacterStream());
        }
        throw new LoadingException("Invalid InputSource");
    }
}

