/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;
import org.pageseeder.diffx.core.TextOnlyProcessor;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.load.text.TextTokenizer;
import org.pageseeder.diffx.load.text.TokenizerBySpaceWord;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLToken;

public final class CompareReplaceFilter
extends DiffFilter<XMLToken>
implements DiffHandler<XMLToken> {
    private final TextTokenizer tokenizer = new TokenizerBySpaceWord(WhiteSpaceProcessing.PRESERVE);
    private Operation<XMLToken> previous = null;

    public CompareReplaceFilter(DiffHandler<XMLToken> target) {
        super(target);
    }

    @Override
    public void handle(@NotNull Operator operator, @NotNull XMLToken token) {
        if (token instanceof TextToken && operator.isEdit()) {
            if (this.previous != null) {
                this.diff((TextToken)token, (TextToken)this.previous.token(), operator == Operator.INS);
                this.previous = null;
            } else {
                this.flushPrevious();
                this.previous = new Operation<XMLToken>(operator, token);
            }
        } else {
            this.flushPrevious();
            this.target.handle(operator, token);
        }
    }

    private void diff(TextToken a, TextToken b, boolean forward) {
        List<TextToken> tokensA = this.tokenizer.tokenize(a.getCharacters());
        List<TextToken> tokensB = this.tokenizer.tokenize(b.getCharacters());
        TextOnlyProcessor<TextToken> diff = new TextOnlyProcessor<TextToken>();
        if (forward) {
            diff.diff(tokensA, tokensB, this.target);
        } else {
            diff.diff(tokensB, tokensA, this.target);
        }
    }

    public void flushPrevious() {
        if (this.previous != null) {
            this.target.handle(this.previous.operator(), this.previous.token());
            this.previous = null;
        }
    }

    @Override
    public void end() {
        this.flushPrevious();
        this.target.end();
    }

    public String toString() {
        return "CompareReplaceFilter -> " + String.valueOf(this.target);
    }
}

