/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.algorithm.Point;
import org.pageseeder.diffx.algorithm.Snake;
import org.pageseeder.diffx.algorithm.Vector;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;

public final class MyersGreedyAlgorithm<T>
implements DiffAlgorithm<T> {
    @Override
    public void diff(@NotNull List<? extends T> from, @NotNull List<? extends T> to, @NotNull DiffHandler<T> handler) {
        Instance<T> instance = new Instance<T>(from, to);
        List<Snake> snakes = instance.computePath();
        this.handle(from, to, handler, snakes);
    }

    private void handle(List<? extends T> a, List<? extends T> b, DiffHandler<T> handler, List<Snake> snakes) {
        int x = 0;
        int y = 0;
        for (Snake snake : snakes) {
            Point start = snake.getStart();
            while (x < start.x()) {
                handler.handle(Operator.DEL, a.get(x));
                ++x;
            }
            while (y < start.y()) {
                handler.handle(Operator.INS, b.get(y));
                ++y;
            }
            for (int i = 0; i < snake.length(); ++i) {
                handler.handle(Operator.MATCH, a.get(x));
                ++x;
                ++y;
            }
        }
    }

    private static class Instance<T> {
        private final List<? extends T> a;
        private final List<? extends T> b;
        private final int sizeA;
        private final int sizeB;

        Instance(List<? extends T> a, List<? extends T> b) {
            this.a = a;
            this.b = b;
            this.sizeA = a.size();
            this.sizeB = b.size();
        }

        private List<Snake> computePath() {
            Vector vector = Vector.createGreedy(this.sizeA, this.sizeB);
            ArrayList<Vector> vectors = new ArrayList<Vector>();
            int max = this.sizeA + this.sizeB;
            boolean found = false;
            for (int d = 0; d <= max; ++d) {
                found = this.forward(vector, d);
                vectors.add(vector.snapshot(d));
                if (found) break;
            }
            if (!found) {
                throw new IllegalStateException("Unable to find a solution!");
            }
            return this.solve(vectors);
        }

        private boolean forward(Vector vector, int d) {
            for (int k = -d; k <= d; k += 2) {
                int y;
                boolean down = k == -d || k != d && vector.getX(k - 1) < vector.getX(k + 1);
                int x = down ? vector.getX(k + 1) : vector.getX(k - 1) + 1;
                for (y = x - k; x < this.sizeA && y < this.sizeB && this.a.get(x).equals(this.b.get(y)); ++x, ++y) {
                }
                vector.setX(k, x);
                if (x < this.sizeA || y < this.sizeB) continue;
                return true;
            }
            return false;
        }

        @NotNull
        private List<Snake> solve(@NotNull List<Vector> vectors) {
            LinkedList<Snake> snakes = new LinkedList<Snake>();
            Point target = new Point(this.sizeA, this.sizeB);
            int d = vectors.size() - 1;
            while (target.x() > 0 || target.y() > 0) {
                int yStart;
                int yEnd;
                int k;
                Vector vector = vectors.get(d);
                int xEnd = vector.getX(k = target.x() - target.y());
                if (target.isNotSame(xEnd, yEnd = xEnd - k)) {
                    throw new IllegalStateException("No solution for d:" + d + " k:" + k + " p:" + String.valueOf(target) + " V:( " + xEnd + ", " + yEnd + " )");
                }
                boolean down = k == -d || k != d && vector.getX(k - 1) < vector.getX(k + 1);
                int xStart = down ? vector.getX(k + 1) : vector.getX(k - 1);
                int matching = Math.min(xEnd - xStart, yEnd - (yStart = xStart - (down ? k + 1 : k - 1)));
                if (matching > 0 || snakes.isEmpty()) {
                    Snake snake = new Snake(new Point(target.x() - matching, target.y() - matching), matching);
                    snakes.addFirst(snake);
                }
                target = new Point(xStart, Math.max(yStart, 0));
                --d;
            }
            return snakes;
        }
    }
}

