/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.util;

import com.pageseeder.db.model.XLink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class ObjectProperties {
    private ObjectProperties() {
    }

    public static Map<String, List<String>> toMap(@Nullable String properties) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (properties == null) {
            return map;
        }
        for (String prop : properties.split("(?<!(/\\|))\\|(?!\\|)")) {
            int eq = prop.indexOf(61);
            if (eq == -1) continue;
            String name = prop.substring(0, eq);
            List values = map.computeIfAbsent(name, k -> new ArrayList());
            values.add(prop.substring(1 + eq).replaceAll("/\\|\\|", "|"));
        }
        return map;
    }

    public static String toString(Map<String, List<String>> properties) {
        StringBuilder props = new StringBuilder();
        for (Map.Entry<String, List<String>> property : properties.entrySet()) {
            String name = property.getKey();
            List<String> values = property.getValue();
            if (values == null || values.isEmpty()) continue;
            for (String value : values) {
                props.append(name).append('=');
                props.append(value.replaceAll("\\|", "/||"));
                props.append('|');
            }
        }
        return props.toString();
    }

    public static void setXLinkProperty(@Nullable XLink xl, @Nullable String propname, @Nullable List<String> propvalues) {
        if (xl == null || propname == null) {
            return;
        }
        Map<String, List<String>> existingProps = ObjectProperties.toMap(xl.getProperties());
        if (propvalues != null && !propvalues.isEmpty()) {
            existingProps.put(propname, propvalues);
        } else {
            existingProps.remove(propname);
        }
        xl.setProperties(ObjectProperties.toString(existingProps));
    }
}

