/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.oauth;

import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.PersistentToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jdo.Query;
import org.eclipse.jdt.annotation.Nullable;

public final class OAuthQuery {
    private OAuthQuery() {
    }

    public static @Nullable Client getClientByName(Database db, String name) throws QueryFailedException {
        Client client;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Client.class, "this.name == aname");
            try {
                q.declareParameters("String aname");
                q.setUnique(true);
                client = (Client)q.execute((Object)name);
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return client;
    }

    public static int getClientCount(Database db) throws QueryFailedException {
        int n;
        block8: {
            String sql = "SELECT count(*) FROM CLIENT";
            Query q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql);
            try {
                List results = (List)q.execute();
                Object result = results.iterator().next();
                int n2 = n = result instanceof Integer ? ((Integer)result).intValue() : ((Long)result).intValue();
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return n;
    }

    public static @Nullable Client getClient(Database db, String client) throws QueryFailedException {
        if (client.startsWith("~")) {
            return OAuthQuery.getClientByIdentifier(db, client.substring(1));
        }
        try {
            Long id = Long.parseLong(client);
            return OAuthQuery.getClientById(db, id);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static @Nullable Client getClientByIdentifier(Database db, @Nullable String identifier) throws QueryFailedException {
        Client client;
        block9: {
            if (identifier != null) {
                identifier = identifier.toLowerCase();
            }
            Query q = db.getPersistenceManager().newQuery(Client.class, "this.identifier == identifier");
            try {
                q.declareParameters("String identifier");
                q.setUnique(true);
                client = (Client)q.execute((Object)identifier);
                if (q == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return client;
    }

    public static @Nullable Client getClientById(Database db, Long id) throws QueryFailedException {
        Client client;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Client.class, "id == theid");
            try {
                q.declareImports("import java.lang.Long");
                q.declareParameters("java.lang.Long theid");
                q.setUnique(true);
                client = (Client)q.execute((Object)id);
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return client;
    }

    public static List<Client> listAllClients(Database db) throws QueryFailedException {
        ArrayList<Client> arrayList;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Client.class);
            try {
                q.setOrdering("this.id ascending");
                arrayList = new ArrayList<Client>((Collection)q.execute());
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }

    public static List<Client> listClientsByMemberID(Database db, Long memberId) throws QueryFailedException {
        ArrayList<Client> arrayList;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Client.class, "this.member.id == memid");
            try {
                q.declareParameters("Long memid");
                arrayList = new ArrayList<Client>((Collection)q.execute((Object)memberId));
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }

    public static List<Client> listClientsByClientURIStartsWith(Database db, String uriprefix) throws QueryFailedException {
        ArrayList<Client> arrayList;
        block8: {
            Query q = db.getPersistenceManager().newQuery(Client.class, "this.clientURI.startsWith(uriprefix)");
            try {
                q.declareParameters("String uriprefix");
                arrayList = new ArrayList<Client>((Collection)q.execute((Object)uriprefix));
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }

    public static @Nullable PersistentToken getPersistentToken(Database db, Long tokenId) throws QueryFailedException {
        PersistentToken persistentToken;
        block8: {
            Query q = db.getPersistenceManager().newQuery(PersistentToken.class, "id == theid");
            try {
                q.declareImports("import java.lang.Long");
                q.declareParameters("java.lang.Long theid");
                q.setUnique(true);
                persistentToken = (PersistentToken)q.execute((Object)tokenId);
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return persistentToken;
    }

    public static @Nullable PersistentToken getPersistentToken(Database db, String token) throws QueryFailedException {
        PersistentToken persistentToken;
        block8: {
            Query q = db.getPersistenceManager().newQuery(PersistentToken.class, "this.tokenHash == hash");
            try {
                q.declareParameters("String hash");
                q.setUnique(true);
                persistentToken = (PersistentToken)q.execute((Object)PersistentToken.hash(token));
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return persistentToken;
    }

    public static @Nullable PersistentToken getPersistentToken(Database db, String token, Member member) throws QueryFailedException {
        PersistentToken persistentToken;
        block8: {
            Query q = db.getPersistenceManager().newQuery(PersistentToken.class, "this.tokenHash == hash && this.member.id == memid");
            try {
                q.declareParameters("String hash, Long memid");
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("hash", PersistentToken.hash(token));
                parameters.put("memid", member.getId());
                q.setUnique(true);
                persistentToken = (PersistentToken)q.executeWithMap(parameters);
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return persistentToken;
    }

    public static @Nullable PersistentToken getPersistentToken(Database db, String token, String identifier) throws QueryFailedException {
        PersistentToken persistentToken;
        block9: {
            if (identifier != null) {
                identifier = identifier.toLowerCase();
            }
            Query q = db.getPersistenceManager().newQuery(PersistentToken.class, "this.tokenHash == hash && this.client.identifier == identifier && (this.expires == null || this.expires > now)");
            try {
                q.declareParameters("String hash, String identifier, java.util.Date now");
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("hash", PersistentToken.hash(token));
                parameters.put("identifier", identifier);
                parameters.put("now", new Date());
                q.setUnique(true);
                persistentToken = (PersistentToken)q.executeWithMap(parameters);
                if (q == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return persistentToken;
    }

    public static int purgeRefreshTokens(Database db) throws QueryFailedException {
        int n;
        block8: {
            Query q = db.getPersistenceManager().newQuery(PersistentToken.class, "this.client != null && this.expires != null && this.expires < now");
            try {
                q.declareParameters("java.util.Date now");
                long count = q.deletePersistentAll(new Object[]{new Date()});
                int n2 = n = count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return n;
    }

    public static int purgePersistentTokens(Database db, int days) throws QueryFailedException {
        int n;
        block8: {
            Query q = db.getPersistenceManager().newQuery(PersistentToken.class, "this.client == null && this.expires != null && this.expires < limit");
            try {
                q.declareParameters("java.util.Date limit");
                long now = System.currentTimeMillis();
                Date date = new Date(now - (long)(days * 24 * 60 * 60) * 1000L);
                long count = q.deletePersistentAll(new Object[]{date});
                int n2 = n = count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return n;
    }

    public static List<PersistentToken> listRefreshTokens(Database db, int page, int pagesize) throws QueryFailedException {
        ArrayList<PersistentToken> arrayList;
        block8: {
            Query q = db.getPersistenceManager().newQuery(PersistentToken.class, "this.client != null");
            try {
                DatabaseQuery.setPaging(q, page, pagesize);
                arrayList = new ArrayList<PersistentToken>((Collection)q.execute());
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }

    public static List<PersistentToken> listPersistentTokensByMemberID(Database db, Long memberId) throws QueryFailedException {
        ArrayList<PersistentToken> arrayList;
        block8: {
            Query q = db.getPersistenceManager().newQuery(PersistentToken.class, "this.member.id == memid");
            try {
                q.declareParameters("Long memid");
                arrayList = new ArrayList<PersistentToken>((Collection)q.execute((Object)memberId));
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }

    public static List<PersistentToken> listPersistentTokensByClientID(Database db, Long clientId) throws QueryFailedException {
        ArrayList<PersistentToken> arrayList;
        block8: {
            Query q = db.getPersistenceManager().newQuery(PersistentToken.class, "this.client.id == clientid");
            try {
                q.declareParameters("Long clientid");
                arrayList = new ArrayList<PersistentToken>((Collection)q.execute((Object)clientId));
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    DatabaseQuery.logDatabaseException(ex);
                    throw new QueryFailedException(ex.getMessage());
                }
            }
            q.close();
        }
        return arrayList;
    }
}

