/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Discussion {
    private static final Logger LOGGER = LoggerFactory.getLogger(Discussion.class);
    private final Long threadID;
    private boolean forModeration = false;
    private @Nullable Integer replyCount = null;
    private Long lastCommentID = null;
    private Date lastCommentDate = null;
    private final Collection<String> groupNames;
    private @Nullable XLink rootXLink = null;
    private @Nullable XLink firstReply = null;
    private XLink lastReply = null;
    private XLink draftReply = null;
    private List<XLink> replies = null;
    private String title = null;
    private @Nullable URI uri = null;
    private @Nullable Locator locator = null;
    private boolean archiveLoaded = false;
    private boolean allLoaded = false;
    private boolean rootLoaded = false;
    private boolean attached = false;

    public Discussion(XLink root, Collection<String> groupNames) {
        this.rootXLink = Objects.requireNonNull(root, "Root XLink can not be null");
        this.threadID = Objects.requireNonNull(root.getId(), "Root XLink must have an ID");
        this.groupNames = groupNames;
    }

    public Discussion(Long threadId, Collection<String> groupNames) {
        this.threadID = Objects.requireNonNull(threadId, "Thread ID can not be null");
        this.groupNames = groupNames;
    }

    public Discussion(Long threadId, @Nullable Integer replyCount, Long lastCommentId, Date lastCommentDate, Collection<String> groupNames) {
        this.threadID = Objects.requireNonNull(threadId, "Thread ID cannot be null");
        this.replyCount = replyCount;
        this.lastCommentID = Objects.requireNonNull(lastCommentId, "lastCommentId cannot be null");
        this.lastCommentDate = Objects.requireNonNull(lastCommentDate, "lastCommentDate can not be null");
        this.groupNames = groupNames;
    }

    public void setForModeration(boolean forModeration) {
        this.forModeration = forModeration;
    }

    public Long getThreadID() {
        return this.threadID;
    }

    public @Nullable Integer getReplyCount() {
        return this.replyCount;
    }

    public Long getLastCommentID() {
        return this.lastCommentID;
    }

    public Date getLastCommentDate() {
        return this.lastCommentDate;
    }

    public String getTitle() {
        return this.title;
    }

    public @Nullable XLink getRootComment() {
        return this.rootLoaded ? this.rootXLink : null;
    }

    public XLink getLastReply() {
        return this.lastReply;
    }

    public XLink getDraftReply() {
        return this.draftReply;
    }

    public List<XLink> getReplies() {
        if (this.allLoaded || this.archiveLoaded) {
            return this.replies;
        }
        if (!this.rootLoaded && this.firstReply != null) {
            return Collections.singletonList(this.firstReply);
        }
        return null;
    }

    public @Nullable URI getUri() {
        return this.uri;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void loadFirstComment(Database db) {
        this.loadRootComment(db);
        if (!this.rootLoaded) {
            if (this.firstReply != null || this.rootXLink == null) {
                return;
            }
            try {
                this.firstReply = DatabaseQuery.getFirstReplyByGroupsArchivedAccepted(db, this.rootXLink, this.groupNames, false, !this.forModeration);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load first reply", (Throwable)ex);
            }
        }
    }

    public void loadRootComment(Database db) {
        if (this.rootLoaded) {
            return;
        }
        if (this.rootXLink == null) {
            try {
                this.rootXLink = DatabaseQuery.getXLinkById(db, this.threadID);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load root xlink ({}): ", (Object)this.threadID, (Object)ex);
            }
        }
        if (this.rootXLink != null && (this.rootXLink.getAccepted().booleanValue() || this.forModeration) && XLinks.isComment(this.rootXLink) && (this.archiveLoaded || !XLinks.isArchived(this.rootXLink))) {
            this.rootLoaded = true;
        }
        if (this.title == null && this.rootLoaded) {
            this.setTitle(this.rootXLink);
        }
    }

    public void loadLastComment(Database db, boolean countReplies) {
        if (this.lastReply != null) {
            return;
        }
        if (this.lastCommentID != null) {
            if (this.threadID.equals(this.lastCommentID)) {
                this.loadRootComment(db);
            } else {
                try {
                    this.lastReply = DatabaseQuery.getXLinkById(db, this.lastCommentID);
                    this.setTitle(this.lastReply);
                }
                catch (QueryFailedException ex) {
                    LOGGER.error("Failed to load last reply ({}): {}", (Object)this.lastCommentID, (Object)ex.getMessage());
                }
            }
        } else {
            XLink reply = null;
            try {
                reply = DatabaseQuery.getLastReplyByGroupsArchivedAccepted(db, this.threadID, this.groupNames, false, !this.forModeration);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load last reply", (Throwable)ex);
            }
            if (reply == null || this.threadID > reply.getId()) {
                this.loadRootComment(db);
                this.lastCommentID = this.rootXLink.getId();
                this.lastCommentDate = this.rootXLink.getDate();
            } else {
                this.lastReply = reply;
                this.lastCommentID = reply.getId();
                this.lastCommentDate = reply.getDate();
                this.setTitle(this.lastReply);
            }
        }
        if (countReplies) {
            this.loadReplyCount(db);
        }
    }

    public void loadReplyCount(Database db) {
        if (this.replyCount != null) {
            return;
        }
        if (this.rootXLink == null) {
            try {
                this.rootXLink = DatabaseQuery.getXLinkById(db, this.threadID);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load root xlink ({}): ", (Object)this.threadID, (Object)ex);
                return;
            }
        }
        if (this.threadID.equals(this.lastCommentID)) {
            this.replyCount = 0;
        } else {
            try {
                this.replyCount = DatabaseQuery.getReplyCount(db, this.threadID, this.groupNames);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load reply count ({}): {}", (Object)this.threadID, (Object)ex.getMessage());
                return;
            }
        }
        if (XLinks.isArchived(this.rootXLink)) {
            Integer n = this.replyCount;
            Integer n2 = this.replyCount = Integer.valueOf(this.replyCount - 1);
        }
    }

    public void loadAllComments(Database db, int size) {
        if (this.allLoaded) {
            return;
        }
        if (this.archiveLoaded) {
            this.replies = null;
        }
        this.allLoaded = true;
        this.archiveLoaded = false;
        this.loadRootComment(db);
        if (this.replies == null) {
            this.replies = new ArrayList<XLink>();
            try {
                this.replies.addAll(DatabaseQuery.getRepliesByGroupsArchivedAccepted(db, this.rootXLink, this.groupNames, false, !this.forModeration, 1, size - 1));
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load replies", (Throwable)ex);
            }
        }
        if (this.replies.size() < size - 1) {
            this.setLastCommentFields();
        }
        this.loadLastComment(db, true);
    }

    public void loadArchiveComments(Database db, int size) {
        if (this.archiveLoaded) {
            return;
        }
        this.allLoaded = false;
        this.archiveLoaded = true;
        this.loadRootComment(db);
        this.replies = new ArrayList<XLink>();
        if (size > 1) {
            try {
                this.replies.addAll(DatabaseQuery.getRepliesByGroupsArchivedAccepted(db, this.rootXLink, this.groupNames, true, !this.forModeration, 1, size - 1));
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load replies", (Throwable)ex);
            }
        }
        if (this.replies.size() < size - 1) {
            this.setLastCommentFields();
        }
        this.loadLastComment(db, true);
    }

    private void setLastCommentFields() {
        ListIterator<XLink> repi = this.replies.listIterator(this.replies.size());
        XLink reply = null;
        while (repi.hasPrevious() && XLinks.isArchived(reply = repi.previous())) {
        }
        if (reply == null || this.threadID > reply.getId()) {
            this.lastCommentID = this.rootXLink.getId();
            this.lastCommentDate = this.rootXLink.getDate();
        } else {
            this.lastCommentID = reply.getId();
            this.lastCommentDate = reply.getDate();
            this.setTitle(reply);
        }
    }

    public void loadDraftComment(Database db, @Nullable Member member) {
        if (member == null) {
            return;
        }
        if (this.rootXLink == null) {
            try {
                this.rootXLink = DatabaseQuery.getXLinkById(db, this.threadID);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load root xlink ({}): ", (Object)this.threadID, (Object)ex);
            }
        }
        if (this.rootXLink != null && this.rootXLink.getAuthorOnly().booleanValue() && member.equals(this.rootXLink.getMember())) {
            this.rootLoaded = true;
        } else {
            try {
                List<XLink> drafts = DatabaseQuery.getCommentDraftsByMemberReplyTo(db, member.getId(), this.threadID);
                if (!drafts.isEmpty()) {
                    this.draftReply = drafts.get(0);
                }
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load draft xlink ({}): ", (Object)this.threadID, (Object)ex);
            }
        }
    }

    public void loadLocator(Database db) {
        if (this.locator != null) {
            return;
        }
        try {
            if (this.rootXLink == null) {
                this.rootXLink = DatabaseQuery.getXLinkById(db, this.threadID);
            }
            Collection<LocatorForXLink> lfxs = this.rootXLink.getLocatorsForXLinkCol();
            for (LocatorForXLink lfx : lfxs) {
                if (lfx.getRole() != null) continue;
                this.locator = lfx.getLocator();
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load locator for thread ({}): {}", (Object)this.threadID, (Object)ex.getMessage());
        }
    }

    public void loadUri(Database db, @Nullable Group group) {
        if (this.uri != null) {
            return;
        }
        try {
            if (this.rootXLink == null) {
                this.rootXLink = DatabaseQuery.getXLinkById(db, this.threadID);
            }
            if (this.locator == null) {
                this.loadLocator(db);
            }
            if (this.locator != null) {
                this.uri = this.locator.getURI();
            }
            this.setTitle(this.rootXLink);
            this.setTitle(this.lastReply);
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load uri for thread ({}): {}", (Object)this.threadID, (Object)ex.getMessage());
        }
    }

    private void setTitle(@Nullable XLink xlink) {
        if (xlink == null) {
            return;
        }
        this.title = XLinks.isWorkflow(xlink) && this.uri != null ? this.uri.getDisplayTitle() : xlink.getContentTitle();
    }

    public String toString() {
        return "Discussion " + this.threadID;
    }

    public boolean equals(Object obj) {
        return obj instanceof Discussion && this.threadID.equals(((Discussion)obj).threadID);
    }

    public int hashCode() {
        return this.threadID.intValue();
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean attached) {
        this.attached = attached;
    }
}

