/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.db.Database;
import com.pageseeder.db.DeleteFailedException;
import com.pageseeder.db.InsertFailedException;
import java.util.Objects;
import javax.jdo.JDOException;
import org.eclipse.jdt.annotation.Nullable;

public abstract class DBObject
implements Comparable<DBObject> {
    @Override
    public int compareTo(@Nullable DBObject o) {
        if (o == null) {
            return 1;
        }
        if (o.getClass() != this.getClass()) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        if (this.getId() == null) {
            return -1;
        }
        return this.getId().compareTo(o.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBObject that = (DBObject)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public abstract Long getId();

    public void delete(Database db) throws DeleteFailedException {
        try {
            db.getPersistenceManager().deletePersistent((Object)this);
        }
        catch (JDOException ex) {
            throw new DeleteFailedException("Exception: " + ex.getMessage());
        }
    }

    public DBObject insert(Database db) throws InsertFailedException {
        try {
            db.getPersistenceManager().makePersistent((Object)this);
        }
        catch (JDOException ex) {
            throw new InsertFailedException("Exception: " + ex.getMessage());
        }
        return this;
    }
}

