/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db;

import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Webhook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jdo.JDOException;
import javax.jdo.Query;
import org.eclipse.jdt.annotation.Nullable;

public final class WebhookQuery {
    private WebhookQuery() {
    }

    public static @Nullable Webhook getWebhookByName(Database db, String name) throws QueryFailedException {
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Webhook.class, "this.name == thename");
            q.declareParameters("String thename");
            q.setUnique(true);
            Webhook webhook = (Webhook)q.execute((Object)name);
            return webhook;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
        }
    }

    public static @Nullable Webhook getWebhook(Database db, Long id) throws QueryFailedException {
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Webhook.class, "this.id == theid");
            q.declareParameters("Long theid");
            q.setUnique(true);
            Webhook webhook = (Webhook)q.execute((Object)id);
            return webhook;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
        }
    }

    public static List<Webhook> listWebhooksByClientID(Database db, Long clientid) throws QueryFailedException {
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Webhook.class, "this.client.id == clientid");
            q.declareParameters("Long clientid");
            ArrayList<Webhook> arrayList = new ArrayList<Webhook>((Collection)q.execute((Object)clientid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
        }
    }

    public static int countAllWebhooks(Database db) throws QueryFailedException {
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Webhook.class);
            q.setResult("count(this)");
            int n = ((Long)q.execute()).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
        }
    }

    public static List<Webhook> listAllWebhooks(Database db) throws QueryFailedException {
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Webhook.class);
            q.setOrdering("this.id ascending");
            ArrayList<Webhook> arrayList = new ArrayList<Webhook>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
        }
    }

    public static List<Webhook> listWebhooksByStatus(Database db, Collection<String> statuses) throws QueryFailedException {
        if (statuses == null || statuses.isEmpty()) {
            return WebhookQuery.listAllWebhooks(db);
        }
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Webhook.class, "statuses.contains(this.status)");
            q.declareParameters("java.util.Collection statuses");
            q.setOrdering("this.id ascending");
            ArrayList<Webhook> arrayList = new ArrayList<Webhook>((Collection)q.execute(statuses));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
        }
    }
}

