/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db;

import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import javax.jdo.JDOException;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transaction.class);
    private final javax.jdo.Transaction tr;

    public Transaction(Database db) {
        this.tr = db.getPersistenceManager().currentTransaction();
    }

    public void abort() {
        if (this.tr != null && this.tr.isActive()) {
            this.tr.rollback();
        }
    }

    public void commitAndStart() throws StartTransactionException, CommitTransactionException {
        long before = System.currentTimeMillis();
        this.doCommit();
        Transaction.profiling("commitAndStart()", null, before);
        this.begin();
    }

    public void commitAndStart(String caller) throws StartTransactionException, CommitTransactionException {
        long before = System.currentTimeMillis();
        this.doCommit();
        Transaction.profiling("commitAndStart()", caller, before);
        this.begin();
    }

    public void begin() throws StartTransactionException {
        try {
            if (this.tr != null && !this.tr.isActive()) {
                this.tr.begin();
            }
        }
        catch (JDOException ex) {
            throw new StartTransactionException("Exception: " + ex.getMessage());
        }
    }

    public void commit() throws CommitTransactionException {
        long before = System.currentTimeMillis();
        this.doCommit();
        Transaction.profiling("commit()", null, before);
    }

    public void commit(String caller) throws CommitTransactionException {
        long before = System.currentTimeMillis();
        this.doCommit();
        Transaction.profiling("commit()", caller, before);
    }

    public void commit(boolean justUpdated) throws CommitTransactionException {
        long before = System.currentTimeMillis();
        if (!justUpdated) {
            this.doCommit();
        }
        Transaction.profiling("commit(justUpdated)", null, before);
    }

    private void doCommit() throws CommitTransactionException {
        try {
            if (this.tr != null && this.tr.isActive()) {
                this.tr.commit();
            }
        }
        catch (JDOException ex) {
            if (ex.getCause() != null) {
                LOGGER.error(ex.getCause().getMessage(), ex.getCause());
            }
            throw new CommitTransactionException("Exception: " + ex.getMessage(), ex);
        }
    }

    private static void profiling(String method, @Nullable String caller, long before) {
        long after = System.currentTimeMillis();
        long diff = after - before;
        if (diff > DatabaseQuery.profiling) {
            String current = caller;
            if (current == null) {
                StackTraceElement[] st = Thread.currentThread().getStackTrace();
                String string = current = st.length > 3 ? st[3].getClassName() : "Unknown class";
            }
            if (current != null && current.startsWith("com.pageseeder.")) {
                current = current.substring(15);
            }
            LOGGER.warn("DB-JDO: {} {} {} ---> {}ms.", new Object[]{method, caller == null ? "in" : "for", current, diff});
        }
    }
}

