/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db;

import com.pageseeder.common.util.Rules;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.PSQuery;
import com.pageseeder.db.Predicate;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.GroupURI;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public final class Predicates {
    private static final String ORDER_BY_ID = "this.id ascending";

    private Predicates() {
    }

    public static Predicate predicateURIsByGroups(Database db, Collection<String> groups) {
        PSQuery subq = new PSQuery(GroupURI.class, "this.groups.contains(grp) && (grp.name == 'public' || groupnames.contains(grp.name))", new Predicate(db));
        subq.addParameter("java.util.Collection groupnames", groups);
        subq.addVariable("com.pageseeder.db.model.Group grp");
        subq.setResult("this.id");
        Predicate pred = new Predicate(db);
        pred.setClause("guriids.contains(aguri.id) && this.groupURIs.contains(aguri)");
        pred.addSubQuery(subq, "java.util.Collection guriids");
        pred.addVariable("com.pageseeder.db.model.GroupURI aguri");
        pred.addParam("java.util.Collection groupnames", groups);
        pred.setResult("DISTINCT this");
        return pred;
    }

    public static Predicate predicateGroupsByGroups(Database db, Collection<String> groups) {
        if (groups == null) {
            groups = Collections.emptyList();
        }
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("groups", groups);
        p.setClause(unique + ".contains(this.name)");
        p.addParam("java.util.Collection " + unique, groups);
        return p;
    }

    @Deprecated
    public static Predicate predicateGroupsByNameContains(Database db, String contains, boolean doesContain) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("namecontains", contains);
        p.setClause("this.name.indexOf(" + unique + ") " + (doesContain ? "!" : "=") + "= -1");
        p.addParam("java.lang.String " + unique, contains);
        return p;
    }

    @Deprecated
    public static Predicate predicateGroupsByFlagContains(Database db, String contains, boolean doesContain) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("flag", contains);
        if (doesContain) {
            p.setClause("this.flags.indexOf(" + unique + ") != -1");
        } else {
            p.setClause("this.flags == null || this.flags.indexOf(" + unique + ") == -1");
        }
        p.addParam("java.lang.String " + unique, contains);
        return p;
    }

    @Deprecated
    public static Predicate predicateGroupsByNameStartsWith(Database db, String start) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("start", start);
        p.setClause("this.name.startsWith(" + unique + ")");
        p.addParam("java.lang.String " + unique, start);
        return p;
    }

    @Deprecated
    public static Predicate predicateMemberByUsername(Database db, String username) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("username", username);
        p.setClause("this.username == " + unique);
        p.addParam("java.lang.String " + unique, username);
        return p;
    }

    public static Predicate predicateMemberForGroupByGroups(Database db, Collection<String> groups) {
        Predicate p = new Predicate(db);
        if (groups == null || groups.isEmpty()) {
            return p;
        }
        StringBuilder clause = new StringBuilder();
        boolean first = true;
        for (String gn : groups) {
            String unique = Predicates.unique("gns", gn);
            p.addParam("String " + unique, gn);
            if (!first) {
                clause.append(" || ");
            }
            clause.append(unique + " == this.group.name");
            first = false;
        }
        p.setClause(clause.toString());
        return p;
    }

    public static Predicate predicateGroupsForXLinkByGroups(Database db, Collection<String> groups) {
        if (groups == null) {
            groups = Collections.emptyList();
        }
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("gns", groups);
        p.setClause(unique + ".contains(this.group.name) || this.group.flags.indexOf('p') != -1");
        p.addParam("java.util.Collection " + unique, groups);
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinksByHistory(Database db, int history) {
        Predicate p = new Predicate(db);
        if (history <= 0) {
            return p;
        }
        Date after = new Date();
        long dayInMillis = 86400000L;
        after.setTime(System.currentTimeMillis() - (long)history * 86400000L);
        String unique = Predicates.unique("after", after.getTime());
        p.addParam("java.util.Date " + unique, after);
        p.setClause("(this.modifiedDate > " + unique + " || (this.modifiedDate == null && this.date > " + unique + "))");
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinksLabelled(Database db, boolean mustBeLabelled) {
        Predicate p = new Predicate(db);
        if (!mustBeLabelled) {
            return p;
        }
        p.setClause("(this.properties.startsWith('label=') || this.properties.indexOf('|label=') != -1)");
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinksByCreatedByOrModifiedBy(Database db, Long memberid) {
        Predicate p = new Predicate(db);
        if (memberid != null && memberid > 0L) {
            String unique = Predicates.unique("mid", memberid);
            p.setClause("(this.member.id == " + unique + " || this.modifiedBy.id == " + unique + ")");
            p.addParam("java.lang.Long " + unique, memberid);
        }
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinksByCompareId(Database db, boolean biggerThan, Long xlinkid) {
        Predicate p = new Predicate(db);
        if (xlinkid != null && xlinkid > 0L) {
            String unique = Predicates.unique("mid", xlinkid);
            p.setClause("this.id " + (biggerThan ? "> " : "< ") + unique);
            p.addParam("java.lang.Long " + unique, xlinkid);
        }
        return p;
    }

    public static Predicate predicateOrderBy(Database db, String orderBy) {
        Predicate p = new Predicate(db);
        p.setOrdering("this." + orderBy);
        return p;
    }

    @Deprecated
    public static Predicate predicateLocatorForXLinksByContentTitle(Database db, String title, boolean equals) {
        Predicate pred = new Predicate(db);
        if (title == null) {
            return pred;
        }
        String unique = Predicates.unique("title", title);
        pred.setClause("this.xlink.contentTitle" + (equals ? " == " : " != ") + unique);
        pred.addParam("java.lang.String " + unique, title);
        return pred;
    }

    @Deprecated
    public static Predicate predicateXLinksByContentTitle(Database db, String title, boolean equals) {
        Predicate pred = new Predicate(db);
        if (title == null) {
            return pred;
        }
        String unique = Predicates.unique("title", title);
        pred.setClause("this.contentTitle" + (equals ? " == " : " != ") + unique);
        pred.addParam("java.lang.String " + unique, title);
        return pred;
    }

    @Deprecated
    public static Predicate predicateXLinksByAssignedTo(Database db, Long memberid) {
        Predicate pred = new Predicate(db);
        if (memberid == null) {
            return pred;
        }
        String unique = Predicates.unique("memberid", memberid);
        pred.setClause("this.assignedTo.id == " + unique);
        pred.addParam("java.lang.Long " + unique, memberid);
        return pred;
    }

    @Deprecated
    public static Predicate predicateXLinksByContentRole(Database db, String[] includeRoles, String[] excludeRoles) {
        return Predicates.predicateXLinksByContentRoleDates(db, includeRoles, excludeRoles, null, null);
    }

    public static Predicate predicateXLinksByContentRoleDates(Database db, String[] includeRoles, String[] excludeRoles, Date before, Date after) {
        String unique;
        int i;
        Predicate pred = new Predicate(db);
        Object clause = "";
        if (includeRoles != null) {
            clause = (String)clause + "(";
            for (i = 0; i < includeRoles.length; ++i) {
                if (i != 0) {
                    clause = (String)clause + " || ";
                }
                unique = Predicates.unique("inc", includeRoles, i);
                clause = includeRoles[i].endsWith("%") ? (String)clause + "this.contentRole.startsWith(" + unique + ")" : (String)clause + "this.contentRole == " + unique;
                pred.addParam("java.lang.String " + unique, includeRoles[i].replaceFirst("%$", ""));
            }
            clause = (String)clause + ")";
        }
        if (excludeRoles != null) {
            if (((String)clause).length() > 0) {
                clause = (String)clause + " && ";
            }
            clause = (String)clause + "(this.contentRole == null || (";
            for (i = 0; i < excludeRoles.length; ++i) {
                if (i > 0) {
                    clause = (String)clause + " && ";
                }
                unique = Predicates.unique("exc", excludeRoles, i);
                clause = excludeRoles[i].endsWith("%") ? (String)clause + "!this.contentRole.startsWith(" + unique + ")" : (String)clause + "this.contentRole != " + unique;
                pred.addParam("java.lang.String " + unique, excludeRoles[i].replaceFirst("%$", ""));
            }
            clause = (String)clause + "))";
        }
        if (before != null) {
            String unique2 = Predicates.unique("before", before.getTime());
            if (((String)clause).length() > 0) {
                clause = (String)clause + " && ";
            }
            clause = (String)clause + "this.date < " + unique2;
            pred.addParam("java.util.Date " + unique2, before);
        }
        if (after != null) {
            String unique3 = Predicates.unique("after", after.getTime());
            if (((String)clause).length() > 0) {
                clause = (String)clause + " && ";
            }
            clause = (String)clause + "this.date > " + unique3;
            pred.addParam("java.util.Date " + unique3, after);
        }
        if (((String)clause).length() == 0) {
            return pred;
        }
        pred.setClause((String)clause);
        return pred;
    }

    @Deprecated
    public static Predicate predicateXLinksByGroupContentRoleDates(Database db, Long groupid, String[] includeRoles, String[] excludeRoles, Date before, Date after) {
        int i;
        Predicate pred = new Predicate(db);
        String unique = Predicates.unique("groupid", groupid);
        String clause = "this.groupsForXLink.contains(gfx) && gfx.group.id == " + unique;
        pred.addVariable("com.pageseeder.db.model.GroupForXLink gfx");
        pred.addParam("java.lang.Long " + unique, groupid);
        if (includeRoles != null) {
            clause = clause + " && (";
            for (i = 0; i < includeRoles.length; ++i) {
                if (i != 0) {
                    clause = clause + " || ";
                }
                unique = Predicates.unique("inc", includeRoles, i);
                clause = includeRoles[i].endsWith("%") ? clause + "this.contentRole.startsWith(" + unique + ")" : clause + "this.contentRole == " + unique;
                pred.addParam("java.lang.String " + unique, includeRoles[i].replaceFirst("%$", ""));
            }
            clause = clause + ")";
        }
        if (excludeRoles != null) {
            clause = clause + " && (this.contentRole == null || (";
            for (i = 0; i < excludeRoles.length; ++i) {
                if (i > 0) {
                    clause = clause + " && ";
                }
                unique = Predicates.unique("exc", excludeRoles, i);
                clause = excludeRoles[i].endsWith("%") ? clause + "!this.contentRole.startsWith(" + unique + ")" : clause + "this.contentRole != " + unique;
                pred.addParam("java.lang.String " + unique, excludeRoles[i].replaceFirst("%$", ""));
            }
            clause = clause + "))";
        }
        if (before != null) {
            unique = Predicates.unique("before", before.getTime());
            clause = clause + " && this.date < " + unique;
            pred.addParam("java.util.Date " + unique, before);
        }
        if (after != null) {
            unique = Predicates.unique("after", after.getTime());
            clause = clause + " && this.date > " + unique;
            pred.addParam("java.util.Date " + unique, after);
        }
        pred.setClause(clause);
        return pred;
    }

    @Deprecated
    public static Predicate predicateXLinksAcceptedNotArchivedOrdered(Database db) {
        Predicate pred = new Predicate(db);
        pred.setClause("this.accepted && !this.contentRole.startsWith('archive-') && this.contentRole != 'Archive'");
        pred.setOrdering(ORDER_BY_ID);
        return pred;
    }

    @Deprecated
    public static Predicate predicateXLinksByStatus(Database db, String[] includeStatuses, String[] excludeStatuses) {
        String unique;
        int i;
        Predicate pred = new Predicate(db);
        Object clause = "";
        if (includeStatuses != null && (includeStatuses.length != 1 || includeStatuses[0].length() != 0)) {
            clause = (String)clause + "(";
            for (i = 0; i < includeStatuses.length; ++i) {
                if (i != 0) {
                    clause = (String)clause + " || ";
                }
                unique = Predicates.unique("inc", includeStatuses, i);
                clause = includeStatuses[i].endsWith("%") ? (String)clause + "this.status.startsWith(" + unique + ")" : (String)clause + "this.status == " + unique;
                pred.addParam("java.lang.String " + unique, includeStatuses[i].replaceFirst("%$", ""));
            }
            clause = (String)clause + ")";
        }
        if (excludeStatuses != null && (excludeStatuses.length != 1 || excludeStatuses[0].length() != 0)) {
            if (((String)clause).length() > 0) {
                clause = (String)clause + " && ";
            }
            clause = (String)clause + "(this.status == null || (";
            for (i = 0; i < excludeStatuses.length; ++i) {
                unique = Predicates.unique("exc", excludeStatuses, i);
                if (i > 0) {
                    clause = (String)clause + " && ";
                }
                clause = excludeStatuses[i].endsWith("%") ? (String)clause + "!this.status.startsWith(" + unique + ")" : (String)clause + "this.status != " + unique;
                pred.addParam("java.lang.String " + unique, excludeStatuses[i].replaceFirst("%$", ""));
            }
            clause = (String)clause + "))";
        }
        if (((String)clause).length() == 0) {
            return pred;
        }
        pred.setClause((String)clause);
        return pred;
    }

    @Deprecated
    public static Predicate predicateXLinksForLocatorByGroups(Database db, Collection<String> groups) {
        return Predicates.predicateXLinksForLocatorByGroupsArchived(db, groups, false);
    }

    public static Predicate predicateXLinksForLocatorByGroupsArchived(Database db, Collection<String> groups, boolean archived) {
        return Predicates.predicateXLinkForLocatorByGroups(db, groups, archived);
    }

    @Deprecated
    public static Predicate predicateIsApprover(Database db) {
        Predicate pred = new Predicate(db);
        pred.setClause("this.editor && this.editorFlags.indexOf('a') != -1 && this.editorFlags.indexOf('d') == -1");
        return pred;
    }

    @Deprecated
    public static Predicate predicateIsManager(Database db) {
        Predicate pred = new Predicate(db);
        pred.setClause("this.editor && this.editorFlags.indexOf('e') != -1 && this.editorFlags.indexOf('d') == -1");
        return pred;
    }

    public static Predicate predicateLocatorFragmentStartsWith(Database db, String locfrag) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("frag", locfrag);
        p.setClause("this.fragment.startsWith(" + unique + ")");
        p.addParam("java.lang.String " + unique, locfrag);
        return p;
    }

    public static Predicate predicateLocatorFragment(Database db, String locfrag) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("frag", locfrag);
        p.setClause("this.fragment" + DatabaseQuery.lowerCase() + " == " + unique);
        p.addParam("java.lang.String " + unique, locfrag.toLowerCase());
        return p;
    }

    public static Predicate predicateLocatorFragmentDiscussion(Database db, String locfrag) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("frag", locfrag);
        String unique2 = Predicates.unique("frag2", locfrag + "//Discussion");
        p.setClause("this.fragment == " + unique + " || this.fragment == " + unique2);
        p.addParam("java.lang.String " + unique, locfrag);
        p.addParam("java.lang.String " + unique2, locfrag + "//Discussion");
        p.setOrdering("this.fragment ascending");
        return p;
    }

    public static Predicate predicateContentByContentType(Database db, String ctype) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("ctype", ctype);
        p.setClause("this.type == " + unique);
        p.addParam("java.lang.String " + unique, ctype);
        return p;
    }

    public static Predicate predicateLocatorFragmentFragmentStart(Database db, String frag, String[] frags, String[] fragstart) {
        String unique;
        Predicate p = new Predicate(db);
        ArrayList<CallSite> ors = new ArrayList<CallSite>();
        if (frag != null && !frag.isEmpty()) {
            String unique2 = Predicates.unique("frag", frag);
            p.addParam("java.lang.String " + unique2, frag);
            ors.add((CallSite)((Object)("this.fragment == " + unique2)));
        }
        if (frags != null) {
            for (int i = 0; i < frags.length; ++i) {
                unique = Predicates.unique("frags", frags, i);
                p.addParam("java.lang.String " + unique, frags[i]);
                ors.add((CallSite)((Object)("this.fragment == " + unique)));
            }
        }
        if (fragstart != null) {
            for (int i = 0; i < fragstart.length; ++i) {
                unique = Predicates.unique("fragstart", fragstart, i);
                p.addParam("java.lang.String " + unique, fragstart[i].trim());
                ors.add((CallSite)((Object)("this.fragment.startsWith(" + unique + ")")));
            }
        }
        StringBuilder clause = new StringBuilder();
        while (!ors.isEmpty()) {
            clause.append((String)ors.remove(0));
            if (ors.isEmpty()) continue;
            clause.append(" || ");
        }
        if (clause.length() > 0) {
            clause.insert(0, '(').append(')');
            p.setClause(clause.toString());
        }
        return p;
    }

    @Deprecated
    public static Predicate predicateNotLocatorFragment(Database db, String locfrag) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("frag", locfrag);
        p.setClause("!this.frag == als(" + unique + ")");
        p.addParam("java.lang.String " + unique, locfrag);
        return p;
    }

    @Deprecated
    public static Predicate predicateMFGAlphaSurname(Database db) {
        Predicate pred = new Predicate(db);
        pred.setOrdering("this.member.surname ascending");
        return pred;
    }

    public static Predicate predicateMemberForGroupRegistered(Database db, boolean archived) {
        Predicate pred = new Predicate(db);
        pred.setClause("(this.editorFlags == null || this.editorFlags.indexOf('d') == -1)" + (archived ? "" : "  && (this.group.flags == null || this.group.flags.indexOf('d') == -1)"));
        return pred;
    }

    public static Predicate predicateMemberForGroupEditorFlagsContain(Database db, String containValue, boolean contain) {
        Predicate pred = new Predicate(db);
        String unique = Predicates.unique("contains", containValue);
        if (contain) {
            pred.setClause("(this.editorFlags != null && this.editorFlags.indexOf(" + unique + ") != -1)");
        } else {
            pred.setClause("(this.editorFlags == null || this.editorFlags.indexOf(" + unique + ") == -1)");
        }
        pred.addParam("java.lang.String " + unique, containValue);
        return pred;
    }

    @Deprecated
    public static Predicate predicateMemberForGroupRegisteredProject(Database db) {
        Predicate pred = new Predicate(db);
        pred.setClause("(this.editorFlags == null || this.editorFlags.indexOf('d') == -1) && (this.group.flags != null && this.group.flags.indexOf('f') != -1)");
        return pred;
    }

    @Deprecated
    public static Predicate predicateMemberForGroupNameStartsWith(Database db, String prefix) {
        Predicate pred = new Predicate(db);
        String unique = Predicates.unique("gname", prefix);
        pred.setClause("this.group.name.startsWith(" + unique + ")");
        pred.addParam("java.lang.String " + unique, prefix);
        return pred;
    }

    public static Predicate predicateMemberForGroupNotNewToProjectGroupNameStartsWith(Database db, String prefix) {
        Predicate pred = new Predicate(db);
        String unique = Predicates.unique("gname", prefix);
        pred.setClause("this.editorFlags.indexOf('n') == -1 && this.group.name.startsWith(" + unique + ")");
        pred.addParam("java.lang.String " + unique, prefix);
        return pred;
    }

    public static Predicate predicateURIByPathContains(Database db, String path) {
        Predicate pred = new Predicate(db);
        String unique = Predicates.unique("thepath", path);
        pred.setClause("this.path.indexOf(" + unique + ") != -1");
        pred.addParam("java.lang.String " + unique, Rules.uriEncodedPathToDBPath((String)path));
        pred.setResult("DISTINCT this");
        return pred;
    }

    @Deprecated
    public static Predicate predicateXLinkForLocatorByStatusContentRole(Database db, String status, boolean statusEquals, String[] cRoles) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("status", status);
        String clause = statusEquals ? "(this.xlink.status == " + unique + ")" : "(this.xlink.status == null || this.xlink.status != " + unique + ")";
        p.addParam("java.lang.String " + unique, status);
        if (cRoles != null) {
            clause = clause + " && (";
            for (int i = 0; i < cRoles.length; ++i) {
                if (i != 0) {
                    clause = clause + " || ";
                }
                unique = Predicates.unique("role", cRoles, i);
                clause = clause + "this.xlink.contentRole == " + unique;
                p.addParam("java.lang.String " + unique, cRoles[i]);
            }
            clause = clause + ")";
        }
        p.setClause(clause);
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinkAuthorEmailDateAfter(Database db, String authemail, Date date) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("email", authemail);
        p.setClause("this.date > date && (this.authorEmail == " + unique + " || this.member.email == " + unique + ")");
        p.addParam("java.lang.String " + unique, authemail);
        if (date == null) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(0L);
            date = c.getTime();
        }
        p.addParam("java.util.Date date", date);
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinkArchived(Database db, boolean archived) {
        Predicate p = new Predicate(db);
        p.setClause("this.accepted" + (!archived ? " && !this.contentRole.startsWith('archive-') && this.contentRole != 'Archive'" : ""));
        return p;
    }

    public static Predicate predicateXLinkForLocatorAuthorEmailDateAfter(Database db, String authemail, Date date) {
        Predicate p = new Predicate(db);
        p.setClause("(this.xlink.authorEmail == theemail || this.xlink.member.email == theemail)" + (date == null ? "" : " && this.xlink.date > thedate"));
        p.addParam("java.lang.String theemail", authemail);
        if (date != null) {
            p.addParam("java.util.Date thedate", date);
        }
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinkByGroups(Database db, Collection<String> grpc) {
        return Predicates.predicateXLinkByGroups(db, grpc, true);
    }

    public static Predicate predicateXLinkByGroups(Database db, Collection<String> grpc, boolean archived) {
        Predicate p = new Predicate(db, "predicateXLinkByGroups");
        StringBuilder clause = new StringBuilder("this.accepted && this.groupsForXLink.contains(gfx)");
        clause.append(" && (gfx.group.flags.indexOf('p') != -1 || groups.contains(gfx.group.name))");
        if (!archived) {
            clause.append(" && !this.contentRole.startsWith('archive-') && this.contentRole != 'Archive'");
        }
        p.addParam("java.util.Collection groups", grpc);
        p.addParam("java.lang.Boolean archived", archived);
        p.addVariable("com.pageseeder.db.model.GroupForXLink gfx");
        p.setClause(clause.toString());
        p.setResult("DISTINCT this");
        p.setOrdering(ORDER_BY_ID);
        return p;
    }

    public static Predicate predicateXLinkForLocatorByGroups(Database db, Collection<String> grpc, boolean archived) {
        return Predicates.predicateXLinkForLocatorByGroups(db, grpc, archived, true);
    }

    @Deprecated
    public static Predicate predicateXLinkForLocatorByGroups(Database db, Collection<String> grpc) {
        return Predicates.predicateXLinkForLocatorByGroups(db, grpc, true);
    }

    public static Predicate predicateXLinkForLocatorByGroups(Database db, Collection<String> grpc, boolean archived, boolean docchange) {
        return Predicates.predicateXLinkForLocatorByGroups(db, grpc, archived, docchange, true);
    }

    public static Predicate predicateXLinkForLocatorByGroups(Database db, Collection<String> grpc, boolean archived, boolean docchange, boolean olddoc) {
        return Predicates.predicateXLinkForLocatorByGroups(db, grpc, archived, docchange, false, olddoc, true);
    }

    public static Predicate predicateXLinkForLocatorByGroups(Database db, Collection<String> grpc, boolean archived, boolean docchange, boolean docrelease, boolean olddoc, boolean fileupload) {
        Predicate pred = new Predicate(db);
        Object qs = "this.xlink.groupsForXLink.contains(gfx) && (gfx.group.flags.indexOf('p') != -1 || groupnames.contains(gfx.group.name)) && this.xlink.accepted";
        if (!archived) {
            qs = (String)qs + " && this.xlink.contentRole != 'Archive' && !this.xlink.contentRole.startsWith('archive-')";
        }
        if (!docchange) {
            qs = (String)qs + " && this.xlink.contentRole.indexOf('Xref') == -1 && ";
            qs = (String)qs + (docrelease ? "(!this.xlink.contentRole.startsWith('Documentation') || this.xlink.contentRole == 'Documentation-Release' || this.xlink.contentRole == 'Documentation-Version')" : "!this.xlink.contentRole.startsWith('Documentation')");
        }
        if (!fileupload) {
            qs = (String)qs + " && this.xlink.contentRole != 'File Upload'";
        }
        if (!olddoc) {
            qs = (String)qs + " && (this.xlink.status == null || this.xlink.status != 'Documentation-Old')";
        }
        pred.setClause((String)qs);
        pred.addParam("java.util.Collection groupnames", grpc);
        pred.addVariable("com.pageseeder.db.model.GroupForXLink gfx");
        pred.setResult("DISTINCT this");
        pred.setOrdering(ORDER_BY_ID);
        return pred;
    }

    public static Predicate predicateXLinkForLocatorCommentsByGroups(Database db, Collection<String> grpc, boolean archived) {
        Predicate p = new Predicate(db);
        Object qs = "this.xlink.groupsForXLink.contains(gfx) && (gfx.group.flags.indexOf('p') != -1 || groupnames.contains(gfx.group.name)) && this.xlink.accepted && (this.xlink.contentRole == 'Comment' || this.xlink.contentRole == 'File Attachment'";
        if (archived) {
            qs = (String)qs + " || this.xlink.contentRole == 'archive-Comment' || this.xlink.contentRole == 'archive-File Attachment'";
        }
        qs = (String)qs + ")";
        p.addVariable("com.pageseeder.db.model.GroupForXLink gfx");
        p.addParam("java.util.Collection groupnames", grpc);
        p.setClause((String)qs);
        p.setResult("DISTINCT this");
        p.setOrdering(ORDER_BY_ID);
        return p;
    }

    public static Predicate predicateLocatorForXLinkByContentrolesAndNotStatuses(Database db, String[] croles, String[] notstatuses) throws QueryFailedException {
        String unique;
        int i;
        Predicate p = new Predicate(db);
        Object clause = "";
        if (croles != null && croles.length > 0) {
            clause = (String)clause + "(";
            for (i = 0; i < croles.length; ++i) {
                unique = Predicates.unique("crole", croles[i]);
                if (i > 0) {
                    clause = (String)clause + " || ";
                }
                clause = (String)clause + "this.xlink.contentRole == " + unique;
                p.addParam("java.lang.String " + unique, croles[i]);
            }
            clause = (String)clause + ")";
        }
        if (notstatuses != null && notstatuses.length > 0) {
            clause = (String)clause + (((String)clause).isEmpty() ? "" : " && ") + "(this.xlink.status == null || (";
            for (i = 0; i < notstatuses.length; ++i) {
                unique = Predicates.unique("notstatuses", notstatuses[i]);
                if (i > 0) {
                    clause = (String)clause + " && ";
                }
                clause = (String)clause + "this.xlink.status != " + unique;
                p.addParam("java.lang.String " + unique, notstatuses[i]);
            }
            clause = (String)clause + "))";
        }
        p.setClause((String)clause);
        return p;
    }

    public static Predicate predicateLocatorForXLinkByGroupContentrolesAndNotStatuses(Database db, Long groupid, String[] croles, String[] notstatuses) throws QueryFailedException {
        int i;
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("groupid", groupid);
        String clause = "this.xlink.groupsForXLink.contains(gfx) && gfx.group.id == " + unique + " && !this.xlink.contentTitle.startsWith('Share')";
        p.addVariable("com.pageseeder.db.model.GroupForXLink gfx");
        p.addParam("java.lang.Long " + unique, groupid);
        if (croles != null && croles.length > 0) {
            clause = clause + " && (";
            for (i = 0; i < croles.length; ++i) {
                unique = Predicates.unique("crole", croles[i]);
                if (i > 0) {
                    clause = clause + " || ";
                }
                clause = clause + "this.xlink.contentRole == " + unique;
                p.addParam("java.lang.String " + unique, croles[i]);
            }
            clause = clause + ")";
        }
        if (notstatuses != null && notstatuses.length > 0) {
            clause = clause + " && (this.xlink.status == null || (";
            for (i = 0; i < notstatuses.length; ++i) {
                unique = Predicates.unique("notstatuses", notstatuses[i]);
                if (i > 0) {
                    clause = clause + " && ";
                }
                clause = clause + "this.xlink.status != " + unique;
                p.addParam("java.lang.String " + unique, notstatuses[i]);
            }
            clause = clause + "))";
        }
        p.setClause(clause);
        return p;
    }

    @Deprecated
    public static Predicate predicateLocatorForXLinkAuthorUsername(Database db, String username) {
        Predicate p = new Predicate(db);
        p.setClause("this.xlink.member.username == theusername");
        p.addParam("java.lang.String theusername", username);
        return p;
    }

    public static Predicate predicateLocatorForXLinkByContentrolesDescending(Database db, String[] croles) throws QueryFailedException {
        Predicate p = new Predicate(db);
        Object clause = "";
        if (croles != null && croles.length > 0) {
            for (int i = 0; i < croles.length; ++i) {
                String unique = Predicates.unique("crole", croles[i]);
                if (i > 0) {
                    clause = (String)clause + " || ";
                }
                clause = (String)clause + "this.xlink.contentRole == " + unique;
                p.addParam("java.lang.String " + unique, croles[i]);
            }
        }
        p.setClause((String)clause);
        p.setOrdering("this.id descending");
        return p;
    }

    public static Predicate predicateLocatorForXLinkByContentRole(Database db, String contentRole) {
        return Predicates.predicateLocatorForXLinkByContentRoleEquals(db, contentRole, true);
    }

    public static Predicate predicateLocatorForXLinkByContentRoleEquals(Database db, String contentRole, boolean eq) {
        Predicate p = new Predicate(db);
        String unique1 = Predicates.unique("role", contentRole);
        p.setClause("this.xlink.contentRole " + (eq ? (char)'=' : '!') + "= " + unique1 + " && (this.xlink.properties == null || this.xlink.properties.indexOf('version=') == -1)");
        p.addParam("java.lang.String " + unique1, contentRole);
        p.setOrdering("this.id descending");
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinkForLocatorByContentRole(Database db, String contentrole) {
        return Predicates.predicateLocatorForXLinkByContentRole(db, contentrole);
    }

    @Deprecated
    public static Predicate predicateXLinkByContentRole(Database db, String contentrole) {
        Predicate p = new Predicate(db);
        String unique1 = Predicates.unique("role", contentrole);
        p.setClause("this.contentRole == " + unique1 + " && (this.properties == null || this.properties.indexOf('version=') == -1)");
        p.addParam("java.lang.String " + unique1, contentrole);
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinkForLocatorByPropertiesContains(Database db, String properties) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("prop", properties);
        p.setClause("this.xlink.properties.indexOf(" + unique + ") != -1");
        p.addParam("java.lang.String " + unique, properties);
        p.setOrdering("this.id descending");
        return p;
    }

    public static Predicate predicateXLinkForLocatorContentRoleLike(Database db, String[] contentrole) {
        return Predicates.predicateXLinkForLocatorStatusContentRoleLike(db, null, false, contentrole);
    }

    public static Predicate predicateXLinkForLocatorEdits(Database db, String groupname, boolean olddoc) {
        Predicate p = new Predicate(db);
        Object qs = "this.xlink.groupsForXLink.contains(gfx) && (gfx.group.flags.indexOf('p') != -1 || gfx.group.name == gname) && this.xlink.accepted && (this.xlink.contentRole.startsWith('Documentation') || this.xlink.contentRole == 'Workflow' || this.xlink.contentRole.indexOf('Xref') != -1)";
        if (!olddoc) {
            qs = (String)qs + " && (this.xlink.status == null || this.xlink.status != 'Documentation-Old')";
        }
        p.setClause((String)qs);
        p.addVariable("com.pageseeder.db.model.GroupForXLink gfx");
        p.addParam("java.lang.String gname", groupname);
        p.setResult("DISTINCT this");
        p.setOrdering(ORDER_BY_ID);
        return p;
    }

    public static Predicate predicateXLinkForLocatorStatusContentRoleLike(Database db, String status, boolean statusEquals, String[] contentrole) {
        return Predicates.predicateXLinkForLocatorStatusContentRoleLikeDates(db, status, statusEquals, contentrole, null, null);
    }

    public static Predicate predicateXLinkForLocatorStatusContentRoleLikeDates(Database db, String status, boolean statusEquals, String[] contentrole, Date before, Date after) {
        String unique;
        Predicate p = new Predicate(db);
        Object clause = "";
        if (status != null) {
            unique = Predicates.unique("status", status);
            p.addParam("java.lang.String " + unique, status);
            clause = (String)clause + "(" + (statusEquals ? "this.xlink.status == " + unique : "this.xlink.status == null || this.xlink.status != " + unique) + ")";
        }
        if (contentrole != null && contentrole.length > 0) {
            Object sclause = "";
            for (int i = 0; i < contentrole.length; ++i) {
                if (i != 0) {
                    sclause = (String)sclause + " || ";
                }
                String unique2 = Predicates.unique("role", contentrole, i);
                if (!contentrole[i].endsWith("%")) {
                    sclause = (String)sclause + "this.xlink.contentRole == " + unique2;
                    p.addParam("java.lang.String " + unique2, contentrole[i]);
                    continue;
                }
                String value = contentrole[i].replaceFirst("%$", "");
                p.addParam("java.lang.String " + unique2, value);
                sclause = (String)sclause + "this.xlink.contentRole.substring(0, " + value.length() + ") == " + unique2;
            }
            if (((String)sclause).length() > 0) {
                if (((String)clause).length() > 0) {
                    clause = (String)clause + " && ";
                }
                clause = (String)clause + "(" + (String)sclause + ")";
            }
        }
        if (before != null) {
            unique = Predicates.unique("before", before.getTime());
            if (((String)clause).length() > 0) {
                clause = (String)clause + " && ";
            }
            clause = (String)clause + "this.xlink.date < " + unique;
            p.addParam("java.util.Date " + unique, before);
        }
        if (after != null) {
            unique = Predicates.unique("after", after.getTime());
            if (((String)clause).length() > 0) {
                clause = (String)clause + " && ";
            }
            clause = (String)clause + "this.xlink.date > " + unique;
            p.addParam("java.util.Date " + unique, after);
        }
        if (((String)clause).length() > 0) {
            p.setClause((String)clause);
        }
        return p;
    }

    public static Predicate predicateXLinkForLocatorByGroupStatusContentRoleLike(Database db, Long groupid, String status, boolean statusEquals, String[] contentrole) {
        return Predicates.predicateXLinkForLocatorByGroupStatusContentRoleLikeDates(db, groupid, status, statusEquals, contentrole, null, null);
    }

    public static Predicate predicateXLinkForLocatorByGroupStatusContentRoleLikeDates(Database db, Long groupid, String status, boolean statusEquals, String[] contentrole, Date before, Date after) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("groupid", groupid);
        String clause = "this.xlink.groupsForXLink.contains(gfx) && gfx.group.id == " + unique;
        p.addVariable("com.pageseeder.db.model.GroupForXLink gfx");
        p.addParam("java.lang.Long " + unique, groupid);
        if (status != null) {
            unique = Predicates.unique("status", status);
            p.addParam("java.lang.String " + unique, status);
            clause = clause + " && (" + (statusEquals ? "this.xlink.status == " + unique : "this.xlink.status == null || this.xlink.status != " + unique) + ")";
        }
        if (contentrole != null && contentrole.length > 0) {
            Object sclause = "";
            for (int i = 0; i < contentrole.length; ++i) {
                if (i != 0) {
                    sclause = (String)sclause + " || ";
                }
                unique = Predicates.unique("role", contentrole, i);
                if (!contentrole[i].endsWith("%")) {
                    sclause = (String)sclause + "this.xlink.contentRole == " + unique;
                    p.addParam("java.lang.String " + unique, contentrole[i]);
                    continue;
                }
                String value = contentrole[i].replaceFirst("%$", "");
                p.addParam("java.lang.String " + unique, value);
                sclause = (String)sclause + "this.xlink.contentRole.substring(0, " + value.length() + ") == " + unique;
            }
            if (((String)sclause).length() > 0) {
                clause = clause + " && (" + (String)sclause + ")";
            }
        }
        if (before != null) {
            unique = Predicates.unique("before", before.getTime());
            clause = clause + " && this.xlink.date < " + unique;
            p.addParam("java.util.Date " + unique, before);
        }
        if (after != null) {
            unique = Predicates.unique("after", after.getTime());
            clause = clause + " && this.xlink.date > " + unique;
            p.addParam("java.util.Date " + unique, after);
        }
        p.setClause(clause);
        return p;
    }

    public static Predicate predicateXLinkForLocatorNotContentRoleStartsWith(Database db, String[] contentrole) {
        Predicate p = new Predicate(db);
        if (contentrole != null && contentrole.length > 0) {
            Object clause = "";
            for (int i = 0; i < contentrole.length; ++i) {
                if (i != 0) {
                    clause = (String)clause + " && ";
                }
                String unique = Predicates.unique("role", contentrole, i);
                clause = (String)clause + "!this.xlink.contentRole.startsWith(" + unique + ")";
                p.addParam("java.lang.String " + unique, contentrole[i]);
            }
            p.setClause("(" + (String)clause + ")");
        }
        return p;
    }

    public static Predicate predicateXLinkForLocatorRoleContains(Database db, String role) {
        Predicate p = new Predicate(db);
        String unique = Predicates.unique("role", role);
        p.setClause("this.role.indexOf(" + unique + ") != -1");
        p.addParam("java.lang.String " + unique, role);
        return p;
    }

    public static Predicate predicateXLinkForLocatorRoleContains(Database db, String[] roles) {
        Predicate p = new Predicate(db);
        Object clause = "";
        for (int i = 0; i < roles.length; ++i) {
            if (i != 0) {
                clause = (String)clause + " || ";
            }
            String unique = Predicates.unique("role", roles, i);
            clause = (String)clause + "this.role.indexOf(" + unique + ") != -1";
            p.addParam("java.lang.String " + unique, roles[i]);
        }
        p.setClause("(" + (String)clause + ")");
        return p;
    }

    public static Predicate predicateXLinkForLocatorRoleContainsNoFileUpload(Database db, String[] roles) {
        Predicate p = new Predicate(db);
        Object clause = "(";
        for (int i = 0; i < roles.length; ++i) {
            if (i != 0) {
                clause = (String)clause + " || ";
            }
            String unique = Predicates.unique("role", roles, i);
            clause = (String)clause + "this.role.indexOf(" + unique + ") != -1";
            p.addParam("java.lang.String " + unique, roles[i]);
        }
        p.setClause((String)clause + ")");
        return p;
    }

    @Deprecated
    public static Predicate predicateXLinkForLocatorNotRoleContains(Database db, String[] roles) {
        Predicate p = new Predicate(db);
        Object clause = "(this.role == null || (";
        for (int i = 0; i < roles.length; ++i) {
            if (i != 0) {
                clause = (String)clause + " && ";
            }
            String unique = Predicates.unique("role", roles, i);
            clause = (String)clause + "this.role.indexOf(" + unique + ") == -1";
            p.addParam("java.lang.String " + unique, roles[i]);
        }
        p.setClause((String)clause + "))");
        return p;
    }

    private static String unique(String prefix, long i) {
        return prefix + Math.abs(i == Long.MIN_VALUE ? 0L : i);
    }

    private static String unique(String prefix, String s) {
        if (s == null) {
            return prefix + "0";
        }
        int hash = s.hashCode();
        return prefix + Math.abs(hash == Integer.MIN_VALUE ? 0 : hash);
    }

    private static String unique(String prefix, Collection<String> collection) {
        if (collection == null) {
            return prefix + "0";
        }
        int hash = collection.hashCode();
        return prefix + Math.abs(hash == Integer.MIN_VALUE ? 0 : hash);
    }

    private static String unique(String prefix, String[] array, int position) {
        int hash = Arrays.hashCode(array);
        return prefix + "_" + position + Math.abs(hash == Integer.MIN_VALUE ? 0 : hash);
    }
}

