/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db;

import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicate;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOException;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSQuery<T extends DBObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSQuery.class);
    private final Database db;
    private final Class<? extends DBObject> queryClass;
    private String ordering = null;
    private String result = null;
    private int pageSize = -1;
    private boolean pagePlusOne = false;
    private int page = 1;
    private List<String> queryClauses = null;
    private List<String> paramDeclarations = null;
    private List<String> variables = null;
    private Map<String, Object> params = null;
    private Map<String, PSQuery<? extends DBObject>> subqueries = null;
    private Map<PSQuery<? extends DBObject>, String> candidates = null;

    public PSQuery(Class<? extends DBObject> cl, String clause, Object pred) {
        if (!(pred instanceof Predicate)) {
            throw new IllegalArgumentException("Predicate must be an instance of com.pageseeder.db.Predicate class");
        }
        this.queryClass = cl;
        this.params = new HashMap<String, Object>();
        Predicate predicate = (Predicate)pred;
        this.db = predicate.getDatabase();
        this.addClause(clause);
        this.addClause(predicate.getClause());
        this.setResult(predicate.getResult());
        this.setPaging(predicate.getPage(), predicate.getPageSize());
        this.setOrdering(predicate.getOrdering());
        this.addParameters(predicate.getParameters());
        this.addVariables(predicate.getVariables());
        this.addSubQueries(predicate);
    }

    public PSQuery(Class<? extends DBObject> cl, Database db) {
        this.queryClass = cl;
        this.db = db;
        this.params = new HashMap<String, Object>();
    }

    public Class<? extends DBObject> getQueryClass() {
        return this.queryClass;
    }

    public void setPaging(int page, int pagesize) {
        this.page = page;
        this.pageSize = pagesize;
    }

    public void setPaging(int page, int pagesize, boolean plusone) {
        this.page = page;
        this.pageSize = pagesize;
        this.pagePlusOne = plusone;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final int getPage() {
        return this.page;
    }

    public void setOrdering(String order) {
        this.ordering = order;
    }

    public void setResult(String res) {
        this.result = res;
    }

    public void addClause(String clause) {
        if (clause == null || clause.length() == 0) {
            return;
        }
        if (this.queryClauses == null) {
            this.queryClauses = new ArrayList<String>();
        }
        this.queryClauses.add(clause);
    }

    public void addVariables(List<String> vars) {
        if (vars == null) {
            return;
        }
        for (String string : vars) {
            this.addVariable(string);
        }
    }

    public void addVariable(String variable) {
        if (this.variables == null) {
            this.variables = new ArrayList<String>();
        }
        if (variable.indexOf(" ") == -1) {
            throw new IllegalArgumentException(variable + " is not a valid variable.");
        }
        this.variables.add(variable);
    }

    public void addParameters(Map<String, Object> parameters) {
        if (parameters == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
    }

    public void addParameter(String declaration, Object value) {
        if (declaration == null) {
            return;
        }
        if (this.paramDeclarations == null) {
            this.paramDeclarations = new ArrayList<String>();
        }
        if (declaration.indexOf(" ") == -1) {
            throw new IllegalArgumentException(declaration + " is not a valid parameter declaration.");
        }
        this.paramDeclarations.add(declaration);
        String[] paramDetails = declaration.split(" ");
        if (value == null) {
            value = "null";
        }
        this.params.put(paramDetails[1], value);
    }

    public void addSubQuery(PSQuery<? extends DBObject> subquery, String variable) {
        this.addSubQuery(subquery, variable, null);
    }

    public void addSubQuery(PSQuery<? extends DBObject> subquery, String variable, String candidate) {
        if (this.subqueries == null) {
            this.subqueries = new HashMap<String, PSQuery<? extends DBObject>>();
        }
        this.subqueries.put(variable, subquery);
        this.addVariable(variable);
        if (candidate != null) {
            if (this.candidates == null) {
                this.candidates = new HashMap<PSQuery<? extends DBObject>, String>();
            }
            this.candidates.put(subquery, candidate);
        }
    }

    public List<T> execute() throws QueryFailedException {
        long after;
        long diff;
        ArrayList arrayList;
        long before;
        block7: {
            before = System.currentTimeMillis();
            Query q = null;
            try {
                q = this.toQuery();
                arrayList = new ArrayList((Collection)q.executeWithMap(this.getParameters()));
                if (q == null) break block7;
            }
            catch (JDOException ex) {
                try {
                    throw new QueryFailedException(ex.getMessage());
                }
                catch (Throwable throwable) {
                    long after2;
                    long diff2;
                    if (q != null) {
                        q.closeAll();
                    }
                    if ((diff2 = (after2 = System.currentTimeMillis()) - before) > DatabaseQuery.profiling) {
                        StackTraceElement[] st = Thread.currentThread().getStackTrace();
                        StackTraceElement current = st.length > 2 ? st[2] : null;
                        LOGGER.warn("DB-JDO: PS Query {} ---> {}ms.", (Object)current, (Object)diff2);
                    }
                    throw throwable;
                }
            }
            q.closeAll();
        }
        if ((diff = (after = System.currentTimeMillis()) - before) > DatabaseQuery.profiling) {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            StackTraceElement current = st.length > 2 ? st[2] : null;
            LOGGER.warn("DB-JDO: PS Query {} ---> {}ms.", (Object)current, (Object)diff);
        }
        return arrayList;
    }

    public Long executeCount() throws QueryFailedException {
        long after;
        long diff;
        Long l;
        long before;
        block10: {
            before = System.currentTimeMillis();
            if (this.result == null) {
                this.result = "COUNT(this)";
            } else if (!this.result.toLowerCase().startsWith("count")) {
                this.result = "COUNT(" + this.result + ")";
            }
            this.ordering = null;
            Query q = null;
            try {
                q = this.toQuery();
                l = (Long)q.executeWithMap(this.getParameters());
                if (q == null) break block10;
            }
            catch (JDOException ex) {
                try {
                    throw new QueryFailedException(ex.getMessage(), ex);
                }
                catch (Throwable throwable) {
                    long after2;
                    long diff2;
                    if (q != null) {
                        q.closeAll();
                    }
                    if ((diff2 = (after2 = System.currentTimeMillis()) - before) > DatabaseQuery.profiling) {
                        StackTraceElement[] st = Thread.currentThread().getStackTrace();
                        StackTraceElement current = st.length > 2 ? st[2] : null;
                        LOGGER.warn("DB-JDO: PS Query " + current + " ---> " + diff2 + "ms.");
                    }
                    throw throwable;
                }
            }
            q.closeAll();
        }
        if ((diff = (after = System.currentTimeMillis()) - before) > DatabaseQuery.profiling) {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            StackTraceElement current = st.length > 2 ? st[2] : null;
            LOGGER.warn("DB-JDO: PS Query " + current + " ---> " + diff + "ms.");
        }
        return l;
    }

    public Query toQuery() {
        Query q = this.db.getPersistenceManager().newQuery(this.queryClass, this.getQueryString());
        q.declareVariables(this.getVariablesDeclaration());
        q.declareParameters(this.getParametersDeclaration());
        if (this.ordering != null) {
            q.setOrdering(this.ordering);
        }
        if (this.result != null) {
            q.setResult(this.result);
        }
        if (this.subqueries != null && !this.subqueries.isEmpty()) {
            for (String var : this.subqueries.keySet()) {
                PSQuery<? extends DBObject> pq = this.subqueries.get(var);
                String candidate = this.candidates == null ? null : this.candidates.get(pq);
                q.addSubquery(pq.toQuery(), var, candidate, pq.getParameters());
            }
        }
        if (this.pageSize != -1) {
            DatabaseQuery.setPaging(q, this.page, this.pageSize, this.pagePlusOne);
        }
        return q;
    }

    public Map<String, Object> getParameters() {
        return this.params;
    }

    private void addSubQueries(Predicate pred) {
        Map<String, PSQuery<? extends DBObject>> subqueries = pred.getSubQueries();
        if (subqueries == null) {
            return;
        }
        for (Map.Entry<String, PSQuery<? extends DBObject>> entry : subqueries.entrySet()) {
            String var = entry.getKey();
            PSQuery<? extends DBObject> query = entry.getValue();
            this.addSubQuery(query, var, pred.getCandidate(query));
        }
    }

    private String getQueryString() {
        StringBuilder queryString = new StringBuilder("");
        if (this.queryClauses != null) {
            Iterator<String> iterator = this.queryClauses.iterator();
            while (iterator.hasNext()) {
                Object str = iterator.next();
                if (((String)str).indexOf(32) == -1) {
                    str = (String)str + " == true";
                }
                queryString.append("(").append((String)str).append(")");
                if (!iterator.hasNext()) continue;
                queryString.append(" && ");
            }
        }
        return queryString.toString();
    }

    private String getVariablesDeclaration() {
        StringBuilder variablesString = new StringBuilder();
        if (this.variables != null) {
            Iterator<String> i = this.variables.iterator();
            while (i.hasNext()) {
                variablesString.append(i.next());
                if (!i.hasNext()) continue;
                variablesString.append("; ");
            }
        }
        return variablesString.toString();
    }

    private String getParametersDeclaration() {
        StringBuilder parametersString = new StringBuilder("");
        if (this.paramDeclarations != null) {
            Iterator<String> iterator = this.paramDeclarations.iterator();
            while (iterator.hasNext()) {
                parametersString.append(iterator.next());
                if (!iterator.hasNext()) continue;
                parametersString.append(", ");
            }
        }
        return parametersString.toString();
    }
}

