/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db;

import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Rules;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.ObjectStateException;
import com.pageseeder.db.PSQuery;
import com.pageseeder.db.Predicate;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForGroup;
import com.pageseeder.db.model.GroupForXLink;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.HostAlias;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberForGroupStatus;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.ReverseXRefs;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.Groups;
import com.pageseeder.db.util.XLinks;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jdo.JDOException;
import javax.jdo.Query;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseQuery {
    private static String databaseType = null;
    private static boolean isSQLServer = false;
    private static final Pattern ESCAPE_LIKE_PATTERN = Pattern.compile("[%_\\\\]");
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseQuery.class);
    public static final long DEFAULT_PROFILING_THRESHOLD = 5000L;
    public static final int DEFAULT_MAX_PAGE_SIZE = 10000;
    public static final String GENERAL_URI_PATH = "/com.pageseeder.general/";
    public static long profiling = 5000L;
    private static final String ORDER_BY_ID = "this.id ascending";

    private static String binarySQL() {
        return "mysql".equalsIgnoreCase(DatabaseQuery.getDatabaseType()) ? " BINARY" : "";
    }

    private static void profiling(String method, long before) {
        DatabaseQuery.profiling(method, null, before);
    }

    private static void profiling(String method, @Nullable String sql, long before) {
        long after = System.currentTimeMillis();
        long diff = after - before;
        if (diff > profiling) {
            if (sql != null) {
                LOGGER.warn("DB-JDO: {} ---> {}ms. \nSQL:{}", new Object[]{method, diff, sql});
            } else {
                LOGGER.warn("DB-JDO: {} ---> {}ms.", (Object)method, (Object)diff);
            }
        }
    }

    private DatabaseQuery() {
    }

    protected static String escapeForLike(String value) {
        return ESCAPE_LIKE_PATTERN.matcher(value).replaceAll("\\\\$0");
    }

    protected static String lowerCase() {
        String type = DatabaseQuery.getDatabaseType();
        return "postgresql".equalsIgnoreCase(type) ? ".toLowerCase()" : "";
    }

    protected static String lowerCaseSQL(String fieldname) {
        String type = DatabaseQuery.getDatabaseType();
        return "postgresql".equalsIgnoreCase(type) ? "LOWER(" + fieldname + ")" : fieldname;
    }

    public static Integer[] getPersonalGroupsIndexVersionNumbers(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object filter = "this.name.startsWith('member-') && this.name.indexOf('-') > 0";
            filter = (String)filter + " && (this.flags == null || (this.flags.indexOf('f') == -1 && this.flags.indexOf('d') == -1))";
            String declParams = "java.lang.Integer current,java.lang.Integer major";
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("current", Settings.CURRENT_INDEX_VERSION);
            params.put("major", Settings.CURRENT_INDEX_VERSION / 10000 * 1000);
            q = db.getPersistenceManager().newQuery(Group.class, (String)filter + " && this.indexVersion == current");
            q.setResult("count(this.id)");
            q.declareParameters(declParams);
            Long current = (Long)q.executeWithMap(params);
            q.setFilter((String)filter + " && this.indexVersion < current && this.indexVersion >= major");
            Long old = (Long)q.executeWithMap(params);
            q.setFilter((String)filter + " && (this.indexVersion == null || this.indexVersion < major)");
            Long obsolete = (Long)q.executeWithMap(params);
            Integer[] integerArray = new Integer[]{current == null ? 0 : current.intValue(), old == null ? 0 : old.intValue(), obsolete == null ? 0 : obsolete.intValue()};
            return integerArray;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPersonalGroupsIndexVersionNumbers", before);
        }
    }

    public static Integer[] getIndexVersionNumbers(Database db, @Nullable String groupPrefix) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object filter = "this.name != 'public' && this.name != 'admin' && this.name != 'member' && this.name != 'archive' && !this.name.startsWith('member-') && !this.name.startsWith('archive-') && this.name.indexOf('-') > 0";
            filter = (String)filter + " && (this.flags == null || (this.flags.indexOf('f') == -1 && this.flags.indexOf('d') == -1))";
            Object declParams = "java.lang.Integer current,java.lang.Integer major";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("current", Settings.CURRENT_INDEX_VERSION);
            params.put("major", Settings.CURRENT_INDEX_VERSION / 10000 * 1000);
            if (!Strings.isEmpty((String)groupPrefix)) {
                declParams = (String)declParams + ",java.lang.String prefix";
                filter = (String)filter + " && this.name.startsWith(prefix)";
                params.put("prefix", groupPrefix);
            }
            q = db.getPersistenceManager().newQuery(Group.class, (String)filter + " && this.indexVersion == current");
            q.setResult("count(this.id)");
            q.declareParameters((String)declParams);
            Long current = (Long)q.executeWithMap(params);
            q.setFilter((String)filter + " && this.indexVersion < current && this.indexVersion >= major");
            Long old = (Long)q.executeWithMap(params);
            q.setFilter((String)filter + " && (this.indexVersion == null || this.indexVersion < major)");
            Long obsolete = (Long)q.executeWithMap(params);
            Integer[] integerArray = new Integer[]{current == null ? 0 : current.intValue(), old == null ? 0 : old.intValue(), obsolete == null ? 0 : obsolete.intValue()};
            return integerArray;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getIndexVersionNumbers", before);
        }
    }

    public static Collection<Group> getPersonalGroups(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder filter = new StringBuilder("this.name.startsWith('member-') && this.name.indexOf('-') > 0");
            filter.append(" && (this.flags == null || (this.flags.indexOf('f') == -1 && this.flags.indexOf('d') == -1))");
            q = db.getPersistenceManager().newQuery(Group.class, filter.toString());
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPersonalGroups", before);
        }
    }

    public static Collection<Group> getGroupsByPrefix(Database db, @Nullable String groupPrefix) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder filter = new StringBuilder("this.name != 'public' && this.name != 'admin' && this.name != 'member' && this.name != 'archive' && !this.name.startsWith('archive-') && !this.name.startsWith('member-') && this.name.indexOf('-') > 0 && (this.flags == null || (this.flags.indexOf('f') == -1 && this.flags.indexOf('d') == -1))");
            String declParams = null;
            HashMap<String, String> params = new HashMap<String, String>();
            if (!Strings.isEmpty((String)groupPrefix)) {
                declParams = "java.lang.String prefix";
                filter.append(" && this.name.startsWith(prefix)");
                params.put("prefix", groupPrefix);
            }
            q = db.getPersistenceManager().newQuery(Group.class, filter.toString());
            if (declParams != null) {
                q.declareParameters(declParams);
            }
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupsByPrefix", before);
        }
    }

    public static String getTablesVersion(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)"SELECT count(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'DATABASE_METADATA'");
            List nb = (List)q.execute();
            if (nb.isEmpty()) {
                String string = "unknown";
                return string;
            }
            if ("0".equals(nb.get(0))) {
                String string = "pre 4.04";
                return string;
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)"SELECT Version FROM DATABASE_METADATA");
            List v = (List)q.execute();
            String string = v.isEmpty() ? "unknown" : (String)v.get(0);
            return string;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getTablesVersion", before);
        }
    }

    public static boolean updateTablesVersion(Database db, String version) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)("UPDATE DATABASE_METADATA SET VERSION='" + version + "'"));
            Long nb = (Long)q.execute();
            if (nb != 1L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("updateTablesVersion", before);
        }
    }

    public static Collection<? extends DBObject> getCollection(Database db, Class<? extends DBObject> cl, Predicate p) throws QueryFailedException {
        long before = System.currentTimeMillis();
        PSQuery pq = null;
        try {
            pq = new PSQuery(cl, cl.equals(Group.class) ? "this.name != 'admin' && this.name != 'public' && this.name != 'member' && !this.name.startsWith('member-') && !this.name.startsWith('archive-member-')" : "this.id != null", p);
            List list = pq.execute();
            return list;
        }
        catch (QueryFailedException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            pq = null;
            DatabaseQuery.profiling("getCollection of " + cl.toString() + " with predicate " + p.toString(), before);
        }
    }

    public static Collection<Group> getAllNonArchivedGroupsCol(Database db) throws QueryFailedException {
        return DatabaseQuery.getAllNonArchivedGroupsCol(db, false);
    }

    public static Collection<Group> getAllNonArchivedGroupsCol(Database db, boolean excludeProjects) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object filter = "this.name != 'admin' && this.name != 'public' && this.name != 'member' && !this.name.startsWith('member-') && (flags == null || flags.indexOf('d') == -1)";
            if (excludeProjects) {
                filter = (String)filter + " && (flags == null || flags.indexOf('f') == -1)";
            }
            q = db.getPersistenceManager().newQuery(Group.class, (String)filter);
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getAllNonArchivedGroupsCol", before);
        }
    }

    public static List<Group> getGroupsByNameTitleprefix(Database db, int page, int pagesize, String nameprefix, String titleprefix, boolean archivedOnly, boolean oneMore) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object clause = "this.name != 'admin' && this.name != 'public' && this.name != 'member' && !this.name.startsWith('member-') && this.name != 'archive-member' && !this.name.startsWith('archive-member-')";
            if (nameprefix != null || titleprefix != null) {
                clause = (String)clause + " && (";
                if (nameprefix != null) {
                    clause = (String)clause + "this.name.startsWith(nameprefix)" + (titleprefix != null ? " || " : "");
                }
                if (titleprefix != null) {
                    clause = (String)clause + "this.title" + DatabaseQuery.lowerCase() + ".startsWith(titleprefix)";
                }
                clause = (String)clause + ")";
            }
            clause = archivedOnly ? (String)clause + " && flags.indexOf('d') != -1" : (String)clause + " && (flags == null || flags.indexOf('d') == -1)";
            q = db.getPersistenceManager().newQuery(Group.class, (String)clause);
            q.setOrdering("name ascending");
            DatabaseQuery.setPaging(q, page, pagesize, oneMore);
            q.declareParameters("java.lang.String nameprefix, java.lang.String titleprefix");
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute((Object)nameprefix, (Object)(titleprefix != null ? titleprefix.toLowerCase() : titleprefix)));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupsByNameTitleprefix", before);
        }
    }

    public static List<Group> getGroupsByNameprefix(Database db, int page, int pagesize, String nameprefix, boolean archivedOnly, boolean descendants, boolean groups, boolean oneMore) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object clause = "this.name != 'admin' && this.name != 'public' && this.name != 'member' && !this.name.startsWith('member-') && this.name != 'archive-member' && !this.name.startsWith('archive-member-')";
            if (!descendants) {
                clause = nameprefix != null ? (String)clause + " && this.name.startsWith(nameprefix) && this.name.substring(nameprefix.length()).indexOf('-') == -1" : (String)clause + " && this.name.indexOf('-') == -1";
            } else if (nameprefix != null) {
                clause = (String)clause + " && this.name.startsWith(nameprefix)";
            }
            clause = archivedOnly ? (String)clause + " && flags.indexOf('d') != -1" : (String)clause + " && (flags == null || flags.indexOf('d') == -1)";
            if (!groups) {
                clause = (String)clause + " && flags.indexOf('f') != -1";
            }
            q = db.getPersistenceManager().newQuery(Group.class, (String)clause);
            q.setOrdering("name ascending");
            DatabaseQuery.setPaging(q, page, pagesize, oneMore);
            if (nameprefix != null) {
                q.declareParameters("java.lang.String nameprefix");
                ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute((Object)nameprefix));
                return arrayList;
            }
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupsByNameprefix", before);
        }
    }

    public static List<Host> getAllHostsAlpha(Database db, boolean external, int page, int pagesize, boolean plusone) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Host.class);
            if (external) {
                q.setFilter("this.external");
            } else {
                q.setFilter("this.external == null || !this.external");
            }
            q.setOrdering("name ascending");
            DatabaseQuery.setPaging(q, page, pagesize, plusone);
            ArrayList<Host> arrayList = new ArrayList<Host>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getAllHostsAlpha", before);
        }
    }

    public static Collection<GroupURI> getGroupURIsByHostNotSchemeOrNotPort(Database db, Host host, @Nullable String scheme, @Nullable Integer port) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object clause = "this.host.id == hid";
            Object paramsDeclaration = "java.lang.Long hid";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("hid", host.getId());
            if (scheme != null) {
                if (port != null) {
                    clause = (String)clause + " && (this.scheme != thescheme || this.port != theport)";
                    params.put("theport", port);
                    paramsDeclaration = (String)paramsDeclaration + ", java.lang.Long theport";
                } else {
                    clause = (String)clause + " && this.scheme != thescheme";
                }
                params.put("thescheme", scheme);
                paramsDeclaration = (String)paramsDeclaration + ", java.lang.String thescheme";
            } else if (port != null) {
                clause = (String)clause + " && this.port != theport";
                params.put("theport", port);
                paramsDeclaration = (String)paramsDeclaration + ", java.lang.Long theport";
            }
            q = db.getPersistenceManager().newQuery(GroupURI.class, (String)clause);
            q.declareParameters((String)paramsDeclaration);
            ArrayList<GroupURI> arrayList = new ArrayList<GroupURI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupURIsByHostNotSchemeOrNotPort", before);
        }
    }

    public static Collection<URI> getURIsByHost(Database db, Host host) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(URI.class, "this.host.id == hid");
            q.declareParameters("java.lang.Long hid");
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.execute((Object)host.getId()));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsByHost", before);
        }
    }

    public static Collection<URI> getURIsByHostNotSchemeOrNotPort(Database db, Host host, @Nullable String scheme, @Nullable Integer port) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object clause = "this.host.id == hid";
            Object paramsDeclaration = "java.lang.Long hid";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("hid", host.getId());
            if (scheme != null) {
                if (port != null) {
                    clause = (String)clause + " && (this.scheme == thescheme || this.port != theport)";
                    params.put("theport", port);
                    paramsDeclaration = (String)paramsDeclaration + ", java.lang.Long theport";
                } else {
                    clause = (String)clause + " && this.scheme != thescheme";
                }
                params.put("thescheme", scheme);
                paramsDeclaration = (String)paramsDeclaration + ", java.lang.String thescheme";
            } else if (port != null) {
                clause = (String)clause + " && this.port != theport";
                params.put("theport", port);
                paramsDeclaration = (String)paramsDeclaration + ", java.lang.Long theport";
            }
            q = db.getPersistenceManager().newQuery(URI.class, (String)clause);
            q.declareParameters((String)paramsDeclaration);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsByHostNotSchemeOrNotPort", before);
        }
    }

    public static Collection<Locator> getLocatorsForPublicationByURI(Database db, long uriid, XLink pub_xlink) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT L.LocatorID as LocatorID, Fragment, Accepted, Behavior, URIID");
            sql.append(" FROM PUBLICATION_FOR_LOCATOR PFL, LOCATOR L");
            sql.append(" where L.LocatorID = PFL.LocatorID");
            sql.append(" and PFL.XLinkID=" + pub_xlink.getId() + " and L.URIID=" + uriid);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(Locator.class);
            ArrayList<Locator> arrayList = new ArrayList<Locator>((List)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getLocatorsForPublicationByURI", before);
        }
    }

    public static Collection<Locator> getLocatorsForPublication(Database db, XLink pub_xlink) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT L.LocatorID as LocatorID, Fragment, Accepted, Behavior, URIID");
            sql.append(" FROM PUBLICATION_FOR_LOCATOR PFL, LOCATOR L");
            sql.append(" where L.LocatorID = PFL.LocatorID");
            sql.append(" and PFL.XLinkID=" + pub_xlink.getId());
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(Locator.class);
            ArrayList<Locator> arrayList = new ArrayList<Locator>((List)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getLocatorsForPublication", before);
        }
    }

    public static Collection<URI> getURIsForPublication(Database db, XLink pub_xlink) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT DISTINCT ARCHIVED, U.BEHAVIOR AS Behavior, DATEARCHIVED, DATECREATED, DESCRIPTION, DOCID, FOLDER, U.URIID AS URIID, LABELS, LASTMODIFIED, PARENTPATH, PATH, PORT, SCHEME, SIZE, TYPE, USERTITLE, HOSTID, U.XLINKID AS XLinkID, DRAFTEDITXLINKID, PATHHASH FROM URI U");
            sql.append(" INNER JOIN LOCATOR L ON L.URIID = U.URIID");
            sql.append(" INNER JOIN PUBLICATION_FOR_LOCATOR PFL ON PFL.LocatorID = L.LocatorID");
            sql.append(" WHERE PFL.XLinkID=" + pub_xlink.getId());
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((List)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsForPublication", before);
        }
    }

    public static boolean isHostReferenced(Database db, Host host) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q1 = null;
        Query q2 = null;
        try {
            q1 = db.getPersistenceManager().newQuery(GroupURI.class, "this.host.id == hid");
            q1.declareParameters("java.lang.Long hid");
            q1.setResult("COUNT(this.id)");
            Long count = (Long)q1.execute((Object)host.getId());
            if (count > 0L) {
                boolean bl = true;
                return bl;
            }
            q2 = db.getPersistenceManager().newQuery(URI.class, "this.host.id == hid");
            q2.declareParameters("java.lang.Long hid");
            q2.setResult("COUNT(this)");
            count = (Long)q2.execute((Object)host.getId());
            if (count > 0L) {
                boolean bl = true;
                return bl;
            }
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q1 != null) {
                q1.closeAll();
            }
            q1 = null;
            if (q2 != null) {
                q2.closeAll();
            }
            q2 = null;
            DatabaseQuery.profiling("isHostReferenced", before);
        }
        return false;
    }

    public static Collection<Member> getAllMembersCol(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Member.class);
            ArrayList<Member> arrayList = new ArrayList<Member>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getAllMembersCol", before);
        }
    }

    public static void executeSQLQuery(Database db, String sql, PrintWriter out) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql);
            Collection result = (Collection)q.execute();
            out.println("Found " + result.size() + " result" + (result.size() == 1 ? "" : "s") + ":");
            for (Object object : result) {
                if (object instanceof Object[]) {
                    Object[] objs = (Object[])object;
                    for (int i = 0; i < objs.length; ++i) {
                        if (i != 0) {
                            out.print(",");
                        }
                        out.print(objs[i]);
                    }
                } else if (object instanceof String || object instanceof Long) {
                    out.print(object);
                } else {
                    out.print("Unknown class for result: " + object.getClass());
                }
                out.println();
            }
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("executeSQLQuery " + sql, before);
        }
    }

    public static Collection<Member> getAllMembersListAlpha(Database db, int page, int pagesize) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Member.class);
            q.setOrdering("surname ascending");
            DatabaseQuery.setPaging(q, page, pagesize);
            ArrayList<Member> arrayList = new ArrayList<Member>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getAllMembersListAlpha", before);
        }
    }

    public static @Nullable Group getGroupById(Database db, Long id) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "id == theid");
            q.declareImports("import java.lang.Long");
            q.declareParameters("java.lang.Long theid");
            q.setUnique(true);
            Group group = (Group)q.execute((Object)id);
            return group;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupById", before);
        }
    }

    public static Collection<Group> getAllNonArchivedProjects(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "flags.indexOf('f') != -1 && flags.indexOf('d') == -1 && this.name != 'member' && !this.name.startsWith('member-') && !this.name.startsWith('archive-member-')");
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getAllNonArchivedProjects", before);
        }
    }

    public static Collection<Group> getAllProjects(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "flags.indexOf('f') != -1 && this.name != 'member' && !this.name.startsWith('member-') && !this.name.startsWith('archive-member-')");
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getAllProjects", before);
        }
    }

    public static @Nullable Group getGroupByName(Database db, String name) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "this.name == thename");
            q.declareImports("import java.lang.String");
            q.declareParameters("java.lang.String thename");
            q.setUnique(true);
            Group group = (Group)q.execute((Object)name);
            return group;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupByName", before);
        }
    }

    public static Collection<Group> getGroupsByNameStartsWith(Database db, String prefix) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "name.startsWith(thename)");
            q.declareImports("import java.lang.String");
            q.declareParameters("java.lang.String thename");
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute((Object)prefix));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupsByNameStartsWith", before);
        }
    }

    public static Collection<Group> getGroupsByControlGroupNameCol(Database db, String groupname, boolean includeArchived) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String clause = !includeArchived ? " && (flags == null || flags.indexOf('d') == -1)" : "";
            q = db.getPersistenceManager().newQuery(Group.class, "controlGroupName == thename" + clause);
            q.declareImports("import java.lang.String");
            q.declareParameters("java.lang.String thename");
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute((Object)groupname));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupsByControlGroupNameCol", before);
        }
    }

    public static Collection<Group> getGroupsByOwnerColAlpha(Database db, String owner) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "owner == thename && this.name != 'member' && !this.name.startsWith('member-') && !this.name.startsWith('archive-member-')");
            q.declareImports("import java.lang.String");
            q.declareParameters("java.lang.String thename");
            q.setOrdering("name ascending");
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute((Object)owner));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupsByOwnerColAlpha", before);
        }
    }

    public static Collection<Group> getGroupsByOwnerDirectoryNonArchivedCol(Database db, String ownerDir) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "this.ownerDirectory == thename && this.name != 'member' && !this.name.startsWith('member-') && (flags == null || flags.indexOf('d') == -1)");
            q.declareImports("import java.lang.String");
            q.declareParameters("java.lang.String thename");
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute((Object)ownerDir));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupsByOwnerDirectoryCol", before);
        }
    }

    public static Collection<GroupURIForGroup> getGroupURIForGroupsByURI(Database db, URI uri) throws QueryFailedException {
        PSQuery query = new PSQuery(GroupURIForGroup.class, db);
        query.addClause("guris.contains(this.groupURI)");
        query.addParameter("java.util.Collection guris", uri.getGroupURIsCol());
        query.setResult("DISTINCT this");
        return query.execute();
    }

    public static Collection<GroupURI> getGroupURIsByURIGroup(Database db, URI uri, Group group) throws QueryFailedException {
        PSQuery query = new PSQuery(GroupURIForGroup.class, db);
        query.addClause("guris.contains(this.groupURI) && this.group.id == groupid");
        query.addParameter("java.util.Collection guris", uri.getGroupURIsCol());
        query.addParameter("Long groupid", group.getId());
        query.setResult("DISTINCT this.groupURI");
        return query.execute();
    }

    public static Collection<Group> getGroupsByURIIdCol(Database db, Long uriid) throws QueryFailedException {
        return DatabaseQuery.queryGroupsByURIIdCol(db, DatabaseQuery.getURIById(db, uriid)).execute();
    }

    public static Collection<Group> getGroupsByURIIdColNameNotEquals(Database db, Long uriid, String[] names) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q1 = null;
        Object q2 = null;
        try {
            Collection<GroupURI> guris;
            URI uri = DatabaseQuery.getURIById(db, uriid);
            Collection<GroupURI> collection = guris = uri == null ? null : uri.getGroupURIsCol();
            if (guris == null || guris.isEmpty()) {
                List<Group> list = Collections.emptyList();
                return list;
            }
            StringBuilder clause = new StringBuilder("guris.contains(this.groupURI)");
            StringBuilder paramsDeclaration = new StringBuilder("java.util.Collection guris");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("guris", guris);
            if (names != null) {
                for (String name : names) {
                    String unique = DatabaseQuery.unique("name", name);
                    clause.append("&& this.group.name != ").append(unique);
                    paramsDeclaration.append(", java.lang.String " + unique);
                    params.put(unique, name);
                }
            }
            q1 = db.getPersistenceManager().newQuery(GroupURIForGroup.class, clause.toString());
            q1.declareParameters(paramsDeclaration.toString());
            q1.setResult("DISTINCT this.group");
            q1.setOrdering(ORDER_BY_ID);
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q1.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q1 != null) {
                q1.closeAll();
            }
            if (q2 != null) {
                q2.closeAll();
            }
            q1 = null;
            q2 = null;
            DatabaseQuery.profiling("getGroupsByURIIdCol", before);
        }
    }

    public static PSQuery<Group> queryGroupsByURIIdCol(Database db, URI uri) {
        PSQuery<Group> query = new PSQuery<Group>(GroupURIForGroup.class, db);
        query.addClause("guris.contains(this.groupURI)");
        query.addParameter("java.util.Collection guris", uri.getGroupURIsCol());
        query.setResult("DISTINCT this.group");
        query.setOrdering("this.group.id ascending");
        return query;
    }

    public static Collection<GroupForXLink> getGroupForXLinksByGroup(Database db, Group gp) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(GroupForXLink.class, "this.group.id == gid");
            q.declareImports("import java.lang.Long");
            q.declareParameters("java.lang.Long gid");
            ArrayList<GroupForXLink> arrayList = new ArrayList<GroupForXLink>((Collection)q.execute((Object)gp.getId()));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupForXLinksByGroup", before);
        }
    }

    public static @Nullable GroupURI getGroupURIById(Database db, Long id) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(GroupURI.class, "id == theid");
            q.declareImports("import java.lang.Long");
            q.declareParameters("java.lang.Long theid");
            q.setUnique(true);
            GroupURI groupURI = (GroupURI)q.execute((Object)id);
            return groupURI;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupURIById", before);
        }
    }

    public static @Nullable GroupURI getGroupURIBySchemeHostPortPath(Database db, String scheme, String host, Integer port, String path) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(GroupURI.class, "scheme == thescheme && port == theport && path" + DatabaseQuery.lowerCase() + " == thepath && host.name == thehost");
            q.declareImports("import java.lang.String; import java.lang.Integer");
            q.declareParameters("java.lang.String thescheme, java.lang.Integer theport, java.lang.String thepath, java.lang.String thehost");
            q.setUnique(true);
            GroupURI groupURI = (GroupURI)q.executeWithArray(new Object[]{scheme, port, path.toLowerCase(), host});
            return groupURI;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupURIBySchemeHostPortPath", before);
        }
    }

    public static @Nullable GroupURI getGeneralDiscussionGroupURI(Database db, Group group) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(GroupURIForGroup.class, "this.groupURI.path.indexOf(path) > 1 && this.group.id == groupid");
            q.declareParameters("String path, Long groupid");
            q.setResult("this.groupURI");
            q.setUnique(true);
            GroupURI groupURI = (GroupURI)q.executeWithArray(new Object[]{GENERAL_URI_PATH + group.getId(), group.getId()});
            return groupURI;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupURIBySchemeHostPortPath", before);
        }
    }

    public static @Nullable GroupURIForGroup getGroupURIForGroupByGroupURI(Database db, GroupURI guri, Group group) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(GroupURIForGroup.class, "this.groupURI.id == guriid && this.group.id == groupid");
            q.declareParameters("Long guriid, Long groupid");
            q.setUnique(true);
            GroupURIForGroup groupURIForGroup = (GroupURIForGroup)q.executeWithArray(new Object[]{guri.getId(), group.getId()});
            return groupURIForGroup;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupURIForGroupByGroupURI", before);
        }
    }

    public static void logDatabaseException(Throwable ex) {
        LOGGER.error(ex.getMessage() + (String)(ex.getCause() != null ? ": " + ex.getCause().getMessage() : ""), ex);
    }

    public static Collection<GroupURI> getGroupURIsBySchemeHostPortSubpathCol(Database db, String scheme, String host, Integer port, String subpath) throws QueryFailedException {
        return DatabaseQuery.getGroupURIsBySchemeHostPortSuperSubpathCol(db, scheme, host, port, subpath, true, true);
    }

    public static Collection<GroupURI> getGroupURIsBySchemeHostPortSuperSubpathCol(Database db, String scheme, String host, Integer port, String path, boolean descendants, boolean includeSelf) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<Object, Object> params = new HashMap<Object, Object>();
            Object clause = "SELECT GURI.GroupURIID AS GroupURIID FROM DGROUPURI GURI INNER JOIN HOST H ON GURI.HostID = H.HostID WHERE H.Name = :thehost AND GURI.Port = :theport AND GURI.Scheme = :thescheme AND ";
            params.put("thescheme", scheme);
            params.put("theport", port);
            params.put("thehost", host);
            String subpath = path.replaceFirst("/\\*?$", "").toLowerCase();
            if (!descendants) {
                String ancestor;
                ArrayList<CallSite> conditions = new ArrayList<CallSite>();
                String string = ancestor = includeSelf ? subpath : subpath.replaceFirst("/[^/]+$", "");
                while (ancestor.indexOf(47, 1) != -1) {
                    conditions.add((CallSite)((Object)(DatabaseQuery.lowerCaseSQL("GURI.path") + " = :p" + ancestor.length())));
                    params.put("p" + ancestor.length(), ancestor + "/*");
                    ancestor = ancestor.replaceFirst("/[^/]+$", "");
                }
                if (conditions.isEmpty()) {
                    List<GroupURI> list = Collections.emptyList();
                    return list;
                }
                clause = (String)clause + "(" + String.join((CharSequence)" OR ", conditions) + ")";
            } else if (includeSelf) {
                clause = (String)clause + DatabaseQuery.lowerCaseSQL("GURI.path") + " like :thepath";
                params.put("thepath", subpath + "/%");
            } else {
                clause = (String)clause + "(" + DatabaseQuery.lowerCaseSQL("GURI.path") + " like :thepath AND " + DatabaseQuery.lowerCaseSQL("GURI.path") + " != :thepath2)";
                params.put("thepath", subpath + "/%");
                params.put("thepath2", subpath + "/*");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", clause);
            q.setClass(GroupURI.class);
            ArrayList<GroupURI> arrayList = new ArrayList<GroupURI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            DatabaseQuery.profiling("getGroupURIsBySchemeHostPortSuperSubpathCol", before);
        }
    }

    public static List<GroupURI> getGroupURIsBySchemeHostPortSubpathGroup(Database db, String scheme, String host, Integer port, String subpath, Long groupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)("SELECT DISTINCT GURI.GroupURIID AS GroupURIID FROM DGROUPURI GURI INNER JOIN DGROUPURI_FOR_DGROUP GURIFG ON GURI.GroupURIID = GURIFG.GroupURIID INNER JOIN HOST H ON GURI.HostID = H.HostID WHERE (H.Name = :thehost AND GURI.Port = :theport AND GURI.Scheme = :thescheme AND " + DatabaseQuery.lowerCaseSQL("GURI.path") + " like :thepath)  OR GURIFG.GroupID = :thegroupid"));
            String path = !subpath.endsWith("/") ? subpath + "/%" : subpath + "%";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("thescheme", scheme);
            params.put("theport", port);
            params.put("thepath", path.toLowerCase());
            params.put("thehost", host);
            params.put("thegroupid", groupid);
            q.setClass(GroupURI.class);
            ArrayList<GroupURI> arrayList = new ArrayList<GroupURI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupURIsBySchemeHostPortSubpathGroup", before);
        }
    }

    public static @Nullable Host getHostByName(Database db, String name) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Host.class, "name == thename");
            q.declareImports("import java.lang.String");
            q.declareParameters("java.lang.String thename");
            Collection hosts = (Collection)q.execute((Object)name);
            if (hosts == null || hosts.isEmpty()) {
                Host host = null;
                return host;
            }
            Host host = (Host)hosts.iterator().next();
            return host;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getHostByName", before);
        }
    }

    public static @Nullable Host getHostById(Database db, long id) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Host.class, "id == theid");
            q.declareImports("import java.lang.Long");
            q.declareParameters("java.lang.Long theid");
            Collection hosts = (Collection)q.execute((Object)id);
            if (hosts == null || hosts.isEmpty()) {
                Host host = null;
                return host;
            }
            Host host = (Host)hosts.iterator().next();
            return host;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getHostById", before);
        }
    }

    public static @Nullable HostAlias getHostAliasByName(Database db, String name) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(HostAlias.class, "name == thename");
            q.declareImports("import java.lang.String");
            q.declareParameters("java.lang.String thename");
            q.setUnique(true);
            HostAlias hostAlias = (HostAlias)q.execute((Object)name);
            return hostAlias;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getHostAliasByName", before);
        }
    }

    public static @Nullable Member getMemberByEmail(Database db, String email) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Member.class, "email" + DatabaseQuery.lowerCase() + " == theemail");
            q.declareImports("import java.lang.String");
            q.declareParameters("java.lang.String theemail");
            q.setUnique(true);
            Member member = (Member)q.execute((Object)email.toLowerCase());
            return member;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberByEmail", before);
        }
    }

    public static @Nullable Member getMemberById(Database db, Long id) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Member.class, "id == theid");
            q.declareImports("import java.lang.Long");
            q.declareParameters("java.lang.Long theid");
            q.setUnique(true);
            Member member = (Member)q.execute((Object)id);
            return member;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberById", before);
        }
    }

    public static @Nullable Member getMemberByUsername(Database db, String username) throws QueryFailedException {
        if (username == null) {
            return null;
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Member.class, "username" + DatabaseQuery.lowerCase() + " == theusername");
            q.declareImports("import java.lang.String");
            q.declareParameters("java.lang.String theusername");
            q.setUnique(true);
            Member member = (Member)q.execute((Object)username.toLowerCase());
            return member;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberByUsername", before);
        }
    }

    public static @Nullable MemberForGroup getMemberForGroupByGroupIdMemberId(Database db, Long groupid, Long memberid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String clause = "(this.member.id == mid && this.group.id == gid)";
            q = db.getPersistenceManager().newQuery(MemberForGroup.class, clause);
            q.declareParameters("Long gid, Long mid");
            q.setUnique(true);
            MemberForGroup memberForGroup = (MemberForGroup)q.execute((Object)groupid, (Object)memberid);
            return memberForGroup;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberForGroupByGroupIdMemberId", before);
        }
    }

    public static Collection<MemberForGroup> getMemberForGroupsByGroupId(Database db, Long groupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder clause = new StringBuilder();
        try {
            clause.append("SELECT DISTINCT MFG.MemberForGroupID AS MemberForGroupID FROM MEMBER_FOR_DGROUP MFG");
            clause.append("  WHERE MFG.GroupID = ").append(groupid);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(MemberForGroup.class);
            ArrayList<MemberForGroup> arrayList = new ArrayList<MemberForGroup>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberForGroupsByGroupId", before);
        }
    }

    public static Collection<MemberForGroup> getMemberForGroupsByGroupIdMemberId(Database db, Long groupid, Long memberid, boolean includeSubgroups) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder clause = new StringBuilder();
        try {
            clause.append("SELECT DISTINCT MFG.MemberForGroupID AS MemberForGroupID FROM MEMBER_FOR_DGROUP MFG");
            if (includeSubgroups) {
                clause.append(" LEFT OUTER JOIN DGROUP_FOR_DGROUP GFG ON MFG.GroupID = GFG.MemberGroupID");
            }
            clause.append("  WHERE MFG.MemberID = " + memberid + " AND (MFG.GroupID = " + groupid);
            if (includeSubgroups) {
                clause.append(" OR GFG.GroupID = " + groupid);
            }
            clause.append(")");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(MemberForGroup.class);
            ArrayList<MemberForGroup> arrayList = new ArrayList<MemberForGroup>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberForGroupsByGroupIdMemberId", before);
        }
    }

    private static void sqlMemberDetails(String prefix, String username, String firstname, String surname, String email, StringBuilder sql, Map<String, Object> params) {
        if (username != null) {
            sql.append(" AND " + DatabaseQuery.lowerCaseSQL("M.Username") + " = :theusername");
            params.put("theusername", username.toLowerCase());
        }
        if (firstname != null) {
            sql.append(" AND " + DatabaseQuery.lowerCaseSQL("M.FirstName") + " = :thefirstname");
            params.put("thefirstname", firstname.toLowerCase());
        }
        if (surname != null) {
            sql.append(" AND " + DatabaseQuery.lowerCaseSQL("M.Surname") + " = :thesurname");
            params.put("thesurname", surname.toLowerCase());
        }
        if (email != null) {
            sql.append(" AND " + DatabaseQuery.lowerCaseSQL("M.Email") + " = :theemail");
            params.put("theemail", email.toLowerCase());
        }
        if (!Strings.isEmpty((String)prefix)) {
            sql.append(" AND (" + DatabaseQuery.lowerCaseSQL("M.Username") + " LIKE :prefix OR " + DatabaseQuery.lowerCaseSQL("M.FirstName") + " LIKE :prefix OR " + DatabaseQuery.lowerCaseSQL("M.Surname") + " LIKE :prefix OR " + DatabaseQuery.lowerCaseSQL("M.Email") + " LIKE :prefix)");
            params.put("prefix", DatabaseQuery.escapeForLike(prefix.toLowerCase()) + "%");
        }
    }

    private static void sqlMemberGroupDetails(List<MemberForGroupStatus> status, Map<String, String> fields, StringBuilder sql, Map<String, Object> params) {
        int i;
        if (!status.isEmpty()) {
            sql.append(" AND (");
            for (i = 0; i < status.size(); ++i) {
                MemberForGroupStatus s = status.get(i);
                if (i != 0) {
                    sql.append(" OR ");
                }
                if (s == MemberForGroupStatus.NORMAL) {
                    sql.append("(MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%d%')");
                    continue;
                }
                if (s == MemberForGroupStatus.DISABLED) {
                    sql.append("(MFG.EditorFlags LIKE '%d%' AND MFG.EditorFlags NOT LIKE '%n%' AND MFG.EditorFlags NOT LIKE '%s%' AND MFG.EditorFlags NOT LIKE '%m%')");
                    continue;
                }
                if (s == MemberForGroupStatus.INVITED) {
                    sql.append("MFG.EditorFlags LIKE '%n%'");
                    continue;
                }
                if (s == MemberForGroupStatus.SELF_INVITED) {
                    sql.append("MFG.EditorFlags LIKE '%s%'");
                    continue;
                }
                if (s != MemberForGroupStatus.MODERATED) continue;
                sql.append("MFG.EditorFlags LIKE '%m%'");
            }
            sql.append(")");
        }
        if (fields != null && !fields.isEmpty()) {
            for (i = 1; i <= 15; ++i) {
                String value = fields.get("field" + i);
                if (value == null) continue;
                if (value.isEmpty()) {
                    sql.append(" AND D.Field" + i + " IS NULL");
                    continue;
                }
                sql.append(" AND D.Field" + i + " = :thefield" + i);
                params.put("thefield" + i, value);
            }
        }
    }

    public static List<MemberForGroup> getMemberForGroupByGroupIDDetailsSubgroups(Database db, Long groupid, String prefix, String username, String firstname, String surname, String email, Role role, List<MemberForGroupStatus> status, Map<String, String> fields, boolean subgroups, int page, int pagesize) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            sql.append("SELECT * FROM (");
            DatabaseQuery.sqlMemberForGroupByGroupIDDetailsSubgroups(groupid, prefix, username, firstname, surname, email, role, status, fields, subgroups, sql, params);
            sql.append(" ORDER BY sname, fname, mid");
            DatabaseQuery.setPaging(sql, page, pagesize, true);
            sql.append(") x");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(MemberForGroup.class);
            ArrayList<MemberForGroup> arrayList = new ArrayList<MemberForGroup>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberForGroupByGroupIDDetailsSubgroups", before);
        }
    }

    public static int getMemberForGroupByGroupIDDetailsSubgroupsCount(Database db, Long groupid, String prefix, String username, String firstname, String surname, String email, Role role, List<MemberForGroupStatus> status, Map<String, String> fields, boolean subgroups) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            sql.append("SELECT COUNT(DISTINCT mid) FROM (");
            DatabaseQuery.sqlMemberForGroupByGroupIDDetailsSubgroups(groupid, prefix, username, firstname, surname, email, role, status, fields, subgroups, sql, params);
            sql.append(") x");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            Collection results = (Collection)q.executeWithMap(params);
            int n = ((Long)results.toArray()[0]).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberForGroupByGroupIDDetailsSubgroupsCount", before);
        }
    }

    public static void sqlMemberForGroupByGroupIDDetailsSubgroups(Long groupid, String prefix, String username, String firstname, String surname, String email, Role role, List<MemberForGroupStatus> status, Map<String, String> fields, boolean subgroups, StringBuilder sql, Map<String, Object> params) {
        String mfg_member_join = "SELECT MFG.MemberForGroupID, M.Surname sname, M.FirstName fname, M.MemberID mid FROM MEMBER_FOR_DGROUP MFG INNER JOIN MEMBER M ON MFG.MemberID = M.MemberID";
        String mgd_join = " LEFT OUTER JOIN MEMBER_GROUP_DETAILS D ON D.MemberGroupDetailsID = MFG.MemberGroupDetailsID";
        String gfg_join = " INNER JOIN DGROUP_FOR_DGROUP GFG ON GFG.MemberGroupID = MFG.GroupID";
        sql.append("(");
        sql.append(mfg_member_join);
        if (fields != null && !fields.isEmpty()) {
            sql.append(mgd_join);
        }
        sql.append(" WHERE MFG.GroupID = " + groupid);
        DatabaseQuery.sqlMemberDetails(prefix, username, firstname, surname, email, sql, params);
        DatabaseQuery.sqlMemberGroupDetails(status, fields, sql, params);
        if (role != null) {
            if (role.isEditor()) {
                sql.append(" AND MFG.Editor = '1'");
            } else {
                sql.append(" AND MFG.Editor = '0'");
            }
            if (role.isModerator()) {
                sql.append(" AND MFG.ModeratorID IS NOT NULL");
            } else {
                sql.append(" AND MFG.ModeratorID IS NULL");
            }
            if (role.hasFlag('g')) {
                sql.append(" AND MFG.EditorFlags LIKE '%g%'");
            } else {
                sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%g%')");
            }
            if (role.hasFlag('e')) {
                sql.append(" AND MFG.EditorFlags LIKE '%e%'");
            } else {
                sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%e%')");
            }
            if (role.hasFlag('a')) {
                sql.append(" AND MFG.EditorFlags LIKE '%a%'");
            } else {
                sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%a%')");
            }
        }
        if (!subgroups || !status.isEmpty() && !status.contains((Object)MemberForGroupStatus.NORMAL)) {
            sql.append(")");
        } else {
            sql.append(") UNION (");
            sql.append(mfg_member_join);
            sql.append(gfg_join);
            sql.append(" WHERE GFG.GroupID = " + groupid);
            DatabaseQuery.sqlMemberDetails(prefix, username, firstname, surname, email, sql, params);
            DatabaseQuery.sqlMemberGroupDetails(Collections.singletonList(MemberForGroupStatus.NORMAL), null, sql, params);
            sql.append(")");
        }
    }

    public static @Nullable MemberForGroup getMemberForGroupById(Database db, Long id) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(MemberForGroup.class, "id == theid");
            q.declareParameters("java.lang.Long theid");
            q.declareImports("import java.lang.Long");
            q.setUnique(true);
            MemberForGroup memberForGroup = (MemberForGroup)q.execute((Object)id);
            return memberForGroup;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberForGroupById", before);
        }
    }

    public static Iterator<MemberForGroup> getMembersForGroupByGroupIdAlpha(Database db, int page, int pagesize, Long groupid) throws QueryFailedException {
        return DatabaseQuery.getMembersForGroupByGroupIdAlphaCol(db, page, pagesize, groupid).iterator();
    }

    public static List<MemberForGroup> getMembersForGroupByGroupIdAlphaCol(Database db, int page, int pagesize, Long groupid) throws QueryFailedException {
        return DatabaseQuery.getMembersForGroupByGroupIdAlphaCol(db, page, pagesize, groupid, false, null, null);
    }

    public static List<MemberForGroup> getMembersForGroupByGroupIdAlphaCol(Database db, int page, int pagesize, Long groupid, boolean deleted, Collection<String> usernames, Collection<Long> memberids) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object clause = "this.group.id == gid";
            if (!deleted) {
                clause = (String)clause + " && (this.editorFlags == null || this.editorFlags.indexOf('d') == -1)";
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("gid", groupid);
            Object paramsDeclaration = "Long gid";
            if (usernames != null && !usernames.isEmpty()) {
                clause = (String)clause + " && membernames.contains(this.member.username)";
                paramsDeclaration = (String)paramsDeclaration + ", Collection membernames";
                params.put("membernames", usernames);
            }
            if (memberids != null && !memberids.isEmpty()) {
                clause = (String)clause + " && memberids.contains(this.member.id)";
                paramsDeclaration = (String)paramsDeclaration + ", Collection memberids";
                params.put("memberids", memberids);
            }
            q = db.getPersistenceManager().newQuery(MemberForGroup.class, (String)clause);
            q.declareParameters((String)paramsDeclaration);
            q.declareImports("import java.lang.Long; import java.util.Collection");
            q.setOrdering("this.member.surname ascending, this.member.firstName ascending");
            DatabaseQuery.setPaging(q, page, pagesize);
            ArrayList<MemberForGroup> arrayList = new ArrayList<MemberForGroup>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMembersForGroupByGroupIdAlpha", before);
        }
    }

    public static @Nullable GroupForGroup getGroupForGroupByMainGroupSubGroup(Database db, Long mainGroupid, Long subGroupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(GroupForGroup.class, "this.group.id == maingroupid && this.memberGroup.id == subgroupid");
            q.declareParameters("Long maingroupid, Long subgroupid");
            q.setUnique(true);
            GroupForGroup groupForGroup = (GroupForGroup)q.execute((Object)mainGroupid, (Object)subGroupid);
            return groupForGroup;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupForGroupByMainGroupSubGroup", before);
        }
    }

    public static Collection<GroupForGroup> getGroupForGroupsBySubGroup(Database db, Long subGroupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(GroupForGroup.class, "this.memberGroup.id == subgroupid");
            q.declareParameters("Long subgroupid");
            ArrayList<GroupForGroup> arrayList = new ArrayList<GroupForGroup>((Collection)q.execute((Object)subGroupid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupForGroupByMainGroupSubGroup", before);
        }
    }

    public static List<MemberForGroup> getMembersForGroupByGroupIdSubgroups(Database db, int pagesize, Long groupid, boolean deleted) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder sql = new StringBuilder();
        HashMap params = new HashMap();
        String mfg_member_join = "SELECT MFG.MemberForGroupID, M.Surname sname, M.FirstName fname, M.MemberID mid FROM MEMBER_FOR_DGROUP MFG INNER JOIN MEMBER M ON MFG.MemberID = M.MemberID";
        String gfg_join = " INNER JOIN DGROUP_FOR_DGROUP GFG ON GFG.MemberGroupID = MFG.GroupID";
        try {
            sql.append("SELECT * FROM (");
            sql.append("(");
            sql.append(mfg_member_join);
            sql.append(" WHERE MFG.GroupID = " + groupid);
            if (!deleted) {
                sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%d%')");
            }
            sql.append(") UNION (");
            sql.append(mfg_member_join);
            sql.append(gfg_join);
            sql.append(" WHERE GFG.GroupID = " + groupid);
            sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%d%')");
            sql.append(")");
            sql.append(" ORDER BY sname, fname, mid");
            String dbtype = DatabaseQuery.getDatabaseType();
            pagesize = DatabaseQuery.getMaxPageSize(pagesize) + 1;
            if ("mysql".equalsIgnoreCase(dbtype)) {
                sql.append(" LIMIT " + pagesize);
            } else {
                sql.append(" FETCH FIRST " + pagesize + " ROWS ONLY");
            }
            sql.append(") x");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(MemberForGroup.class);
            ArrayList<MemberForGroup> arrayList = new ArrayList<MemberForGroup>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMembersForGroupByGroupIdSubgroups", before);
        }
    }

    public static Collection<MemberForGroup> getMembersForGroupByGroupIdDeletedAlphaCol(Database db, Long groupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(MemberForGroup.class, "this.group.id == gid && this.editorFlags.indexOf('d') != -1");
            q.declareParameters("java.lang.Long gid");
            q.declareImports("import java.lang.Long");
            q.setOrdering("this.member.surname ascending");
            ArrayList<MemberForGroup> arrayList = new ArrayList<MemberForGroup>((Collection)q.execute((Object)groupid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMembersForGroupByGroupIdDeletedAlpha", before);
        }
    }

    public static List<Member> getMembersByPrefixDomain(Database db, int page, int pagesize, @Nullable String prefix, @Nullable String domain, @Nullable String status, boolean oneMore) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder clause = new StringBuilder();
            if (prefix != null) {
                clause.append("(this.email" + DatabaseQuery.lowerCase() + ".startsWith(prefix) || this.firstName" + DatabaseQuery.lowerCase() + ".startsWith(prefix) || this.surname" + DatabaseQuery.lowerCase() + ".startsWith(prefix) || this.username" + DatabaseQuery.lowerCase() + ".startsWith(prefix))");
                if (domain != null || status != null) {
                    clause.append(" && ");
                }
            }
            if (domain != null) {
                clause.append("(this.emailDomain" + DatabaseQuery.lowerCase() + " == domain)");
                if (status != null) {
                    clause.append(" && ");
                }
            }
            if ("disabled".equals(status)) {
                clause.append("this.submitPref.indexOf('d') != -1");
            } else if ("set-password".equals(status)) {
                clause.append("(this.submitPref.indexOf('p') != -1 && this.submitPref.indexOf('d') == -1)");
            } else if ("unactivated".equals(status)) {
                clause.append("(this.submitPref.indexOf('u') != -1 && this.submitPref.indexOf('p') == -1 && this.submitPref.indexOf('d') == -1)");
            } else if ("activated".equals(status)) {
                clause.append("(this.submitPref == null || (this.submitPref.indexOf('u') == -1 && this.submitPref.indexOf('p') == -1 && this.submitPref.indexOf('d') == -1))");
            } else if (status != null) {
                throw new IllegalArgumentException("Status invalid");
            }
            q = db.getPersistenceManager().newQuery(Member.class, clause.toString());
            q.setOrdering("surname ascending, firstName ascending, email ascending");
            DatabaseQuery.setPaging(q, page, pagesize, oneMore);
            q.declareParameters("java.lang.String prefix, java.lang.String domain");
            ArrayList<Member> arrayList = new ArrayList<Member>((Collection)q.execute((Object)(prefix != null ? prefix.toLowerCase() : null), (Object)(domain != null ? domain.toLowerCase() : null)));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMembersByPrefixDomain", before);
        }
    }

    public static List<Member> getMembersByPrefixDomainProject(Database db, int page, int pagesize, @Nullable String prefix, @Nullable String domain, String projectname, boolean oneMore) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String projectprefix = projectname + "-";
            StringBuilder clause = new StringBuilder("SELECT DISTINCT mfg.member FROM com.pageseeder.db.model.MemberForGroup mfg");
            clause.append(" WHERE ");
            clause.append("mfg.group.name.startsWith(projectprefix)");
            if (prefix != null || domain != null) {
                clause.append(" && ");
            }
            if (prefix != null) {
                clause.append("(mfg.member.email" + DatabaseQuery.lowerCase() + ".startsWith(prefix) || mfg.member.firstName" + DatabaseQuery.lowerCase() + ".startsWith(prefix) || mfg.member.surname" + DatabaseQuery.lowerCase() + ".startsWith(prefix) || mfg.member.username" + DatabaseQuery.lowerCase() + ".startsWith(prefix))");
                if (domain != null) {
                    clause.append(" && ");
                }
            }
            if (domain != null) {
                clause.append("(mfg.member.emailDomain == domain)");
            }
            q = db.getPersistenceManager().newQuery(clause.toString());
            q.setClass(MemberForGroup.class);
            q.setOrdering("mfg.member.surname ascending, mfg.member.firstName ascending, mfg.member.email ascending");
            DatabaseQuery.setPaging(q, page, pagesize, oneMore);
            q.declareParameters("java.lang.String prefix, java.lang.String domain, java.lang.String projectprefix");
            ArrayList<Member> arrayList = new ArrayList<Member>((Collection)q.execute((Object)(prefix != null ? prefix.toLowerCase() : null), (Object)(domain != null ? domain.toLowerCase() : null), (Object)projectprefix));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMembersByPrefixDomainProject", before);
        }
    }

    public static Collection<Member> getMembersByGroupId(Database db, Long groupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder sql = new StringBuilder();
        String mfg_member_join = "SELECT M.MemberID memberid FROM MEMBER_FOR_DGROUP MFG INNER JOIN MEMBER M ON MFG.MemberID = M.MemberID";
        String gfg_join = " INNER JOIN DGROUP_FOR_DGROUP GFG ON GFG.MemberGroupID = MFG.GroupID";
        try {
            sql.append("SELECT * FROM (");
            sql.append("(");
            sql.append(mfg_member_join);
            sql.append(" WHERE MFG.GroupID = " + groupid);
            sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%d%')");
            sql.append(") UNION (");
            sql.append(mfg_member_join);
            sql.append(gfg_join);
            sql.append(" WHERE GFG.GroupID = " + groupid);
            sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%d%')");
            sql.append(")");
            sql.append(") x");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(Member.class);
            ArrayList<Member> arrayList = new ArrayList<Member>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMembersByGroupId", before);
        }
    }

    public static Collection<Member> getMembersByGroupIdNoSubgroups(Database db, Long groupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder clause = new StringBuilder("SELECT DISTINCT mfg.member FROM com.pageseeder.db.model.MemberForGroup mfg");
            clause.append(" WHERE ");
            clause.append("mfg.group.id == " + groupid + " && ");
            clause.append("(mfg.editorFlags == null || mfg.editorFlags.indexOf('d') == -1)");
            q = db.getPersistenceManager().newQuery(clause.toString());
            q.setClass(MemberForGroup.class);
            ArrayList<Member> arrayList = new ArrayList<Member>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMembersByGroupIdNoSubgroups", before);
        }
    }

    public static Collection<Member> getMembersByGroupIdNotification(Database db, Long groupid, String notify) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder sql = new StringBuilder();
        HashMap<String, String> params = new HashMap<String, String>();
        String mfg_member_join = "SELECT DISTINCT M.MemberID memberid FROM MEMBER_FOR_DGROUP MFG INNER JOIN MEMBER M ON MFG.MemberID = M.MemberID";
        String gfg_join = " INNER JOIN DGROUP_FOR_DGROUP GFG ON GFG.MemberGroupID = MFG.GroupID LEFT OUTER JOIN MEMBER_FOR_DGROUP MFG2 ON MFG2.MemberID = M.MemberID AND MFG2.GroupID = " + groupid;
        try {
            sql.append("SELECT * FROM (");
            sql.append("(");
            sql.append(mfg_member_join);
            sql.append(" WHERE MFG.GroupID = " + groupid);
            sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%d%')");
            sql.append(" AND MFG.Notification = :notify");
            sql.append(") UNION (");
            sql.append(mfg_member_join);
            sql.append(gfg_join);
            sql.append(" WHERE GFG.GroupID = " + groupid);
            sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%d%')");
            sql.append(" AND GFG.Notification IS NULL AND MFG.Notification = :notify");
            sql.append(" AND (MFG2.MemberID IS NULL OR MFG2.EditorFlags LIKE '%d%')");
            sql.append(") UNION (");
            sql.append(mfg_member_join);
            sql.append(gfg_join);
            sql.append(" WHERE GFG.GroupID = " + groupid);
            sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%d%')");
            sql.append(" AND GFG.Notification = " + DatabaseQuery.lowerCaseSQL(":notify"));
            sql.append(" AND (MFG2.MemberID IS NULL OR MFG2.EditorFlags LIKE '%d%')");
            sql.append(")");
            sql.append(") x");
            params.put("notify", notify);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(Member.class);
            ArrayList<Member> arrayList = new ArrayList<Member>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMembersByGroupIdNotification", before);
        }
    }

    public static Collection<Member> getMembersByGroupIdApprover(Database db, Long groupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder sql = new StringBuilder();
        String mfg_member_join = "SELECT M.MemberID memberid FROM MEMBER_FOR_DGROUP MFG INNER JOIN MEMBER M ON MFG.MemberID = M.MemberID";
        String gfg_join = " INNER JOIN DGROUP_FOR_DGROUP GFG ON GFG.MemberGroupID = MFG.GroupID";
        try {
            sql.append("SELECT * FROM (");
            sql.append("(");
            sql.append(mfg_member_join);
            sql.append(" WHERE MFG.GroupID = " + groupid);
            sql.append(" AND MFG.EditorFlags LIKE '%a%' AND MFG.EditorFlags NOT LIKE '%d%'");
            sql.append(") UNION (");
            sql.append(mfg_member_join);
            sql.append(gfg_join);
            sql.append(" WHERE GFG.GroupID = " + groupid);
            sql.append(" AND MFG.EditorFlags LIKE '%a%' AND MFG.EditorFlags NOT LIKE '%d%'");
            sql.append(" AND GFG.RoleFlags IS NULL");
            sql.append(") UNION (");
            sql.append(mfg_member_join);
            sql.append(gfg_join);
            sql.append(" WHERE GFG.GroupID = " + groupid);
            sql.append(" AND (MFG.EditorFlags IS NULL OR MFG.EditorFlags NOT LIKE '%d%')");
            sql.append(" AND GFG.RoleFlags LIKE '%a%'");
            sql.append(")");
            sql.append(") x");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(Member.class);
            ArrayList<Member> arrayList = new ArrayList<Member>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMembersByGroupIdApprover", before);
        }
    }

    public static @Nullable MemberGroupDetails getMemberGroupDetailsByMemberIdOwnerForm(Database db, Long memid, String owner, String form) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(MemberForGroup.class, "this.group.owner == theowner && this.group.detailsForm == theform && member.id == mid && this.memberGroupDetails != null");
            q.declareParameters("java.lang.String theowner, java.lang.String theform, java.lang.Long mid");
            q.declareImports("import java.lang.Long; import java.lang.String");
            q.setResult("this.memberGroupDetails");
            q.setRange(0L, 1L);
            q.setOrdering(ORDER_BY_ID);
            q.setUnique(true);
            MemberGroupDetails memberGroupDetails = (MemberGroupDetails)q.execute((Object)owner, (Object)form, (Object)memid);
            return memberGroupDetails;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getMemberGroupDetailsByMemberIdOwnerForm", before);
        }
    }

    public static Collection<Member> getMembersByUsernameEmailNameList(Database db, int page, int pagesize, @Nullable String username, @Nullable String email, @Nullable String firstname, @Nullable String surname) throws QueryFailedException {
        long before = System.currentTimeMillis();
        if (!(Strings.isEmpty((String)username) && Strings.isEmpty((String)email) && Strings.isEmpty((String)firstname) && Strings.isEmpty((String)surname))) {
            Object queryString = "";
            String tolowercase = DatabaseQuery.lowerCase();
            if (!Strings.isEmpty((String)username)) {
                queryString = "this.username" + tolowercase + ".equals(theusername)";
                username = username.toLowerCase();
            }
            if (!Strings.isEmpty((String)email)) {
                if (((String)queryString).length() != 0) {
                    queryString = (String)queryString + " && ";
                }
                queryString = (String)queryString + "this.email" + tolowercase + ".equals(theemail)";
                email = email.toLowerCase();
            }
            if (!Strings.isEmpty((String)firstname)) {
                if (((String)queryString).length() != 0) {
                    queryString = (String)queryString + " && ";
                }
                queryString = (String)queryString + "this.firstName" + tolowercase + ".equals(thefirstname)";
                firstname = firstname.toLowerCase();
            }
            if (!Strings.isEmpty((String)surname)) {
                if (((String)queryString).length() != 0) {
                    queryString = (String)queryString + " && ";
                }
                queryString = (String)queryString + "this.surname" + tolowercase + ".equals(thesurname)";
                surname = surname.toLowerCase();
            }
            Query q = null;
            try {
                q = db.getPersistenceManager().newQuery(Member.class, (String)queryString);
                q.declareImports("import java.lang.String");
                q.declareParameters("java.lang.String theusername, java.lang.String theemail, java.lang.String thefirstname, java.lang.String thesurname");
                DatabaseQuery.setPaging(q, page, pagesize);
                ArrayList<Member> arrayList = new ArrayList<Member>((Collection)q.executeWithArray(new Object[]{username, email, firstname, surname}));
                return arrayList;
            }
            catch (JDOException ex) {
                DatabaseQuery.logDatabaseException(ex);
                throw new QueryFailedException(ex.getMessage());
            }
            finally {
                if (q != null) {
                    q.closeAll();
                }
                q = null;
                DatabaseQuery.profiling("getMembersByUsernameEmailNameList", before);
            }
        }
        return Collections.emptyList();
    }

    public static MemberForGroup getModeratorByGroupId(Database db, Long groupid) throws QueryFailedException {
        return DatabaseQuery.getModeratorByGroupId(db, groupid, false);
    }

    public static @Nullable MemberForGroup getModeratorByGroupId(Database db, Long groupid, boolean includedeleted) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(MemberForGroup.class, "this.moderator != null && this.group.id == gid" + (includedeleted ? "" : " && (this.editorFlags == null || this.editorFlags.indexOf('d') == -1)"));
            q.declareParameters("java.lang.Long gid");
            q.declareImports("import java.lang.Long");
            Collection c = (Collection)q.execute((Object)groupid);
            MemberForGroup memberForGroup = c == null || c.isEmpty() ? null : (MemberForGroup)c.iterator().next();
            return memberForGroup;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getModeratorByGroupId", before);
        }
    }

    public static List<XLink> getRepliesByGroups(Database db, XLink xl, Collection<String> groups) throws QueryFailedException {
        return DatabaseQuery.getRepliesByGroupsArchivedAccepted(db, xl, groups, false, false);
    }

    public static List<XLink> getRepliesByGroupsArchivedAccepted(Database db, XLink xl, Collection<String> groups, boolean archived, boolean acceptedOnly) throws QueryFailedException {
        return DatabaseQuery.getRepliesByGroupsArchivedAccepted(db, xl, groups, archived, acceptedOnly, 1, 1000);
    }

    public static List<XLink> getRepliesByArchivedAcceptedAllGroups(Database db, XLink xl, boolean archived, boolean acceptedOnly) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder clause = new StringBuilder("SELECT DISTINCT(X.XLinkID) as XLinkID FROM XLINK_FOR_XLINK XX ");
            clause.append("INNER JOIN XLINK X ON XX.ReplyID = X.XLinkID ");
            clause.append("WHERE XX.ReplyToID = ").append(xl.getId()).append(' ');
            clause.append("AND XX.ReplyID != ").append(xl.getId()).append(' ');
            if (acceptedOnly) {
                clause.append("AND X.Accepted = '1' ");
            }
            if (!archived) {
                clause.append("AND X.ContentRole NOT LIKE 'archive-%' AND X.ContentRole != 'Archive' ");
            }
            clause.append(" ORDER BY X.XLinkID ASC");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getRepliesByArchivedAcceptedAllGroups", before);
        }
    }

    public static List<XLink> getRepliesByGroupsArchivedAccepted(Database db, XLink xl, Collection<String> groups, boolean archived, boolean acceptedOnly, int page, int pagesize) throws QueryFailedException {
        if (groups == null || groups.isEmpty()) {
            throw new QueryFailedException("Groups must not be null or empty.");
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder clause = new StringBuilder("SELECT DISTINCT(X.XLinkID) as XLinkID FROM XLINK_FOR_XLINK XX ");
            clause.append("INNER JOIN XLINK X ON XX.ReplyID = X.XLinkID ");
            clause.append("INNER JOIN DGROUP_FOR_XLINK GFX ON GFX.XLinkID = X.XLinkID ");
            clause.append("INNER JOIN DGROUP  G ON G.GroupID = GFX.GroupID ");
            clause.append("WHERE XX.ReplyToID = ").append(xl.getId()).append(' ');
            clause.append("AND XX.ReplyID != ").append(xl.getId()).append(' ');
            if (acceptedOnly) {
                clause.append("AND X.Accepted = '1' ");
            }
            if (!archived) {
                clause.append("AND X.ContentRole NOT LIKE 'archive-%' AND X.ContentRole != 'Archive' ");
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            clause.append("AND (G.Flags LIKE '%p%'");
            for (String gname : groups) {
                String unique = DatabaseQuery.unique("groupname", gname);
                clause.append(" OR G.GroupName = :" + unique);
                parameters.put(unique, gname);
            }
            clause.append(')');
            clause.append(" ORDER BY X.XLinkID ASC");
            DatabaseQuery.setPaging(clause, page, pagesize);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(XLink.class);
            ArrayList arrayList = new ArrayList((Collection)q.executeWithMap(parameters));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getRepliesByGroupsArchivedAccepted", before);
        }
    }

    public static @Nullable XLink getFirstReplyByGroupsArchivedAccepted(Database db, XLink xl, Collection<String> groups, boolean archived, boolean acceptedOnly) throws QueryFailedException {
        if (groups == null || groups.isEmpty()) {
            throw new QueryFailedException("Groups must not be null or empty.");
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder clause = new StringBuilder("SELECT MIN(X.XLinkID) as XLinkID FROM XLINK_FOR_XLINK XX ");
            clause.append("INNER JOIN XLINK X ON XX.ReplyID = X.XLinkID ");
            if (groups != null && !groups.isEmpty()) {
                clause.append("INNER JOIN DGROUP_FOR_XLINK GFX ON GFX.XLinkID = X.XLinkID ");
                clause.append("INNER JOIN DGROUP  G ON G.GroupID = GFX.GroupID ");
            }
            clause.append("WHERE XX.ReplyToID = ").append(xl.getId()).append(' ');
            clause.append("AND XX.ReplyID != ").append(xl.getId()).append(' ');
            if (acceptedOnly) {
                clause.append("AND X.Accepted  = '1' ");
            }
            if (!archived) {
                clause.append("AND X.ContentRole NOT LIKE 'archive-%' AND X.ContentRole != 'Archive' ");
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            clause.append("AND (G.Flags LIKE '%p%'");
            for (String gname : groups) {
                String unique = DatabaseQuery.unique("groupname", gname);
                clause.append(" OR G.GroupName = :" + unique);
                parameters.put(unique, gname);
            }
            clause.append(')');
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(XLink.class);
            q.setUnique(true);
            XLink xLink = (XLink)q.executeWithMap(parameters);
            return xLink;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getFirstReplyByGroupsArchivedAccepted", before);
        }
    }

    public static @Nullable XLink getLastReplyByGroupsArchivedAccepted(Database db, Long xlinkid, Collection<String> groups, boolean archived, boolean acceptedOnly) throws QueryFailedException {
        if (groups == null || groups.isEmpty()) {
            throw new QueryFailedException("Groups must not be null or empty.");
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder clause = new StringBuilder("SELECT MAX(X.XLinkID) as XLinkID FROM XLINK_FOR_XLINK XX ");
            clause.append("INNER JOIN XLINK X ON XX.ReplyID = X.XLinkID ");
            clause.append("INNER JOIN DGROUP_FOR_XLINK GFX ON GFX.XLinkID = X.XLinkID ");
            clause.append("INNER JOIN DGROUP  G ON G.GroupID = GFX.GroupID ");
            clause.append("WHERE XX.ReplyToID = ").append(xlinkid).append(' ');
            clause.append("AND XX.ReplyID != ").append(xlinkid).append(' ');
            if (acceptedOnly) {
                clause.append("AND X.Accepted = '1' ");
            }
            if (!archived) {
                clause.append("AND X.ContentRole NOT LIKE 'archive-%' AND X.ContentRole != 'Archive' ");
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            clause.append("AND (G.Flags LIKE '%p%'");
            for (String gname : groups) {
                String unique = DatabaseQuery.unique("groupname", gname);
                clause.append(" OR G.GroupName = :" + unique);
                parameters.put(unique, gname);
            }
            clause.append(')');
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(XLink.class);
            q.setUnique(true);
            XLink xLink = (XLink)q.executeWithMap(parameters);
            return xLink;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getLastReplyByGroupsArchivedAccepted", before);
        }
    }

    public static List<XLink> getRepliesByStatusNotNull(Database db, XLink xl) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder clause = new StringBuilder("SELECT X.XLinkID as XLinkID FROM XLINK_FOR_XLINK XX ");
            clause.append("INNER JOIN XLINK X ON XX.ReplyID = X.XLinkID ");
            clause.append("WHERE XX.ReplyToID = ").append(xl.getId());
            clause.append(" AND XX.ReplyID != ").append(xl.getId());
            clause.append(" AND X.Status IS NOT NULL");
            clause.append(" AND X.Accepted  = '1'");
            clause.append(" AND X.ContentRole NOT LIKE 'archive-%' AND X.ContentRole != 'Archive'");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)(clause.toString() + " ORDER BY X.XLinkID ASC"));
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getRepliesByStatusNotNull", before);
        }
    }

    public static Collection<XLink> getRepliesByAuthorEmailDateAfter(Database db, XLink xl, String authoremail, Date date) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder clause = new StringBuilder("SELECT X.XLinkID as XLinkID FROM XLINK_FOR_XLINK XX ");
            clause.append("INNER JOIN XLINK X ON XX.ReplyID = X.XLinkID ");
            if (authoremail != null && !authoremail.isEmpty()) {
                clause.append("INNER JOIN MEMBER M ON X.MemberID = M.MemberID ");
            }
            clause.append("WHERE XX.ReplyToID = ").append(xl.getId()).append(' ');
            clause.append("AND XX.ReplyID != ").append(xl.getId()).append(' ');
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (authoremail != null) {
                clause.append("AND (X.AuthorEmail = :email OR M.Email = :email)");
                parameters.put("email", authoremail);
            }
            if (date != null) {
                clause.append("AND X.CreationDate > '").append(ISO8601.DATETIME.format(date.getTime())).append("'");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)(clause.toString() + " ORDER BY X.XLinkID ASC"));
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(parameters));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getRepliesByAuthorEmailDateAfter", before);
        }
    }

    public static List<XLink> getRepliesByContentRole(Database db, XLink xl, String[] includeRoles, String[] excludeRoles) throws QueryFailedException {
        return DatabaseQuery.getRepliesByGroupContentRoleDates(db, xl, null, includeRoles, excludeRoles, null, null);
    }

    public static List<XLink> getRepliesByGroupContentRoleDates(Database db, XLink xl, Long groupid, String[] includeRoles, String[] excludeRoles, Date creationFrom, Date creationTo) throws QueryFailedException {
        return DatabaseQuery.getRepliesByGroupContentRoleDates(db, xl, groupid, includeRoles, excludeRoles, creationFrom, creationTo, false);
    }

    public static List<XLink> getRepliesByGroupContentRoleDates(Database db, XLink xl, Long groupid, String[] includeRoles, String[] excludeRoles, Date creationFrom, Date creationTo, boolean nostatus) throws QueryFailedException {
        long start = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder clause = new StringBuilder("SELECT X.XLinkID as XLinkID FROM XLINK_FOR_XLINK XX ");
            clause.append("INNER JOIN XLINK X ON XX.ReplyID = X.XLinkID ");
            if (groupid != null) {
                clause.append("INNER JOIN DGROUP_FOR_XLINK GFX ON GFX.XLinkID = X.XLinkID ");
            }
            clause.append("WHERE XX.ReplyToID = ").append(xl.getId()).append(' ');
            clause.append("AND XX.ReplyID != ").append(xl.getId()).append(' ');
            if (groupid != null) {
                clause.append("AND GFX.GroupID = ").append(groupid).append(' ');
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            if (includeRoles != null && includeRoles.length > 0) {
                clause.append("AND (");
                for (int i = 0; i < includeRoles.length; ++i) {
                    if (i != 0) {
                        clause.append(" OR ");
                    }
                    String unique = DatabaseQuery.unique("include", includeRoles[i]);
                    clause.append("X.ContentRole = :" + unique);
                    parameters.put(unique, includeRoles[i]);
                }
                clause.append(") ");
            }
            if (excludeRoles != null && excludeRoles.length > 0) {
                for (String excludeRole : excludeRoles) {
                    String unique = DatabaseQuery.unique("exclude", excludeRole);
                    clause.append("AND X.ContentRole != :").append(unique).append(" ");
                    parameters.put(unique, excludeRole);
                }
            }
            if (creationFrom != null) {
                clause.append("AND X.CreationDate >= :creationFrom ");
                parameters.put("creationFrom", new Timestamp(creationFrom.getTime()));
            }
            if (creationTo != null) {
                clause.append("AND X.CreationDate <= :creationTo ");
                parameters.put("creationTo", new Timestamp(creationTo.getTime()));
            }
            if (nostatus) {
                clause.append("AND X.Status IS NULL ");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)(clause.toString() + " ORDER BY X.XLinkID ASC"));
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(parameters));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getRepliesByContentRoleDates", start);
        }
    }

    public static @Nullable Locator getLocatorById(Database db, Long id) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Locator.class, "id == theid");
            q.declareParameters("java.lang.Long theid");
            q.declareImports("import java.lang.Long");
            q.setUnique(true);
            Locator locator = (Locator)q.execute((Object)id);
            return locator;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getLocatorById", before);
        }
    }

    public static @Nullable URI getURIById(Database db, Long id) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(URI.class, "id == theid");
            q.declareParameters("java.lang.Long theid");
            q.declareImports("import java.lang.Long");
            q.setUnique(true);
            URI uRI = (URI)q.execute((Object)id);
            return uRI;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIById", before);
        }
    }

    public static @Nullable URI getUriByHostDocumentID(Database db, String host, String docid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(URI.class, "this.docID == thedocid && this.host.name == thehost && this.path" + DatabaseQuery.lowerCase() + ".indexOf('/archive/') == -1");
            q.declareParameters("java.lang.String thedocid, java.lang.String thehost");
            q.declareImports("import java.lang.String");
            q.setUnique(true);
            URI uRI = (URI)q.executeWithArray(new Object[]{docid, host});
            return uRI;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getUriByHostDateTime", before);
        }
    }

    public static @Nullable URI getURIBySchemeHostIDPortPathCase(Database db, String scheme, Long hostid, Integer port, String path) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT URIID FROM URI U WHERE");
            sql.append(" U.Scheme = :thescheme AND");
            sql.append(" U.Port = :theport AND");
            sql.append(" U.HostID = :thehost AND");
            sql.append(" U.Path =" + DatabaseQuery.binarySQL() + " :thepath");
            ConcurrentHashMap<String, Object> params = new ConcurrentHashMap<String, Object>();
            params.put("thescheme", scheme);
            params.put("thehost", hostid);
            params.put("thepath", Rules.uriEncodedPathToDBPath((String)path));
            params.put("theport", port);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(URI.class);
            q.setUnique(true);
            URI uRI = (URI)q.executeWithMap(params);
            return uRI;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIBySchemeHostIDPortPathCase", before);
        }
    }

    public static @Nullable URI getURIBySchemeHostIDPortPath(Database db, String scheme, Long hostid, Integer port, String path) throws QueryFailedException {
        long before = System.currentTimeMillis();
        String tolowercase = DatabaseQuery.lowerCase();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(URI.class, "scheme == thescheme && port == theport && path" + tolowercase + " == thepath && host.id == thehost");
            q.declareParameters("java.lang.String thescheme, java.lang.Integer theport, java.lang.String thepath, java.lang.Long thehost");
            q.declareImports("import java.lang.String; import java.lang.Integer; import java.lang.Long");
            q.setUnique(true);
            URI uRI = (URI)q.executeWithArray(new Object[]{scheme, port, Rules.uriEncodedPathToDBPath((String)(path == null ? null : path.toLowerCase())), hostid});
            return uRI;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIBySchemeHostIDPortPath", before);
        }
    }

    public static @Nullable URI getURIBySchemeHostPortPath(Database db, String scheme, String host, Integer port, String path) throws QueryFailedException {
        long before = System.currentTimeMillis();
        String tolowercase = DatabaseQuery.lowerCase();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(URI.class, "scheme == thescheme && port == theport && path" + tolowercase + " == thepath && host.name == thehost");
            q.declareParameters("java.lang.String thescheme, java.lang.Integer theport, java.lang.String thepath, java.lang.String thehost");
            q.declareImports("import java.lang.String; import java.lang.Integer");
            q.setUnique(true);
            URI uRI = (URI)q.executeWithArray(new Object[]{scheme, port, Rules.uriEncodedPathToDBPath((String)(path == null ? null : path.toLowerCase())), host});
            return uRI;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIBySchemeHostPortPath", before);
        }
    }

    public static int getURICountBySchemeHostPortPathLike(Database db, String scheme, String host, Integer port, String path, String behavior) throws QueryFailedException {
        long before = System.currentTimeMillis();
        path = Rules.uriEncodedPathToDBPath((String)path).toLowerCase();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)("SELECT COUNT(U.URIID) FROM URI U WHERE U.Scheme = :ascheme AND U.Port = :aport AND " + DatabaseQuery.lowerCaseSQL("U.Path") + " LIKE :apath AND U.HostID IN (SELECT H.HostID FROM HOST H WHERE H.Name = :ahost)" + (behavior == null ? "" : " AND U.Behavior = :abehavior")));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ascheme", scheme);
            params.put("aport", port);
            params.put("apath", path);
            params.put("ahost", host);
            if (behavior != null) {
                params.put("abehavior", behavior);
            }
            Collection results = (Collection)q.executeWithMap(params);
            int n = ((Long)results.toArray()[0]).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURICountBySchemeHostPortPathLike", before);
        }
    }

    public static @Nullable URI getURIBySchemePortPath(Database db, String scheme, Integer port, String path) throws QueryFailedException {
        long before = System.currentTimeMillis();
        String tolowercase = DatabaseQuery.lowerCase();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(URI.class, "scheme == thescheme && port == theport && path" + tolowercase + " == thepath");
            q.declareParameters("java.lang.String thescheme, java.lang.Integer theport, java.lang.String thepath");
            q.declareImports("import java.lang.String; import java.lang.Integer");
            Collection uris = (Collection)q.executeWithArray(new Object[]{scheme, port, Rules.uriEncodedPathToDBPath((String)(path == null ? null : path.toLowerCase()))});
            if (uris.isEmpty()) {
                URI uRI = null;
                return uRI;
            }
            URI uRI = (URI)uris.iterator().next();
            return uRI;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIBySchemePortPath", before);
        }
    }

    public static Collection<URI> getURIsByGroupURISharedPSML(Database db, GroupURI defaultGuri, Group group) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (defaultGuri == null || defaultGuri.getId() == null || group == null) {
                ArrayList<URI> arrayList = new ArrayList<URI>();
                return arrayList;
            }
            StringBuilder clause = new StringBuilder();
            clause.append("SELECT DISTINCT U.URIID AS URIID FROM URI U");
            clause.append(" INNER JOIN URI_FOR_DGROUPURI UFG ON UFG.URIID = U.URIID");
            clause.append(" INNER JOIN URI_FOR_DGROUPURI UFG2 ON UFG2.URIID = U.URIID");
            clause.append(" INNER JOIN DGROUPURI_FOR_DGROUP GURIFG ON GURIFG.GroupURIID = UFG2.GroupURIID");
            clause.append(" WHERE UFG.GroupURIID = ").append(defaultGuri.getId());
            clause.append(" AND GURIFG.GroupID != ").append(group.getId());
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsByGroupURISharedPSML", before);
        }
    }

    public static Collection<URI> getURIsByGroupURI(Database db, GroupURI guri) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (guri == null || guri.getId() == null) {
                ArrayList<URI> arrayList = new ArrayList<URI>();
                return arrayList;
            }
            q = db.getPersistenceManager().newQuery(URI.class, "this.groupURIs.contains(guri)");
            q.declareParameters("com.pageseeder.db.model.GroupURI guri");
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.execute((Object)guri));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsByGroupURI", before);
        }
    }

    public static Collection<URI> getURIsByGroupURIPSML(Database db, GroupURI guri) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (guri == null || guri.getId() == null) {
                ArrayList<URI> arrayList = new ArrayList<URI>();
                return arrayList;
            }
            q = db.getPersistenceManager().newQuery(URI.class, "this.groupURIs.contains(guri) && this.behavior.startsWith('psml-')");
            q.declareParameters("com.pageseeder.db.model.GroupURI guri");
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.execute((Object)guri));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsByGroupURIPSML", before);
        }
    }

    @Deprecated
    public static List<URI> getURIsByGroupURIInFolder(Database db, GroupURI guri, String folderpath, boolean onlyFolders, int page, int pagesize) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Object q = null;
        StringBuilder clause = new StringBuilder();
        try {
            clause.append("SELECT U.URIID AS URIID, U.Type, U.Path FROM URI U");
            clause.append(" INNER JOIN URI_FOR_DGROUPURI UFG ON UFG.URIID = U.URIID");
            clause.append(" WHERE UFG.GroupURIID = ").append(guri.getId());
            clause.append(" AND U.Path != :thepath0");
            clause.append(" AND U.Path LIKE :thepath1");
            clause.append(" AND U.Path NOT LIKE :thepath2");
            if (onlyFolders) {
                clause.append(" AND U.Type = 'folder'");
            }
            clause.append(" ORDER BY U.Type!='folder', U.Path");
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            String path = Rules.uriEncodedPathToDBPath((String)folderpath);
            params.put("thepath0", (CallSite)((Object)(path + "/")));
            params.put("thepath1", (CallSite)((Object)(DatabaseQuery.escapeForLike(path) + "/%")));
            params.put("thepath2", (CallSite)((Object)(DatabaseQuery.escapeForLike(path) + "/%/%")));
            int ps = DatabaseQuery.getMaxPageSize(pagesize);
            if (page > 0 && ps > 0) {
                int start = (page - 1) * ps;
                clause.append(" LIMIT " + start + "," + (ps + 1));
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            System.out.println(q != null ? q.toString() : "null");
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsByGroupURIInFolder", clause.toString(), before);
        }
    }

    public static Collection<URI> getURIsBySchemeHostPortPathCol(Database db, String scheme, String host, Integer port, String path) throws QueryFailedException {
        long before = System.currentTimeMillis();
        String tolowercase = DatabaseQuery.lowerCase();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(URI.class, "scheme == thescheme && port == theport && path" + tolowercase + " == thepath && host.name == thehost");
            q.declareParameters("java.lang.String thescheme, java.lang.Integer theport, java.lang.String thepath, java.lang.String thehost");
            q.declareImports("import java.lang.String; import java.lang.Integer");
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithArray(new Object[]{scheme, port, Rules.uriEncodedPathToDBPath((String)(path == null ? null : path.toLowerCase())), host}));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsBySchemeHostPortPathCol", before);
        }
    }

    public static Collection<URI> getURIsBySchemeHostPortSubpathCol(Database db, String scheme, String host, Integer port, String subpath) throws QueryFailedException {
        return DatabaseQuery.getURIsBySchemeHostPortSubpath(db, scheme, host, port, subpath, true);
    }

    public static Collection<URI> getURIsBySchemeHostPortSubpath(Database db, String scheme, String host, Integer port, String subpath, boolean folders) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT URIID FROM URI U");
            sql.append(" INNER JOIN HOST H ON U.HostID = H.HostID WHERE");
            sql.append(" U.Scheme = :thescheme AND ");
            sql.append(" U.Port = :theport AND ");
            sql.append(" H.Name = :thehost AND ");
            sql.append(DatabaseQuery.lowerCaseSQL("U.Path") + " LIKE :thepath");
            ConcurrentHashMap<String, Object> params = new ConcurrentHashMap<String, Object>();
            params.put("thescheme", scheme);
            params.put("thehost", host);
            params.put("thepath", DatabaseQuery.escapeForLike(Rules.uriEncodedPathToDBPath((String)subpath.toLowerCase())) + "%");
            params.put("theport", port);
            if (!folders) {
                sql.append(" AND U.Type != 'folder'");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsBySchemeHostPortSubpathCol", before);
        }
    }

    public static Collection<URI> getURIsBySchemeHostPortSubpathMediaDocumentType(Database db, String scheme, String host, Integer port, String subpath, @Nullable String mediatype, @Nullable String documenttype) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT URIID FROM URI U");
            sql.append(" INNER JOIN HOST H ON U.HostID = H.HostID WHERE");
            sql.append(" U.Scheme = :thescheme AND ");
            sql.append(" U.Port = :theport AND ");
            sql.append(" H.Name = :thehost AND ");
            sql.append(DatabaseQuery.lowerCaseSQL("U.Path") + " LIKE :thepath");
            ConcurrentHashMap<String, Object> params = new ConcurrentHashMap<String, Object>();
            params.put("thescheme", scheme);
            params.put("thehost", host);
            params.put("thepath", DatabaseQuery.escapeForLike(Rules.uriEncodedPathToDBPath((String)subpath.toLowerCase())) + "%");
            params.put("theport", port);
            if (documenttype != null) {
                if ("default".equalsIgnoreCase(documenttype)) {
                    documenttype = "";
                }
                sql.append(" AND U.Behavior = :thebehavior");
                params.put("thebehavior", "psml-" + documenttype + "-");
            }
            if (mediatype != null) {
                sql.append(" AND U.Type = :thetype");
                params.put("thetype", mediatype);
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsBySchemeHostPortSubpathCol", before);
        }
    }

    public static Collection<URI> getURIsByURIXRefsAllGroups(Database db, URI uri, boolean old) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Object q = null;
        try {
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT DISTINCT(L2.URIID) AS URIID FROM LOCATOR L1 ");
            qs.append("  INNER JOIN LOCATOR_FOR_XLINK LFX1 ON LFX1.LocatorID = L1.LocatorID");
            qs.append("  INNER JOIN XLINK X                ON X.XLinkID = LFX1.XLinkID ");
            qs.append("  INNER JOIN LOCATOR_FOR_XLINK LFX2 ON X.XLinkID = LFX2.XLinkID");
            qs.append("  INNER JOIN LOCATOR L2             ON LFX2.LocatorID = L2.LocatorID ");
            qs.append("  INNER JOIN URI U2                 ON L2.URIID = U2.URIID");
            qs.append("  INNER JOIN HOST H2                ON U2.HostID = H2.HostID");
            qs.append(" WHERE X.ContentRole LIKE 'XRef%'");
            if (!old) {
                qs.append("   AND (X.Status IS NULL OR X.Status != 'Documentation-Old')");
            }
            qs.append("   AND ((LFX1.Role = 'xref-link' AND LFX2.Role != 'xref-link')");
            qs.append("     OR (LFX2.Role = 'xref-link' AND LFX1.Role = 'xref-source-manual-link'))");
            qs.append("   AND L1.URIID  = ").append(uri.getId());
            qs.append("   AND L2.URIID != ").append(uri.getId());
            qs.append("   AND (U2.Path NOT LIKE '" + GlobalSettings.getSitePrefix() + "/archive/%'");
            qs.append("     OR H2.ExternalFlag = '1')");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            System.out.println(q != null ? q.toString() : "null");
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            DatabaseQuery.profiling("getURIsByURIXRefsGroup", before);
        }
    }

    public static Collection<Long> getExternalURIsUsedInGroupByType(Database db, Long groupid, @Nullable String urltype) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (groupid == null) {
                List<Long> list = Collections.emptyList();
                return list;
            }
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            params.put("psprefix", (CallSite)((Object)(GlobalSettings.getSitePrefix() + "/%")));
            StringBuilder clause = new StringBuilder("SELECT Distinct(U.URIID) FROM XLINK AS XL");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX      ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L                  ON LFX.LocatorID = L.LocatorID");
            clause.append("    INNER JOIN URI U                      ON L.URIID = U.URIID");
            clause.append("    INNER JOIN HOST H                     ON U.HostID = H.HostID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2     ON LFX2.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L2                 ON LFX2.LocatorID = L2.LocatorID");
            clause.append("    INNER JOIN URI_FOR_DGROUPURI UFGU     ON L2.URIID = UFGU.URIID");
            clause.append("    INNER JOIN DGROUPURI_FOR_DGROUP GUFG  ON GUFG.GroupURIID = UFGU.GroupURIID");
            clause.append("  WHERE (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            clause.append("    AND (U.Archived IS NULL OR U.Archived = '0')");
            clause.append("    AND (U.Folder IS NULL OR U.Folder = '0')");
            clause.append("    AND GUFG.GroupID = ").append(groupid);
            clause.append("    AND (H.ExternalFlag = '1' OR U.Path NOT LIKE :psprefix)");
            clause.append("    AND XL.ContentRole LIKE 'XRef%'");
            clause.append("    AND LFX.Role = 'xref-link'");
            clause.append("    AND LFX2.Role = 'xref-source-manual-link'");
            if ("default".equals(urltype)) {
                clause.append("    AND U.Behavior IS NULL");
            } else if (urltype != null) {
                params.put("behavior", (CallSite)((Object)("url-" + urltype + "-")));
                clause.append("    AND U.Behavior = :behavior");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object o : (Collection)q.executeWithMap(params)) {
                ids.add(DatabaseQuery.getLong(o));
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getExternalURIsUsedInGroupByType", before);
        }
    }

    public static Collection<Long> getExternalURIsCommentsInGroupByType(Database db, Long groupid, @Nullable String urltype) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (groupid == null) {
                List<Long> list = Collections.emptyList();
                return list;
            }
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            params.put("psprefix", (CallSite)((Object)(GlobalSettings.getSitePrefix() + "/%")));
            StringBuilder clause = new StringBuilder("SELECT Distinct(U.URIID) FROM XLINK AS XL");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX      ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L                  ON LFX.LocatorID = L.LocatorID");
            clause.append("    INNER JOIN URI U                      ON L.URIID = U.URIID");
            clause.append("    INNER JOIN HOST H                     ON U.HostID = H.HostID");
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GFX       ON GFX.XLinkID = XL.XLinkID");
            clause.append("  WHERE (XL.ContentRole = 'Comment' or XL.ContentRole = 'File Attachment')");
            clause.append("    AND XL.Accepted='1'");
            clause.append("    AND (U.Archived IS NULL OR U.Archived = '0')");
            clause.append("    AND (U.Folder IS NULL OR U.Folder = '0')");
            clause.append("    AND GFX.GroupID = ").append(groupid);
            clause.append("    AND (H.ExternalFlag = '1' OR U.Path NOT LIKE :psprefix)");
            if ("default".equals(urltype)) {
                clause.append("    AND U.Behavior IS NULL");
            } else if (urltype != null) {
                params.put("behavior", (CallSite)((Object)("url-" + urltype + "-")));
                clause.append("    AND U.Behavior = :behavior");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Object o : (Collection)q.executeWithMap(params)) {
                ids.add(DatabaseQuery.getLong(o));
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getExternalURIsCommentsInGroupByType", before);
        }
    }

    public static Collection<Long> getExternalURIsUsedOrCommentsInGroupByType(Database db, Long groupid, @Nullable String urltype) throws QueryFailedException {
        HashSet<Long> uriids = new HashSet<Long>();
        uriids.addAll(DatabaseQuery.getExternalURIsUsedInGroupByType(db, groupid, urltype));
        uriids.addAll(DatabaseQuery.getExternalURIsCommentsInGroupByType(db, groupid, urltype));
        return uriids;
    }

    public static List<URI> getExternalURIsByType(Database db, @Nullable String type) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            params.put("psprefix", (CallSite)((Object)(GlobalSettings.getSitePrefix() + "/%")));
            Object sql = "SELECT U.URIID FROM URI U INNER JOIN HOST H ON U.HostID = H.HostID WHERE (U.Archived IS NULL OR U.Archived = '0') AND (U.Folder IS NULL OR U.Folder = '0') AND ( H.ExternalFlag = '1' OR U.Path NOT LIKE :psprefix)";
            if ("default".equals(type)) {
                sql = (String)sql + " AND U.Behavior IS NULL";
            } else if (type != null) {
                params.put("behavior", (CallSite)((Object)("url-" + type + "-")));
                sql = (String)sql + " AND U.Behavior = :behavior";
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", sql);
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getExternalURIsByType", before);
        }
    }

    public static List<URI> getExternalURIsByHost(Database db, String host, boolean archivedOnly, int page, int pagesize, boolean plusone) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (host == null || host.isEmpty()) {
                List<URI> list = Collections.emptyList();
                return list;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("host", host);
            params.put("psprefix", GlobalSettings.getSitePrefix() + "/%");
            StringBuilder qs = new StringBuilder("SELECT U.URIID FROM URI U INNER JOIN HOST H ON U.HostID = H.HostID WHERE H.Name = :host AND ( H.ExternalFlag = '1' OR U.Path NOT LIKE :psprefix)");
            if (archivedOnly) {
                qs.append(" AND U.Archived = '1' ORDER BY U.DATEARCHIVED DESC");
            } else {
                qs.append(" AND (U.Archived IS NULL OR U.Archived = '0') ORDER BY U.DATECREATED DESC");
            }
            DatabaseQuery.setPaging(qs, page, pagesize, plusone);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getExternalURIsByHost", before);
        }
    }

    public static List<URI> getExternalURIsByHostsMediatypes(Database db, Collection<String> hosts, Collection<String> mediatypes) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String unique;
            boolean first;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("psprefix", GlobalSettings.getSitePrefix() + "/%");
            Object sql = "SELECT U.URIID FROM URI U INNER JOIN HOST H ON U.HostID = H.HostID WHERE ( H.ExternalFlag = '1' OR U.Path NOT LIKE :psprefix)";
            if (hosts != null && !hosts.isEmpty()) {
                sql = (String)sql + " AND (";
                first = true;
                for (String host : hosts) {
                    unique = DatabaseQuery.unique("host", host);
                    params.put(unique, host);
                    if (!first) {
                        sql = (String)sql + " OR ";
                    }
                    sql = (String)sql + "H.name = :" + unique;
                    first = false;
                }
                sql = (String)sql + ")";
            }
            if (mediatypes != null && !mediatypes.isEmpty()) {
                sql = (String)sql + " AND (";
                first = true;
                for (String mediatype : mediatypes) {
                    unique = DatabaseQuery.unique("mediatype", mediatype);
                    params.put(unique, mediatype);
                    if (!first) {
                        sql = (String)sql + " OR ";
                    }
                    sql = (String)sql + "U.type = :" + unique;
                    first = false;
                }
                sql = (String)sql + ")";
            }
            sql = (String)sql + " AND (U.Archived IS NULL OR U.Archived = '0') ORDER BY U.DATECREATED DESC";
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", sql);
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getExternalURIsByHostsMediatypes", before);
        }
    }

    public static List<URI> getURIsBySchemeHostPortDirectoryType(Database db, Long groupid, String scheme, String host, Integer port, String dir, boolean includeFiles, boolean includeFolders, String relationship, @Nullable String exclude, int page, int pagesize, boolean plusone) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String[] folders;
            if (dir == null || dir.isEmpty()) {
                List<URI> list = Collections.emptyList();
                return list;
            }
            String thepath = Rules.uriEncodedPathToDBPath((String)(dir.endsWith("/") ? dir.substring(0, dir.length() - 1) : dir).toLowerCase());
            HashMap<Object, Object> params = new HashMap<Object, Object>();
            StringBuilder sql = new StringBuilder("SELECT DISTINCT ARCHIVED, BEHAVIOR, DATEARCHIVED, DATECREATED, DESCRIPTION, DOCID, FOLDER, U.URIID AS URIID, LABELS, LASTMODIFIED, PARENTPATH, PATH, PORT, SCHEME, SIZE, TYPE, USERTITLE, U.HOSTID AS HostID, XLINKID, DRAFTEDITXLINKID, PATHHASH FROM URI U");
            sql.append(" INNER JOIN HOST H ON U.HostID = H.HostID");
            sql.append(" INNER JOIN URI_FOR_DGROUPURI UFGURI ON UFGURI.URIID = U.URIID");
            sql.append(" INNER JOIN DGROUPURI_FOR_DGROUP GURIFG ON GURIFG.GroupURIID = UFGURI.GroupURIID");
            sql.append(" WHERE U.Scheme = :thescheme");
            sql.append(" AND U.Port = :theport");
            sql.append(" AND H.Name = :thehost");
            sql.append(" AND GURIFG.GroupID = :thegroupid");
            boolean orderByPath = false;
            if ("ancestors-siblings".equalsIgnoreCase(relationship)) {
                folders = Strings.split((String)thepath, (char)'/');
                Object thefolder = "";
                sql.append(" AND (");
                for (int i = 0; i < folders.length; ++i) {
                    if (folders[i].isEmpty()) continue;
                    if (((String)thefolder).length() > 0) {
                        sql.append(" OR ");
                    }
                    thefolder = (String)thefolder + "/" + folders[i];
                    sql.append(DatabaseQuery.lowerCaseSQL("U.ParentPath") + " = :thepath" + i);
                    params.put("thepath" + i, thefolder);
                }
                sql.append(")");
                orderByPath = true;
            } else if ("ancestors".equalsIgnoreCase(relationship)) {
                folders = Strings.split((String)thepath, (char)'/');
                Object thefolder = "";
                for (int i = 0; i < folders.length; ++i) {
                    if (folders[i].isEmpty()) continue;
                    if ("".equals(thefolder)) {
                        sql.append(" AND (");
                    } else {
                        sql.append(" OR ");
                    }
                    thefolder = (String)thefolder + "/" + folders[i];
                    sql.append(DatabaseQuery.lowerCaseSQL("U.Path") + " = :thepath" + i);
                    params.put("thepath" + i, thefolder);
                }
                sql.append(")");
                orderByPath = true;
            } else if ("descendants".equalsIgnoreCase(relationship)) {
                sql.append(" AND " + DatabaseQuery.lowerCaseSQL("U.Path") + " LIKE :thepath");
                params.put("thepath", DatabaseQuery.escapeForLike(Rules.uriEncodedPathToDBPath((String)thepath.toLowerCase())) + "/%");
                if (exclude != null) {
                    sql.append(" AND " + DatabaseQuery.lowerCaseSQL("U.Path") + " NOT LIKE :exclude");
                    params.put("exclude", DatabaseQuery.escapeForLike(Rules.uriEncodedPathToDBPath((String)(thepath.toLowerCase() + "/" + exclude.toLowerCase()))) + "/%");
                }
                orderByPath = true;
            } else {
                sql.append(" AND " + DatabaseQuery.lowerCaseSQL("U.ParentPath") + " = :theparentpath");
                params.put("theparentpath", thepath);
            }
            params.put("thescheme", scheme);
            params.put("thehost", host);
            params.put("theport", port);
            params.put("thegroupid", groupid);
            if (!includeFolders) {
                sql.append(" AND U.Type != 'folder'");
            }
            if (!includeFiles) {
                sql.append(" AND U.Type = 'folder'");
            }
            if (orderByPath) {
                sql.append(" ORDER BY PATH ASC");
            } else {
                sql.append(" ORDER BY FOLDER DESC, USERTITLE ASC, PATH ASC");
            }
            DatabaseQuery.setPaging(sql, page, pagesize, plusone);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsBySchemeHostPortDirectoryType", before);
        }
    }

    public static Collection<URI> getURIsBySchemeHostPortDirectoryMediaDocumentType(Database db, String scheme, String host, Integer port, String dir, String mediatype, String documenttype, boolean sort) throws QueryFailedException {
        long before = System.currentTimeMillis();
        String tolowercase = DatabaseQuery.lowerCase();
        Query q = null;
        try {
            if (dir == null || dir.isEmpty()) {
                List<URI> list = Collections.emptyList();
                return list;
            }
            if (dir.endsWith("/")) {
                dir = dir.substring(0, dir.length() - 1);
            }
            String thepath = Rules.uriEncodedPathToDBPath((String)dir.toLowerCase());
            StringBuilder paramsDecl = new StringBuilder("java.lang.String thescheme, java.lang.Integer theport, java.lang.String thepath, java.lang.String thehost");
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("thescheme", scheme);
            parameters.put("theport", port);
            parameters.put("thepath", thepath);
            parameters.put("thehost", host);
            StringBuilder clause = new StringBuilder("scheme == thescheme && port == theport");
            clause.append(" && parentPath" + tolowercase + ".equals(thepath)");
            clause.append(" && host.name == thehost");
            if (mediatype != null) {
                clause.append(" && type == thetype");
                paramsDecl.append(", java.lang.String thetype");
                parameters.put("thetype", mediatype);
            }
            if (documenttype != null) {
                if ("default".equalsIgnoreCase(documenttype)) {
                    documenttype = "";
                }
                clause.append(" && behavior == thebehavior");
                paramsDecl.append(", java.lang.String thebehavior");
                parameters.put("thebehavior", "psml-" + documenttype + "-");
            }
            q = db.getPersistenceManager().newQuery(URI.class, clause.toString());
            q.declareParameters(paramsDecl.toString());
            q.declareImports("import java.lang.String; import java.lang.Integer");
            if (sort) {
                q.setOrdering("path ascending");
            }
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(parameters));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsBySchemeHostPortDirectoryCol", before);
        }
    }

    private static Query getQueryURIsByGroupURIIgnoreArchiveCol(Database db, GroupURI guri, String subpath, boolean ignoreArchive, Map<String, Object> parameters) {
        subpath = Rules.uriEncodedPathToDBPath((String)subpath);
        StringBuilder clause = new StringBuilder("this.groupURIs.contains(guri) && this.type != 'folder'");
        StringBuilder paramsDecl = new StringBuilder("com.pageseeder.db.model.GroupURI guri");
        if (ignoreArchive) {
            clause.append(" && !this.path.startsWith(archivepath)");
            parameters.put("archivepath", GroupURIs.truncatePath(guri.getPath()) + "/archive/");
            paramsDecl.append(", String archivepath");
        }
        parameters.put("guri", guri);
        if (subpath != null) {
            clause.append(" && this.path.startsWith(subpath)");
            parameters.put("subpath", subpath);
            paramsDecl.append(", String subpath");
        }
        Query q = db.getPersistenceManager().newQuery(URI.class, clause.toString());
        q.declareParameters(paramsDecl.toString());
        return q;
    }

    private static Query getQueryURIsByGroupURIArchivedFormatsCol(Database db, GroupURI guri, String[] formats, Map<String, Object> parameters) {
        StringBuilder clause = new StringBuilder("this.groupURIs.contains(guri) && this.path.startsWith(archivepath)");
        parameters.put("guri", guri);
        parameters.put("archivepath", GroupURIs.truncatePath(guri.getPath()) + "/archive/");
        StringBuilder paramsDecl = new StringBuilder("com.pageseeder.db.model.GroupURI guri, String archivepath");
        if (formats != null && formats.length > 0) {
            clause.append(" && (");
            for (int i = 0; i < formats.length; ++i) {
                String unique = DatabaseQuery.unique("format", formats[i]);
                if (i != 0) {
                    clause.append(" || ");
                }
                clause.append("this.behavior.startsWith(").append(unique).append(')');
                parameters.put(unique, formats[i] + "-");
                paramsDecl.append(", String " + unique);
            }
            clause.append(')');
        }
        Query q = db.getPersistenceManager().newQuery(URI.class, clause.toString());
        q.declareParameters(paramsDecl.toString());
        return q;
    }

    public static Collection<Long> getURIsByGroupURIIgnoreArchiveCol(Database db, GroupURI guri, String subpath, boolean ignoreArchive) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            q = DatabaseQuery.getQueryURIsByGroupURIIgnoreArchiveCol(db, guri, subpath, ignoreArchive, parameters);
            q.setResult("this.id");
            ArrayList<Long> arrayList = new ArrayList<Long>((Collection)q.executeWithMap(parameters));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsByGroupURIIgnoreArchiveFormatsCol", before);
        }
    }

    public static Long getNumberURIsByGroupURIIgnoreArchiveCol(Database db, GroupURI guri, String subpath, boolean ignoreArchive) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            q = DatabaseQuery.getQueryURIsByGroupURIIgnoreArchiveCol(db, guri, subpath, ignoreArchive, parameters);
            q.setResult("COUNT(this)");
            Long l = (Long)q.executeWithMap(parameters);
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getNumberURIsByGroupURIIgnoreArchiveCol", before);
        }
    }

    public static int getNumberURIFilesByParentPath(Database db, String path) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT COUNT(U.URIID) FROM URI U");
            qs.append("  WHERE " + DatabaseQuery.lowerCaseSQL("U.ParentPath") + " = :theparentpath");
            params.put("theparentpath", Rules.uriEncodedPathToDBPath((String)path.toLowerCase()));
            qs.append("  AND U.Type != 'folder'");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            Collection results = (Collection)q.executeWithMap(params);
            int n = ((Long)results.toArray()[0]).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getNumberURIFilesByParentPath", before);
        }
    }

    public static int getNumberGroupsByURIId(Database db, Long uriid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT COUNT(DISTINCT GUFG.GroupID) FROM URI_FOR_DGROUPURI UFGU");
            qs.append("  INNER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
            qs.append("  WHERE UFGU.URIID = " + uriid);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            Collection results = (Collection)q.execute();
            int n = ((Long)results.toArray()[0]).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getNumberGroupsByURIId", before);
        }
    }

    public static int getNumberXRefsByURIGroup(Database db, Long uriid, Group group, Group pgroup) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT COUNT(XL.XLinkID) FROM XLINK XL");
            qs.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            qs.append("    INNER JOIN URI_FOR_DGROUPURI UFGU ON L2.URIID = UFGU.URIID");
            qs.append("    INNER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
            qs.append("  WHERE L.URIID = " + uriid);
            qs.append("  AND (GF.GroupID = " + pgroup.getId());
            qs.append("  OR GUFG.GroupID = " + group.getId() + ")");
            qs.append("  AND XL.ContentRole LIKE 'XRef%'");
            qs.append("  AND LFX.Role = 'xref-link'");
            qs.append("  AND LFX2.Role = 'xref-source-manual-link'");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            Collection results = (Collection)q.execute();
            int n = ((Long)results.toArray()[0]).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getNumberXRefsByURIGroup", before);
        }
    }

    public static Long getNumberNonMemberGroups(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "this.name != 'member' && !this.name.startsWith(\"member-\") && !this.name.startsWith(\"archive-member-\") && (this.flags == null || this.flags.indexOf('f') == -1)");
            q.setResult("COUNT(this)");
            Long l = (Long)q.execute();
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getNumberNonMemberGroups", before);
        }
    }

    public static Long getNumberMembers(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Member.class);
            q.setResult("COUNT(this)");
            Long l = (Long)q.execute();
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getNumberOfMembers", before);
        }
    }

    public static Long getNumberNonArchivedProjects(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "flags.indexOf('f') != -1 && flags.indexOf('d') == -1 && this.name != 'member' && !this.name.startsWith(\"member-\") && !this.name.startsWith(\"archive-member-\")");
            q.setResult("COUNT(this)");
            Long l = (Long)q.execute();
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getNumberNonArchivedProjects", before);
        }
    }

    public static Long getNumberURIsByGroupURIArchivedFormatsCol(Database db, GroupURI guri, String[] formats) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            q = DatabaseQuery.getQueryURIsByGroupURIArchivedFormatsCol(db, guri, formats, parameters);
            q.setResult("COUNT(this)");
            Long l = (Long)q.executeWithMap(parameters);
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getNumberURIsByGroupURIArchivedFormatsCol", before);
        }
    }

    public static @Nullable XLink getXLinkById(Database db, Long id) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLink.class, "id == theid");
            q.declareParameters("java.lang.Long theid");
            q.declareImports("import java.lang.Long");
            q.setUnique(true);
            XLink xLink = (XLink)q.execute((Object)id);
            return xLink;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinkById", before);
        }
    }

    public static List<XLink> getXLinkMemberDataByTypeList(Database db, Long memberid, String type) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String where = "member.id == memberid && contentRole == 'member-data' && type == thetype";
            q = db.getPersistenceManager().newQuery(XLink.class, where);
            q.declareParameters("java.lang.Long memberid, java.lang.String thetype");
            q.declareImports("import java.lang.Long; import java.lang.String");
            q.setOrdering("this.id descending");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)memberid, (Object)type));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            DatabaseQuery.profiling("getXLinkMemberDataByTypeList", before);
        }
    }

    public static List<XLink> getXLinkMemberDataList(Database db, Long memberid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String where = "member.id == memberid && contentRole == 'member-data'";
            q = db.getPersistenceManager().newQuery(XLink.class, where);
            q.declareParameters("java.lang.Long memberid");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)memberid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            DatabaseQuery.profiling("getXLinkMemberDataList", before);
        }
    }

    public static Long getXLinkMemberDataCount(Database db, Long memberid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String where = "member.id == memberid && contentRole == 'member-data'";
            q = db.getPersistenceManager().newQuery(XLink.class, where);
            q.setResult("COUNT(this)");
            q.declareParameters("java.lang.Long memberid");
            q.declareImports("import java.lang.Long");
            Long l = (Long)q.execute((Object)memberid);
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            DatabaseQuery.profiling("getXLinkMemberDataCount", before);
        }
    }

    public static Collection<XLink> getXLinksByMember(Database db, Long memberid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLink.class, "this.member.id == memberid");
            q.declareParameters("java.lang.Long memberid");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)memberid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByMember", before);
        }
    }

    public static List<XLink> getCommentDraftsByMember(Database db, int page, int pagesize, Long memberid, boolean oneMore) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLink.class, "this.member.id == memberid && this.authorOnly && (this.contentRole == 'Comment' || this.contentRole == 'File Attachment'|| this.contentRole == 'Workflow')");
            q.declareParameters("java.lang.Long memberid");
            q.setOrdering("this.id descending");
            DatabaseQuery.setPaging(q, page, pagesize, oneMore);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)memberid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getCommentDraftsByMember", before);
        }
    }

    public static List<XLink> getCommentDraftsByMemberReplyTo(Database db, Long memberid, Long replytoid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        String dbtype = DatabaseQuery.getDatabaseType();
        try {
            StringBuilder clause = new StringBuilder("SELECT X.XLinkID as XLinkID FROM XLINK_FOR_XLINK XX");
            clause.append(" INNER JOIN XLINK X ON XX.ReplyID = X.XLinkID ");
            clause.append(" WHERE X.ContentRole NOT LIKE 'archive-%' AND XX.ReplyToID = ").append(replytoid);
            clause.append(" AND XX.ReplyID != ").append(replytoid);
            clause.append(" AND X.MemberID = ").append(memberid);
            clause.append(" AND X.AuthorOnly='1'");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getCommentDraftsByMemberReplyTo", before);
        }
    }

    public static Collection<XLink> getXLinksByModifiedBy(Database db, Long memberid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLink.class, "this.modifiedBy.id == memberid");
            q.declareParameters("java.lang.Long memberid");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)memberid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByModifiedBy", before);
        }
    }

    public static Collection<XLink> getXLinksByStatusChangedBy(Database db, Long memberid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLink.class, "this.statusChangedBy.id == memberid");
            q.declareParameters("java.lang.Long memberid");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)memberid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByStatusChangedBy", before);
        }
    }

    public static Collection<XLink> getXLinksByAttachedTo(Database db, Long xlinkid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLinkForAttachedXLink.class, "this.attachedXLink.id == xlid");
            q.declareParameters("java.lang.Long xlid");
            q.setResult("this.xlink");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)xlinkid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByAttachedTo", before);
        }
    }

    public static Collection<XLinkForAttachedXLink> getXLinksForAttachedByAttachedTo(Database db, Long xlinkid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLinkForAttachedXLink.class, "this.attachedXLink.id == xlid");
            q.declareParameters("java.lang.Long xlid");
            ArrayList<XLinkForAttachedXLink> arrayList = new ArrayList<XLinkForAttachedXLink>((Collection)q.execute((Object)xlinkid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksForAttachedByAttachedTo", before);
        }
    }

    public static Collection<XLinkForAttachedXLink> getXLinksForAttachedByAttachedToTitleCreated(Database db, Long xlinkid, String title, Date created) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLinkForAttachedXLink.class, "this.attachedXLink.id == xlid && this.xlink.contentTitle.equals(title) && this.xlink.date == created");
            q.declareParameters("java.lang.Long xlid, java.lang.String title, java.util.Date created");
            ArrayList<XLinkForAttachedXLink> arrayList = new ArrayList<XLinkForAttachedXLink>((Collection)q.execute((Object)xlinkid, (Object)title, (Object)created));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksForAttachedByAttachedToTitleCreated", before);
        }
    }

    public static Collection<XLink> getXLinksByAssignedTo(Database db, Long memberid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLink.class, "this.assignedTo.id == memberid");
            q.declareParameters("java.lang.Long memberid");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)memberid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByAssignedTo", before);
        }
    }

    public static Collection<String> getUniqueReleaseTitlesByGroup(Database db, Group group) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)"SELECT DISTINCT X.ContentTitle FROM XLINK X   INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = X.XLinkID  WHERE GF.GroupID = :groupid AND (X.ContentRole = 'Documentation-Version' OR X.ContentRole = 'Documentation-Release')  ORDER BY X.ContentTitle");
            ArrayList<String> arrayList = new ArrayList<String>((Collection)q.executeWithMap(Collections.singletonMap("groupid", group.getId())));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getUniqueReleaseTitlesByGroup", before);
        }
    }

    public static Collection<XLink> getReleaseXLinksByDateAllGroups(Database db, URI uri, Date date) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (uri == null) {
                ArrayList<XLink> arrayList = new ArrayList<XLink>();
                return arrayList;
            }
            Iterator<Locator> loci = uri.getLocators(Predicates.predicateLocatorFragment(db, "default"));
            if (!loci.hasNext()) {
                ArrayList<XLink> arrayList = new ArrayList<XLink>();
                return arrayList;
            }
            q = db.getPersistenceManager().newQuery(LocatorForXLink.class, "this.locator.id == locid && this.xlink.contentRole == 'Documentation-Version' && this.xlink.date == date");
            q.declareImports("import java.lang.Long; import java.util.Date");
            q.declareParameters("java.lang.Long locid, java.util.Date date");
            q.setResult("DISTINCT this.xlink");
            q.setOrdering("this.xlink.id ascending");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)loci.next().getId(), (Object)date));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getReleaseXLinksByDateAllGroups", before);
        }
    }

    public static Iterator<XLink> getXLinksByDraftGroupLocatorMember(Database db, Long groupid, Long locid, Long memberid, boolean memberEquals) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q1 = null;
        Query q0 = null;
        try {
            HashMap<String, Long> params0 = new HashMap<String, Long>();
            params0.put("groupid", groupid);
            params0.put("locid", locid);
            String clause0 = "this.locator.id == locid && (this.xlink.status == null || this.xlink.status != 'Documentation-Draft') && this.xlink.accepted && this.xlink.contentRole.startsWith(\"Documentation\") && this.xlink.groupsForXLink.contains(gfx) && gfx.group.id == groupid";
            q0 = db.getPersistenceManager().newQuery(LocatorForXLink.class, clause0);
            q0.declareImports("import java.lang.Long; import com.pageseeder.db.model.GroupForXLink");
            q0.declareParameters("java.lang.Long locid, java.lang.Long groupid");
            q0.declareVariables("com.pageseeder.db.model.GroupForXLink gfx");
            q0.setResult("MAX(this.xlink.id)");
            Long lastedit = (Long)q0.executeWithMap(params0);
            HashMap<String, Long> params1 = new HashMap<String, Long>();
            params1.put("groupid", groupid);
            params1.put("locid", locid);
            params1.put("lastid", lastedit == null ? Long.valueOf(-1L) : lastedit);
            Object clause1 = "this.locator.id == locid && this.xlink.status == 'Documentation-Draft' && this.xlink.contentRole.startsWith(\"Documentation\") && (this.xlink.id > lastid) && this.xlink.groupsForXLink.contains(gfx2) && gfx2.group.id == groupid";
            Object paramString1 = "java.lang.Long locid, java.lang.Long groupid, long lastid";
            if (memberid != null) {
                clause1 = (String)clause1 + (memberEquals ? "&& this.xlink.member.id == thememid" : "&& this.xlink.member.id != thememid");
                params1.put("thememid", memberid);
                paramString1 = (String)paramString1 + ", java.lang.Long thememid";
            }
            q1 = db.getPersistenceManager().newQuery(LocatorForXLink.class, (String)clause1);
            q1.declareImports("import java.lang.Long; import com.pageseeder.db.model.GroupForXLink");
            q1.declareParameters((String)paramString1);
            q1.declareVariables("com.pageseeder.db.model.GroupForXLink gfx2");
            q1.setResult("this.xlink");
            Iterator<XLink> iterator = new ArrayList((Collection)q1.executeWithMap(params1)).iterator();
            return iterator;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q1 != null) {
                q1.closeAll();
            }
            q1 = null;
            if (q0 != null) {
                q0.closeAll();
            }
            q0 = null;
            DatabaseQuery.profiling("getXLinksByDraftGroupLocatorMember", before);
        }
    }

    public static List<XLink> getXLinksByDraftEditMember(Database db, int page, int pagesize, Long memberid, boolean oneMore) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(XLink.class, "this.member.id == memberid && this.status == 'Documentation-Draft' && this.contentRole.startsWith(\"Documentation\")");
            q.declareParameters("java.lang.Long memberid");
            q.setOrdering("this.id descending");
            DatabaseQuery.setPaging(q, page, pagesize, oneMore);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)memberid));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByDraftEditMember", before);
        }
    }

    public static Collection<Discussion> getDiscussionsByGroups(Database db, Collection<String> groupnames, Group group, int page, int pagesize, Date createdafter, boolean archived) throws QueryFailedException {
        String unique;
        if (group == null && (groupnames == null || groupnames.isEmpty())) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder gs = new StringBuilder();
        if (group != null) {
            gs.append("GF.GroupID = ").append(group.getId());
            groupnames = Collections.singleton(group.getName());
        } else {
            Iterator<String> gnames = groupnames.iterator();
            while (gnames.hasNext()) {
                String gname = gnames.next();
                unique = DatabaseQuery.unique("groupname", gname);
                params.put(unique, gname);
                gs.append("G.GROUPNAME = :").append(unique);
                if (!gnames.hasNext()) continue;
                gs.append(" OR ");
            }
        }
        String type = DatabaseQuery.getDatabaseType();
        StringBuilder qs = new StringBuilder("SELECT DISTINCT Root.XLinkID AS ThreadID,    Latest.XLinkID, Latest.CreationDate FROM XLINK Root  INNER JOIN XLINK Latest ON Root.ThreadEndXLinkID = Latest.XLinkID  INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = Latest.XLinkID" + (group != null ? "" : "  INNER JOIN DGROUP G on G.GroupID = GF.GroupID") + " WHERE (" + gs.toString() + ") AND Root.ThreadEndXLinkID IS NOT NULL AND (Latest.ContentRole = 'Comment' OR Latest.ContentRole = 'File Attachment'" + (archived ? " OR Latest.ContentRole = 'archive-Comment' OR Latest.ContentRole = 'archive-File Attachment'" : "") + ") AND Latest.Accepted='1'");
        if (createdafter != null) {
            unique = DatabaseQuery.unique("createdafter", createdafter.toString());
            qs.append(" AND Latest.CreationDate > :").append(unique);
            params.put(unique, new Timestamp(createdafter.getTime()));
        }
        qs.append(" ORDER BY Latest.XLinkID DESC");
        DatabaseQuery.setPaging(qs, page, pagesize);
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            ArrayList<Discussion> discussions = new ArrayList<Discussion>();
            Collection results = (Collection)q.executeWithMap(params);
            for (Object[] result : results) {
                Discussion disc = new Discussion(DatabaseQuery.getLong(result[0]), null, DatabaseQuery.getLong(result[1]), DatabaseQuery.getDate(result[2]), groupnames);
                discussions.add(disc);
            }
            ArrayList<Discussion> arrayList = discussions;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getDiscussionsByGroup", before);
        }
    }

    public static long getGroupForURICount(Database db, Long uriid) throws QueryFailedException {
        String sql = "SELECT count(*) FROM DGROUP_FOR_URI WHERE URIID = " + uriid.toString();
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql);
            List results = (List)q.execute();
            Object result = results.iterator().next();
            long l = DatabaseQuery.getLong(result);
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupForURICount", before);
        }
    }

    public static Date getCommentLastmodifiedDate(Database db, Long groupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String dbtype = DatabaseQuery.getDatabaseType();
            String sql = " FROM XLINK AS XL INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID WHERE GF.GroupID = " + groupid.toString() + " AND (XL.ContentRole = 'Comment' or XL.ContentRole = 'File Attachment') AND XL.Accepted='1'";
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)("SELECT MAX(XL.CreationDate)" + sql));
            List results = (List)q.execute();
            Object result = results.iterator().next();
            Date created = DatabaseQuery.getDate(result);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)("SELECT MAX(XL.ModifiedDate)" + sql));
            results = (List)q.execute();
            result = results.iterator().next();
            Date modified = DatabaseQuery.getDate(result);
            if (created != null && (modified == null || created.after(modified))) {
                Date date = created;
                return date;
            }
            Date date = modified;
            return date;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getCommentLastmodifiedDate", before);
        }
    }

    public static int getReplyCount(Database db, Long discussionid, Collection<String> groups) throws QueryFailedException {
        if (groups == null || groups.isEmpty()) {
            throw new QueryFailedException("Groups must not be null or empty.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder gs = new StringBuilder();
        Iterator<String> gnames = groups.iterator();
        while (gnames.hasNext()) {
            String gname = gnames.next();
            String unique = DatabaseQuery.unique("groupname", gname);
            params.put(unique, gname);
            gs.append("G.GROUPNAME = :").append(unique);
            if (!gnames.hasNext()) continue;
            gs.append(" OR ");
        }
        String type = DatabaseQuery.getDatabaseType();
        String sql = "SELECT count(DISTINCT Reply.XLinkID) FROM XLINK Reply  INNER JOIN XLINK_FOR_XLINK XFX ON XFX.ReplyID = Reply.XLinkID  INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XFX.ReplyID  INNER JOIN DGROUP G on G.GroupID = GF.GroupID  WHERE (" + gs.toString() + "  ) AND XFX.ReplyToID = " + discussionid.toString() + "    AND XFX.ReplyID != " + discussionid.toString() + "    AND (Reply.ContentRole = 'Comment' OR Reply.ContentRole = 'File Attachment' OR         Reply.ContentRole = 'Documentation-Release' OR Reply.ContentRole = 'Workflow')    AND Accepted='1'";
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql);
            List results = (List)q.executeWithMap(params);
            Object result = results.iterator().next();
            int n = result instanceof Integer ? ((Integer)result).intValue() : ((Long)result).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getReplyCount", before);
        }
    }

    public static @Nullable Discussion getDiscussionByGroups(Database db, Long discussionid, Collection<Group> groups) throws QueryFailedException {
        XLink xl = DatabaseQuery.getXLinkById(db, discussionid);
        if (xl == null || !XLinks.isComment(xl)) {
            return null;
        }
        XLink root = XLinks.getThreadRoot(xl);
        if (root == null) {
            return null;
        }
        return new Discussion(root, Groups.getGroupNames(groups));
    }

    public static Collection<XLink> getCommentsByGroupId(Database db, Long groupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String clause = "this.group.id == gid && this.xlink.accepted && (this.xlink.contentRole == 'Comment' || this.xlink.contentRole == 'File Attachment')";
            String paramsDeclaration = "java.lang.Long gid";
            String importDeclaration = "import java.lang.Long";
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("gid", groupid);
            q = db.getPersistenceManager().newQuery(GroupForXLink.class, clause);
            q.setFilter(clause);
            q.declareImports(importDeclaration);
            q.declareParameters(paramsDeclaration);
            q.setResult("this.xlink");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getCommentsByGroupId", before);
        }
    }

    public static Collection<XLink> getCommentsByGroupIdDateAfter(Database db, Long groupid, Date date) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object clause = "this.group.id == gid && this.xlink.accepted && (this.xlink.contentRole == 'Comment' || this.xlink.contentRole == 'File Attachment')";
            Object paramsDeclaration = "java.lang.Long gid";
            Object importDeclaration = "import java.lang.Long";
            HashMap<String, Comparable<Long>> params = new HashMap<String, Comparable<Long>>();
            params.put("gid", groupid);
            q = db.getPersistenceManager().newQuery(GroupForXLink.class, (String)clause);
            if (date != null) {
                clause = (String)clause + " && this.xlink.date > thedate";
                importDeclaration = (String)importDeclaration + "; import java.util.Date";
                paramsDeclaration = (String)paramsDeclaration + ", java.util.Date thedate";
                params.put("thedate", new Timestamp(date.getTime()));
            }
            q.setFilter((String)clause);
            q.declareImports((String)importDeclaration);
            q.declareParameters((String)paramsDeclaration);
            q.setResult("this.xlink");
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getCommentsByGroupIdDateAfter", before);
        }
    }

    public static List<XLink> getXLinksByURIGroupEditsFragment(Database db, URI uri, Group group, String fragment, boolean ascending) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder qs = new StringBuilder("SELECT DISTINCT X.XLinkID AS XLinkID FROM XLINK X");
            qs.append(" LEFT OUTER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = X.XLinkID");
            qs.append("  INNER JOIN DGROUP G on G.GroupID = GF.GroupID");
            qs.append(" LEFT OUTER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = X.XLinkID");
            qs.append("  INNER JOIN LOCATOR LOC         ON LFX.LocatorID = LOC.LocatorID");
            qs.append("  INNER JOIN URI U               ON U.URIID = LOC.URIID");
            qs.append(" WHERE G.GROUPID = ").append(group.getId());
            qs.append("  AND U.URIID = ").append(uri.getId());
            qs.append("  AND (X.ContentRole = 'Documentation' OR X.ContentRole = 'Documentation-Hidden'");
            qs.append("    OR X.ContentRole = 'Documentation-Original')");
            qs.append("  AND LOC.Fragment = :thefragment");
            qs.append(" ORDER BY XLINKID " + (ascending ? "ASC" : "DESC"));
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(Collections.singletonMap("thefragment", fragment)));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByURIGroupEditsFragment", before);
        }
    }

    public static List<Long> getXLinkIDsByURIGroupEditsFragment(Database db, URI uri, Group group, String fragment) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder qs = new StringBuilder("SELECT DISTINCT X.XLinkID FROM XLINK X");
            qs.append(" LEFT OUTER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = X.XLinkID");
            qs.append("  INNER JOIN DGROUP G on G.GroupID = GF.GroupID");
            qs.append(" LEFT OUTER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = X.XLinkID");
            qs.append("  INNER JOIN LOCATOR LOC         ON LFX.LocatorID = LOC.LocatorID");
            qs.append("  INNER JOIN URI U               ON U.URIID = LOC.URIID");
            qs.append(" WHERE G.GROUPID = ").append(group.getId());
            qs.append("  AND U.URIID = ").append(uri.getId());
            qs.append("  AND (X.ContentRole = 'Documentation' OR X.ContentRole = 'Documentation-Hidden'");
            qs.append("    OR X.ContentRole = 'Documentation-Original')");
            qs.append("  AND LOC.Fragment = :thefragment");
            qs.append(" ORDER BY XLINKID ASC");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            List<Long> list = ((Collection)q.executeWithMap(Collections.singletonMap("thefragment", fragment))).stream().map(DatabaseQuery::getLong).collect(Collectors.toList());
            return list;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinkIDsByURIGroupEditsFragment", before);
        }
    }

    public static List<XLink> getXLinksURIStructure(Database db, URI uri, Group group) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder qs = new StringBuilder("SELECT DISTINCT X.XLinkID AS XLinkID FROM XLINK X");
            qs.append(" LEFT OUTER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = X.XLinkID");
            qs.append("  INNER JOIN DGROUP G on G.GroupID = GF.GroupID");
            qs.append(" LEFT OUTER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = X.XLinkID");
            qs.append("  INNER JOIN LOCATOR LOC         ON LFX.LocatorID = LOC.LocatorID");
            qs.append("  INNER JOIN URI U               ON U.URIID = LOC.URIID");
            qs.append(" WHERE G.GROUPID = ").append(group.getId());
            qs.append("  AND U.URIID = ").append(uri.getId());
            qs.append("  AND X.ContentRole = 'Documentation-Structure'");
            qs.append("  AND LOC.Fragment = 'default'");
            qs.append(" ORDER BY XLinkID ASC");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksURIStructure", before);
        }
    }

    public static @Nullable XLink getXLinkByURIGroupLastEditFragmentDraftCreationBeforeStatusChangedAfter(Database db, URI uri, Group group, String fragment, boolean includeOriginal, boolean includeAnyDraft, boolean includeArchive, @Nullable Long draftMemberId, @Nullable Date creationBefore, @Nullable Date statusChangedAfter) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query query = null;
        StringBuilder clause = new StringBuilder("SELECT MAX(XL.XLinkID) FROM XLINK AS XL");
        try {
            Collection results;
            HashMap<String, Object> params = new HashMap<String, Object>();
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID");
            clause.append("  WHERE L.URIID = " + uri.getId());
            clause.append("  AND GF.GroupID = " + group.getId());
            clause.append("  AND (XL.ContentRole = 'Documentation'");
            if (includeOriginal) {
                clause.append("  OR XL.ContentRole = 'Documentation-Original'");
            }
            if (includeArchive) {
                clause.append("  OR XL.ContentRole = 'Documentation-Hidden'");
            }
            clause.append("  OR XL.ContentRole = 'Documentation-Deleted')");
            if (!includeAnyDraft) {
                clause.append(" AND ((XL.Status IS NULL OR XL.Status != 'Documentation-Draft')");
                if (draftMemberId != null) {
                    clause.append(" OR XL.MemberID = " + draftMemberId);
                }
                clause.append(')');
            }
            if (fragment != null) {
                params.put("thefrag", fragment);
                clause.append(" AND L.Fragment = :thefrag");
            }
            if (creationBefore != null) {
                clause.append(" AND (XL.CreationDate <= :creationBeforeDate");
                if (includeOriginal) {
                    clause.append(" OR XL.ContentRole = 'Documentation-Original')");
                } else {
                    clause.append(")");
                }
                params.put("creationBeforeDate", new Timestamp(creationBefore.getTime()));
            }
            if (statusChangedAfter != null) {
                clause.append(" AND (XL.StatusChangedDate IS NULL OR XL.StatusChangedDate >= :statusChangedAfterDate)");
                params.put("statusChangedAfterDate", new Timestamp(statusChangedAfter.getTime()));
            }
            Object id = (results = (Collection)(query = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString())).executeWithMap(params)).isEmpty() ? null : results.iterator().next();
            XLink xLink = id == null ? null : DatabaseQuery.getXLinkById(db, DatabaseQuery.getLong(id));
            return xLink;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (query != null) {
                query.closeAll();
            }
            query = null;
            DatabaseQuery.profiling("getXLinksByURIGroupLastEditFragmentDraftCreationBeforeStatusChangedAfter", clause.toString(), before);
        }
    }

    public static @Nullable XLink getXLinkURIStructure(Database db, URI uri, Group group, Date creationBefore) throws QueryFailedException {
        return DatabaseQuery.getXLinkURIStructure(db, uri, group, creationBefore, false);
    }

    public static @Nullable XLink getXLinkURIStructure(Database db, URI uri, Group group, Date creationBefore, boolean includeNew) throws QueryFailedException {
        return DatabaseQuery.getXLinkURIStructure(db, uri, group, creationBefore, -1L, includeNew);
    }

    public static @Nullable XLink getXLinkURIStructure(Database db, URI uri, Group group, Date creationBefore, long idBefore, boolean includeNew) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT MAX(XL.XLINKID) from XLINK XL");
            sql.append("  INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            sql.append("  INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            sql.append("  INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID");
            sql.append("  INNER JOIN URI U ON U.URIID = L.URIID");
            sql.append("  WHERE XL.ContentRole = 'Documentation-Structure'");
            sql.append("  AND L.Fragment = 'default'");
            sql.append("  AND U.URIID = ").append(uri.getId());
            sql.append("  AND GF.GroupID = ").append(group.getId());
            if (!includeNew) {
                sql.append("  AND (XL.Status IS NULL OR XL.Status != 'Documentation-New')");
            }
            HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
            if (creationBefore != null) {
                sql.append(" AND XL.CreationDate <= :before");
                params.put("before", new Timestamp(creationBefore.getTime()));
            } else if (idBefore > 0L) {
                sql.append(" AND XL.XLINKID <= :beforeid");
                params.put("beforeid", Long.valueOf(idBefore));
            } else {
                sql.append(" AND (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            Collection results = (Collection)q.executeWithMap(params);
            if (results == null || results.isEmpty()) {
                XLink xLink = null;
                return xLink;
            }
            Object id = results.iterator().next();
            if (id == null) {
                XLink xLink = null;
                return xLink;
            }
            XLink xLink = DatabaseQuery.getXLinkById(db, DatabaseQuery.getLong(id));
            return xLink;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinkURIStructure", before);
        }
    }

    public static @Nullable XLink getXLinkURIStructureNew(Database db, URI uri, Group group) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String sql = "SELECT MAX(XL.XLINKID) from XLINK XL  INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID  INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID  INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID  INNER JOIN URI U ON U.URIID = L.URIID  WHERE XL.ContentRole = 'Documentation-Structure'  AND XL.Status = 'Documentation-New'  AND L.Fragment = 'default'  AND U.URIID = " + uri.getId() + "  AND GF.GroupID = " + group.getId();
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql);
            Collection results = (Collection)q.execute();
            if (results == null || results.isEmpty()) {
                XLink xLink = null;
                return xLink;
            }
            Object id = results.iterator().next();
            if (id == null) {
                XLink xLink = null;
                return xLink;
            }
            XLink xLink = DatabaseQuery.getXLinkById(db, DatabaseQuery.getLong(id));
            return xLink;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinkURIStructure", before);
        }
    }

    public static @Nullable XLink getXLinkPreviousURIStructure(Database db, URI uri, Group group) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT MAX(XL.XLinkID) from XLINK XL");
            sql.append("  INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            sql.append("  INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            sql.append("  INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID");
            sql.append("  INNER JOIN URI U ON U.URIID = L.URIID");
            sql.append("  WHERE XL.ContentRole = 'Documentation-Structure'");
            sql.append("  AND L.Fragment = 'default'");
            sql.append("  AND U.URIID = ").append(uri.getId());
            sql.append("  AND GF.GroupID = ").append(group.getId());
            sql.append("  AND XL.Status = 'Documentation-Old'");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            Collection results = (Collection)q.execute();
            if (results == null || results.isEmpty()) {
                XLink xLink = null;
                return xLink;
            }
            Long id = DatabaseQuery.getLong(results.iterator().next());
            XLink xLink = DatabaseQuery.getXLinkById(db, id);
            return xLink;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinkPreviousURIStructure", before);
        }
    }

    public static Map<String, List<XLink>> getXLinksByURIGroupNotesCreationBeforeAfter(Database db, URI uri, Long groupid, @Nullable Date creationFrom, @Nullable Date creationTo) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT L.Fragment, X.XLinkID FROM XLINK X");
            sql.append(" INNER JOIN XLINK_FOR_XLINK   XX ON  X.XLinkID    = XX.ReplyID");
            sql.append(" INNER JOIN XLINK             EX ON XX.ReplyToID  = EX.XLinkID");
            sql.append(" INNER JOIN DGROUP_FOR_XLINK  GX ON  X.XLinkID    = GX.XLinkID");
            sql.append(" INNER JOIN LOCATOR_FOR_XLINK LX ON XX.ReplyToID  = LX.XLinkID");
            sql.append(" INNER JOIN LOCATOR            L ON LX.LocatorID  =  L.LocatorID");
            sql.append(" INNER JOIN URI                U ON  L.URIID      =  U.URIID");
            sql.append(" WHERE GX.GroupID = ").append(groupid);
            sql.append("   AND  U.URIID = ").append(uri.getId());
            sql.append("   AND  X.ContentRole = 'Documentation-Note'");
            HashMap<String, Timestamp> params = new HashMap<String, Timestamp>();
            if (creationFrom != null) {
                sql.append(" AND EX.CreationDate >= :creationFrom");
                params.put("creationFrom", new Timestamp(creationFrom.getTime()));
            }
            if (creationTo != null) {
                sql.append(" AND EX.CreationDate <= :creationTo");
                params.put("creationTo", new Timestamp(creationTo.getTime()));
            }
            sql.append(" ORDER BY X.XLinkID ASC");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            Collection result = (Collection)q.executeWithMap(params);
            HashMap<String, ArrayList<XLink>> notes = new HashMap<String, ArrayList<XLink>>();
            for (Object[] row : result) {
                String frag = (String)row[0];
                ArrayList<XLink> alreadyThere = (ArrayList<XLink>)notes.get(frag);
                if (alreadyThere == null) {
                    alreadyThere = new ArrayList<XLink>();
                    notes.put(frag, alreadyThere);
                }
                alreadyThere.add(DatabaseQuery.getXLinkById(db, DatabaseQuery.getLong(row[1])));
            }
            HashMap<String, ArrayList<XLink>> hashMap = notes;
            return hashMap;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByURIGroupNotesCreationBeforeAfter", before);
        }
    }

    public static Map<String, Collection<Long>> getXLinksByURIGroupOutgoingXRefsFragmentCreationBeforeStatusChangedAfter(Database db, URI uri, Group group, Date creationBefore, Date statusChangedAfter) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder clause = new StringBuilder("SELECT XL.XLinkID AS XLinkID, L.Fragment FROM XLINK AS XL");
        try {
            HashMap<String, Timestamp> params = new HashMap<String, Timestamp>();
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID");
            clause.append("  WHERE L.URIID = " + uri.getId());
            clause.append("  AND GF.GroupID = " + group.getId());
            clause.append("  AND XL.ContentRole LIKE 'XRef%'");
            clause.append(" AND LFX.Role NOT LIKE 'xref-link%'");
            if (creationBefore != null) {
                clause.append(" AND XL.CreationDate <= :creationBefore");
                params.put("creationBefore", new Timestamp(creationBefore.getTime()));
            }
            if (statusChangedAfter != null) {
                clause.append(" AND (XL.StatusChangedDate IS NULL OR XL.StatusChangedDate >= :statusChangedAfter)");
                params.put("statusChangedAfter", new Timestamp(statusChangedAfter.getTime()));
            }
            if (creationBefore == null && statusChangedAfter == null) {
                clause.append(" AND XL.Status IS NULL");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            Collection results = (Collection)q.executeWithMap(params);
            HashMap<String, ArrayList<Long>> reverseXrefs = new HashMap<String, ArrayList<Long>>();
            for (Object[] result : results) {
                String frag = (String)result[1];
                ArrayList<Long> ids = (ArrayList<Long>)reverseXrefs.get(frag);
                if (ids == null) {
                    ids = new ArrayList<Long>();
                    reverseXrefs.put(frag, ids);
                }
                ids.add(DatabaseQuery.getLong(result[0]));
            }
            HashMap<String, ArrayList<Long>> hashMap = reverseXrefs;
            return hashMap;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByURIGroupOutgoingXRefsFragmentCreationBeforeStatusChangedAfter", clause.toString(), before);
        }
    }

    public static int getAttachedToCountByURI(Database db, URI uri) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder clause = new StringBuilder("SELECT COUNT(DISTINCT XL.XLinkID) FROM XLINK AS XL");
        try {
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID");
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN DGROUP G on G.GroupID = GF.GroupID");
            clause.append("  WHERE L.URIID = " + uri.getId());
            clause.append("  AND LFX.Role IS NOT NULL");
            clause.append("  AND (XL.ContentRole = 'Comment' OR XL.ContentRole = 'File Attachment')");
            clause.append("  AND XL.Accepted  = '1'");
            clause.append("  AND G.GroupName  != 'admin' AND G.GroupName NOT LIKE 'archive-%'");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            Collection results = (Collection)q.execute();
            int n = ((Long)results.toArray()[0]).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getAttachedToCountByURI", clause.toString(), before);
        }
    }

    public static int getDiscussionCountByURI(Database db, URI uri) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder clause = new StringBuilder("SELECT COUNT(DISTINCT XL.XLinkID) FROM XLINK AS XL");
        try {
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID");
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN DGROUP G on G.GroupID = GF.GroupID");
            clause.append("  WHERE L.URIID = " + uri.getId());
            clause.append("  AND LFX.Role IS NULL");
            clause.append("  AND (XL.ContentRole = 'Comment' OR XL.ContentRole = 'File Attachment')");
            clause.append("  AND XL.Accepted  = '1'");
            clause.append("  AND G.GroupName  != 'admin' AND G.GroupName NOT LIKE 'archive-%'");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            Collection results = (Collection)q.execute();
            int n = ((Long)results.toArray()[0]).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getDiscussionCountByURI", clause.toString(), before);
        }
    }

    public static List<LocatorForXLink> getLocatorForXLinksByURIDiscussion(Database db, URI uri) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder clause = new StringBuilder("SELECT DISTINCT LFX.LocatorForXLinkID FROM XLINK AS XL");
        try {
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID");
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN DGROUP G on G.GroupID = GF.GroupID");
            clause.append("  WHERE L.URIID = " + uri.getId());
            clause.append("  AND (XL.ContentRole = 'Comment' OR XL.ContentRole = 'File Attachment')");
            clause.append("  AND XL.Accepted  = '1'");
            clause.append("  AND G.GroupName  != 'admin' AND G.GroupName NOT LIKE 'archive-%'");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(LocatorForXLink.class);
            ArrayList<LocatorForXLink> arrayList = new ArrayList<LocatorForXLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getLocatorForXLinksByURIDiscussion", clause.toString(), before);
        }
    }

    public static Map<String, List<Discussion>> getDiscussionsFragmentsByURIGroups(Database db, URI uri, Collection<String> groups, @Nullable String fragment, boolean attachedto, int maxresults) throws QueryFailedException {
        if (groups.isEmpty()) {
            return new LinkedHashMap<String, List<Discussion>>();
        }
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder clause = new StringBuilder("SELECT DISTINCT XL.XLinkID AS XLinkID, L.Fragment FRAG, LFX.Role FROM XLINK AS XL");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            StringBuilder gs = new StringBuilder("G.Flags LIKE '%p%' OR ");
            Iterator<String> gnames = groups.iterator();
            while (gnames.hasNext()) {
                String gname = gnames.next();
                String unique = DatabaseQuery.unique("groupname", gname);
                params.put(unique, gname);
                gs.append("G.GROUPNAME = :").append(unique);
                if (!gnames.hasNext()) continue;
                gs.append(" OR ");
            }
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN DGROUP G on G.GroupID = GF.GroupID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID");
            clause.append("  WHERE L.URIID = " + uri.getId());
            if (fragment != null) {
                params.put("fragment", fragment);
                params.put("discfragment", fragment + "//Discussion");
                clause.append("  AND (L.Fragment = :fragment OR L.Fragment = :discfragment)");
            }
            clause.append("  AND (" + gs.toString() + ")");
            clause.append("  AND XL.Accepted  = '1'");
            clause.append("  AND (XL.ContentRole = 'Comment' OR XL.ContentRole = 'File Attachment'");
            clause.append("    OR XL.ContentRole = 'archive-Comment' OR XL.ContentRole = 'archive-File Attachment')");
            if (!attachedto) {
                clause.append(" AND LFX.Role IS NULL");
            }
            clause.append(" ORDER BY FRAG, XLINKID");
            String dbtype = DatabaseQuery.getDatabaseType();
            maxresults = DatabaseQuery.getMaxPageSize(maxresults);
            if ("mysql".equalsIgnoreCase(dbtype)) {
                clause.append(" LIMIT " + maxresults);
            } else {
                clause.append(" FETCH FIRST " + maxresults + " ROWS ONLY");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            Collection results = (Collection)q.executeWithMap(params);
            LinkedHashMap discussions = new LinkedHashMap();
            for (Object[] result : results) {
                String frag = (String)result[1];
                ArrayList<Discussion> ids = (ArrayList<Discussion>)discussions.get(frag);
                if (ids == null) {
                    ids = new ArrayList<Discussion>();
                    discussions.put(frag, ids);
                }
                Discussion d = new Discussion(DatabaseQuery.getLong(result[0]), groups);
                d.setAttached(result[2] != null);
                ids.add(d);
            }
            LinkedHashMap linkedHashMap = discussions;
            return linkedHashMap;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getDiscussionsFragmentsByURIGroups", clause.toString(), before);
        }
    }

    public static Map<String, List<Long>> getEditIDsFragmentsByURIGroup(Database db, URI uri, String groupname, @Nullable String fragment, int maxresults) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder clause = new StringBuilder("SELECT DISTINCT XL.XLinkID AS XLinkID, L.Fragment FRAG FROM XLINK AS XL");
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("groupname", groupname);
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN DGROUP G on G.GroupID = GF.GroupID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON L.LocatorID = LFX.LocatorID");
            clause.append("  WHERE L.URIID = ").append(uri.getId());
            if (fragment != null) {
                params.put("fragment", fragment);
                clause.append("  AND (L.Fragment = :fragment OR L.Fragment = :discfragment)");
            }
            clause.append("  AND G.GROUPNAME = :groupname");
            clause.append("  AND XL.Accepted  = '1'");
            clause.append("  AND XL.ContentRole LIKE 'Documentation%'");
            clause.append("  AND XL.ContentRole != 'Documentation-Version'");
            clause.append("  AND XL.ContentRole != 'Documentation-Release'");
            clause.append("  AND XL.ContentRole != 'Documentation-Structure'");
            clause.append("  AND XL.ContentRole != 'Documentation-Note'");
            clause.append(" ORDER BY FRAG, XLINKID");
            String dbtype = DatabaseQuery.getDatabaseType();
            maxresults = DatabaseQuery.getMaxPageSize(maxresults);
            if ("mysql".equalsIgnoreCase(dbtype)) {
                clause.append(" LIMIT ").append(maxresults);
            } else {
                clause.append(" FETCH FIRST ").append(maxresults).append(" ROWS ONLY");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            Collection results = (Collection)q.executeWithMap(params);
            LinkedHashMap<String, List> edits = new LinkedHashMap<String, List>();
            for (Object[] result : results) {
                String frag = (String)result[1];
                List ids = edits.computeIfAbsent(frag, s -> new ArrayList());
                ids.add(DatabaseQuery.getLong(result[0]));
            }
            LinkedHashMap<String, List> linkedHashMap = edits;
            return linkedHashMap;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getEditIDsFragmentsByURIGroup", clause.toString(), before);
        }
    }

    public static @Nullable ReverseXRefs getXLinksByURIGroupReverseXRefsCreationBeforeStatusChangedAfter(Database db, URI uri, Group group, Date creationBefore, Date statusChangedAfter, int page, int pagesize) throws QueryFailedException {
        long before = System.currentTimeMillis();
        boolean external = uri.getExternal();
        StringBuilder clause = new StringBuilder("SELECT DISTINCT XL.XLinkID AS XLinkID, L.Fragment FROM XLINK AS XL");
        Query q = null;
        try {
            HashMap<String, Timestamp> params = new HashMap<String, Timestamp>();
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            clause.append("    INNER JOIN URI U2 ON L2.URIID = U2.URIID");
            clause.append("    INNER JOIN HOST H2 ON U2.HostID = H2.HostID");
            if (external) {
                clause.append("    INNER JOIN URI_FOR_DGROUPURI UFGU ON L2.URIID = UFGU.URIID");
                clause.append("    INNER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
            }
            clause.append("  WHERE L.URIID = " + uri.getId());
            if (external) {
                Group pgroup = DatabaseQuery.getGroupByName(db, "public");
                clause.append("  AND (GF.GroupID = " + pgroup.getId());
                clause.append("  OR GUFG.GroupID = " + group.getId() + ")");
            } else {
                clause.append("  AND GF.GroupID = " + group.getId());
            }
            clause.append("  AND XL.ContentRole LIKE 'XRef%'");
            clause.append("  AND LFX.Role = 'xref-link'");
            clause.append("  AND LFX2.Role = 'xref-source-manual-link'");
            clause.append("  AND (U2.Path NOT LIKE '" + GlobalSettings.getSitePrefix() + "/archive/%'");
            clause.append("    OR H2.ExternalFlag = '1')");
            if (creationBefore != null) {
                clause.append(" AND XL.CreationDate <= :creationBefore");
                params.put("creationBefore", new Timestamp(creationBefore.getTime()));
            }
            if (statusChangedAfter != null) {
                clause.append(" AND (XL.StatusChangedDate IS NULL OR XL.StatusChangedDate >= :statusChangedAfter)");
                params.put("statusChangedAfter", new Timestamp(statusChangedAfter.getTime()));
            }
            if (creationBefore == null && statusChangedAfter == null) {
                clause.append("  AND (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            }
            DatabaseQuery.setPaging(clause, page, pagesize);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            Collection results = (Collection)q.executeWithMap(params);
            ReverseXRefs xrefs = new ReverseXRefs(results.size());
            for (Object[] result : results) {
                xrefs.addReverseXRef((String)result[1], DatabaseQuery.getLong(result[0]));
            }
            ReverseXRefs reverseXRefs = xrefs;
            return reverseXRefs;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByURIGroupReverseXRefsCreationBeforeStatusChangedAfter", clause.toString(), before);
        }
    }

    public static Collection<XLink> getReverseXRefsByURIFragmentGroup(Database db, URI uri, String fragment, Group group) throws QueryFailedException {
        long before = System.currentTimeMillis();
        boolean external = uri.getExternal();
        StringBuilder clause = new StringBuilder("SELECT DISTINCT XL.XLinkID AS XLinkID FROM XLINK AS XL");
        Query q = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            clause.append("    INNER JOIN URI U2 ON L2.URIID = U2.URIID");
            clause.append("    INNER JOIN HOST H2 ON U2.HostID = H2.HostID");
            if (external) {
                clause.append("    INNER JOIN URI_FOR_DGROUPURI UFGU ON L2.URIID = UFGU.URIID");
                clause.append("    INNER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
            }
            clause.append("  WHERE L.URIID = " + uri.getId());
            clause.append("  AND L.Fragment = :fragment");
            params.put("fragment", fragment);
            if (external) {
                Group pgroup = DatabaseQuery.getGroupByName(db, "public");
                clause.append("  AND (GF.GroupID = " + pgroup.getId());
                clause.append("  OR GUFG.GroupID = " + group.getId() + ")");
            } else {
                clause.append("  AND GF.GroupID = " + group.getId());
            }
            clause.append("  AND XL.ContentRole LIKE 'XRef%'");
            clause.append("  AND LFX.Role = 'xref-link'");
            clause.append("  AND LFX2.Role = 'xref-source-manual-link'");
            clause.append("  AND (U2.Path NOT LIKE '" + GlobalSettings.getSitePrefix() + "/archive/%'");
            clause.append("    OR H2.ExternalFlag = '1')");
            clause.append("  AND (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getReverseXRefsByURIFragmentGroup", clause.toString(), before);
        }
    }

    public static List<XLink> getXLinksByURIGroupXRefsCreationBeforeStatusChangedAfter(Database db, URI uri, Group group, Date creationBefore, Date statusChangedAfter, boolean forward, boolean reverse, int page, int pagesize) throws QueryFailedException {
        if (!forward && !reverse) {
            return new ArrayList<XLink>();
        }
        long before = System.currentTimeMillis();
        StringBuilder clause = new StringBuilder("SELECT DISTINCT XL.XLinkID AS XLinkID FROM XLINK AS XL");
        Query q = null;
        try {
            HashMap<String, Timestamp> params = new HashMap<String, Timestamp>();
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            clause.append("    INNER JOIN URI U2 ON L2.URIID = U2.URIID");
            clause.append("    INNER JOIN HOST H2 ON U2.HostID = H2.HostID");
            clause.append("  WHERE GF.GroupID = " + group.getId());
            clause.append("  AND XL.ContentRole LIKE 'XRef%'");
            clause.append("  AND L.URIID = " + uri.getId());
            clause.append("  AND (");
            if (forward) {
                clause.append("  (LFX.Role != 'xref-link'");
                clause.append("  AND LFX2.Role = 'xref-link')");
            }
            if (reverse) {
                if (forward) {
                    clause.append(" OR");
                }
                clause.append("  (LFX.Role = 'xref-link'");
                clause.append("  AND LFX2.Role = 'xref-source-manual-link'");
                clause.append("  AND (U2.Path NOT LIKE '" + GlobalSettings.getSitePrefix() + "/archive/%'");
                clause.append("    OR H2.ExternalFlag = '1'))");
            }
            clause.append(")");
            if (creationBefore != null) {
                clause.append(" AND XL.CreationDate <= :creationBefore");
                params.put("creationBefore", new Timestamp(creationBefore.getTime()));
            }
            if (statusChangedAfter != null) {
                clause.append(" AND (XL.StatusChangedDate IS NULL OR XL.StatusChangedDate >= :statusChangedAfter)");
                params.put("statusChangedAfter", new Timestamp(statusChangedAfter.getTime()));
            }
            if (creationBefore == null && statusChangedAfter == null) {
                clause.append("  AND (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            }
            clause.append(" ORDER BY XLinkID DESC");
            if (page > 0) {
                DatabaseQuery.setPaging(clause, page, pagesize);
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByURIGroupXRefsCreationBeforeStatusChangedAfter", clause.toString(), before);
        }
    }

    public static List<URI> getURIsByLocatorGroupXRefsCreatedStatusChangedAfter(Database db, Locator loc, Group group, Date xrefdate, boolean forward, boolean reverse, boolean embedtrans, int page, int pagesize) throws QueryFailedException {
        if (!forward && !reverse) {
            return new ArrayList<URI>();
        }
        long before = System.currentTimeMillis();
        StringBuilder clause = new StringBuilder("SELECT DISTINCT(L2.URIID) AS URIID FROM XLINK AS XL");
        Query q = null;
        try {
            HashMap<String, Timestamp> params = new HashMap<String, Timestamp>();
            clause.append("    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            clause.append("  WHERE GF.GroupID = " + group.getId());
            clause.append("  AND XL.ContentRole LIKE 'XRef%'");
            clause.append("  AND LFX.LocatorID = " + loc.getId());
            clause.append("  AND LFX.LocatorForXLinkID != LFX2.LocatorForXLinkID");
            clause.append("  AND (");
            if (forward) {
                clause.append("  (LFX2.Role = 'xref-link'");
                if (embedtrans) {
                    clause.append("  AND (LFX.Label = 'embed' or LFX.Label = 'transclude')");
                }
                clause.append("  AND LFX.Role = 'xref-source-manual-link')");
            }
            if (reverse) {
                if (forward) {
                    clause.append(" OR");
                }
                clause.append("  (LFX.Role = 'xref-link'");
                clause.append("  AND LFX2.Role = 'xref-source-manual-link')");
            }
            clause.append(")");
            if (xrefdate != null) {
                clause.append(" AND (XL.CreationDate > :xrefDate OR XL.StatusChangedDate > :xrefDate)");
                params.put("xrefDate", new Timestamp(xrefdate.getTime()));
            }
            DatabaseQuery.setPaging(clause, page, pagesize);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByLocatorGroupXRefsCreationBeforeStatusChangedAfter", clause.toString(), before);
        }
    }

    public static List<URI> getURIsByURIForwardXRefsCreatedStatusChangedAfter(Database db, Long uriid, Date xrefdate, String forwardtype) throws QueryFailedException {
        long before = System.currentTimeMillis();
        StringBuilder clause = new StringBuilder("SELECT DISTINCT(L2.URIID) AS URIID FROM LOCATOR L");
        Query q = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.LocatorID = L.LocatorID");
            clause.append("    INNER JOIN XLINK XL ON XL.XLinkID = LFX.XLinkID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            clause.append("  WHERE XL.ContentRole LIKE 'XRef%'");
            clause.append("  AND L.URIID = " + uriid);
            clause.append("  AND LFX.LocatorForXLinkID != LFX2.LocatorForXLinkID");
            clause.append("  AND LFX2.Role = 'xref-link'");
            clause.append("  AND LFX.Role = 'xref-source-manual-link'");
            if (forwardtype != null) {
                clause.append("  AND LFX.Label = :forwardType");
                params.put("forwardType", forwardtype);
            }
            if (xrefdate != null) {
                clause.append(" AND (XL.CreationDate > :xrefDate OR XL.StatusChangedDate > :xrefDate)");
                params.put("xrefDate", new Timestamp(xrefdate.getTime()));
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsByURIForwardXRefsCreatedStatusChangedAfter", clause.toString(), before);
        }
    }

    public static List<URI> getURIsByLocatorTranscludedAllGroups(Database db, Locator loc) throws QueryFailedException {
        long before = System.currentTimeMillis();
        StringBuilder clause = new StringBuilder("SELECT DISTINCT(L2.URIID) AS URIID FROM LOCATOR L");
        Query q = null;
        try {
            HashMap params = new HashMap();
            clause.append("    INNER JOIN LOCATOR L3 ON L3.URIID = L.URIID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON (LFX.LocatorID = L.LocatorID OR LFX.LocatorID = L3.LocatorID)");
            clause.append("    INNER JOIN XLINK XL ON LFX.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            clause.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            clause.append("  WHERE XL.ContentRole LIKE 'XRef%'");
            clause.append("  AND L.LocatorID = " + loc.getId());
            clause.append("  AND L3.Fragment = 'default'");
            clause.append("  AND LFX.Role = 'xref-link'");
            clause.append("  AND LFX2.Role != 'xref-link'");
            clause.append("  AND LFX2.Label = 'transclude'");
            clause.append("  AND (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause.toString());
            q.setClass(URI.class);
            ArrayList<URI> arrayList = new ArrayList<URI>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getURIsByLocatorTranscludedAllGroups", clause.toString(), before);
        }
    }

    public static List<XLink> getWorkflowsByGroupId(Database db, Long groupid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String clause = "SELECT DISTINCT Latest.XLinkID FROM XLINK Latest  INNER JOIN XLINK Root ON Root.ThreadEndXLinkID = Latest.XLinkID  INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = Latest.XLinkID WHERE Latest.ContentRole = 'Workflow' AND GF.GroupID = " + groupid;
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)clause);
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getWorkflowsByGroupId", before);
        }
    }

    public static @Nullable XLink getXLinkByContentRoleLocatorLastChange(Database db, String[] crolesEquals, String[] crolesStartsWith, Long locId) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q1 = null;
        Query q2 = null;
        try {
            int i;
            StringBuilder sclause;
            StringBuilder clause = new StringBuilder("this.locator.id == ").append(locId);
            if (crolesEquals != null && crolesEquals.length > 0) {
                sclause = new StringBuilder();
                for (i = 0; i < crolesEquals.length; ++i) {
                    if (i != 0) {
                        sclause.append(" || ");
                    }
                    sclause.append("this.xlink.contentRole == '").append(crolesEquals[i]).append("'");
                }
                if (sclause.length() > 0) {
                    if (clause.length() > 0) {
                        clause.append(" && ");
                    }
                    clause.append('(').append(sclause.toString()).append(')');
                }
            }
            if (crolesStartsWith != null && crolesStartsWith.length > 0) {
                sclause = new StringBuilder();
                for (i = 0; i < crolesStartsWith.length; ++i) {
                    if (i != 0) {
                        sclause.append(" || ");
                    }
                    sclause.append("this.xlink.contentRole.startsWith(\"").append(crolesStartsWith[i]).append("\")");
                }
                if (sclause.length() > 0) {
                    if (clause.length() > 0) {
                        clause.append(" && ");
                    }
                    clause.append('(').append(sclause.toString()).append(')');
                }
            }
            q1 = db.getPersistenceManager().newQuery(LocatorForXLink.class, clause.toString());
            q1.declareImports("import java.lang.Long");
            q1.declareParameters("java.lang.Long locid");
            q1.setResult("MAX(this.xlink.id)");
            q2 = db.getPersistenceManager().newQuery(XLink.class, "this.id == maxid");
            q2.declareVariables("java.lang.Long maxid");
            q2.addSubquery(q1, "java.lang.Long maxid", null);
            q2.setUnique(true);
            XLink xLink = (XLink)q2.execute();
            return xLink;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q1 != null) {
                q1.closeAll();
            }
            q1 = null;
            if (q2 != null) {
                q2.closeAll();
            }
            q2 = null;
            DatabaseQuery.profiling("getXLinkByContentRoleLocatorLastChange", before);
        }
    }

    public static @Nullable XLink getXLinkByLastReplyBefore(Database db, XLink xl, @Nullable Long beforeId) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Object sql = "SELECT MAX(X.XLinkID) AS XLinkID FROM XLINK X ";
            sql = (String)sql + "INNER JOIN XLINK_FOR_XLINK XX ON X.XLinkID = XX.ReplyID ";
            sql = (String)sql + "WHERE XX.ReplyToID = " + xl.getId() + " AND ";
            sql = (String)sql + "XX.ReplyID != " + xl.getId() + " AND ";
            sql = (String)sql + "X.ContentRole = 'uri-properties' AND ";
            sql = beforeId != null ? (String)sql + "X.XLinkID < " + beforeId : (String)sql + "(X.Status IS NULL OR X.Status != 'Documentation-Old')";
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", sql);
            q.setClass(XLink.class);
            q.setUnique(true);
            XLink reply = (XLink)q.execute();
            if (reply != null) {
                XLink xLink = reply;
                return xLink;
            }
            XLink xLink = xl;
            return xLink;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinkByLastReplyBefore", before);
        }
    }

    public static List<XLink> getXLinksByURIRootReleaseAllGroups(Database db, URI uri, int page, int pagesize, boolean plusone) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (uri == null) {
                ArrayList<XLink> arrayList = new ArrayList<XLink>();
                return arrayList;
            }
            Iterator<Locator> loci = uri.getLocators(Predicates.predicateLocatorFragment(db, "default"));
            if (!loci.hasNext()) {
                ArrayList<XLink> arrayList = new ArrayList<XLink>();
                return arrayList;
            }
            q = db.getPersistenceManager().newQuery(LocatorForXLink.class, "this.locator.id == locid && (this.xlink.contentRole == 'Documentation-Version' || this.xlink.contentRole == 'Documentation-Release' || this.xlink.contentRole == 'archive-Documentation-Release')");
            q.declareImports("import java.lang.Long");
            q.declareParameters("java.lang.Long locid");
            q.setResult("DISTINCT this.xlink");
            q.setOrdering("this.xlink.id descending");
            if (pagesize > 0) {
                DatabaseQuery.setPaging(q, page, pagesize, plusone);
            }
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute((Object)loci.next().getId()));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByURIRootReleaseAllGroups", before);
        }
    }

    public static List<XLink> getXLinksByURIRootWorkflowAllGroups(Database db, URI uri) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (uri == null) {
                ArrayList<XLink> arrayList = new ArrayList<XLink>();
                return arrayList;
            }
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT X.XLinkID AS XLinkID FROM XLINK X ");
            qs.append(" INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = X.XLinkID");
            qs.append(" INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            qs.append(" WHERE L.Fragment = 'default'");
            qs.append("   AND (X.ContentRole = 'Workflow' OR X.ContentRole = 'archive-Workflow' OR");
            qs.append("        X.ContentRole = 'Documentation-Release' OR X.ContentRole = 'archive-Documentation-Release')");
            qs.append("   AND L.URIID = ").append(uri.getId());
            qs.append(" ORDER BY XLinkID ASC");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByURIRootWorkflowAllGroups", before);
        }
    }

    public static List<XLink> getXLinksByURIModification(Database db, Long uriid, boolean creation_upload) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (uriid == null) {
                ArrayList<XLink> arrayList = new ArrayList<XLink>();
                return arrayList;
            }
            String dbtype = DatabaseQuery.getDatabaseType();
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT Comment.XLinkID as XLinkID FROM XLINK Comment    INNER JOIN XLINK_FOR_XLINK XFX ON XFX.ReplyID = Comment.XLinkID    INNER JOIN URI U ON U.XLinkID = XFX.ReplyToID");
            qs.append(" WHERE U.URIID = ").append(uriid);
            qs.append(" AND Comment.ContentRole = 'uri-properties'");
            if (creation_upload) {
                qs.append(" AND (Comment.Type = 'creation' OR Comment.Type = 'upload')");
            }
            qs.append(" ORDER BY Comment.XLinkID ASC");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByURIModification", before);
        }
    }

    public static Long getTotalNumberOfMembers(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Member.class);
            q.setResult("COUNT(this)");
            Long l = (Long)q.execute();
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getTotalNumberOfMembers", before);
        }
    }

    public static Long getTotalNumberOfNonMemberGroups(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "this.name != 'member' && !this.name.startsWith(\"member-\") && !this.name.startsWith(\"archive-member-\") && (this.flags == null || this.flags.indexOf('f') == -1)");
            q.setResult("COUNT(this)");
            Long l = (Long)q.execute();
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getTotalNumberOfNonMemberGroups", before);
        }
    }

    public static Long getTotalNumberOfNonArchivedProjects(Database db) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            q = db.getPersistenceManager().newQuery(Group.class, "flags.indexOf('f') != -1 && flags.indexOf('d') == -1 && this.name != 'member' && !this.name.startsWith(\"member-\") && !this.name.startsWith(\"archive-member-\")");
            q.setResult("COUNT(this)");
            Long l = (Long)q.execute();
            return l;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getTotalNumberOfNonArchivedProjects", before);
        }
    }

    public static List<XLink> getTasksByDuedateStatus(Database db, int page, int pagesize, Date dueafter, Date duebefore, Collection<String> statuses, boolean plusone) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            StringBuilder qs = new StringBuilder("SELECT DISTINCT Latest.XLinkID as XLinkID, Latest.DueDate FROM XLINK Root  INNER JOIN XLINK Latest ON Root.ThreadEndXLinkID = Latest.XLinkID");
            qs.append(" WHERE Root.ThreadEndXLinkID IS NOT NULL");
            qs.append(" AND (Latest.ContentRole = 'Comment' OR Latest.ContentRole = 'File Attachment'");
            qs.append("    OR Latest.ContentRole = 'Documentation-Release' OR Latest.ContentRole = 'Workflow')");
            qs.append(" AND Latest.Accepted='1' AND Latest.AssignedToID IS NOT NULL");
            if (!statuses.isEmpty()) {
                Iterator<String> statusesIt = statuses.iterator();
                qs.append(" AND (");
                while (statusesIt.hasNext()) {
                    String status = statusesIt.next();
                    String unique = DatabaseQuery.unique("status", status);
                    qs.append("Latest.Status = :").append(unique);
                    if (statusesIt.hasNext()) {
                        qs.append(" OR ");
                    }
                    params.put(unique, status);
                }
                qs.append(")");
            } else {
                qs.append(" AND Latest.STATUS IS NOT NULL");
            }
            String unique = DatabaseQuery.unique("dueafter", dueafter.toString());
            qs.append(" AND Latest.DueDate >= :").append(unique);
            params.put(unique, new Timestamp(dueafter.getTime()));
            unique = DatabaseQuery.unique("duebefore", duebefore.toString());
            qs.append(" AND Latest.DueDate < :").append(unique);
            params.put(unique, new Timestamp(duebefore.getTime()));
            qs.append(" ORDER BY Latest.DueDate ASC");
            DatabaseQuery.setPaging(qs, page, pagesize, plusone);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getTasksByDuedateStatus", before);
        }
    }

    public static List<Discussion> getTasksByFilterParams(Database db, int page, int pagesize, Collection<Group> groups, Collection<String> paths, String contenttitle, String type, Collection<String> types, Member author, Long assignedto, Date createdafter, Date createdbefore, Date modifiedafter, Date dueafter, Date duebefore, Date assignedafter, Date assignedbefore, Collection<String> priorities, Collection<String> statuses, Collection<String> labels, boolean general, String contentrole, XLink pub_xlink) throws QueryFailedException {
        if (groups == null || groups.isEmpty()) {
            return new ArrayList<Discussion>();
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String unique;
            String unique2;
            String unique3;
            HashMap<String, Object> params = new HashMap<String, Object>();
            String dbtype = DatabaseQuery.getDatabaseType();
            String latest_hint = "mysql".equalsIgnoreCase(dbtype) ? " IGNORE INDEX (Accepted_idx)" : "";
            String join = " INNER JOIN";
            Object includeURITable = (paths == null || paths.isEmpty()) && general && pub_xlink == null ? "" : join + " LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = Root.XLinkID" + join + " LOCATOR L ON L.LocatorID = LFX.LocatorID" + join + " URI U ON U.URIID = L.URIID";
            String publicationLocatorJoin = " INNER JOIN LOCATOR L2 ON L2.URIID = U.URIID INNER JOIN PUBLICATION_FOR_LOCATOR PFL  ON PFL.LocatorID = L2.LocatorID    AND (L2.Fragment = 'default' OR L.Fragment = 'default' OR L2.LocatorID = L.LocatorID)";
            StringBuilder qs = new StringBuilder("SELECT DISTINCT Root.XLinkID AS ThreadID,    Latest.XLinkID, Latest.CreationDate FROM XLINK Root  INNER JOIN XLINK Latest" + latest_hint + " ON Root.ThreadEndXLinkID = Latest.XLinkID  INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = Latest.XLinkID");
            qs.append((String)includeURITable);
            if (pub_xlink != null) {
                qs.append(publicationLocatorJoin);
            }
            qs.append(" WHERE Root.ThreadEndXLinkID IS NOT NULL AND (");
            StringBuilder gs = new StringBuilder();
            Iterator<Group> grps = groups.iterator();
            while (grps.hasNext()) {
                Group group = grps.next();
                gs.append("GF.GroupID = ").append(group.getId());
                if (!grps.hasNext()) continue;
                gs.append(" OR ");
            }
            qs.append(gs.toString());
            qs.append(")");
            if (pub_xlink != null) {
                qs.append(" AND PFL.XLinkID = " + pub_xlink.getId());
            }
            qs.append("  AND (");
            if (!"workflow".equals(contentrole)) {
                qs.append("Latest.ContentRole = 'Comment' OR Latest.ContentRole = 'File Attachment'");
            }
            if (!"workflow".equals(contentrole) && !"comment".equals(contentrole)) {
                qs.append(" OR ");
            }
            if (!"comment".equals(contentrole)) {
                qs.append("Latest.ContentRole = 'Documentation-Release' OR Latest.ContentRole = 'Workflow'");
            }
            qs.append(")");
            qs.append(" AND Latest.Accepted='1'");
            if (types != null && !types.isEmpty()) {
                Iterator<String> typesIt = types.iterator();
                qs.append(" AND (");
                while (typesIt.hasNext()) {
                    String t = typesIt.next();
                    if (t.isEmpty()) {
                        qs.append("Latest.Type IS NULL");
                    } else {
                        unique3 = DatabaseQuery.unique("type", t);
                        qs.append("Latest.Type = :").append(unique3);
                        params.put(unique3, t);
                    }
                    if (!typesIt.hasNext()) continue;
                    qs.append(" OR ");
                }
                qs.append(")");
            }
            if (statuses != null && !statuses.isEmpty()) {
                Iterator<String> statusesIt = statuses.iterator();
                qs.append(" AND (");
                while (statusesIt.hasNext()) {
                    String status = statusesIt.next();
                    unique3 = DatabaseQuery.unique("status", status);
                    qs.append("Latest.Status = :").append(unique3);
                    if (statusesIt.hasNext()) {
                        qs.append(" OR ");
                    }
                    params.put(unique3, status);
                }
                qs.append(")");
            } else {
                qs.append(" AND Latest.STATUS IS NOT NULL");
            }
            if (contenttitle != null) {
                String ctitle = contenttitle.replace("**", "*\n");
                unique2 = DatabaseQuery.unique("title", ctitle);
                if (ctitle.endsWith("*")) {
                    ctitle = ctitle.substring(0, ctitle.length() - 1);
                    qs.append(" AND Latest.ContentTitle LIKE CONCAT(:").append(unique2).append(",'%')");
                } else {
                    qs.append(" AND Latest.ContentTitle = :").append(unique2);
                }
                ctitle = ctitle.replace("\n", "");
                params.put(unique2, ctitle);
            }
            if (type != null) {
                String thetype = type.replace("**", "*\n");
                unique2 = DatabaseQuery.unique("type", thetype);
                if (thetype.endsWith("*")) {
                    thetype = thetype.substring(0, thetype.length() - 1);
                    qs.append(" AND Latest.Type LIKE CONCAT(:").append(unique2).append(",'%')");
                } else {
                    qs.append(" AND Latest.Type = :").append(unique2);
                }
                thetype = thetype.replace("\n", "");
                params.put(unique2, thetype);
            }
            if (author != null) {
                qs.append(" AND Latest.MemberID = ").append(author.getId());
            }
            if (assignedto != null && assignedto.equals(0L)) {
                qs.append(" AND Latest.AssignedToID IS NULL");
            } else if (assignedto != null) {
                qs.append(" AND Latest.AssignedToID = ").append(assignedto);
            }
            if (createdafter != null) {
                unique = DatabaseQuery.unique("createdafter", createdafter.toString());
                qs.append(" AND Latest.CreationDate > :").append(unique);
                params.put(unique, new Timestamp(createdafter.getTime()));
            }
            if (createdbefore != null) {
                unique = DatabaseQuery.unique("createdbefore", createdbefore.toString());
                qs.append(" AND Latest.CreationDate < :").append(unique);
                params.put(unique, new Timestamp(createdbefore.getTime()));
            }
            if (modifiedafter != null) {
                unique = DatabaseQuery.unique("modifiedafter", modifiedafter.toString());
                qs.append(" AND (Latest.ModifiedDate > :").append(unique).append(" OR (Latest.ModifiedDate IS NULL AND Latest.CreationDate > :").append(unique).append("))");
                params.put(unique, new Timestamp(modifiedafter.getTime()));
            }
            if (dueafter != null) {
                unique = DatabaseQuery.unique("dueafter", dueafter.toString());
                qs.append(" AND Latest.DueDate > :").append(unique);
                params.put(unique, new Timestamp(dueafter.getTime()));
            }
            if (duebefore != null) {
                unique = DatabaseQuery.unique("duebefore", duebefore.toString());
                qs.append(" AND Latest.DueDate < :").append(unique);
                params.put(unique, new Timestamp(duebefore.getTime()));
            }
            if (assignedafter != null) {
                unique = DatabaseQuery.unique("assignedafter", assignedafter.toString());
                qs.append(" AND Latest.AssignedDate > :").append(unique);
                params.put(unique, new Timestamp(assignedafter.getTime()));
            }
            if (assignedbefore != null) {
                unique = DatabaseQuery.unique("assignedbefore", assignedbefore.toString());
                qs.append(" AND Latest.AssignedDate < :").append(unique);
                params.put(unique, new Timestamp(assignedbefore.getTime()));
            }
            if (priorities != null && !priorities.isEmpty()) {
                Iterator<String> prioritiesIt = priorities.iterator();
                qs.append(" AND (");
                while (prioritiesIt.hasNext()) {
                    String priority = prioritiesIt.next();
                    unique3 = DatabaseQuery.unique("priority", priority);
                    qs.append("Latest.Priority = :").append(unique3);
                    if (prioritiesIt.hasNext()) {
                        qs.append(" OR ");
                    }
                    params.put(unique3, priority);
                }
                qs.append(")");
            }
            if (labels != null && !labels.isEmpty()) {
                Iterator<String> labelsIt = labels.iterator();
                qs.append(" AND (");
                while (labelsIt.hasNext()) {
                    String label = labelsIt.next();
                    unique3 = DatabaseQuery.unique("label", label);
                    qs.append("Latest.Properties LIKE :").append(unique3);
                    if (labelsIt.hasNext()) {
                        qs.append(" AND ");
                    }
                    params.put(unique3, "%label=" + DatabaseQuery.escapeForLike(label) + "|%");
                }
                qs.append(")");
            }
            if (paths != null && !paths.isEmpty() || !general) {
                qs.append(" AND LFX.Role IS NULL");
                if (!general) {
                    qs.append(" AND U.Path NOT LIKE '" + GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/%'");
                }
                if (paths != null && !paths.isEmpty()) {
                    qs.append(" AND (");
                    Iterator<String> pathsIt = paths.iterator();
                    while (pathsIt.hasNext()) {
                        String path = Rules.uriEncodedPathToDBPath((String)pathsIt.next()).toLowerCase();
                        unique3 = DatabaseQuery.unique("path", path);
                        if (path.endsWith("*")) {
                            qs.append(DatabaseQuery.lowerCaseSQL("U.Path") + " LIKE :").append(unique3);
                            params.put(unique3, DatabaseQuery.escapeForLike(path.substring(0, path.length() - 1)) + "%");
                        } else {
                            qs.append(DatabaseQuery.lowerCaseSQL("U.Path") + " = :").append(unique3);
                            params.put(unique3, path);
                        }
                        if (!pathsIt.hasNext()) continue;
                        qs.append(" OR ");
                    }
                    qs.append(")");
                }
            }
            qs.append(" ORDER BY Latest.XLinkID DESC");
            DatabaseQuery.setPaging(qs, page, pagesize);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            Collection results = (Collection)q.executeWithMap(params);
            ArrayList<Discussion> discussions = new ArrayList<Discussion>();
            Collection<String> groupnames = Groups.getGroupNames(groups);
            for (Object[] result : results) {
                discussions.add(new Discussion(DatabaseQuery.getLong(result[0]), null, DatabaseQuery.getLong(result[1]), DatabaseQuery.getDate(result[2]), groupnames));
            }
            ArrayList<Discussion> arrayList = discussions;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getTasksByFilterParams", before);
        }
    }

    public static List<Discussion> getDiscussionsByFilterParams(Database db, int page, int pagesize, Collection<Group> groups, Collection<String> paths, String contenttitle, String type, Collection<String> types, Member author, Member assignedto, Date createdafter, Date createdbefore, Collection<String> labels, boolean general) throws QueryFailedException {
        if (groups == null || groups.isEmpty()) {
            return new ArrayList<Discussion>();
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String unique;
            String unique2;
            String unique3;
            HashMap<String, Object> params = new HashMap<String, Object>();
            String dbtype = DatabaseQuery.getDatabaseType();
            String comment_hint = "mysql".equalsIgnoreCase(dbtype) ? " IGNORE INDEX (Accepted_idx)" : "";
            String join = " INNER JOIN";
            String includeURITable = (paths == null || paths.isEmpty()) && general ? "" : join + " LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XFX.ReplyToID" + join + " LOCATOR L ON L.LocatorID = LFX.LocatorID" + join + " URI U ON U.URIID = L.URIID";
            StringBuilder qs = new StringBuilder("SELECT DISTINCT Root.XLinkID AS ThreadID, Root.ThreadEndXLinkID  FROM XLINK Root    INNER JOIN XLINK_FOR_XLINK XFX ON XFX.ReplyToID = Root.XLinkID    INNER JOIN XLINK Comment" + comment_hint + " ON Comment.XLinkID = XFX.ReplyID    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = Comment.XLinkID");
            qs.append(includeURITable);
            qs.append(" WHERE Root.ThreadEndXLinkID IS NOT NULL AND (");
            StringBuilder gs = new StringBuilder();
            Iterator<Group> grps = groups.iterator();
            while (grps.hasNext()) {
                Group group = grps.next();
                gs.append("GF.GroupID = ").append(group.getId());
                if (!grps.hasNext()) continue;
                gs.append(" OR ");
            }
            qs.append(gs.toString());
            qs.append(")");
            qs.append("  AND (Comment.ContentRole = 'Comment' OR Comment.ContentRole = 'File Attachment')");
            qs.append("  AND Comment.Accepted='1'");
            if (types != null && !types.isEmpty()) {
                Iterator<String> typesIt = types.iterator();
                qs.append(" AND (");
                while (typesIt.hasNext()) {
                    String t = typesIt.next();
                    if (t.isEmpty()) {
                        qs.append("Comment.Type IS NULL");
                    } else {
                        unique3 = DatabaseQuery.unique("type", t);
                        qs.append("Comment.Type = :").append(unique3);
                        params.put(unique3, t);
                    }
                    if (!typesIt.hasNext()) continue;
                    qs.append(" OR ");
                }
                qs.append(")");
            }
            if (contenttitle != null) {
                String ctitle = contenttitle.replace("**", "*\n");
                unique2 = DatabaseQuery.unique("title", ctitle);
                if (ctitle.endsWith("*")) {
                    ctitle = ctitle.substring(0, ctitle.length() - 1);
                    qs.append(" AND Comment.ContentTitle LIKE CONCAT(:").append(unique2).append(",'%')");
                } else {
                    qs.append(" AND Comment.ContentTitle = :").append(unique2);
                }
                ctitle = ctitle.replace("\n", "");
                params.put(unique2, ctitle);
            }
            if (type != null) {
                String thetype = type.replace("**", "*\n");
                unique2 = DatabaseQuery.unique("type", thetype);
                if (thetype.endsWith("*")) {
                    thetype = thetype.substring(0, thetype.length() - 1);
                    qs.append(" AND Comment.Type LIKE CONCAT(:").append(unique2).append(",'%')");
                } else {
                    qs.append(" AND Comment.Type = :").append(unique2);
                }
                thetype = thetype.replace("\n", "");
                params.put(unique2, thetype);
            }
            if (author != null) {
                qs.append(" AND Comment.MemberID = ").append(author.getId());
            }
            if (assignedto != null) {
                qs.append(" AND Comment.AssignedToID = ").append(assignedto.getId());
            }
            if (createdafter != null) {
                unique = DatabaseQuery.unique("createdafter", createdafter.toString());
                qs.append(" AND Comment.CreationDate > :").append(unique);
                params.put(unique, new Timestamp(createdafter.getTime()));
            }
            if (createdbefore != null) {
                unique = DatabaseQuery.unique("createdbefore", createdbefore.toString());
                qs.append(" AND Comment.CreationDate < :").append(unique);
                params.put(unique, new Timestamp(createdbefore.getTime()));
            }
            if (labels != null && !labels.isEmpty()) {
                Iterator<String> labelsIt = labels.iterator();
                qs.append(" AND (");
                while (labelsIt.hasNext()) {
                    String label = labelsIt.next();
                    unique3 = DatabaseQuery.unique("label", label);
                    qs.append("Comment.Properties LIKE :").append(unique3);
                    if (labelsIt.hasNext()) {
                        qs.append(" AND ");
                    }
                    params.put(unique3, "%label=" + DatabaseQuery.escapeForLike(label) + "|%");
                }
                qs.append(")");
            }
            if (paths != null && !paths.isEmpty() || !general) {
                qs.append(" AND LFX.Role IS NULL");
                if (!general) {
                    qs.append(" AND U.Path NOT LIKE '" + GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/%'");
                }
                if (paths != null && !paths.isEmpty()) {
                    qs.append(" AND (");
                    Iterator<String> pathsIt = paths.iterator();
                    while (pathsIt.hasNext()) {
                        String path = Rules.uriEncodedPathToDBPath((String)pathsIt.next()).toLowerCase();
                        unique3 = DatabaseQuery.unique("path", path);
                        if (path.endsWith("*")) {
                            qs.append(DatabaseQuery.lowerCaseSQL("U.Path") + " LIKE :").append(unique3);
                            params.put(unique3, DatabaseQuery.escapeForLike(path.substring(0, path.length() - 1)) + "%");
                        } else {
                            qs.append(DatabaseQuery.lowerCaseSQL("U.Path") + " = :").append(unique3);
                            params.put(unique3, path);
                        }
                        if (!pathsIt.hasNext()) continue;
                        qs.append(" OR ");
                    }
                    qs.append(")");
                }
            }
            qs.append(" ORDER BY Root.ThreadEndXLinkID DESC");
            DatabaseQuery.setPaging(qs, page, pagesize);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            Collection results = (Collection)q.executeWithMap(params);
            ArrayList<Discussion> discussions = new ArrayList<Discussion>();
            Collection<String> groupnames = Groups.getGroupNames(groups);
            for (Object[] result : results) {
                discussions.add(new Discussion(DatabaseQuery.getLong(result[0]), groupnames));
            }
            ArrayList<Discussion> arrayList = discussions;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getDiscussionsByFilterParams", before);
        }
    }

    public static List<XLink> getCommentsByURIGroups(Database db, int page, int pagesize, Collection<String> groupnames, Long uriid) throws QueryFailedException {
        if (groupnames == null || groupnames.isEmpty()) {
            return new ArrayList<XLink>();
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String dbtype = DatabaseQuery.getDatabaseType();
            String join = " INNER JOIN";
            StringBuilder qs = new StringBuilder("SELECT DISTINCT Comment.XLinkID as XLinkID  FROM XLINK Comment    INNER JOIN XLINK_FOR_XLINK XFX ON XFX.ReplyID = Comment.XLinkID    INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = Comment.XLinkID    INNER JOIN DGROUP G on G.GroupID = GF.GroupID");
            qs.append(join + " LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XFX.ReplyToID" + join + " LOCATOR L ON L.LocatorID = LFX.LocatorID");
            qs.append(" WHERE L.URIID = ").append(uriid);
            qs.append(" AND (");
            StringBuilder gs = new StringBuilder();
            Iterator<String> gnames = groupnames.iterator();
            while (gnames.hasNext()) {
                String gname = gnames.next();
                String unique = DatabaseQuery.unique("groupname", gname);
                params.put(unique, gname);
                gs.append("G.GROUPNAME = :").append(unique);
                if (!gnames.hasNext()) continue;
                gs.append(" OR ");
            }
            qs.append(gs.toString());
            qs.append(")");
            qs.append("  AND Comment.Accepted='1'");
            qs.append("  AND (Comment.ContentRole = 'Comment' OR Comment.ContentRole = 'File Attachment')");
            qs.append(" ORDER BY Comment.XLinkID DESC");
            DatabaseQuery.setPaging(qs, page, pagesize);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getCommentsByURIGroups", before);
        }
    }

    public static List<XLink> getCommentsByFilterParams(Database db, int page, int pagesize, Collection<String> groupnames, Collection<String> paths, String contenttitle, String type, Collection<String> types, Member author, Date createdafter, Date createdbefore, boolean archived, boolean moderated, String labels, boolean first, Collection<String> statuses, boolean general) throws QueryFailedException {
        if (groupnames == null || groupnames.isEmpty()) {
            return new ArrayList<XLink>();
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String unique;
            String unique2;
            String[] unique3;
            String join;
            HashMap<Object, Object> params = new HashMap<Object, Object>();
            String dbtype = DatabaseQuery.getDatabaseType();
            String string = join = "mysql".equalsIgnoreCase(dbtype) ? " STRAIGHT_JOIN" : " INNER JOIN";
            String includeURITable = (paths == null || paths.isEmpty()) && general ? "" : join + " LOCATOR_FOR_XLINK LFX ON LFX.XLinkID =" + (first ? " Comment.XLinkID" : " XFX.ReplyToID") + join + " LOCATOR L ON L.LocatorID = LFX.LocatorID" + join + " URI U ON U.URIID = L.URIID";
            StringBuilder qs = new StringBuilder("SELECT DISTINCT Comment.XLinkID as XLinkID  FROM DGROUP G" + join + " DGROUP_FOR_XLINK GF ON G.GroupID = GF.GroupID" + join + " XLINK Comment on GF.XLinkID = Comment.XLinkID" + (!first && !includeURITable.isEmpty() ? " INNER JOIN XLINK_FOR_XLINK XFX ON XFX.ReplyID = Comment.XLinkID" : ""));
            qs.append(includeURITable);
            qs.append(" WHERE (");
            StringBuilder gs = new StringBuilder();
            Iterator<String> gnames = groupnames.iterator();
            while (gnames.hasNext()) {
                String gname = gnames.next();
                unique3 = DatabaseQuery.unique("groupname", gname);
                params.put(unique3, gname);
                gs.append("G.GROUPNAME = :").append((String)unique3);
                if (!gnames.hasNext()) continue;
                gs.append(" OR ");
            }
            qs.append(gs.toString());
            qs.append(")");
            qs.append("  AND (Comment.ContentRole = 'Comment' OR Comment.ContentRole = 'File Attachment'");
            if (archived) {
                qs.append(" OR Comment.ContentRole = 'archive-Comment' OR Comment.ContentRole = 'archive-File Attachment'");
            }
            qs.append(')');
            if (first && includeURITable.isEmpty()) {
                qs.append(" AND Comment.ThreadEndXLinkID is not NULL");
            }
            if (!moderated) {
                qs.append(" AND Comment.Accepted='1'");
            }
            if (types != null && !types.isEmpty()) {
                Iterator<String> typesIt = types.iterator();
                qs.append(" AND (");
                while (typesIt.hasNext()) {
                    String t = typesIt.next();
                    if (t.isEmpty()) {
                        qs.append("Comment.Type IS NULL");
                    } else {
                        unique2 = DatabaseQuery.unique("type", t);
                        qs.append("Comment.Type = :").append(unique2);
                        params.put(unique2, t);
                    }
                    if (!typesIt.hasNext()) continue;
                    qs.append(" OR ");
                }
                qs.append(")");
            }
            if (statuses != null && !statuses.isEmpty()) {
                Iterator<String> statusesIt = statuses.iterator();
                qs.append(" AND (");
                while (statusesIt.hasNext()) {
                    String status = statusesIt.next();
                    unique2 = DatabaseQuery.unique("status", status);
                    qs.append("Comment.Status = :").append(unique2);
                    if (statusesIt.hasNext()) {
                        qs.append(" OR ");
                    }
                    params.put(unique2, status);
                }
                qs.append(")");
            }
            if (contenttitle != null) {
                String ctitle = contenttitle.replace("**", "*\n");
                unique3 = DatabaseQuery.unique("title", ctitle);
                if (ctitle.endsWith("*")) {
                    ctitle = ctitle.substring(0, ctitle.length() - 1);
                    qs.append(" AND Comment.ContentTitle LIKE CONCAT(:").append((String)unique3).append(",'%')");
                } else {
                    qs.append(" AND Comment.ContentTitle = :").append((String)unique3);
                }
                ctitle = ctitle.replace("\n", "");
                params.put(unique3, ctitle);
            }
            if (type != null) {
                String thetype = type.replace("**", "*\n");
                unique3 = DatabaseQuery.unique("type", thetype);
                if (thetype.endsWith("*")) {
                    thetype = thetype.substring(0, thetype.length() - 1);
                    qs.append(" AND Comment.Type LIKE CONCAT(:").append((String)unique3).append(",'%')");
                } else {
                    qs.append(" AND Comment.Type = :").append((String)unique3);
                }
                thetype = thetype.replace("\n", "");
                params.put(unique3, thetype);
            }
            if (author != null) {
                qs.append(" AND Comment.MemberID = ").append(author.getId());
            }
            if (createdafter != null) {
                unique = DatabaseQuery.unique("createdafter", createdafter.toString());
                qs.append(" AND Comment.CreationDate > :").append(unique);
                params.put(unique, new Timestamp(createdafter.getTime()));
            }
            if (createdbefore != null) {
                unique = DatabaseQuery.unique("createdbefore", createdbefore.toString());
                qs.append(" AND Comment.CreationDate < :").append(unique);
                params.put(unique, new Timestamp(createdbefore.getTime()));
            }
            if (labels != null && !labels.isEmpty()) {
                qs.append(" AND (");
                boolean start = true;
                for (String lab : labels.split(",")) {
                    String label = lab.trim();
                    String unique4 = DatabaseQuery.unique("label", label);
                    if (!start) {
                        qs.append(" AND ");
                    }
                    qs.append("Comment.Properties LIKE :").append(unique4);
                    params.put(unique4, "%label=" + DatabaseQuery.escapeForLike(label) + "|%");
                    start = false;
                }
                qs.append(")");
            }
            if (paths != null && !paths.isEmpty() || !general) {
                qs.append(" AND LFX.Role IS NULL");
                if (!general) {
                    qs.append(" AND U.Path NOT LIKE '" + GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/%'");
                }
                if (paths != null && !paths.isEmpty()) {
                    qs.append(" AND (");
                    Iterator<String> pathsIt = paths.iterator();
                    while (pathsIt.hasNext()) {
                        String path = Rules.uriEncodedPathToDBPath((String)pathsIt.next()).toLowerCase();
                        String unique5 = DatabaseQuery.unique("path", path);
                        if (path.endsWith("*")) {
                            qs.append(DatabaseQuery.lowerCaseSQL("U.Path") + " LIKE :").append(unique5);
                            params.put(unique5, DatabaseQuery.escapeForLike(path.substring(0, path.length() - 1)) + "%");
                        } else {
                            qs.append(DatabaseQuery.lowerCaseSQL("U.Path") + " = :").append(unique5);
                            params.put(unique5, path);
                        }
                        if (!pathsIt.hasNext()) continue;
                        qs.append(" OR ");
                    }
                    qs.append(")");
                }
            }
            qs.append(" ORDER BY XLinkID DESC");
            DatabaseQuery.setPaging(qs, page, pagesize);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getCommentsByFilterParams", before);
        }
    }

    public static List<XLink> getXLinksByURIHistory(Database db, int page, int pagesize, boolean plusone, Member author, String label, Group group, @Nullable Long uriid, String folder, String documenttype, List<String> eventTypes, Date createdafter, Date createdbefore, XLink pub_xlink) throws QueryFailedException {
        if (group == null || eventTypes == null || eventTypes.isEmpty()) {
            return new ArrayList<XLink>();
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String unique;
            String dbtype = DatabaseQuery.getDatabaseType();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("groupid", group.getId());
            StringBuilder where_qs = new StringBuilder();
            where_qs.append(" WHERE Comment.Accepted = '1'");
            if (uriid != null) {
                where_qs.append(" AND U.URIID = ").append(uriid);
            } else {
                if (pub_xlink != null) {
                    where_qs.append(" AND PFL.XLinkID = " + pub_xlink.getId());
                }
                where_qs.append(" AND U.Path != '" + GlobalSettings.get((String)"servletPrefix") + GENERAL_URI_PATH + group.getId() + "'");
                if (folder != null && !((String)folder).isEmpty()) {
                    if (!((String)folder).endsWith("/")) {
                        folder = (String)folder + "/";
                    }
                    unique = DatabaseQuery.unique("folder", (String)folder);
                    where_qs.append(" AND " + DatabaseQuery.lowerCaseSQL("U.Path") + " LIKE :").append(unique);
                    params.put(unique, DatabaseQuery.escapeForLike(Rules.uriEncodedPathToDBPath((String)((String)folder).toLowerCase())) + "%");
                } else {
                    where_qs.append(" AND GF.GroupID = :groupid");
                }
                if (documenttype != null) {
                    unique = DatabaseQuery.unique("documenttype", documenttype.toString());
                    where_qs.append(" AND U.Behavior = :").append(unique);
                    params.put(unique, "psml-" + ("default".equals(documenttype) ? "" : documenttype) + "-");
                }
            }
            if (createdafter != null) {
                unique = DatabaseQuery.unique("createdafter", createdafter.toString());
                where_qs.append(" AND Comment.CreationDate > :").append(unique);
                params.put(unique, new Timestamp(createdafter.getTime()));
            }
            if (createdbefore != null) {
                unique = DatabaseQuery.unique("createdbefore", createdbefore.toString());
                where_qs.append(" AND Comment.CreationDate < :").append(unique);
                params.put(unique, new Timestamp(createdbefore.getTime()));
            }
            if (author != null) {
                unique = DatabaseQuery.unique("author", String.valueOf(author.getId()));
                where_qs.append(" AND Comment.MemberID = :").append(unique);
                params.put(unique, author.getId());
            }
            if (label != null) {
                unique = DatabaseQuery.unique("label", label);
                where_qs.append(" AND Comment.Properties LIKE :").append(unique);
                params.put(unique, "%label=" + DatabaseQuery.escapeForLike(label) + "|%");
            }
            ArrayList<String> clauses = new ArrayList<String>();
            if (eventTypes.contains("upload")) {
                clauses.add("Comment.ContentRole = 'File Upload'");
            }
            if (eventTypes.contains("creation")) {
                clauses.add("Comment.ContentRole = 'File Creation'");
            }
            if (eventTypes.contains("structure")) {
                clauses.add("Comment.ContentRole = 'Documentation-Structure' AND (Comment.ContentTitle = 'Fragment Move' OR Comment.ContentTitle = 'Structure Edit')");
            }
            if (eventTypes.contains("workflow")) {
                clauses.add("Comment.ContentRole = 'Workflow'");
                clauses.add("Comment.ContentRole = 'Documentation-Release' AND Comment.Status IS NOT NULL");
            }
            if (eventTypes.contains("version")) {
                clauses.add("Comment.ContentRole = 'Documentation-Version'");
                clauses.add("Comment.ContentRole = 'Documentation-Release'");
            }
            if (eventTypes.contains("edit")) {
                clauses.add("Comment.ContentRole = 'Documentation' AND (Comment.Status IS NULL OR Comment.Status != 'Documentation-Draft')");
                clauses.add("Comment.ContentRole = 'Documentation-Hidden'");
            }
            if (eventTypes.contains("draft")) {
                clauses.add("Comment.Status = 'Documentation-Draft' AND Comment.ContentRole = 'Documentation'");
            }
            if (eventTypes.contains("note")) {
                clauses.add("Comment.ContentRole = 'Documentation-Note'");
            }
            if (eventTypes.contains("xref")) {
                clauses.add("Comment.ContentRole LIKE 'XRef%' AND LFX.Role LIKE 'xref-source%' AND LFX.Label IS NULL");
                clauses.add("Comment.ContentRole LIKE 'XRef%' AND LFX.Role LIKE 'xref-source%' AND LFX.Label != 'image'");
            }
            if (eventTypes.contains("image")) {
                clauses.add("Comment.ContentRole LIKE 'XRef%' AND LFX.Role LIKE 'xref-source%' AND LFX.Label = 'image'");
            }
            if (eventTypes.contains("comment")) {
                clauses.add("LFX.Role IS NULL AND Comment.Status IS NULL AND Comment.ContentRole = 'Comment' AND GF.GroupID = :groupid");
                clauses.add("LFX.Role IS NULL AND Comment.Status IS NULL AND Comment.ContentRole = 'File Attachment' AND GF.GroupID = :groupid");
            }
            if (eventTypes.contains("task")) {
                clauses.add("LFX.Role IS NULL AND Comment.Status IS NOT NULL AND Comment.ContentRole = 'Comment' AND GF.GroupID = :groupid");
                clauses.add("LFX.Role IS NULL AND Comment.Status IS NOT NULL AND Comment.ContentRole = 'File Attachment' AND GF.GroupID = :groupid");
            }
            String select_reply_sql = "SELECT DISTINCT Comment.XLinkID as XLinkID FROM URI U";
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT * FROM (");
            boolean hasModification = eventTypes.contains("modification");
            boolean hasCreation = eventTypes.contains("creation");
            boolean hasUpload = eventTypes.contains("upload");
            boolean hasRevert = eventTypes.contains("revert");
            boolean hasMove = eventTypes.contains("move");
            String publication_uri_join = " INNER JOIN LOCATOR L ON L.URIID = U.URIID INNER JOIN PUBLICATION_FOR_LOCATOR PFL  ON PFL.LocatorID = L.LocatorID";
            String publication_locator_join = " INNER JOIN LOCATOR L2 ON L2.URIID = U.URIID INNER JOIN PUBLICATION_FOR_LOCATOR PFL  ON PFL.LocatorID = L2.LocatorID    AND (L2.Fragment = 'default' OR L.Fragment = 'default' OR L2.LocatorID = L.LocatorID)";
            String join = " INNER JOIN";
            if (hasModification || hasCreation || hasUpload || hasRevert || hasMove) {
                qs.append("(");
                qs.append(select_reply_sql);
                qs.append(join + " XLINK_FOR_XLINK XFX1 ON U.XLinkID = XFX1.ReplyToID");
                qs.append(join + " XLINK Comment ON XFX1.ReplyID = Comment.XLinkID");
                qs.append(" INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = Comment.XLinkID");
                if (pub_xlink != null) {
                    qs.append(publication_uri_join);
                }
                qs.append(where_qs.toString());
                qs.append(" AND Comment.ContentRole = 'uri-properties'");
                qs.append(" AND (");
                if (hasCreation) {
                    qs.append("Comment.Type = 'creation'").append(hasUpload || hasRevert || hasMove || hasModification ? " OR " : "");
                }
                if (hasUpload) {
                    qs.append("Comment.Type = 'upload'").append(hasRevert || hasMove || hasModification ? " OR " : "");
                }
                if (hasRevert) {
                    qs.append("Comment.Type = 'revert'").append(hasMove || hasModification ? " OR " : "");
                }
                if (hasMove) {
                    qs.append("Comment.Type = 'move'").append(hasModification ? " OR " : "");
                }
                if (hasModification) {
                    qs.append("Comment.Type IS NULL");
                }
                qs.append("))");
            }
            if ((hasModification || hasCreation || hasUpload || hasRevert || hasMove) && !clauses.isEmpty()) {
                qs.append(" UNION ");
            }
            if (!clauses.isEmpty()) {
                qs.append("(");
                qs.append(select_reply_sql);
                qs.append(" INNER JOIN LOCATOR L ON U.URIID = L.URIID");
                qs.append(" INNER JOIN LOCATOR_FOR_XLINK LFX ON L.LocatorID = LFX.LocatorID");
                qs.append(join + " XLINK_FOR_XLINK XFX1 ON LFX.XLinkID = XFX1.ReplyToID");
                qs.append(join + " XLINK Comment ON XFX1.ReplyID = Comment.XLinkID");
                qs.append(" INNER JOIN DGROUP_FOR_XLINK GF ON GF.XLinkID = Comment.XLinkID");
                if (pub_xlink != null) {
                    qs.append(publication_locator_join);
                }
                qs.append(where_qs.toString());
                qs.append(" AND (GF.GroupID = :groupid OR Comment.ContentRole != 'Comment' OR Comment.ContentRole != 'File Attachment')");
                qs.append(" AND (");
                for (int i = 0; i < clauses.size(); ++i) {
                    if (i > 0) {
                        qs.append(" OR ");
                    }
                    qs.append('(').append((String)clauses.get(i)).append(')');
                }
                qs.append(')');
                qs.append(" AND (LFX.Role IS NULL OR LFX.XLinkID = Comment.XLinkID OR (Comment.ContentRole != 'Comment' AND Comment.ContentRole != 'File Attachment'))");
                qs.append(")");
            }
            qs.append(" ORDER BY XLinkID DESC");
            DatabaseQuery.setPaging(qs, page, pagesize, plusone);
            qs.append(") x");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByURIHistory", before);
        }
    }

    public static List<XLink> getXRefsForwardURIGroupFragment(Database db, URI uri, Group group, @Nullable String sourcefrag) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (uri == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT Distinct(X.XLinkID) AS XLinkID FROM XLINK X ");
            qs.append("  INNER JOIN LOCATOR_FOR_XLINK LFX  ON X.XLinkID = LFX.XLinkID ");
            qs.append("  INNER JOIN LOCATOR L              ON LFX.LocatorID = L.LocatorID");
            qs.append("  INNER JOIN DGROUP_FOR_XLINK GFX   ON GFX.XLinkID = X.XLinkID");
            qs.append("  INNER JOIN DGROUP G               ON GFX.GroupID = G.GroupID");
            qs.append(" WHERE X.ContentRole LIKE 'XRef%'");
            qs.append("  AND G.GroupID = ").append(group.getId());
            qs.append("  AND L.URIID  = ").append(uri.getId());
            qs.append("  AND LFX.Role LIKE 'xref-source%'");
            qs.append("  AND (X.Status IS NULL OR X.Status != 'Documentation-Old')");
            if (sourcefrag != null && !sourcefrag.isEmpty()) {
                String unique = DatabaseQuery.unique("fragment", sourcefrag);
                qs.append("  AND L.Fragment = :").append(unique);
                params.put(unique, sourcefrag);
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXRefsForwardURIGroupFragmentTypes", before);
        }
    }

    public static List<URIFragmentPair> getXLinksByReverseXRefsURITypeAllGroups(Database db, Long uriid, String fragment, boolean includeDefault, @Nullable List<String> types) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (uriid == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT L2.URIID, L2.Fragment FROM XLINK X ");
            qs.append("  INNER JOIN LOCATOR_FOR_XLINK LFX  ON X.XLinkID = LFX.XLinkID ");
            qs.append("  INNER JOIN LOCATOR L              ON LFX.LocatorID = L.LocatorID");
            qs.append("  INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = X.XLinkID");
            qs.append("  INNER JOIN LOCATOR L2             ON LFX2.LocatorID = L2.LocatorID");
            qs.append(" WHERE X.ContentRole LIKE 'XRef%'");
            qs.append("  AND L.URIID  = ").append(uriid);
            qs.append("  AND LFX.Role = 'xref-link'");
            qs.append("  AND LFX2.Role != 'xref-link'");
            qs.append("  AND (X.Status IS NULL OR X.Status != 'Documentation-Old')");
            if (fragment != null) {
                String unique = DatabaseQuery.unique("fragment", fragment);
                qs.append(" AND (");
                if (includeDefault) {
                    qs.append(" L.Fragment = 'default' OR");
                }
                qs.append(" L.Fragment = :").append(unique).append(')');
                params.put(unique, fragment);
            }
            if (types != null && !types.isEmpty()) {
                qs.append("  AND (");
                boolean first = true;
                for (String type : types) {
                    if (!first) {
                        qs.append(" OR ");
                    }
                    String unique = DatabaseQuery.unique("type", type);
                    qs.append("LFX2.Label = :").append(unique);
                    params.put(unique, type);
                    first = false;
                }
                qs.append(")");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            Collection results = (Collection)q.executeWithMap(params);
            ArrayList<URIFragmentPair> pairs = new ArrayList<URIFragmentPair>();
            for (Object[] result : results) {
                pairs.add(new URIFragmentPair(DatabaseQuery.getLong(result[0]), (String)result[1]));
            }
            ArrayList<URIFragmentPair> arrayList = pairs;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByReverseXRefsURITypeAllGroups", before);
        }
    }

    public static Integer getXLinksCountByReverseXRefsURIAllGroups(Database db, Long uriid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (uriid == null) {
                Integer n = 0;
                return n;
            }
            HashMap params = new HashMap();
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT COUNT(DISTINCT X.XLinkID) FROM XLINK X ");
            qs.append("  INNER JOIN LOCATOR_FOR_XLINK LFX  ON X.XLinkID = LFX.XLinkID ");
            qs.append("  INNER JOIN LOCATOR L              ON LFX.LocatorID = L.LocatorID");
            qs.append("  INNER JOIN LOCATOR_FOR_XLINK LFX2 ON X.XLinkID = LFX2.XLinkID");
            qs.append("  INNER JOIN LOCATOR L2             ON LFX2.LocatorID = L2.LocatorID");
            qs.append("  INNER JOIN URI U2                 ON L2.URIID = U2.URIID");
            qs.append("  INNER JOIN HOST H2                ON U2.HostID = H2.HostID");
            qs.append(" WHERE X.ContentRole LIKE 'XRef%'");
            qs.append("  AND L.URIID  = ").append(uriid);
            qs.append("  AND LFX.Role = 'xref-link'");
            qs.append("  AND LFX2.Role = 'xref-source-manual-link'");
            qs.append("  AND (U2.Path NOT LIKE '" + GlobalSettings.getSitePrefix() + "/archive/%'");
            qs.append("    OR H2.ExternalFlag = '1')");
            qs.append("  AND (X.Status IS NULL OR X.Status != 'Documentation-Old')");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            Collection results = (Collection)q.executeWithMap(params);
            Integer n = ((Long)results.toArray()[0]).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksCountByReverseXRefsURIAllGroups", before);
        }
    }

    public static List<Group> getGroupsByURIComments(Database db, Long uriid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (uriid == null) {
                List<Group> list = Collections.emptyList();
                return list;
            }
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT DISTINCT(G.GroupID) AS GroupID FROM XLINK XL");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            qs.append("    INNER JOIN DGROUP_FOR_XLINK GFX ON GFX.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN DGROUP G ON G.GroupID = GFX.GroupID");
            qs.append("  WHERE L.URIID = " + uriid);
            qs.append("  AND (XL.ContentRole = 'Comment' or XL.ContentRole = 'File Attachment')");
            qs.append("  AND XL.Accepted = '1'");
            qs.append("  AND G.GroupName != 'admin'");
            qs.append("  AND G.GroupName != 'public'");
            qs.append("  AND (G.Flags IS NULL OR G.Flags NOT LIKE '%d%')");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(Group.class);
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupsByURIComments", before);
        }
    }

    public static List<Group> getGroupsByURIReverseXRefs(Database db, Long uriid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            if (uriid == null) {
                List<Group> list = Collections.emptyList();
                return list;
            }
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT DISTINCT(G.GroupID) AS GroupID FROM XLINK XL");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            qs.append("    INNER JOIN URI_FOR_DGROUPURI UFGU ON L2.URIID = UFGU.URIID");
            qs.append("    INNER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
            qs.append("    INNER JOIN DGROUP G ON G.GroupID = GUFG.GroupID");
            qs.append("  WHERE L.URIID = " + uriid);
            qs.append("  AND XL.ContentRole LIKE 'XRef%'");
            qs.append("  AND LFX.Role = 'xref-link'");
            qs.append("  AND LFX2.Role = 'xref-source-manual-link'");
            qs.append("  AND (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            qs.append("  AND G.GroupName != 'admin'");
            qs.append("  AND G.GroupName != 'public'");
            qs.append("  AND (G.Flags IS NULL OR G.Flags NOT LIKE '%d%')");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(Group.class);
            ArrayList<Group> arrayList = new ArrayList<Group>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getGroupsByURIReverseXRefs", before);
        }
    }

    public static List<XLink> getReverseXRefsByURIGroups(Database db, Long uriid, Collection<Group> groups, int page, int pagesize, boolean plusone) throws QueryFailedException {
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        if (uriid == null) {
            return Collections.emptyList();
        }
        boolean admin = false;
        StringBuilder gs = new StringBuilder();
        for (Group group : groups) {
            if ("admin".equals(group.getName())) {
                admin = true;
                break;
            }
            gs.append("GUFG.GroupID = ").append(group.getId());
            gs.append(" OR ");
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            Group pub = DatabaseQuery.getGroupByName(db, "public");
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT DISTINCT(XL.XLinkID) AS XLinkID FROM XLINK XL");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            qs.append("    LEFT OUTER JOIN URI_FOR_DGROUPURI UFGU ON L2.URIID = UFGU.URIID");
            qs.append("    LEFT OUTER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
            qs.append("    LEFT OUTER JOIN DGROUP_FOR_XLINK GFX ON (GFX.XLinkID = XL.XLinkID AND GFX.GroupID = " + pub.getId() + ")");
            if (admin) {
                qs.append("    INNER JOIN DGROUP G ON (G.GroupID = GUFG.GroupID OR G.GroupID = GFX.GroupID)");
            }
            qs.append("  WHERE L.URIID = " + uriid);
            qs.append("  AND XL.ContentRole LIKE 'XRef%'");
            qs.append("  AND LFX.Role = 'xref-link'");
            qs.append("  AND LFX2.Role = 'xref-source-manual-link'");
            qs.append("  AND (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            if (admin) {
                qs.append("  AND (G.Flags IS NULL OR G.Flags NOT LIKE '%d%')");
            } else {
                qs.append("  AND (").append((CharSequence)gs).append("GFX.GroupID = " + pub.getId() + ")");
            }
            qs.append(" ORDER BY XLinkID DESC");
            DatabaseQuery.setPaging(qs, page, pagesize, plusone);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList<XLink> arrayList = new ArrayList<XLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getReverseXRefsByURIGroups", before);
        }
    }

    public static List<LocatorForXLink> getLocatorForXLinksByURIReverseXRef(Database db, URI uri) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder qs = new StringBuilder();
        try {
            Group pub = DatabaseQuery.getGroupByName(db, "public");
            qs.append("SELECT DISTINCT LFX.LocatorForXLinkID FROM XLINK XL");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            qs.append("    LEFT OUTER JOIN URI_FOR_DGROUPURI UFGU ON L2.URIID = UFGU.URIID");
            qs.append("    LEFT OUTER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
            qs.append("    LEFT OUTER JOIN DGROUP_FOR_XLINK GFX ON (GFX.XLinkID = XL.XLinkID AND GFX.GroupID = " + pub.getId() + ")");
            qs.append("    INNER JOIN DGROUP G ON (G.GroupID = GUFG.GroupID OR G.GroupID = GFX.GroupID)");
            qs.append("  WHERE L.URIID = " + uri.getId());
            qs.append("  AND XL.ContentRole LIKE 'XRef%'");
            qs.append("  AND LFX.Role = 'xref-link'");
            qs.append("  AND LFX2.Role = 'xref-source-manual-link'");
            qs.append("  AND (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            qs.append("  AND (G.Flags IS NULL OR G.Flags NOT LIKE '%d%')");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(LocatorForXLink.class);
            ArrayList<LocatorForXLink> arrayList = new ArrayList<LocatorForXLink>((Collection)q.execute());
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getLocatorForXLinksByURIReverseXRef", qs.toString(), before);
        }
    }

    public static int getReverseXRefCountByURI(Database db, URI uri) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        StringBuilder qs = new StringBuilder();
        try {
            Group pub = DatabaseQuery.getGroupByName(db, "public");
            qs.append("SELECT COUNT(DISTINCT XL.XLinkID) FROM XLINK XL");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX ON LFX.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L ON LFX.LocatorID = L.LocatorID");
            qs.append("    INNER JOIN LOCATOR_FOR_XLINK LFX2 ON LFX2.XLinkID = XL.XLinkID");
            qs.append("    INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID");
            qs.append("    LEFT OUTER JOIN URI_FOR_DGROUPURI UFGU ON L2.URIID = UFGU.URIID");
            qs.append("    LEFT OUTER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
            qs.append("    LEFT OUTER JOIN DGROUP_FOR_XLINK GFX ON (GFX.XLinkID = XL.XLinkID AND GFX.GroupID = " + pub.getId() + ")");
            qs.append("    INNER JOIN DGROUP G ON (G.GroupID = GUFG.GroupID OR G.GroupID = GFX.GroupID)");
            qs.append("  WHERE L.URIID = " + uri.getId());
            qs.append("  AND XL.ContentRole LIKE 'XRef%'");
            qs.append("  AND LFX.Role = 'xref-link'");
            qs.append("  AND LFX2.Role = 'xref-source-manual-link'");
            qs.append("  AND (XL.Status IS NULL OR XL.Status != 'Documentation-Old')");
            qs.append("  AND (G.Flags IS NULL OR G.Flags NOT LIKE '%d%')");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            Collection results = (Collection)q.execute();
            int n = ((Long)results.toArray()[0]).intValue();
            return n;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getReverseXRefCountByURI", qs.toString(), before);
        }
    }

    public static Set<Group> getGroupsByURIReverseXRefsComments(Database db, Long uriid) throws QueryFailedException {
        HashSet<Group> groups = new HashSet<Group>();
        groups.addAll(DatabaseQuery.getGroupsByURIReverseXRefs(db, uriid));
        groups.addAll(DatabaseQuery.getGroupsByURIComments(db, uriid));
        return groups;
    }

    public static List<XLink> getXRefsByGroupsURIContentRoleStatusCreatedStatusChanged(Database db, Collection<String> grpc, URI uri, boolean forward, Collection<String> includeTypes, Collection<String> excludeTypes, String statusNotEquals, Date creationBefore, Date statusChangedAfter, int page, int pagesize) throws QueryFailedException {
        if (grpc == null || grpc.isEmpty()) {
            return new ArrayList<XLink>();
        }
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String unique;
            if (uri == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            StringBuilder qs = new StringBuilder();
            qs.append("SELECT Distinct(X.XLinkID) AS XLinkID FROM XLINK X ");
            qs.append("  INNER JOIN LOCATOR_FOR_XLINK LFX ON X.XLinkID = LFX.XLinkID ");
            qs.append("  INNER JOIN LOCATOR L             ON LFX.LocatorID = L.LocatorID");
            qs.append("  INNER JOIN DGROUP_FOR_XLINK GFX  ON GFX.XLinkID = X.XLinkID");
            qs.append("  INNER JOIN DGROUP G              ON GFX.GroupID = G.GroupID");
            qs.append(" WHERE X.ContentRole LIKE 'XRef%'");
            qs.append("  AND L.URIID  = ").append(uri.getId());
            qs.append("  AND (");
            boolean first = true;
            for (String gp : grpc) {
                if (!first) {
                    qs.append(" OR ");
                }
                unique = DatabaseQuery.unique("group", gp);
                qs.append("G.GroupName = :").append(unique);
                params.put(unique, gp);
                first = false;
            }
            qs.append(')');
            qs.append("  AND LFX.Role ").append(forward ? "" : "NOT ").append("LIKE 'xref-source%'");
            if (forward) {
                if (includeTypes != null && !includeTypes.isEmpty()) {
                    qs.append("  AND (");
                    first = true;
                    for (String type : includeTypes) {
                        if (!first) {
                            qs.append(" OR ");
                        }
                        unique = DatabaseQuery.unique("ifl", type);
                        qs.append("LFX.Label = :").append(unique);
                        params.put(unique, type);
                        first = false;
                    }
                    qs.append(")");
                }
                if (excludeTypes != null && !excludeTypes.isEmpty()) {
                    for (String type : excludeTypes) {
                        unique = DatabaseQuery.unique("efl", type);
                        qs.append(" AND LFX.Label != :").append(unique);
                        params.put(unique, type);
                    }
                }
            }
            if (statusNotEquals != null) {
                qs.append("  AND (X.Status IS NULL OR X.Status != :statusNotEquals)");
                params.put("statusNotEquals", statusNotEquals);
            }
            if (creationBefore != null) {
                qs.append("  AND X.CreationDate <= :creationBefore");
                params.put("creationBefore", new Timestamp(creationBefore.getTime()));
            }
            if (statusChangedAfter != null) {
                qs.append("  AND (X.StatusChangedDate IS null OR X.StatusChangedDate >= :statusChangedAfter)");
                params.put("statusChangedAfter", new Timestamp(statusChangedAfter.getTime()));
            }
            qs.append(" ORDER BY XLinkID ASC");
            if (page > 0) {
                DatabaseQuery.setPaging(qs, page, pagesize);
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)qs.toString());
            q.setClass(XLink.class);
            ArrayList arrayList = new ArrayList((Collection)q.executeWithMap(params));
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getXLinksByGroupsAndURI", before);
        }
    }

    public static @Nullable Publication getPublicationByRootURI(Database db, URI uri, boolean archived) throws QueryFailedException {
        if (!archived && uri.getPath().indexOf("/archive/") != -1) {
            return null;
        }
        return DatabaseQuery.getPublicationByRootURIID(db, uri.getId());
    }

    public static @Nullable Publication getPublicationByRootURIID(Database db, Long uriid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT X2.XLinkID as XLinkID FROM XLINK X2");
            sql.append(" INNER JOIN XLINK_FOR_XLINK XX ON XX.ReplyID = X2.XLinkID ");
            sql.append(" INNER JOIN XLINK X1 ON XX.ReplyToID = X1.XLinkID");
            sql.append(" INNER JOIN URI U ON U.XLinkID = X1.XLinkID");
            sql.append(" WHERE U.URIID = ").append(uriid);
            sql.append("  AND X2.ContentRole = 'publication'");
            sql.append("  ORDER BY XLinkID ASC");
            if ("mysql".equalsIgnoreCase(DatabaseQuery.getDatabaseType())) {
                sql.append(" LIMIT 1");
            } else {
                sql.append(" FETCH FIRST 1 ROWS ONLY");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            Collection xlinks = (Collection)q.execute();
            Publication publication = xlinks == null || xlinks.isEmpty() ? null : DatabaseQuery.publicationFromXLink((XLink)xlinks.iterator().next());
            return publication;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationByRootURIGroup", before);
        }
    }

    public static @Nullable Publication getPublicationByVersion(Database db, Long versionid) throws QueryFailedException {
        long before = System.currentTimeMillis();
        try {
            Collection<XLinkForAttachedXLink> att;
            XLink release = DatabaseQuery.getXLinkById(db, versionid);
            if (release != null && !(att = release.getAttached()).isEmpty()) {
                Publication publication = DatabaseQuery.publicationFromXLink(att.iterator().next().getAttachedXLink());
                return publication;
            }
            Publication publication = null;
            return publication;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            DatabaseQuery.profiling("getPublicationByVersion", before);
        }
    }

    public static @Nullable Publication getPublicationByPublicationIDHost(Database db, String publicationId, Host host) throws DatabaseException {
        return DatabaseQuery.getPublicationByPublicationIDHost(db, publicationId, host.getId());
    }

    public static @Nullable Publication getPublicationByPublicationIDHost(Database db, String publicationId, Long host) throws DatabaseException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT X2.XLinkID as XLinkID FROM XLINK X2");
            sql.append(" INNER JOIN XLINK_FOR_XLINK XX ON XX.ReplyID = X2.XLinkID");
            sql.append(" INNER JOIN XLINK X1 ON XX.ReplyToID = X1.XLinkID");
            sql.append(" INNER JOIN URI U ON U.XLinkID = X1.XLinkID");
            sql.append(" WHERE U.HostID = ").append(host);
            sql.append("  AND U.Path NOT LIKE '%/archive/%'");
            sql.append("  AND X2.ContentRole = 'publication'");
            sql.append("  AND X2.ContentTitle = :title");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            Collection xlinks = (Collection)q.executeWithMap(Collections.singletonMap("title", publicationId));
            if (xlinks.isEmpty()) {
                Publication publication = null;
                return publication;
            }
            if (xlinks.size() > 1) {
                StringBuilder msg = new StringBuilder("The publication ID ");
                msg.append(publicationId).append(" should only be on one root URI but is used on URI IDs ");
                Iterator all = xlinks.iterator();
                while (all.hasNext()) {
                    msg.append(DatabaseQuery.publicationFromXLink((XLink)all.next()).getRootURIId());
                    if (!all.hasNext()) continue;
                    msg.append(", ");
                }
                throw new DatabaseException(msg.toString());
            }
            Publication publication = DatabaseQuery.publicationFromXLink((XLink)xlinks.iterator().next());
            return publication;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationByPublicationIDHost", before);
        }
    }

    public static @Nullable Publication getPublicationByPublicationNoHost(Database db, String publicationId) throws DatabaseException {
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT X2.XLinkID as XLinkID FROM XLINK X2");
            sql.append(" LEFT OUTER JOIN XLINK_FOR_XLINK XX ON XX.ReplyID = X2.XLinkID");
            sql.append(" LEFT OUTER JOIN XLINK X1 ON XX.ReplyToID = X1.XLinkID");
            sql.append(" LEFT OUTER JOIN URI U ON U.XLinkID = X1.XLinkID");
            sql.append(" WHERE U.URIID IS NULL");
            sql.append("  AND X2.ContentRole = 'publication'");
            sql.append("  AND X2.ContentTitle = :title");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            Collection xlinks = (Collection)q.executeWithMap(Collections.singletonMap("title", publicationId));
            if (xlinks.isEmpty()) {
                Publication publication = null;
                return publication;
            }
            if (xlinks.size() > 1) {
                StringBuilder msg = new StringBuilder("The publication ID ");
                msg.append(publicationId).append(" should only be on one root URI but is used on URI IDs ");
                Iterator all = xlinks.iterator();
                while (all.hasNext()) {
                    msg.append(DatabaseQuery.publicationFromXLink((XLink)all.next()).getRootURIId());
                    if (!all.hasNext()) continue;
                    msg.append(", ");
                }
                throw new DatabaseException(msg.toString());
            }
            XLink xl = (XLink)xlinks.iterator().next();
            Publication publication = new Publication(xl.getContentTitle(), -1L, -1L, null, null, xl.getId(), -1L, xl.getType());
            return publication;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationByPublicationNoHost", before);
        }
    }

    public static List<Publication> getAllPublications(Database db) throws QueryFailedException {
        ArrayList<Publication> publications = new ArrayList<Publication>();
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap params = new HashMap();
            StringBuilder sql = new StringBuilder("SELECT DISTINCT X.XLinkID AS XLinkID FROM XLINK X");
            sql.append(" INNER JOIN XLINK_FOR_XLINK XX ON XX.ReplyID = X.XLinkID");
            sql.append(" INNER JOIN XLINK X1 ON XX.ReplyToID = X1.XLinkID");
            sql.append(" INNER JOIN URI U ON U.XLinkID = X1.XLinkID");
            sql.append(" WHERE X.ContentRole = 'publication'");
            sql.append("  AND U.Path NOT LIKE '%/archive/%'");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            for (XLink xlink : (Collection)q.executeWithMap(params)) {
                publications.add(DatabaseQuery.publicationFromXLink(xlink));
            }
            ArrayList<Publication> arrayList = publications;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationsByGroups", before);
        }
    }

    public static List<Publication> getPublicationsByGroups(Database db, Collection<String> groups, int page, int pagesize) throws QueryFailedException {
        return DatabaseQuery.getPublicationsByGroups(db, groups, false, page, pagesize);
    }

    public static List<Publication> getPublicationsByGroups(Database db, Collection<String> groups, boolean archive, int page, int pagesize) throws QueryFailedException {
        ArrayList<Publication> publications = new ArrayList<Publication>();
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            StringBuilder sql = new StringBuilder("SELECT DISTINCT X.XLinkID AS XLinkID, U.UserTitle, U.Path FROM XLINK X");
            sql.append(" INNER JOIN XLINK_FOR_XLINK XX ON XX.ReplyID = X.XLinkID");
            sql.append(" INNER JOIN XLINK X1 ON XX.ReplyToID = X1.XLinkID");
            sql.append(" INNER JOIN URI U ON U.XLinkID = X1.XLinkID");
            sql.append(" INNER JOIN URI_FOR_DGROUPURI UFGU ON UFGU.URIID = U.URIID");
            sql.append(" INNER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
            sql.append(" INNER JOIN DGROUP G ON GUFG.GroupID = G.GroupID");
            sql.append(" WHERE X.ContentRole = 'publication'");
            if (!archive) {
                sql.append("  AND U.Path NOT LIKE '%/archive/%'");
            }
            sql.append("  AND (");
            Iterator<String> gnames = groups.iterator();
            while (gnames.hasNext()) {
                String gname = gnames.next();
                String unique = DatabaseQuery.unique("groupname", gname);
                params.put(unique, gname);
                sql.append("G.GroupName = :").append(unique);
                if (!gnames.hasNext()) continue;
                sql.append(" OR ");
            }
            sql.append(")");
            sql.append(" ORDER BY U.UserTitle ASC, U.Path ASC");
            DatabaseQuery.setPaging(sql, page, pagesize);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            for (XLink xlink : (Collection)q.executeWithMap(params)) {
                publications.add(DatabaseQuery.publicationFromXLink(xlink));
            }
            ArrayList<Publication> arrayList = publications;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationsByGroups", before);
        }
    }

    public static List<Publication> getPublicationsByLocator(Database db, Locator loc) throws QueryFailedException {
        ArrayList<Publication> publications = new ArrayList<Publication>();
        long before = System.currentTimeMillis();
        URI uri = loc.getURI();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT Distinct(PFL.XLinkID) as XLinkID FROM PUBLICATION_FOR_LOCATOR PFL");
            sql.append(" INNER JOIN LOCATOR L ON PFL.LocatorID = L.LocatorID ");
            if ("default".equals(loc.getFragment())) {
                sql.append(" WHERE L.URIID = ").append(uri.getId());
            } else {
                sql.append(" WHERE L.LocatorID = ").append(loc.getId());
                sql.append("  OR (L.Fragment = 'default' AND L.URIID = ").append(uri.getId()).append(")");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            for (XLink xlink : (Collection)q.execute()) {
                publications.add(DatabaseQuery.publicationFromXLink(xlink));
            }
            ArrayList<Publication> arrayList = publications;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationsByLocator", before);
        }
    }

    public static List<Publication> getPublicationsByURI(Database db, Long uriid) throws QueryFailedException {
        ArrayList<Publication> publications = new ArrayList<Publication>();
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT Distinct(PFL.XLinkID) as XLinkID FROM PUBLICATION_FOR_LOCATOR PFL");
            sql.append(" INNER JOIN LOCATOR L ON PFL.LocatorID = L.LocatorID ");
            sql.append(" WHERE L.URIID = ").append(uriid);
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            for (XLink xlink : (Collection)q.execute()) {
                publications.add(DatabaseQuery.publicationFromXLink(xlink));
            }
            ArrayList<Publication> arrayList = publications;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationsByURI", before);
        }
    }

    public static List<Publication> getPublicationsByURIEmbeded(Database db, Long uriid) throws QueryFailedException {
        ArrayList<Publication> publications = new ArrayList<Publication>();
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            StringBuilder sql = new StringBuilder("SELECT Distinct(PFL.XLinkID) as XLinkID FROM LOCATOR L");
            sql.append(" INNER JOIN LOCATOR_FOR_XLINK LFX ON L.LocatorID = LFX.LocatorID ");
            sql.append(" INNER JOIN XLINK X ON LFX.XLinkID = X.XLinkID ");
            sql.append(" INNER JOIN LOCATOR_FOR_XLINK LFX2 ON X.XLinkID = LFX2.XLinkID ");
            sql.append(" INNER JOIN LOCATOR L2 ON LFX2.LocatorID = L2.LocatorID ");
            sql.append(" INNER JOIN LOCATOR L3 ON L2.URIID = L3.URIID ");
            sql.append(" INNER JOIN PUBLICATION_FOR_LOCATOR PFL ON (PFL.LocatorID = L3.LocatorID OR PFL.LocatorID = L2.LocatorID)");
            sql.append(" WHERE X.ContentRole LIKE 'XRef%'");
            sql.append("  AND L.URIID  = ").append(uriid);
            sql.append("  AND L.Fragment = 'default'");
            sql.append("  AND L3.Fragment = 'default'");
            sql.append("  AND LFX.Role = 'xref-link'");
            sql.append("  AND LFX2.Role != 'xref-link'");
            sql.append("  AND LFX2.Label = 'embed'");
            sql.append("  AND (X.Status IS NULL OR X.Status != 'Documentation-Old')");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            for (XLink xlink : (Collection)q.execute()) {
                publications.add(DatabaseQuery.publicationFromXLink(xlink));
            }
            ArrayList<Publication> arrayList = publications;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationsByURIEmbeded", before);
        }
    }

    public static List<Publication> getPublicationsByRootURIGroups(Database db, Long uriid, Collection<String> groups, boolean archive) throws QueryFailedException {
        ArrayList<Publication> publications = new ArrayList<Publication>();
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            StringBuilder sql = new StringBuilder("SELECT Distinct(X2.XLinkID) as XLinkID FROM XLINK X2");
            sql.append(" INNER JOIN XLINK_FOR_XLINK XX ON XX.ReplyID = X2.XLinkID ");
            sql.append(" INNER JOIN XLINK X1 ON XX.ReplyToID = X1.XLinkID");
            sql.append(" INNER JOIN URI U ON U.XLinkID = X1.XLinkID");
            sql.append(" INNER JOIN DGROUP_FOR_XLINK GFX ON GFX.XLinkID = X2.XLinkID");
            sql.append(" INNER JOIN DGROUP G ON GFX.GroupID = G.GroupID");
            sql.append(" WHERE (X2.ContentRole = 'publication'");
            if (archive) {
                sql.append("  OR X2.ContentRole = 'archive-publication'");
            }
            sql.append("  )");
            sql.append("  AND U.URIID = ").append(uriid);
            sql.append("  AND (G.flags LIKE '%p%'");
            for (String gname : groups) {
                String unique = DatabaseQuery.unique("groupname", gname);
                params.put(unique, gname);
                sql.append(" OR G.GroupName = :").append(unique);
            }
            sql.append(") ORDER BY XLinkID DESC");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            for (XLink xlink : (Collection)q.executeWithMap(params)) {
                publications.add(DatabaseQuery.publicationFromXLink(xlink));
            }
            ArrayList<Publication> arrayList = publications;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationsByRootURIGroups", before);
        }
    }

    public static List<Publication> getPublicationsByURIGroups(Database db, Long uriid, Collection<String> groups) throws QueryFailedException {
        ArrayList<Publication> publications = new ArrayList<Publication>();
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            StringBuilder sql = new StringBuilder("SELECT Distinct(PFL.XLinkID) as XLinkID FROM PUBLICATION_FOR_LOCATOR PFL");
            sql.append(" INNER JOIN LOCATOR L ON PFL.LocatorID = L.LocatorID ");
            if (groups.contains("admin")) {
                sql.append(" WHERE L.URIID = ").append(uriid);
            } else {
                sql.append(" INNER JOIN XLINK_FOR_XLINK XX ON XX.ReplyID = PFL.XLinkID");
                sql.append(" INNER JOIN XLINK X1 ON XX.ReplyToID = X1.XLinkID");
                sql.append(" INNER JOIN URI U ON U.XLinkID = X1.XLinkID");
                sql.append(" INNER JOIN URI_FOR_DGROUPURI UFGU ON UFGU.URIID = U.URIID");
                sql.append(" INNER JOIN DGROUPURI_FOR_DGROUP GUFG ON GUFG.GroupURIID = UFGU.GroupURIID");
                sql.append(" INNER JOIN DGROUP G ON GUFG.GroupID = G.GroupID");
                sql.append(" WHERE L.URIID = ").append(uriid);
                sql.append("  AND (G.flags LIKE '%p%'");
                for (String gname : groups) {
                    String unique = DatabaseQuery.unique("groupname", gname);
                    params.put(unique, gname);
                    sql.append(" OR G.GroupName = :").append(unique);
                }
                sql.append(")");
            }
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            for (XLink xlink : (Collection)q.executeWithMap(params)) {
                publications.add(DatabaseQuery.publicationFromXLink(xlink));
            }
            Iterator<String> iterator = publications;
            return iterator;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationsByURIGroups", before);
        }
    }

    public static List<Publication> getPublicationsByProjectType(Database db, String project, String type) throws QueryFailedException {
        ArrayList<Publication> publications = new ArrayList<Publication>();
        long before = System.currentTimeMillis();
        Query q = null;
        try {
            String unique;
            HashMap<String, Object> params = new HashMap<String, Object>();
            StringBuilder sql = new StringBuilder("SELECT X2.XLinkID as XLinkID FROM XLINK X2");
            sql.append(" INNER JOIN XLINK_FOR_XLINK XX ON XX.ReplyID = X2.XLinkID");
            sql.append(" INNER JOIN XLINK X1 ON XX.ReplyToID = X1.XLinkID");
            sql.append(" INNER JOIN URI U ON U.XLinkID = X1.XLinkID");
            sql.append(" INNER JOIN DGROUP_FOR_XLINK GFX ON GFX.XLinkID = X2.XLinkID");
            sql.append(" INNER JOIN DGROUP G ON GFX.GroupID = G.GroupID");
            sql.append(" WHERE X2.ContentRole = 'publication'");
            sql.append("  AND U.Path NOT LIKE '%/archive/%'");
            if (type != null) {
                unique = DatabaseQuery.unique("type", type);
                sql.append(" AND X2.Type = :").append(unique);
                params.put(unique, type);
            }
            unique = DatabaseQuery.unique("groupname", project);
            sql.append("  AND G.GroupName LIKE :").append(unique);
            params.put(unique, project + "-%");
            q = db.getPersistenceManager().newQuery("javax.jdo.query.SQL", (Object)sql.toString());
            q.setClass(XLink.class);
            for (XLink xlink : (Collection)q.executeWithMap(params)) {
                publications.add(DatabaseQuery.publicationFromXLink(xlink));
            }
            ArrayList<Publication> arrayList = publications;
            return arrayList;
        }
        catch (JDOException ex) {
            DatabaseQuery.logDatabaseException(ex);
            throw new QueryFailedException(ex.getMessage());
        }
        finally {
            if (q != null) {
                q.closeAll();
            }
            q = null;
            DatabaseQuery.profiling("getPublicationsByProjectType", before);
        }
    }

    private static Publication publicationFromXLink(XLink xlink) throws ObjectStateException {
        URI uri;
        XLink root = xlink;
        Iterator<XLink> thread = xlink.getReplyTos();
        if (thread.hasNext()) {
            root = thread.next();
        }
        if ((uri = root.getUri()) == null) {
            throw new ObjectStateException("Publication " + xlink.getContentTitle() + " has no root document");
        }
        Group defaultGroup = null;
        for (GroupURI guri : uri.getGroupURIsCol()) {
            for (Group group : guri.getGroupsCol()) {
                String defaultPath = GlobalSettings.getSitePrefix() + "/" + group.getName().replace('-', '/') + "/*";
                if (!defaultPath.equals(guri.getPath()) || defaultGroup != null && defaultGroup.getName().length() >= group.getName().length()) continue;
                defaultGroup = group;
            }
        }
        Group first = null;
        boolean found = false;
        for (GroupForXLink gfx : xlink.getGroupsForXLinkCol()) {
            Group grp = gfx.getGroup();
            if (first == null && !"admin".equals(grp.getName())) {
                first = grp;
            }
            if (defaultGroup == null || gfx.getGroup().getId() != defaultGroup.getId()) continue;
            found = true;
            break;
        }
        return new Publication(xlink, uri, found ? defaultGroup : first);
    }

    public static void setPaging(Query query, int page, int pagesize) {
        DatabaseQuery.setPaging(query, page, pagesize, false);
    }

    public static void setPaging(Query query, int page, int pagesize, boolean plusone) {
        pagesize = DatabaseQuery.getMaxPageSize(pagesize);
        if (page < 1) {
            page = 1;
        }
        query.setRange((long)(pagesize * (page - 1)), (long)(pagesize * page + (plusone ? 1 : 0)));
    }

    private static void setPaging(StringBuilder sql, int page, int pagesize) {
        DatabaseQuery.setPaging(sql, page, pagesize, false);
    }

    private static void setPaging(StringBuilder sql, int page, int pagesize, boolean plusone) {
        String dbtype = DatabaseQuery.getDatabaseType();
        pagesize = DatabaseQuery.getMaxPageSize(pagesize);
        if (page < 1) {
            page = 1;
        }
        int skip = pagesize * (page - 1);
        pagesize += plusone ? 1 : 0;
        if ("mysql".equalsIgnoreCase(dbtype)) {
            if (pagesize >= 0) {
                sql.append(" LIMIT " + pagesize);
            }
            if (skip > 0) {
                sql.append(" OFFSET " + skip);
            }
        } else {
            if (skip > 0) {
                sql.append(" OFFSET " + skip + " ROWS");
            }
            if (pagesize >= 0) {
                sql.append(" FETCH FIRST " + pagesize + " ROWS ONLY");
            }
        }
    }

    public static int getMaxPageSize(int pagesize) {
        int max = GlobalSettings.getInt((String)"maxPageSize", (int)10000);
        if (pagesize < 0 || pagesize > max) {
            pagesize = max;
        }
        return pagesize;
    }

    private static String unique(String prefix, String s) {
        if (s == null) {
            return prefix + "0";
        }
        int hash = s.hashCode();
        return prefix + Math.abs(hash == Integer.MIN_VALUE ? 0 : hash);
    }

    public static String getDatabaseType() {
        return Settings.get((SettingsFile)SettingsFile.DATABASE, (String)"DatabaseType");
    }

    private static Long getLong(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Long ? ((Long)value).longValue() : ((Integer)value).longValue();
    }

    private static Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Date ? (Date)value : Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
    }

    static {
        String profilingMs = GlobalSettings.get((String)"profiling");
        if (profilingMs != null) {
            try {
                profiling = Long.parseLong(profilingMs);
            }
            catch (NumberFormatException ex) {
                profiling = 5000L;
            }
        }
    }

    public static class URIFragmentPair {
        private final Long uri;
        private final String fragment;

        public URIFragmentPair(Long u, String f) {
            this.uri = u;
            this.fragment = f;
        }

        public Long getUri() {
            return this.uri;
        }

        public String getFragment() {
            return this.fragment;
        }

        public boolean equals(Object obj) {
            if (obj instanceof URIFragmentPair) {
                URIFragmentPair other = (URIFragmentPair)obj;
                return other.uri.longValue() == this.uri.longValue() && (this.fragment == null && other.fragment == null || this.fragment != null && this.fragment.equals(other.fragment));
            }
            return false;
        }

        public int hashCode() {
            return this.uri.hashCode() * 13 + (this.fragment == null ? 0 : this.fragment.hashCode() * 7);
        }
    }
}

