/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.utils;

import com.pageseeder.publisher.exceptions.AlreadyRunningException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.pageseeder.xmlwriter.XMLWriterImpl;

public final class ServletUtils {
    private ServletUtils() {
    }

    public static void writeError(String processid, String error, String msg, Map<String, String> properties, Writer out) throws IOException {
        ServletUtils.writeError(processid, error, msg, properties, null, out);
    }

    public static void writeError(String processid, String error, String msg, Map<String, String> properties, Throwable t, Writer out) throws IOException {
        XMLWriterImpl xml = new XMLWriterImpl(out);
        xml.openElement("check", true);
        xml.openElement("publish", true);
        xml.attribute("id", processid);
        xml.element("title", error);
        xml.openElement("parameters");
        for (String prop : properties.keySet()) {
            xml.element(prop, properties.get(prop).toString());
        }
        xml.closeElement();
        xml.element("status", "error");
        xml.openElement("message");
        xml.attribute("type", "error");
        xml.writeText(msg);
        xml.closeElement();
        xml.openElement("message");
        xml.attribute("type", "fail");
        xml.writeText("Action did not run.");
        xml.closeElement();
        if (t != null) {
            StringWriter stacktrace = new StringWriter();
            t.printStackTrace(new PrintWriter(stacktrace));
            xml.element("stacktrace", stacktrace.toString());
            stacktrace.close();
        }
        xml.closeElement();
        xml.closeElement();
    }

    public static void alreadyRunning(String processid, AlreadyRunningException ex, Map<String, String> properties, Writer out) throws IOException {
        XMLWriterImpl xml = new XMLWriterImpl(out);
        xml.openElement("root", true);
        xml.openElement("publish", true);
        xml.attribute("id", processid);
        xml.element("title", "Publishing Already Running");
        xml.openElement("parameters");
        for (String prop : properties.keySet()) {
            xml.element(prop, properties.get(prop).toString());
        }
        xml.closeElement();
        xml.element("status", "error");
        xml.openElement("message");
        xml.attribute("type", "info");
        xml.openElement("other-job");
        xml.attribute("id", ex.getJobID());
        xml.attribute("status", ex.getStatus());
        xml.attribute("message", ex.getMessage());
        xml.closeElement();
        xml.closeElement();
        xml.openElement("message");
        xml.attribute("type", "error");
        xml.writeText("A publishing action is already running on this object, please try again in a few minutes.");
        xml.closeElement();
        xml.openElement("message");
        xml.attribute("type", "fail");
        xml.writeText("Action did not run.");
        xml.closeElement();
        xml.closeElement();
        xml.closeElement();
    }
}

