/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.utils;

import com.pageseeder.common.properties.Settings;
import com.pageseeder.publisher.core.PublishManager;
import java.io.File;
import java.io.FileFilter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilesCleanerThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesCleanerThread.class);
    private static final long SLEEP_DELAY = 1800000L;
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private int counter = 1;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "files-cleaner-" + this.counter++);
        }
    });
    private static final Map<String, FilesCleanerThread> CLEANERS = new HashMap<String, FilesCleanerThread>();
    private final FilesCleaner cleaner;
    private long lastCleanUpDate = -1L;
    private boolean shouldStop = false;

    private FilesCleanerThread(FilesCleaner thecleaner) {
        this.cleaner = thecleaner;
    }

    @Override
    public void run() {
        while (!this.shouldStop) {
            try {
                Thread.sleep(1800000L);
            }
            catch (InterruptedException ex) {
                if (this.shouldStop) break;
                LOGGER.error("Files cleaner thread was interrupted", (Throwable)ex);
                break;
            }
            if (this.lastCleanUpDate >= FilesCleanerThread.twentyFourHoursAgo()) continue;
            this.cleaner.clean();
            this.lastCleanUpDate = System.currentTimeMillis();
        }
    }

    public static void startSessionFilesCleaner() {
        FilesCleanerThread.startFilesCleaner("session", new SessionFilesCleaner());
    }

    public static void startWorkingFilesCleaner() {
        FilesCleanerThread.startFilesCleaner("working", new WorkingFilesCleaner());
    }

    private static void startFilesCleaner(String name, FilesCleaner cleaner) {
        if (!CLEANERS.containsKey(name)) {
            FilesCleanerThread thread = new FilesCleanerThread(cleaner);
            EXECUTOR.execute(thread);
            CLEANERS.put(name, thread);
        }
    }

    public static void stopAllFilesCleaner() {
        for (String key : CLEANERS.keySet()) {
            FilesCleanerThread.CLEANERS.get((Object)key).shouldStop = true;
        }
        EXECUTOR.shutdownNow();
    }

    private static long twelveHoursAgo() {
        Calendar now = Calendar.getInstance();
        now.add(10, -12);
        return now.getTimeInMillis();
    }

    private static long twentyFourHoursAgo() {
        Calendar now = Calendar.getInstance();
        now.add(10, -24);
        return now.getTimeInMillis();
    }

    private static long threeDaysAgo() {
        Calendar now = Calendar.getInstance();
        now.add(5, -3);
        return now.getTimeInMillis();
    }

    private static FileFilter buildFileFilter(long limit) {
        return file -> {
            if (file.isFile()) {
                return file.lastModified() < limit;
            }
            return file.isDirectory();
        };
    }

    private static class SessionFilesCleaner
    implements FilesCleaner {
        private final File root = new File(Settings.getContextPath(), "/WEB-INF/state/publish/session");
        private final FileFilter filter = FilesCleanerThread.buildFileFilter(FilesCleanerThread.twelveHoursAgo());

        SessionFilesCleaner() {
        }

        @Override
        public void clean() {
            if (!this.root.exists()) {
                return;
            }
            File[] toClean = this.root.listFiles();
            if (toClean != null) {
                for (File dir : toClean) {
                    if (!dir.isDirectory()) continue;
                    this.clean(dir);
                }
            }
        }

        private void clean(File folder) {
            String[] left;
            File[] toClean = folder.listFiles(this.filter);
            if (toClean != null) {
                for (File f : toClean) {
                    if (f.isFile()) {
                        f.delete();
                        continue;
                    }
                    this.clean(f);
                }
            }
            if ((left = folder.list()) != null && left.length == 0) {
                folder.delete();
            }
        }
    }

    private static class WorkingFilesCleaner
    implements FilesCleaner {
        private final File root = new File(Settings.getContextPath(), "/WEB-INF/state/publish/working");
        private final FileFilter filter = FilesCleanerThread.buildFileFilter(FilesCleanerThread.threeDaysAgo());

        WorkingFilesCleaner() {
        }

        @Override
        public void clean() {
            this.clean(this.root, null);
        }

        private boolean clean(File folder, File parentValidWorkingFolder) {
            File wf;
            if (!folder.exists()) {
                return true;
            }
            PublishManager pm = PublishManager.getInstance();
            File[] toClean = folder.listFiles(this.filter);
            if (toClean != null) {
                for (File f : toClean) {
                    if (parentValidWorkingFolder != null) {
                        if (pm.isWorkingFolderInUse(parentValidWorkingFolder)) {
                            return false;
                        }
                        if (f.isFile()) {
                            if (f.delete()) continue;
                            LOGGER.error("Unable to delete: " + f.getAbsolutePath());
                            continue;
                        }
                        if (this.clean(f, parentValidWorkingFolder)) continue;
                        return false;
                    }
                    if (this.isValidWorkingFolder(f)) {
                        if (pm.isWorkingFolderInUse(f)) {
                            return false;
                        }
                        if (this.clean(f, f)) continue;
                        return false;
                    }
                    if (!f.isDirectory() || this.clean(f, null)) continue;
                    return false;
                }
            }
            String[] left = folder.list();
            File file = parentValidWorkingFolder != null ? parentValidWorkingFolder : (wf = this.isValidWorkingFolder(folder) ? folder : null);
            if (left != null && left.length == 0 && wf != null) {
                if (pm.isWorkingFolderInUse(wf)) {
                    return false;
                }
                folder.delete();
            }
            return true;
        }

        private boolean isValidWorkingFolder(File f) {
            return f.isDirectory() && ("ps-upload".equals(f.getName()) || "ps-group".equals(f.getName()) || "ps-uri".equals(f.getName()) || "ps-folder".equals(f.getName()));
        }
    }

    private static interface FilesCleaner {
        public void clean();
    }
}

