/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.core;

import com.pageseeder.publisher.core.PublishThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PublishThreadList {
    private Map<String, PublishThread> threads = new ConcurrentHashMap<String, PublishThread>();
    private Map<String, String> workingfolders = new ConcurrentHashMap<String, String>();
    private Map<String, String> ids = new ConcurrentHashMap<String, String>();

    public void add(String processID, String processKey, PublishThread pthread, String workingfolder) {
        this.ids.put(processKey, processID);
        this.threads.put(processID, pthread);
        this.workingfolders.put(processID, workingfolder);
    }

    public List<String> getIDs() {
        return new ArrayList<String>(this.ids.values());
    }

    public PublishThread getWithID(String id) {
        if (id != null) {
            return this.threads.get(id);
        }
        return null;
    }

    public boolean hasWorkingFolder(String folder) {
        return this.workingfolders.values().contains(folder);
    }

    public PublishThread getWithKey(String key) {
        return this.getWithID(this.ids.get(key));
    }

    public PublishThread removeWithKey(String key) {
        String id = this.ids.remove(key);
        if (id != null) {
            this.workingfolders.remove(id);
            return this.threads.remove(id);
        }
        return null;
    }

    public PublishThread removeWithID(String id) {
        if (id != null) {
            String key = null;
            for (String akey : this.ids.keySet()) {
                if (!id.equals(this.ids.get(akey))) continue;
                key = akey;
                break;
            }
            if (key != null) {
                this.ids.remove(key);
            }
            this.workingfolders.remove(id);
            return this.threads.remove(id);
        }
        return null;
    }

    public boolean hasKey(String key) {
        return this.getWithID(this.ids.get(key)) != null;
    }
}

