/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class Parameter {
    private final String name;
    private final String value;

    public Parameter(String name, String value) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public String toQueryString() {
        return this.encodedName() + "=" + this.encodedValue();
    }

    public String encodedName() {
        return URLEncoder.encode(this.name, StandardCharsets.UTF_8);
    }

    public String encodedValue() {
        return URLEncoder.encode(this.value, StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return Objects.equals(this.name, parameter.name) && Objects.equals(this.value, parameter.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return this.toQueryString();
    }
}

