/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class Localiser {
    private static Locale locale = null;
    private static boolean displayCodesInMessages = false;
    private static Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private static Map<String, MessageFormat> msgFormats = new ConcurrentHashMap<String, MessageFormat>();

    public static void registerBundle(String bundleName, ClassLoader loader) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, loader);
            for (String key : bundle.keySet()) {
                properties.put(key, bundle.getString(key));
            }
        }
        catch (MissingResourceException mre) {
            NucleusLogger.GENERAL.error("ResourceBundle " + bundleName + " for locale " + locale + " was not found!");
        }
    }

    public static String msg(String messageKey) {
        return Localiser.getMessage(messageKey, new Object[0]);
    }

    public static String msg(String messageKey, long arg) {
        Object[] args = new Object[]{String.valueOf(arg)};
        return Localiser.getMessage(messageKey, args);
    }

    public static String msg(String messageKey, Object ... args) {
        return Localiser.getMessage(messageKey, args);
    }

    private static final String getMessage(String messageKey, Object ... msgArgs) {
        char c;
        String stringForKey;
        if (messageKey == null) {
            NucleusLogger.GENERAL.error("Attempt to retrieve resource with NULL name !");
            return null;
        }
        if (msgArgs != null) {
            for (int i = 0; i < msgArgs.length; ++i) {
                if (msgArgs[i] == null) {
                    msgArgs[i] = "";
                    continue;
                }
                if (!Throwable.class.isAssignableFrom(msgArgs[i].getClass())) continue;
                msgArgs[i] = StringUtils.getStringFromException((Throwable)msgArgs[i]);
            }
        }
        if ((stringForKey = properties.get(messageKey)) == null) {
            NucleusLogger.GENERAL.error("Message \"" + messageKey + "\" doesn't exist in any registered ResourceBundle");
            return null;
        }
        if (displayCodesInMessages && (c = messageKey.charAt(0)) >= '0' && c <= '9') {
            stringForKey = "[DN-" + messageKey + "] " + stringForKey;
        }
        if (msgArgs != null) {
            MessageFormat formatter = msgFormats.get(stringForKey);
            if (formatter == null) {
                formatter = new MessageFormat(stringForKey);
                msgFormats.put(stringForKey, formatter);
            }
            return formatter.format(msgArgs);
        }
        return stringForKey;
    }

    static {
        String language = System.getProperty("datanucleus.localisation.language");
        locale = language == null ? Locale.getDefault() : new Locale(language);
        String messageCodes = System.getProperty("datanucleus.localisation.messageCodes");
        if (messageCodes != null) {
            displayCodesInMessages = Boolean.parseBoolean(messageCodes);
        }
        Localiser.registerBundle("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    }
}

