/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.Duration;
import org.datanucleus.store.types.converters.TypeConverter;

public class DurationDoubleConverter
implements TypeConverter<Duration, Double> {
    private static final long serialVersionUID = 8560242792431943497L;

    @Override
    public Duration toMemberType(Double val) {
        if (val == null) {
            return null;
        }
        return Duration.ofNanos((long)(val * 1.0E9));
    }

    @Override
    public Double toDatastoreType(Duration date) {
        if (date == null) {
            return null;
        }
        return (double)date.getSeconds() + (double)date.getNano() / 1.0E9;
    }
}

