/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.ContainerAdapter;
import org.datanucleus.store.types.TypeManager;

public class NullifyRelationFieldManager
extends AbstractFieldManager {
    private final ObjectProvider op;

    public NullifyRelationFieldManager(ObjectProvider op) {
        this.op = op;
    }

    @Override
    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd;
        RelationType relType;
        Object value = this.op.provideField(fieldNumber);
        if (value != null && (relType = (mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getRelationType(this.op.getExecutionContext().getClassLoaderResolver())) != RelationType.NONE) {
            if (mmd.hasContainer()) {
                TypeManager typeManager = this.op.getExecutionContext().getTypeManager();
                ContainerAdapter containerAdapter = typeManager.getContainerAdapter(value);
                containerAdapter.clear();
                return containerAdapter.getContainer();
            }
            this.op.makeDirty(fieldNumber);
            return null;
        }
        return value;
    }

    @Override
    public boolean fetchBooleanField(int fieldNumber) {
        return true;
    }

    @Override
    public char fetchCharField(int fieldNumber) {
        return '0';
    }

    @Override
    public byte fetchByteField(int fieldNumber) {
        return 0;
    }

    @Override
    public double fetchDoubleField(int fieldNumber) {
        return 0.0;
    }

    @Override
    public float fetchFloatField(int fieldNumber) {
        return 0.0f;
    }

    @Override
    public int fetchIntField(int fieldNumber) {
        return 0;
    }

    @Override
    public long fetchLongField(int fieldNumber) {
        return 0L;
    }

    @Override
    public short fetchShortField(int fieldNumber) {
        return 0;
    }

    @Override
    public String fetchStringField(int fieldNumber) {
        return "";
    }
}

