/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.query.compiler.NodeType;

public class Node {
    protected NodeType nodeType;
    protected Object nodeValue;
    private int cursorPos = -1;
    protected Node parent;
    protected List<Node> childNodes = new ArrayList<Node>();
    protected List<Node> properties = null;

    public Node(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public Node(NodeType nodeType, Object nodeValue) {
        this.nodeType = nodeType;
        this.nodeValue = nodeValue;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeValue(Object val) {
        this.nodeValue = val;
    }

    public Object getNodeValue() {
        return this.nodeValue;
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public List<Node> getProperties() {
        return this.properties;
    }

    public void addProperty(Node node) {
        if (this.properties == null) {
            this.properties = new ArrayList<Node>();
        }
        this.properties.add(node);
    }

    public void setPropertyAtPosition(int position, Node node) {
        if (this.properties == null) {
            return;
        }
        if (position >= this.properties.size()) {
            return;
        }
        this.properties.set(position, node);
    }

    public List<Node> getChildNodes() {
        return this.childNodes;
    }

    public void removeChildNode(Node node) {
        this.childNodes.remove(node);
    }

    public Node insertChildNode(Node node) {
        this.childNodes.add(0, node);
        return node;
    }

    public Node insertChildNode(Node node, int position) {
        this.childNodes.add(position, node);
        return node;
    }

    public Node appendChildNode(Node node) {
        this.childNodes.add(node);
        return node;
    }

    public Node getChildNode(int index) {
        return this.childNodes.get(index);
    }

    public Node getFirstChild() {
        this.cursorPos = 0;
        if (this.childNodes.size() < 1) {
            return null;
        }
        return this.childNodes.get(0);
    }

    public Node getNextChild() {
        ++this.cursorPos;
        if (this.childNodes.size() <= this.cursorPos) {
            return null;
        }
        return this.childNodes.get(this.cursorPos);
    }

    public boolean hasNextChild() {
        return this.cursorPos + 1 < this.childNodes.size();
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getParent() {
        return this.parent;
    }

    public String getNodeId() {
        StringBuilder sb = new StringBuilder();
        for (Node node = this; node != null && node.getNodeType() == NodeType.IDENTIFIER; node = node.getParent()) {
            if (sb.length() > 0) {
                sb.insert(0, ".");
            }
            sb.insert(0, node.getNodeValue());
        }
        return sb.toString();
    }

    public String getNodeChildId() {
        StringBuilder sb = new StringBuilder();
        for (Node node = this; node != null && node.getNodeType() == NodeType.IDENTIFIER; node = node.getFirstChild()) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(node.getNodeValue());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.printTree(0));
        return sb.toString();
    }

    public Node clone(Node parent) {
        Node n = new Node(this.nodeType, this.nodeValue);
        n.parent = parent;
        if (!this.childNodes.isEmpty()) {
            for (Node child : this.childNodes) {
                Node c = child.clone(n);
                n.appendChildNode(c);
            }
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Node prop : this.properties) {
                Node p = prop.clone(n);
                n.addProperty(p);
            }
        }
        return n;
    }

    private String printTree(int indentation) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.indent(indentation));
        String nodeTypeStr = this.nodeType.toString();
        sb.append("[" + nodeTypeStr + " : " + this.nodeValue);
        if (this.properties != null) {
            sb.append(this.indent(indentation)).append("(");
            for (i = 0; i < this.properties.size(); ++i) {
                sb.append(this.properties.get(i).printTree(indentation + 1));
                if (i >= this.properties.size() - 1) continue;
                sb.append(",");
            }
            sb.append(this.indent(indentation)).append(")");
        }
        if (!this.childNodes.isEmpty()) {
            sb.append(".");
            for (i = 0; i < this.childNodes.size(); ++i) {
                sb.append(this.childNodes.get(i).printTree(indentation + 1));
                if (i >= this.childNodes.size() - 1) continue;
                sb.append(",");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String indent(int indentation) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (int i = 0; i < 4 * indentation; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

