/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.utils.XMLUtils;

public final class URIObject {
    private String _decodedpath = null;
    private String _path = null;
    private String _relativepath = null;
    private String _id = null;
    private String _labels = null;
    private String _docid = null;
    private String _title = null;
    private String _behavior = null;
    private String _format = null;
    private String _type = null;
    private final StringBuffer xrefs = new StringBuffer();
    private final StringBuffer reversexrefs = new StringBuffer();

    public String getPath() {
        return this._path;
    }

    public boolean isFolder() {
        return "folder".equals(this._type) || this._type == null && this.getPath() != null && this.getPath().endsWith("/");
    }

    public String getDocid() {
        return this._docid;
    }

    public String getFormat() {
        return this._format;
    }

    public String getId() {
        return this._id;
    }

    public String getLabels() {
        return this._labels;
    }

    public String getRelativepath() {
        return this._relativepath;
    }

    public String getDecodedPath() {
        return this._decodedpath;
    }

    public String getTitle() {
        return this._title;
    }

    public String getType() {
        return this._type;
    }

    public void setRelativepath(String relativepath) {
        this._relativepath = relativepath;
    }

    public void setDocid(String docid) {
        this._docid = docid;
    }

    public String getBehavior() {
        return this._behavior;
    }

    public void setBehavior(String behavior) {
        this._behavior = behavior;
        this._format = this._behavior == null || this._behavior.indexOf(45) == -1 ? null : this._behavior.substring(0, this._behavior.indexOf(45));
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setLabels(String labels) {
        this._labels = labels;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public void setDecodedpath(String dpath) {
        this._decodedpath = dpath;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void appendXRef(String xml) {
        this.xrefs.append(xml);
    }

    public void appendReverseXRef(String xml) {
        this.reversexrefs.append(xml);
    }

    public String toXML() {
        StringBuilder xml = new StringBuilder();
        this.toXML(xml);
        return xml.toString();
    }

    public void toXML(StringBuilder xml) {
        xml.append("<uri>");
        if (this._decodedpath != null) {
            xml.append("<decodedpath>").append(XMLUtils.escape(this._decodedpath)).append("</decodedpath>");
        }
        if (this._path != null) {
            xml.append("<path>").append(XMLUtils.escape(this._path)).append("</path>");
        }
        if (this._id != null) {
            xml.append("<id>").append(XMLUtils.escape(this._id)).append("</id>");
        }
        if (this._relativepath != null) {
            xml.append("<relativepath>").append(XMLUtils.escape(this._relativepath)).append("</relativepath>");
        }
        if (this._labels != null) {
            xml.append("<labels>").append(XMLUtils.escape(this._labels)).append("</labels>");
        }
        if (this._docid != null) {
            xml.append("<documentid>").append(XMLUtils.escape(this._docid)).append("</documentid>");
        }
        if (this._title != null) {
            xml.append("<usertitle>").append(XMLUtils.escape(this._title)).append("</usertitle>");
        }
        if (this._behavior != null) {
            xml.append("<behavior>").append(XMLUtils.escape(this._behavior)).append("</behavior>");
        }
        if (this._type != null) {
            xml.append("<type>").append(XMLUtils.escape(this._type)).append("</type>");
        }
        if (this.xrefs.length() > 0) {
            xml.append("<xrefs>").append(this.xrefs).append("</xrefs>");
        }
        if (this.reversexrefs.length() > 0) {
            xml.append("<reversexrefs>").append(this.reversexrefs).append("</reversexrefs>");
        }
        xml.append("</uri>");
    }
}

