/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.DefaultThreadLogger;
import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import com.pageseeder.publishapi.utils.ThreadLogger;
import com.pageseeder.publishapi.utils.XMLUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tools.ant.util.ReaderInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ThreadPoller {
    private long pollingIntervalMs = 2000L;
    private String threadid = null;
    private ThreadLogger logger = null;
    private final ExternalConfig _config;

    public ThreadPoller(ExternalConfig config) {
        this._config = config;
    }

    public void setPollingInterval(long milliseconds) {
        this.pollingIntervalMs = milliseconds;
    }

    public void setLogger(ThreadLogger logger) {
        this.logger = logger;
    }

    public String getThreadID() {
        return this.threadid;
    }

    public String poll(String startResponse) throws PageseederException {
        if (this.logger == null) {
            this.logger = new DefaultThreadLogger();
        }
        if (startResponse == null) {
            throw new PageseederException("Cannot poll from empty response");
        }
        ThreadResponseHandler handler = new ThreadResponseHandler();
        XMLUtils.parse((InputStream)new ReaderInputStream((Reader)new StringReader(startResponse)), handler);
        this.logger.addStatus(handler.threadstatus, handler.getThreadMessage());
        this.threadid = handler.threadid;
        this.logger.setThreadID(this.threadid);
        String resp = startResponse;
        while (this.threadid != null && !handler.isThreadFinished()) {
            try {
                Thread.sleep(this.pollingIntervalMs);
            }
            catch (InterruptedException ex) {
                throw new PageseederException("Interrupted while waiting delay", ex);
            }
            Request checkRequest = new Request("/service/threads/" + this.threadid + "/progress", this._config);
            checkRequest.send();
            resp = checkRequest.getResponseAsString();
            XMLUtils.parse((InputStream)new ReaderInputStream((Reader)new StringReader(resp)), handler);
            this.logger.addStatus(handler.threadstatus, handler.getThreadMessage());
        }
        this.logger.complete();
        return resp;
    }

    private static class ThreadResponseHandler
    extends DefaultHandler {
        private String threadid = null;
        private ThreadLogger.Status threadstatus = null;
        private StringBuilder xml = new StringBuilder();
        private boolean inMessage = false;

        private ThreadResponseHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.inMessage) {
                this.xml.append("<").append(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.xml.append(" ").append(attributes.getQName(i)).append("='").append(XMLUtils.escapeForAttribute(attributes.getValue(i))).append("'");
                }
                this.xml.append(">");
            }
            if ("thread".equals(qName)) {
                this.threadid = attributes.getValue("id");
                this.threadstatus = ThreadLogger.Status.fromString(attributes.getValue("status"));
            } else if ("message".equals(qName)) {
                this.inMessage = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("message".equals(qName)) {
                this.inMessage = false;
            }
            if (this.inMessage) {
                this.xml.append("</").append(qName).append(">");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inMessage) {
                this.xml.append(XMLUtils.escape(new String(ch, start, length)));
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.xml.setLength(0);
            this.threadstatus = null;
            this.inMessage = false;
        }

        boolean isThreadFinished() {
            return this.threadstatus == ThreadLogger.Status.CANCELLED || this.threadstatus == ThreadLogger.Status.FAILED || this.threadstatus == ThreadLogger.Status.COMPLETED;
        }

        public String getThreadMessage() {
            return this.xml.toString();
        }
    }
}

