/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import com.pageseeder.publishapi.utils.URIObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class DownloadedItem {
    private final URIObject uri;
    private final Map<String, String> parameters;
    private final ExternalConfig config;

    public DownloadedItem(ExternalConfig conf, URIObject u, Map<String, String> params) {
        this.config = conf;
        this.uri = u;
        this.parameters = params;
    }

    public String getItempath() {
        return this.uri.getRelativepath() == null ? this.uri.getPath() : this.uri.getRelativepath();
    }

    public boolean isFolder() {
        return this.uri.isFolder();
    }

    public URIObject getURI() {
        return this.uri;
    }

    public void writeData(OutputStream out) throws PageseederException {
        if (this.isFolder()) {
            return;
        }
        Request psreq = new Request(this.uri.getPath(), this.config);
        for (String param : this.parameters.keySet()) {
            psreq.addParameter(param, this.parameters.get(param));
        }
        psreq.send();
        try {
            out.write(psreq.getResponse());
        }
        catch (IOException ex) {
            throw new PageseederException("Failed to write response to output: " + ex.getMessage(), ex);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        return this.uri.getPath();
    }
}

