/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.ExternalConfig;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class ANTUtils {
    private ANTUtils() {
    }

    public static ExternalConfig buildConfig(Project project, String config) {
        String jsessionid;
        String password;
        String csrftoken;
        ExternalConfig ecfg = new ExternalConfig(config == null ? "default" : config);
        String host = project.getProperty("ps.config." + config + ".host");
        if (host == null) {
            throw new BuildException("Invalid config, no host");
        }
        ecfg.setHost(host);
        String port = project.getProperty("ps.config." + config + ".port");
        if (port == null) {
            throw new BuildException("Invalid config, no port");
        }
        ecfg.setPort(port);
        String scheme = project.getProperty("ps.config." + config + ".scheme");
        if (scheme == null) {
            throw new BuildException("Invalid config, no scheme");
        }
        ecfg.setScheme(scheme);
        String siteprefix = project.getProperty("ps.config." + config + ".site.prefix");
        if (siteprefix == null) {
            throw new BuildException("Invalid config, no site prefix");
        }
        ecfg.setPSPrefix(siteprefix);
        String servletprefix = project.getProperty("ps.config." + config + ".servlet.prefix");
        if (servletprefix == null) {
            throw new BuildException("Invalid config, no servlet prefix");
        }
        ecfg.setServletPrefix(servletprefix);
        String username = project.getProperty("ps.config." + config + ".username");
        if (username == null) {
            throw new BuildException("Invalid config, no username");
        }
        ecfg.setUsername(username);
        String usertoken = project.getProperty("ps.config." + config + ".user.token");
        if (usertoken != null) {
            ecfg.setUserToken(usertoken);
        }
        if ((csrftoken = project.getProperty("ps.config." + config + ".anticsrftoken")) != null) {
            ecfg.setAntiCSRFToken(csrftoken);
        }
        if ((password = project.getProperty("ps.config." + config + ".password")) != null) {
            ecfg.setPassword(password);
        }
        if ((jsessionid = project.getProperty("ps.config." + config + ".jsessionid")) != null) {
            ecfg.setJSessionID(jsessionid);
        }
        String urihost = project.getProperty("ps.config." + config + ".uri.host");
        String grouphost = project.getProperty("ps.config." + config + ".group.host");
        if (urihost != null) {
            ecfg.setUriHost(urihost);
        } else if (grouphost != null) {
            ecfg.setUriHost(grouphost);
        }
        return ecfg;
    }
}

