/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.oauth;

import com.pageseeder.publishapi.oauth.OAuthUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenResponse.class);
    private final int _responseCode;
    private @Nullable String token;
    private @Nullable String username;
    private final @Nullable String _response;
    private final Map<@NonNull String, @NonNull String> _json;

    TokenResponse(int code, @Nullable String response, Map<@NonNull String, @NonNull String> json) {
        this._responseCode = code;
        this._response = response;
        this._json = json;
    }

    public @Nullable String getAccessToken() {
        return this.token;
    }

    public @Nullable String getMemberUsername() {
        return this.username;
    }

    public boolean isSuccessful() {
        return this._responseCode == 200;
    }

    public @Nullable String getError() {
        return this._json.get("error");
    }

    public static TokenResponse consume(HttpURLConnection connection, String clientSecret) {
        TokenResponse tokenResponse;
        block9: {
            int responseCode = connection.getResponseCode();
            InputStream in = OAuthUtils.stream(connection);
            try {
                String raw = OAuthUtils.readAll(in, connection.getContentLength());
                LOGGER.debug("JSON response: {}", (Object)raw);
                Map<String, String> json = OAuthUtils.parse(raw);
                TokenResponse response = new TokenResponse(responseCode, raw, json);
                if (response.isSuccessful()) {
                    response.token = json.get("access_token");
                    response.username = TokenResponse.extractMemberUsername(json, clientSecret);
                }
                tokenResponse = response;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return TokenResponse.error("io_error", ex.getMessage());
                }
            }
            in.close();
        }
        return tokenResponse;
    }

    static TokenResponse error(String error, @Nullable String description) {
        HashMap<String, String> json = new HashMap<String, String>(2);
        json.put("error", error);
        if (description != null) {
            json.put("error_description", description);
        }
        return new TokenResponse(-1, null, json);
    }

    private static @Nullable String extractMemberUsername(Map<String, String> json, String clientSecret) {
        String idToken = json.get("id_token");
        if (idToken != null) {
            Map<String, String> details = OAuthUtils.parseOpenIDToken(idToken, clientSecret.getBytes());
            return details == null ? null : details.get("username");
        }
        return null;
    }
}

