/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant.md;

import com.pageseeder.publishapi.ant.AntLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.pageseeder.psml.PSML;
import org.pageseeder.psml.md.MarkdownSerializer;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.psml.util.DiagnosticCollector;
import org.slf4j.Logger;

public class MarkdownExportTask
extends Task {
    private String src;
    private String dest;

    public void setSrc(String src) {
        this.src = src;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public void execute() throws BuildException {
        if (this.src == null || this.dest == null) {
            throw new BuildException("Both src and dest attributes are required");
        }
        try {
            PSMLElement psml;
            File input = new File(this.src);
            File output = new File(this.dest);
            output.getParentFile().mkdirs();
            Logger logger = AntLogger.newInstance(this);
            logger.info("Converting PSML file: {} to Markdown: {}", (Object)this.src, (Object)this.dest);
            try (BufferedReader in = new BufferedReader(new FileReader(input, StandardCharsets.UTF_8));){
                psml = PSML.load((Reader)in);
            }
            MarkdownSerializer md = new MarkdownSerializer();
            DiagnosticCollector collector = (isError, message) -> {
                if (isError) {
                    logger.error(message);
                } else {
                    logger.warn(message);
                }
            };
            try (BufferedWriter out = new BufferedWriter(new FileWriter(output, StandardCharsets.UTF_8));){
                md.serialize(psml, (Appendable)out, collector);
            }
            logger.info("Conversion completed successfully");
        }
        catch (Exception e) {
            throw new BuildException("Error converting PSML to Markdown: " + e.getMessage(), (Throwable)e);
        }
    }
}

