/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.Upload;
import com.pageseeder.publishapi.ant.AntLogger;
import com.pageseeder.publishapi.ant.Notification;
import com.pageseeder.publishapi.ant.Workflow;
import com.pageseeder.publishapi.utils.ANTUtils;
import com.pageseeder.publishapi.utils.ThreadLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.slf4j.Logger;

public class UploadTask
extends Task {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private String group;
    private Notification notification = null;
    private Workflow workflow;
    private String folder;
    private String doclabels;
    private boolean unzip = false;
    private boolean resolve = true;
    private boolean validate = true;
    private boolean failOnError = true;
    private boolean deleteZip = true;
    private boolean overwrite = false;
    private boolean overwriteProperties = false;
    private boolean index = true;
    private boolean docid_is_filename = false;
    private String saveuris;
    private long pollinginterval = 5000L;
    private String config = "default";

    public void setConfig(String cfg) {
        this.config = cfg;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setFolder(String _folder) {
        _folder = _folder != null && _folder.startsWith("/") ? _folder.substring(1) : _folder;
        this.folder = _folder = _folder != null && _folder.endsWith("/") ? _folder.substring(0, _folder.length() - 1) : _folder;
    }

    public void setGroup(String _group) {
        this.group = _group;
    }

    public Notification createNotification() {
        this.notification = new Notification();
        return this.notification;
    }

    public void setIndex(boolean _index) {
        this.index = _index;
    }

    public void setUnzip(boolean _unzip) {
        this.unzip = _unzip;
    }

    public void setDeleteZip(boolean deleteZip) {
        this.deleteZip = deleteZip;
    }

    public void setDocidIsFilename(boolean _docid_is_filename) {
        this.docid_is_filename = _docid_is_filename;
    }

    public void setResolve(boolean resolve) {
        this.resolve = resolve;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setValidate(boolean val) {
        this.validate = val;
    }

    public void setOverwriteProperties(boolean _overwriteProperties) {
        this.overwriteProperties = _overwriteProperties;
    }

    public void setOverwrite(boolean _overwrite) {
        this.overwrite = _overwrite;
    }

    public Workflow createWorkflow() {
        this.workflow = new Workflow();
        return this.workflow;
    }

    public void setSaveURIs(String _uris) {
        this.saveuris = _uris;
    }

    public void setDocLabels(String dlabels) {
        this.doclabels = dlabels;
    }

    public void setPollinginterval(long ms) {
        this.pollinginterval = ms;
    }

    public void execute() throws BuildException {
        block18: {
            if (this.filesets.size() == 0) {
                throw new BuildException("No target directory/files is specfified. Please specify the embedded '<fileset>' argument.");
            }
            if (this.group == null) {
                throw new BuildException("Please specify a group name.");
            }
            AntUploadLogger logger = new AntUploadLogger(this);
            try {
                HashMap<String, File> toUpload = new HashMap<String, File>();
                for (int i = 0; i < this.filesets.size(); ++i) {
                    FileSet fs = this.filesets.get(i);
                    DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                    File dir = fs.getDir(this.getProject());
                    String[] files = ds.getIncludedFiles();
                    for (int j = 0; j < files.length; ++j) {
                        String file = files[j];
                        File f = new File(dir, file);
                        if (!f.exists()) continue;
                        if (toUpload.containsKey(f.getName())) {
                            this.log("The file " + f.getAbsolutePath() + " is ignored as there is already a file with this name: " + ((File)toUpload.get(f.getName())).getAbsolutePath());
                            continue;
                        }
                        toUpload.put(f.getName(), f);
                    }
                }
                if (toUpload.isEmpty()) {
                    throw new BuildException("No files to upload");
                }
                Upload up = new Upload(ANTUtils.buildConfig(this.getProject(), this.config), this.group, this.folder);
                up.setNotification(this.notification);
                up.setWorkflow(this.workflow);
                up.setUploadDetails(this.overwrite, this.overwriteProperties, this.resolve, this.validate, this.index, this.unzip, this.deleteZip);
                up.setPollingInterval(this.pollinginterval);
                up.setUploadLogger(logger);
                up.setLoadCreatedURIs(this.saveuris != null);
                Object files_uploaded = "";
                Iterator iterator = toUpload.values().iterator();
                while (iterator.hasNext()) {
                    File f = (File)iterator.next();
                    up.addFile(f, "UTF-8", f.getName(), null, this.docid_is_filename ? "[filename]" : null, this.doclabels == null ? null : this.doclabels.split(","));
                    files_uploaded = (String)files_uploaded + f.getName();
                    if (!iterator.hasNext()) continue;
                    files_uploaded = (String)files_uploaded + ", ";
                }
                this.log("The following files have been sent: " + (String)files_uploaded);
                String response = up.getResponse();
                if (this.saveuris == null) break block18;
                try (FileOutputStream fout = new FileOutputStream(this.saveuris);){
                    fout.write(response.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception ex) {
                if (logger.getThreadID() != null) {
                    Logger log = AntLogger.newInstance(this);
                    String msg = "<threadid group=\"" + this.group + "\">" + logger.getThreadID() + "</threadid>";
                    if (this.failOnError) {
                        log.error(msg);
                    } else {
                        log.warn(msg);
                    }
                }
                if (this.failOnError) {
                    this.log("Failed to upload: " + ex.getMessage(), 0);
                    throw new BuildException("Error executing Upload: " + ex.getMessage(), (Throwable)ex);
                }
                this.log("Failed to upload: " + ex.getMessage(), 1);
            }
        }
    }

    private static class AntUploadLogger
    implements ThreadLogger {
        private final UploadTask task;
        private String threadID = null;

        public AntUploadLogger(UploadTask t) {
            this.task = t;
        }

        @Override
        public void addStatus(ThreadLogger.Status status, String msg) {
            int level;
            if (status == ThreadLogger.Status.WARNING) {
                level = 1;
            } else if (status == ThreadLogger.Status.COMPLETED) {
                level = 2;
            } else if (status == ThreadLogger.Status.CANCELLED) {
                level = 1;
            } else if (status == ThreadLogger.Status.FAILED) {
                level = 0;
            } else if (status == ThreadLogger.Status.ERROR) {
                level = 0;
            } else {
                return;
            }
            if (this.task.failOnError && level == 0) {
                throw new BuildException(msg);
            }
            this.task.log(msg, level);
        }

        @Override
        public void complete() {
        }

        @Override
        public String getFinalResponse() {
            return null;
        }

        @Override
        public void setThreadID(String threadid) {
            this.threadID = threadid;
        }

        @Override
        public String getThreadID() {
            return this.threadID;
        }
    }
}

