/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import com.pageseeder.publishapi.ant.Body;
import com.pageseeder.publishapi.ant.Parameter;
import com.pageseeder.publishapi.ant.RequestFileReader;
import com.pageseeder.publishapi.utils.ANTUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class RequestTask
extends Task {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private String path;
    private String output;
    private String method;
    private long pollingIntervalMs = 2000L;
    private boolean failOnError = true;
    private String config = "default";
    private boolean followRedirects = true;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private Body body = null;

    public Body createBody() {
        this.body = new Body();
        return this.body;
    }

    public Parameter createParameter() {
        Parameter param = new Parameter();
        this.parameters.add(param);
        return param;
    }

    public void setPath(String p) {
        this.path = p;
    }

    public void setOutput(String o) {
        this.output = o;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setMethod(String m) {
        this.method = m;
    }

    public void setConfig(String cfg) {
        this.config = cfg;
    }

    public void setFollowRedirects(boolean follow) {
        this.followRedirects = follow;
    }

    public void setPollingInterval(long pollingInterval) {
        this.pollingIntervalMs = pollingInterval;
    }

    public void execute() throws BuildException {
        if (this.path == null && this.filesets.isEmpty()) {
            this.error("Servlet must be specified unless using <fileset>.", null);
            return;
        }
        if (this.output == null) {
            this.error("Please specify a file output to write the response data.", null);
            return;
        }
        if (this.method == null) {
            this.method = "GET";
        }
        if (!this.isMethodAllowed(this.method)) {
            this.error("The accepted HTTP method are GET, POST, PATCH, PUT and DELETE.", null);
            return;
        }
        ExternalConfig psconfig = ANTUtils.buildConfig(this.getProject(), this.config);
        try {
            File outputFile = new File(this.output);
            this.log("Storing request response as " + outputFile.getAbsolutePath(), 4);
            try (FileOutputStream out = new FileOutputStream(outputFile);){
                if (this.filesets.isEmpty()) {
                    this.processSingleFile(out, psconfig);
                } else {
                    this.processFileset(out, psconfig);
                }
            }
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.error("Error executing PSRequest: " + ex.getMessage(), ex);
        }
    }

    private void processSingleFile(OutputStream out, ExternalConfig config) throws IOException {
        try {
            String requestBody = this.body != null ? this.body.getValue() : null;
            this.runRequest(out, this.path, null, requestBody, this.parameters, config, false);
        }
        catch (PageseederException ex) {
            String resp = ex.getResponse();
            if (resp != null) {
                out.write(this.removeXmlDeclaration(resp).getBytes(StandardCharsets.UTF_8));
            }
            this.error(ex.getMessage() + ", see output for details", null);
        }
    }

    private void processFileset(OutputStream fout, ExternalConfig config) throws IOException {
        Object logMessage = "Generating requests from the following files\n";
        fout.write("<responses>\n".getBytes(StandardCharsets.UTF_8));
        int nbfiles = 0;
        for (FileSet fs : this.filesets) {
            String[] files;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File dir = fs.getDir(this.getProject());
            for (String file : files = ds.getIncludedFiles()) {
                boolean hasOwnOutput;
                RequestFileReader reader;
                File f = new File(dir, file);
                if (!f.exists()) continue;
                String filepath = f.getParentFile().getName() + File.separator + f.getName();
                logMessage = (String)logMessage + filepath;
                if (++nbfiles == 50) {
                    logMessage = (String)logMessage + "\n";
                    nbfiles = 0;
                } else {
                    logMessage = (String)logMessage + ", ";
                }
                try {
                    reader = RequestFileReader.parse(f);
                }
                catch (Exception e) {
                    this.log("Failed to load request from file " + filepath + " " + e.getMessage());
                    continue;
                }
                boolean bl = hasOwnOutput = reader.getOutput() != null;
                if (hasOwnOutput) {
                    try (FileOutputStream out = new FileOutputStream(reader.getOutput());){
                        this.processFileFromFileset(out, config, reader, filepath, false);
                        continue;
                    }
                }
                fout.write(("<response filepath=\"" + filepath + "\">\n").getBytes(StandardCharsets.UTF_8));
                this.processFileFromFileset(fout, config, reader, filepath, true);
                fout.write("</response>\n".getBytes(StandardCharsets.UTF_8));
            }
        }
        if (((String)logMessage).endsWith(", ")) {
            logMessage = ((String)logMessage).substring(0, ((String)logMessage).length() - 2) + "\n";
        }
        this.log((String)logMessage);
        fout.write("</responses>".getBytes(StandardCharsets.UTF_8));
    }

    private void processFileFromFileset(OutputStream out, ExternalConfig config, RequestFileReader reader, String filepath, boolean stripXMLDecl) throws IOException {
        try {
            this.runRequest(out, reader.getPath(), reader.getMethod(), reader.getBody(), reader.getParams(), config, stripXMLDecl);
        }
        catch (PageseederException pe) {
            String resp = pe.getResponse();
            if (resp != null) {
                out.write(this.removeXmlDeclaration(resp).getBytes(StandardCharsets.UTF_8));
            }
            this.error("Failed to run request from file " + filepath + " " + pe.getMessage() + ", see output for details", null);
        }
        catch (Exception ex) {
            this.log("Failed to run request from file " + filepath + " " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRequest(OutputStream out, String path, String method, String body, List<Parameter> params, ExternalConfig psconfig, boolean stripXMLDecl) throws PageseederException, IOException {
        String m = method == null ? this.method : method;
        Request req = new Request(path != null ? path : this.path, psconfig);
        req.setFollowRedirects(this.followRedirects);
        req.setHTTPMethod(m);
        req.setThreadHandlingDetails(this.pollingIntervalMs, null);
        for (Parameter param : params) {
            req.addParameter(param.getName(), param.getValue());
        }
        req.send();
        if ("PUT".equals(m) && body != null) {
            req.writeAllContent(body, StandardCharsets.UTF_8.toString());
        }
        try {
            if (stripXMLDecl) {
                String resp = req.getResponseAsString();
                out.write(this.removeXmlDeclaration(resp).getBytes(StandardCharsets.UTF_8));
            } else {
                out.write(req.getResponse());
            }
        }
        finally {
            if (psconfig.getJSessionID() != null && psconfig.getName() != null) {
                this.getProject().setProperty("ps.config." + psconfig.getName() + ".jsessionid", psconfig.getJSessionID());
            }
        }
    }

    private void error(String msg, Throwable t) {
        if (t != null) {
            t.printStackTrace();
        }
        if (this.failOnError) {
            throw new BuildException(msg, t);
        }
        this.log(msg, t, 0);
    }

    private String removeXmlDeclaration(String xml) {
        return xml.replaceFirst("<\\?xml.*?\\?>", "");
    }

    private boolean isMethodAllowed(String method) {
        return method.equals("GET") || method.equals("POST") || method.equals("PATCH") || method.equals("PUT") || method.equals("DELETE");
    }
}

