/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public final class ProgressTask
extends Task {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private String percent = null;
    private String message = null;
    private String result = null;
    private String resultfile = null;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setPercent(String percent) {
        this.percent = percent;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setResultfile(String resultfile) {
        this.resultfile = resultfile;
    }

    public void execute() throws BuildException {
        this.setTaskName("progress");
        if (this.percent != null) {
            try {
                int p = Integer.parseInt(this.percent);
                if (p < 0 || p > 100) {
                    throw new BuildException("Percent must be from 0 to 100");
                }
            }
            catch (NumberFormatException ex) {
                throw new BuildException("Invalid percent " + this.percent);
            }
        }
        if (this.resultfile == null && this.result != null && !"reload".equals(this.result)) {
            throw new BuildException("Resultfile is required");
        }
        if (this.filesets.size() > 1) {
            throw new BuildException("A maximum of 1 fileset is allowed");
        }
        if (this.filesets.size() == 1 && (this.result == null || "reload".equals(this.result) || "urilink".equals(this.result))) {
            throw new BuildException("Fileset is only supported for result other than 'urilink' or 'reload'");
        }
        Object resultpath = this.resultfile;
        if (this.resultfile != null && !"urilink".equals(this.result)) {
            File res = new File(this.resultfile);
            if (!res.exists()) {
                res = new File(this.getProject().getBaseDir(), this.resultfile);
            }
            if (!res.exists() || !res.isFile()) {
                throw new BuildException("Invalid resultfile location " + this.resultfile);
            }
            String session = "/session/" + this.getProject().getProperty("ps-sessionfolder") + this.getProject().getProperty("ps-groupFolderNoPrefix") + "/result";
            boolean copied = false;
            Object folder = "";
            String filename = res.getName();
            if (this.filesets.size() == 1) {
                int i = filename.lastIndexOf(".");
                folder = i > 0 ? "/" + filename.substring(0, i) : filename;
                FileSet fs = this.filesets.get(0);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File dir = fs.getDir(this.getProject());
                String[] files = ds.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    String file = files[j];
                    File f = new File(dir, file);
                    if (!f.exists()) continue;
                    try {
                        if (f.getCanonicalPath().equals(res.getCanonicalPath())) {
                            copied = true;
                        }
                        String relPath = dir.toPath().relativize(f.toPath()).toString();
                        File dest = new File(this.getProject().getProperty("ps-webRoot") + session + (String)folder + "/" + relPath);
                        Files.createDirectories(dest.getParentFile().toPath(), new FileAttribute[0]);
                        Files.copy(f.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    catch (IOException ex) {
                        throw new BuildException("Unable to copy result file " + f.getName() + ":" + ex.getMessage());
                    }
                }
            }
            resultpath = ("preview".equals(this.result) ? "" : this.getProject().getProperty("ps-engineUrl")) + session + (String)folder + "/" + filename;
            if (!copied) {
                File dest = new File(this.getProject().getProperty("ps-webRoot") + session + (String)folder + "/" + filename);
                try {
                    Files.createDirectories(dest.getParentFile().toPath(), new FileAttribute[0]);
                    if (filename.toLowerCase().endsWith(".zip")) {
                        Files.move(res.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.copy(res.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException ex) {
                    throw new BuildException("Unable to copy result file: " + ex.getMessage());
                }
            }
        }
        try {
            if (this.percent != null) {
                this.log("<progress percent=\"" + this.percent + "\" />");
            }
            if (this.message != null) {
                this.log(this.message);
            }
            if ("window".equals(this.result)) {
                this.log("<displayUriPath>" + (String)resultpath + "</displayUriPath>");
            } else if ("panel".equals(this.result)) {
                this.log("<displayPanelPath>" + (String)resultpath + "</displayPanelPath>");
            } else if ("preview".equals(this.result)) {
                this.log("<previewPath>" + (String)resultpath + "</previewPath>");
            } else if ("link".equals(this.result)) {
                this.log("<downloadLink>" + (String)resultpath + "</downloadLink>");
            } else if ("urilink".equals(this.result)) {
                this.log("<uriLink>" + (String)resultpath + "</uriLink>");
            } else if ("reload".equals(this.result)) {
                this.log("<reload/>");
            } else if (this.result != null) {
                throw new BuildException("Result must be one of: window,panel,preview,link,urilink,reload");
            }
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception ex) {
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }
}

